(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[   1213882,      26105]
NotebookOptionsPosition[   1119014,      24814]
NotebookOutlinePosition[   1119411,      24830]
CellTagsIndexPosition[   1119368,      24827]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"<<", "VilTeX`"}]], "Input",
 CellChangeTimes->{{3.966968271457609*^9, 3.9669682779533978`*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"d22e0b2f-27dd-49bb-aa7b-225a331d45e3"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     StyleBox["\<\"\|01f680 VilTeX cargado\"\>",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontSize->16,
      FontWeight->Bold,
      FontColor->RGBColor[0, 0, 1]]},
    {
     StyleBox["\<\"\:2705 Listo para usar. Versi\[OAcute]n del \
01/10/2025.\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontWeight->Bold,
      FontColor->GrayLevel[0]]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967021426435034*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[33]:=",ExpressionUUID->"7113f414-55a2-4371-9c21-2f92320ec3ee"],

Cell[BoxData["\<\"Mostrando editores ya detectados...\"\>"], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.9670214513756437`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[33]:=",ExpressionUUID->"0cca1bfa-b268-4500-b067-061644c32482"],

Cell[BoxData["\<\"=== EDITORES LaTeX DETECTADOS ===\"\>"], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967021451376987*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[33]:=",ExpressionUUID->"0399d72b-ca77-4eb6-9da5-5a6cbd80c904"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"TeXShop\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"TeXShop\"\>"}],
  SequenceForm["\[Checkmark] ", "TeXShop", " \[RightArrow] ", "TeXShop"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.9670214513774033`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[33]:=",ExpressionUUID->"817a3580-f91e-4277-a871-74be57dc20d7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"texstudio-4.8.8-osx-m1\"\>"}],
  SequenceForm[
  "\[Checkmark] ", "TeXstudio", " \[RightArrow] ", "texstudio-4.8.8-osx-m1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967021451377853*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[33]:=",ExpressionUUID->"737c87d3-931e-40f2-b600-df40eaeb1a53"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"Texifier\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"Texifier\"\>"}],
  SequenceForm["\[Checkmark] ", "Texifier", " \[RightArrow] ", "Texifier"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967021451378263*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[33]:=",ExpressionUUID->"e0e860b4-07b4-4883-9e4c-bcff2e51e5d7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"LaTeXiT\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"LaTeXiT\"\>"}],
  SequenceForm["\[Checkmark] ", "LaTeXiT", " \[RightArrow] ", "LaTeXiT"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967021451378668*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[33]:=",ExpressionUUID->"df305314-8b28-4f52-9a72-0751dd85a52e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["12. CASOS ESPECIALES", "Subtitle",
 CellChangeTimes->{{3.964711967446312*^9, 3.9647120331966953`*^9}, {
   3.965828746741377*^9, 3.965828772379876*^9}, {3.966422117997758*^9, 
   3.966422160573628*^9}, {3.9664222257197533`*^9, 3.966422232684371*^9}, 
   3.9664306609167547`*^9, {3.966529948809907*^9, 3.966529956215705*^9}, {
   3.966967689320518*^9, 3.966967689696537*^9}},
 Background->RGBColor[
  0.4, 0.6, 1, 0.33],ExpressionUUID->"e620c90a-a47e-4279-8a06-c63909917048"],

Cell[CellGroupData[{

Cell["DiagramaFuncion", "Section",
 CellChangeTimes->{
  3.966968435050807*^9},ExpressionUUID->"049de2f9-a8a2-4df2-a8ed-\
609a322f3729"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "DiagramaFuncion"}]], "Input",
 CellChangeTimes->{{3.966968437294499*^9, 3.966968438599978*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"95a0db4e-ffd0-4e0d-918f-fe812752c85a"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DiagramaFuncion[eA, eB, rel, opts] crea un diagrama \
de Venn que muestra dos conjuntos A y B representados como elipses, con \
flechas que indican las relaciones entre sus elementos.\\n\\nPAR\
\[CapitalAAcute]METROS:\\n- eA: Lista de elementos del conjunto A \
(dominio)\\n- eB: Lista de elementos del conjunto B (codominio)  \\n- rel: \
Lista de reglas que definen las relaciones (ej: {a1 -> b1, a2 -> b2})\\n- \
opts: Opciones adicionales (ver OPCIONES)\\n\\nOPCIONES:\\n- \
\\\"CenterGap\\\" -> 6: Distancia horizontal entre los centros de las dos \
elipses\\n- \\\"EllipseRadii\\\" -> {1.5, 3}: Radio horizontal y vertical de \
las elipses {rx, ry}\\n- \\\"TextGapLeft\\\" -> 0.20: Separaci\[OAcute]n \
horizontal del texto respecto al borde izquierdo de la elipse\\n- \
\\\"TextGapRight\\\" -> 0.20: Separaci\[OAcute]n horizontal del texto \
respecto al borde derecho de la elipse\\n- \\\"FontSize\\\" -> 14: Tama\
\[NTilde]o de fuente para los elementos y etiquetas\\n- \\\"Labels\\\" -> {\\\
\"A\\\", \\\"B\\\"}: Etiquetas que aparecen encima de cada conjunto\\n- \
\\\"ShowArc\\\" -> True: Si se muestra (True) o no (False) el arco superior \
que representa la funci\[OAcute]n f\\n- \\\"ArcBaseY\\\" -> 2.9: Posici\
\[OAcute]n vertical base donde inicia el arco de la funci\[OAcute]n\\n- \
\\\"ArcHeight\\\" -> 0.6: Altura m\[AAcute]xima del arco de la \
funci\[OAcute]n\\n- \\\"ArcHalfWidth\\\" -> 2.6: Mitad del ancho total del \
arco de la funci\[OAcute]n\\n- \\\"ArcStep\\\" -> 0.12: Incremento usado para \
dibujar puntos del arco (menor valor = arco m\[AAcute]s suave)\\n- \
\\\"ImageSize\\\" -> 520: Tama\[NTilde]o en p\[IAcute]xeles de la imagen \
resultante\\n\\nEJEMPLO:\\nDiagramaFuncion[{1, 2, 3}, {a, b, c}, {1 -> a, 2 \
-> b, 3 -> c}]\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"DiagramaFuncion", "[", 
                    
                    RowBox[{
                    "VilTeX`Private`eA_List", ",", "VilTeX`Private`eB_List", 
                    ",", "VilTeX`Private`rel_List", ",", 
                    RowBox[{"VilTeX`Private`opts", ":", 
                    RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`gap", ",", "VilTeX`Private`rx", 
                    ",", "VilTeX`Private`ry", ",", "VilTeX`Private`tL", ",", 
                    "VilTeX`Private`tR", ",", "VilTeX`Private`fs", ",", 
                    "VilTeX`Private`labA", ",", "VilTeX`Private`labB", ",", 
                    "VilTeX`Private`showArc", ",", "VilTeX`Private`y0", ",", 
                    "VilTeX`Private`h", ",", "VilTeX`Private`w", ",", 
                    "VilTeX`Private`step", ",", "VilTeX`Private`isz", ",", 
                    "VilTeX`Private`cxL", ",", "VilTeX`Private`cxR", ",", 
                    "VilTeX`Private`yPad", ",", "VilTeX`Private`ysA", ",", 
                    "VilTeX`Private`ysB", ",", "VilTeX`Private`txtA", ",", 
                    "VilTeX`Private`txtB", ",", "VilTeX`Private`norm", ",", 
                    "VilTeX`Private`Akeys", ",", "VilTeX`Private`Bkeys", ",", 
                    "VilTeX`Private`iA", ",", "VilTeX`Private`iB", ",", 
                    "VilTeX`Private`pairs", ",", "VilTeX`Private`arrows", ",",
                     "VilTeX`Private`arc"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`gap", "=", 
                    RowBox[{"OptionValue", "[", "\"CenterGap\"", "]"}]}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`rx", ",", "VilTeX`Private`ry"}], 
                    "}"}], "=", 
                    RowBox[{"OptionValue", "[", "\"EllipseRadii\"", "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`tL", "=", 
                    RowBox[{"OptionValue", "[", "\"TextGapLeft\"", "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`tR", "=", 
                    RowBox[{"OptionValue", "[", "\"TextGapRight\"", "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`fs", "=", 
                    RowBox[{"OptionValue", "[", "\"FontSize\"", "]"}]}], ";", 
                    
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`labA", ",", 
                    "VilTeX`Private`labB"}], "}"}], "=", 
                    RowBox[{"OptionValue", "[", "\"Labels\"", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`showArc", "=", 
                    RowBox[{"TrueQ", "[", 
                    RowBox[{"OptionValue", "[", "\"ShowArc\"", "]"}], "]"}]}],
                     ";", 
                    RowBox[{"VilTeX`Private`y0", "=", 
                    RowBox[{"OptionValue", "[", "\"ArcBaseY\"", "]"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`h", "=", 
                    RowBox[{"OptionValue", "[", "\"ArcHeight\"", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`w", "=", 
                    RowBox[{"OptionValue", "[", "\"ArcHalfWidth\"", "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`step", "=", 
                    RowBox[{"OptionValue", "[", "\"ArcStep\"", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`isz", "=", 
                    RowBox[{"OptionValue", "[", "\"ImageSize\"", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`cxL", "=", 
                    RowBox[{"-", 
                    FractionBox["VilTeX`Private`gap", "2"]}]}], ";", 
                    RowBox[{"VilTeX`Private`cxR", "=", 
                    FractionBox["VilTeX`Private`gap", "2"]}], ";", 
                    RowBox[{"VilTeX`Private`yPad", "=", "0.7`"}], ";", 
                    RowBox[{"VilTeX`Private`ysA", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`eA", "]"}], 
                    "\[Equal]", "1"}], ",", 
                    RowBox[{"{", "0", "}"}], ",", 
                    RowBox[{"Subdivide", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ry", "-", "VilTeX`Private`yPad"}],
                     ",", 
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`ry", "-", "VilTeX`Private`yPad"}],
                     ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`eA", "]"}], "-", 
                    "1"}]}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`ysB", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`eB", "]"}], 
                    "\[Equal]", "1"}], ",", 
                    RowBox[{"{", "0", "}"}], ",", 
                    RowBox[{"Subdivide", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ry", "-", "VilTeX`Private`yPad"}],
                     ",", 
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`ry", "-", "VilTeX`Private`yPad"}],
                     ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`eB", "]"}], "-", 
                    "1"}]}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`txtA", "=", 
                    RowBox[{"MapThread", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Text", "[", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#1", ",", "VilTeX`Private`fs"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`cxL", ",", "#2"}], "}"}]}], "]"}],
                     "&"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`eA", ",", "VilTeX`Private`ysA"}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`txtB", "=", 
                    RowBox[{"MapThread", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Text", "[", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#1", ",", "VilTeX`Private`fs"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`cxR", ",", "#2"}], "}"}]}], "]"}],
                     "&"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`eB", ",", "VilTeX`Private`ysB"}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`norm", "[", "VilTeX`Private`x_", 
                    "]"}], ":=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    RowBox[{"Unevaluated", "[", "VilTeX`Private`x", "]"}], 
                    ",", "StandardForm"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`Akeys", "=", 
                    
                    RowBox[{"VilTeX`Private`norm", "/@", 
                    "VilTeX`Private`eA"}]}], ";", 
                    RowBox[{"VilTeX`Private`Bkeys", "=", 
                    
                    RowBox[{"VilTeX`Private`norm", "/@", 
                    "VilTeX`Private`eB"}]}], ";", 
                    RowBox[{"VilTeX`Private`iA", "=", 
                    RowBox[{"AssociationThread", "[", 
                    RowBox[{"VilTeX`Private`Akeys", "\[Rule]", 
                    RowBox[{"Range", "[", 
                    RowBox[{"Length", "[", "VilTeX`Private`eA", "]"}], 
                    "]"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`iB", "=", 
                    RowBox[{"AssociationThread", "[", 
                    RowBox[{"VilTeX`Private`Bkeys", "\[Rule]", 
                    RowBox[{"Range", "[", 
                    RowBox[{"Length", "[", "VilTeX`Private`eB", "]"}], 
                    "]"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`pairs", "=", 
                    RowBox[{"Cases", "[", 
                    RowBox[{"VilTeX`Private`rel", ",", 
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`x_", "\[Rule]", 
                    "VilTeX`Private`y_"}], ")"}], "\[RuleDelayed]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Lookup", "[", 
                    RowBox[{"VilTeX`Private`iA", ",", 
                    RowBox[{"VilTeX`Private`norm", "[", "VilTeX`Private`x", 
                    "]"}], ",", 
                    RowBox[{"Missing", "[", "]"}]}], "]"}], ",", 
                    RowBox[{"Lookup", "[", 
                    RowBox[{"VilTeX`Private`iB", ",", 
                    
                    RowBox[{"VilTeX`Private`norm", "[", "VilTeX`Private`y", 
                    "]"}], ",", 
                    RowBox[{"Missing", "[", "]"}]}], "]"}]}], "}"}]}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`pairs", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{"VilTeX`Private`pairs", ",", 
                    RowBox[{
                    RowBox[{"FreeQ", "[", 
                    RowBox[{"#1", ",", "Missing"}], "]"}], "&"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`arrows", "=", 
                    RowBox[{"Arrow", "/@", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`cxL", "+", "VilTeX`Private`tL"}], 
                    ",", 
                    RowBox[{"VilTeX`Private`ysA", "\[LeftDoubleBracket]", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "\[RightDoubleBracket]"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`cxR", "-", "VilTeX`Private`tR"}], 
                    ",", 
                    RowBox[{"VilTeX`Private`ysB", "\[LeftDoubleBracket]", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "\[RightDoubleBracket]"}]}], 
                    "}"}]}], "}"}], "&"}], ")"}], "/@", 
                    "VilTeX`Private`pairs"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`arc", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`showArc", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Arrow", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`x", ",", 
                    RowBox[{"VilTeX`Private`y0", "+", 
                    RowBox[{"VilTeX`Private`h", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox["VilTeX`Private`x", "VilTeX`Private`w"], 
                    ")"}], "2"]}], ")"}]}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`x", ",", 
                    RowBox[{"-", "VilTeX`Private`w"}], ",", 
                    "VilTeX`Private`w", ",", "VilTeX`Private`step"}], "}"}]}],
                     "]"}], "]"}], ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    
                    RowBox[{"\"f\"", ",", "VilTeX`Private`fs", ",", 
                    "Italic"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    
                    RowBox[{"VilTeX`Private`y0", "+", "VilTeX`Private`h", "+",
                     "0.25`"}]}], "}"}]}], "]"}]}], "}"}], ",", 
                    RowBox[{"{", "}"}]}], "]"}]}], ";", 
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
                    RowBox[{"FaceForm", "[", "None", "]"}], ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`cxL", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`rx", ",", "VilTeX`Private`ry"}], 
                    "}"}]}], "]"}], ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`cxR", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`rx", ",", "VilTeX`Private`ry"}], 
                    "}"}]}], "]"}], ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    
                    RowBox[{"VilTeX`Private`labA", ",", "VilTeX`Private`fs", 
                    ",", "Bold"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`cxL", ",", 
                    RowBox[{"VilTeX`Private`ry", "+", "0.5`"}]}], "}"}]}], 
                    "]"}], ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    
                    RowBox[{"VilTeX`Private`labB", ",", "VilTeX`Private`fs", 
                    ",", "Bold"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`cxR", ",", 
                    RowBox[{"VilTeX`Private`ry", "+", "0.5`"}]}], "}"}]}], 
                    "]"}], ",", "VilTeX`Private`txtA", ",", 
                    "VilTeX`Private`txtB", ",", "VilTeX`Private`arrows", ",", 
                    "VilTeX`Private`arc"}], "}"}], ",", 
                    RowBox[{"PlotRange", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "VilTeX`Private`gap"}], ",", 
                    "VilTeX`Private`gap"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "VilTeX`Private`ry"}], "-", "1.5`"}], ",", 
                    RowBox[{"VilTeX`Private`ry", "+", "2.5`"}]}], "}"}]}], 
                    "}"}]}], ",", 
                    RowBox[{"ImageSize", "\[Rule]", "VilTeX`Private`isz"}]}], 
                    "]"}]}]}], "]"}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   PaneSelectorBox[{True->
                    ButtonBox[
                    PaneSelectorBox[{False->
                    TemplateBox[{"\[ThickSpace]", "\"\[ThickSpace]\"", 
                    StyleBox[
                    "\"Options\"", "InformationRowLabel", StripOnInput -> 
                    False], 
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "DownPointerOpener"]]},
                    "RowWithSeparators"], True->
                    TemplateBox[{"\[ThickSpace]", "\"\[ThickSpace]\"", 
                    StyleBox[
                    "\"Options\"", "InformationRowLabel", StripOnInput -> 
                    False], 
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "DownPointerOpenerHot"]]},
                    "RowWithSeparators"]}, Dynamic[
                    CurrentValue["MouseOver"]],
                    FrameMargins->0,
                    ImageSize->Automatic],
                    Appearance->None,
                    BaseStyle->None,
                    
                    ButtonFunction:>(Part[System`InformationDump`open$$, 3] = 
                    False),
                    Evaluator->Automatic,
                    FrameMargins->0,
                    ImageMargins->0,
                    Method->"Preemptive"], False->
                    ButtonBox[
                    PaneSelectorBox[{False->
                    TemplateBox[{"\[ThickSpace]", "\"\[ThickSpace]\"", 
                    StyleBox[
                    "\"Options\"", "InformationRowLabel", StripOnInput -> 
                    False], 
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "RightPointerOpener"]]},
                    "RowWithSeparators"], True->
                    TemplateBox[{"\[ThickSpace]", "\"\[ThickSpace]\"", 
                    StyleBox[
                    "\"Options\"", "InformationRowLabel", StripOnInput -> 
                    False], 
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "RightPointerOpenerHot"]]},
                    "RowWithSeparators"]}, Dynamic[
                    CurrentValue["MouseOver"]],
                    FrameMargins->0,
                    ImageSize->Automatic],
                    Appearance->None,
                    BaseStyle->None,
                    
                    ButtonFunction:>(Part[System`InformationDump`open$$, 3] = 
                    True),
                    Evaluator->Automatic,
                    FrameMargins->0,
                    ImageMargins->0,
                    Method->"Preemptive"]}, Dynamic[
                    FEPrivate`Part[System`InformationDump`open$$, 3]]], 
                   PaneSelectorBox[{True->GridBox[{
                    {
                    RowBox[{"\<\"CenterGap\"\>", "\[Rule]", "6"}]},
                    {
                    RowBox[{"\<\"EllipseRadii\"\>", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"1.5`", ",", "3"}], "}"}]}]},
                    {
                    RowBox[{"\<\"TextGapLeft\"\>", "\[Rule]", "0.2`"}]},
                    {
                    RowBox[{"\<\"TextGapRight\"\>", "\[Rule]", "0.2`"}]},
                    {
                    RowBox[{"\<\"FontSize\"\>", "\[Rule]", "14"}]},
                    {
                    RowBox[{"\<\"Labels\"\>", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"\<\"A\"\>", ",", "\<\"B\"\>"}], "}"}]}]},
                    {
                    RowBox[{"\<\"ShowArc\"\>", "\[Rule]", "True"}]},
                    {
                    RowBox[{"\<\"ArcBaseY\"\>", "\[Rule]", "2.9`"}]},
                    {
                    RowBox[{"\<\"ArcHeight\"\>", "\[Rule]", "0.6`"}]},
                    {
                    RowBox[{"\<\"ArcHalfWidth\"\>", "\[Rule]", "2.6`"}]},
                    {
                    RowBox[{"\<\"ArcStep\"\>", "\[Rule]", "0.12`"}]},
                    {
                    RowBox[{"\<\"ImageSize\"\>", "\[Rule]", "520"}]},
                    {
                    StyleBox[
                    
                    TemplateBox[{
                    "\"(\"", "\"\[InvisibleSpace]\"", "12", "\" total)\""},
                    "RowDefault"], "InformationRowOpener",
                    StripOnInput->False]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{1.}}}], False->
                    RowBox[{
                    RowBox[{"\<\"CenterGap\"\>", "\[Rule]", "6"}], "\[ThinSpace]", 
                    StyleBox["\<\"\[Ellipsis]\"\>", "InformationRowOpener",
                    StripOnInput->False], "\[ThinSpace]", 
                    StyleBox[
                    
                    TemplateBox[{
                    "\"(\"", "\"\[InvisibleSpace]\"", "12", "\" total)\""},
                    "RowDefault"], "InformationRowOpener",
                    StripOnInput->False]}]}, Dynamic[
                    FEPrivate`Part[System`InformationDump`open$$, 3]],
                    BaselinePosition->Baseline,
                    ImageSize->Automatic]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilTeX`DiagramaFuncion\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DiagramaFuncion[eA, eB, rel, opts] crea un diagrama \
de Venn que muestra dos conjuntos A y B representados como elipses, con \
flechas que indican las relaciones entre sus elementos.\\n\\nPAR\
\[CapitalAAcute]METROS:\\n- eA: Lista de elementos del conjunto A \
(dominio)\\n- eB: Lista de elementos del conjunto B (codominio)  \\n- rel: \
Lista de reglas que definen las relaciones (ej: {a1 -> b1, a2 -> b2})\\n- \
opts: Opciones adicionales (ver OPCIONES)\\n\\nOPCIONES:\\n- \
\\\"CenterGap\\\" -> 6: Distancia horizontal entre los centros de las dos \
elipses\\n- \\\"EllipseRadii\\\" -> {1.5, 3}: Radio horizontal y vertical de \
las elipses {rx, ry}\\n- \\\"TextGapLeft\\\" -> 0.20: Separaci\[OAcute]n \
horizontal del texto respecto al borde izquierdo de la elipse\\n- \
\\\"TextGapRight\\\" -> 0.20: Separaci\[OAcute]n horizontal del texto \
respecto al borde derecho de la elipse\\n- \\\"FontSize\\\" -> 14: Tama\
\[NTilde]o de fuente para los elementos y etiquetas\\n- \\\"Labels\\\" -> {\\\
\"A\\\", \\\"B\\\"}: Etiquetas que aparecen encima de cada conjunto\\n- \
\\\"ShowArc\\\" -> True: Si se muestra (True) o no (False) el arco superior \
que representa la funci\[OAcute]n f\\n- \\\"ArcBaseY\\\" -> 2.9: Posici\
\[OAcute]n vertical base donde inicia el arco de la funci\[OAcute]n\\n- \
\\\"ArcHeight\\\" -> 0.6: Altura m\[AAcute]xima del arco de la \
funci\[OAcute]n\\n- \\\"ArcHalfWidth\\\" -> 2.6: Mitad del ancho total del \
arco de la funci\[OAcute]n\\n- \\\"ArcStep\\\" -> 0.12: Incremento usado para \
dibujar puntos del arco (menor valor = arco m\[AAcute]s suave)\\n- \
\\\"ImageSize\\\" -> 520: Tama\[NTilde]o en p\[IAcute]xeles de la imagen \
resultante\\n\\nEJEMPLO:\\nDiagramaFuncion[{1, 2, 3}, {a, b, c}, {1 -> a, 2 \
-> b, 3 -> c}]\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}},
            ScrollPosition->{0., 0.}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "DiagramaFuncion[eA, eB, rel, opts] crea un diagrama de Venn que muestra \
dos conjuntos A y B representados como elipses, con flechas que indican las \
relaciones entre sus elementos.\n\nPAR\[CapitalAAcute]METROS:\n- eA: Lista de \
elementos del conjunto A (dominio)\n- eB: Lista de elementos del conjunto B \
(codominio)  \n- rel: Lista de reglas que definen las relaciones (ej: {a1 -> \
b1, a2 -> b2})\n- opts: Opciones adicionales (ver OPCIONES)\n\nOPCIONES:\n- \
\"CenterGap\" -> 6: Distancia horizontal entre los centros de las dos elipses\
\n- \"EllipseRadii\" -> {1.5, 3}: Radio horizontal y vertical de las elipses \
{rx, ry}\n- \"TextGapLeft\" -> 0.20: Separaci\[OAcute]n horizontal del texto \
respecto al borde izquierdo de la elipse\n- \"TextGapRight\" -> 0.20: \
Separaci\[OAcute]n horizontal del texto respecto al borde derecho de la \
elipse\n- \"FontSize\" -> 14: Tama\[NTilde]o de fuente para los elementos y \
etiquetas\n- \"Labels\" -> {\"A\", \"B\"}: Etiquetas que aparecen encima de \
cada conjunto\n- \"ShowArc\" -> True: Si se muestra (True) o no (False) el \
arco superior que representa la funci\[OAcute]n f\n- \"ArcBaseY\" -> 2.9: \
Posici\[OAcute]n vertical base donde inicia el arco de la funci\[OAcute]n\n- \
\"ArcHeight\" -> 0.6: Altura m\[AAcute]xima del arco de la funci\[OAcute]n\n- \
\"ArcHalfWidth\" -> 2.6: Mitad del ancho total del arco de la funci\[OAcute]n\
\n- \"ArcStep\" -> 0.12: Incremento usado para dibujar puntos del arco (menor \
valor = arco m\[AAcute]s suave)\n- \"ImageSize\" -> 520: Tama\[NTilde]o en p\
\[IAcute]xeles de la imagen resultante\n\nEJEMPLO:\nDiagramaFuncion[{1, 2, \
3}, {a, b, c}, {1 -> a, 2 -> b, 3 -> c}]", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilTeX`DiagramaFuncion, {VilTeX`DiagramaFuncion[
         Pattern[VilTeX`Private`eA, 
          Blank[List]], 
         Pattern[VilTeX`Private`eB, 
          Blank[List]], 
         Pattern[VilTeX`Private`rel, 
          Blank[List]], 
         Pattern[VilTeX`Private`opts, 
          OptionsPattern[]]] :> 
       Module[{VilTeX`Private`gap, VilTeX`Private`rx, VilTeX`Private`ry, 
          VilTeX`Private`tL, VilTeX`Private`tR, VilTeX`Private`fs, 
          VilTeX`Private`labA, VilTeX`Private`labB, VilTeX`Private`showArc, 
          VilTeX`Private`y0, VilTeX`Private`h, VilTeX`Private`w, 
          VilTeX`Private`step, VilTeX`Private`isz, VilTeX`Private`cxL, 
          VilTeX`Private`cxR, VilTeX`Private`yPad, VilTeX`Private`ysA, 
          VilTeX`Private`ysB, VilTeX`Private`txtA, VilTeX`Private`txtB, 
          VilTeX`Private`norm, VilTeX`Private`Akeys, VilTeX`Private`Bkeys, 
          VilTeX`Private`iA, VilTeX`Private`iB, VilTeX`Private`pairs, 
          VilTeX`Private`arrows, VilTeX`Private`arc}, 
         VilTeX`Private`gap = 
          OptionValue["CenterGap"]; {VilTeX`Private`rx, VilTeX`Private`ry} = 
          OptionValue["EllipseRadii"]; 
         VilTeX`Private`tL = OptionValue["TextGapLeft"]; 
         VilTeX`Private`tR = OptionValue["TextGapRight"]; 
         VilTeX`Private`fs = 
          OptionValue["FontSize"]; {VilTeX`Private`labA, VilTeX`Private`labB} = 
          OptionValue["Labels"]; VilTeX`Private`showArc = TrueQ[
            OptionValue["ShowArc"]]; 
         VilTeX`Private`y0 = OptionValue["ArcBaseY"]; 
         VilTeX`Private`h = OptionValue["ArcHeight"]; 
         VilTeX`Private`w = OptionValue["ArcHalfWidth"]; 
         VilTeX`Private`step = OptionValue["ArcStep"]; 
         VilTeX`Private`isz = OptionValue["ImageSize"]; 
         VilTeX`Private`cxL = (-VilTeX`Private`gap)/2; 
         VilTeX`Private`cxR = VilTeX`Private`gap/2; VilTeX`Private`yPad = 0.7; 
         VilTeX`Private`ysA = If[Length[VilTeX`Private`eA] == 1, {0}, 
            Subdivide[
            VilTeX`Private`ry - 
             VilTeX`Private`yPad, -(VilTeX`Private`ry - VilTeX`Private`yPad), 
             Length[VilTeX`Private`eA] - 1]]; 
         VilTeX`Private`ysB = If[Length[VilTeX`Private`eB] == 1, {0}, 
            Subdivide[
            VilTeX`Private`ry - 
             VilTeX`Private`yPad, -(VilTeX`Private`ry - VilTeX`Private`yPad), 
             Length[VilTeX`Private`eB] - 1]]; 
         VilTeX`Private`txtA = MapThread[Text[
             Style[#, VilTeX`Private`fs], {VilTeX`Private`cxL, #2}]& , {
            VilTeX`Private`eA, VilTeX`Private`ysA}]; 
         VilTeX`Private`txtB = MapThread[Text[
             Style[#, VilTeX`Private`fs], {VilTeX`Private`cxR, #2}]& , {
            VilTeX`Private`eB, VilTeX`Private`ysB}]; VilTeX`Private`norm[
            Pattern[VilTeX`Private`x, 
             Blank[]]] := ToString[
            Unevaluated[VilTeX`Private`x], StandardForm]; 
         VilTeX`Private`Akeys = Map[VilTeX`Private`norm, VilTeX`Private`eA]; 
         VilTeX`Private`Bkeys = Map[VilTeX`Private`norm, VilTeX`Private`eB]; 
         VilTeX`Private`iA = AssociationThread[VilTeX`Private`Akeys -> Range[
              Length[VilTeX`Private`eA]]]; 
         VilTeX`Private`iB = AssociationThread[VilTeX`Private`Bkeys -> Range[
              Length[VilTeX`Private`eB]]]; 
         VilTeX`Private`pairs = 
          Cases[VilTeX`Private`rel, (Pattern[VilTeX`Private`x, 
               Blank[]] -> Pattern[VilTeX`Private`y, 
               Blank[]]) :> {
              Lookup[VilTeX`Private`iA, 
               VilTeX`Private`norm[VilTeX`Private`x], 
               Missing[]], 
              Lookup[VilTeX`Private`iB, 
               VilTeX`Private`norm[VilTeX`Private`y], 
               Missing[]]}]; 
         VilTeX`Private`pairs = 
          Select[VilTeX`Private`pairs, FreeQ[#, Missing]& ]; 
         VilTeX`Private`arrows = Map[Arrow, 
            Map[{{VilTeX`Private`cxL + VilTeX`Private`tL, 
               Part[VilTeX`Private`ysA, 
                Part[#, 1]]}, {VilTeX`Private`cxR - VilTeX`Private`tR, 
               Part[VilTeX`Private`ysB, 
                Part[#, 2]]}}& , VilTeX`Private`pairs]]; 
         VilTeX`Private`arc = If[VilTeX`Private`showArc, {
             Arrow[
              
              Table[{VilTeX`Private`x, VilTeX`Private`y0 + 
                VilTeX`Private`h (
                  1 - (VilTeX`Private`x/VilTeX`Private`w)^2)}, {
               VilTeX`Private`x, -VilTeX`Private`w, VilTeX`Private`w, 
                VilTeX`Private`step}]], 
             Text[
              Style["f", VilTeX`Private`fs, Italic], {
              0, VilTeX`Private`y0 + VilTeX`Private`h + 0.25}]}, {}]; 
         Graphics[{
            EdgeForm[Black], 
            FaceForm[None], 
            
            Disk[{VilTeX`Private`cxL, 0}, {
             VilTeX`Private`rx, VilTeX`Private`ry}], 
            
            Disk[{VilTeX`Private`cxR, 0}, {
             VilTeX`Private`rx, VilTeX`Private`ry}], 
            Text[
             Style[VilTeX`Private`labA, VilTeX`Private`fs, Bold], {
             VilTeX`Private`cxL, VilTeX`Private`ry + 0.5}], 
            Text[
             Style[VilTeX`Private`labB, VilTeX`Private`fs, Bold], {
             VilTeX`Private`cxR, VilTeX`Private`ry + 0.5}], 
            VilTeX`Private`txtA, VilTeX`Private`txtB, VilTeX`Private`arrows, 
            VilTeX`Private`arc}, 
           PlotRange -> {{-VilTeX`Private`gap, 
              VilTeX`Private`gap}, {-VilTeX`Private`ry - 1.5, 
              VilTeX`Private`ry + 2.5}}, ImageSize -> VilTeX`Private`isz]]}], 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, 
    "Options" -> {
     "CenterGap" -> 6, "EllipseRadii" -> {1.5, 3}, "TextGapLeft" -> 0.2, 
      "TextGapRight" -> 0.2, "FontSize" -> 14, "Labels" -> {"A", "B"}, 
      "ShowArc" -> True, "ArcBaseY" -> 2.9, "ArcHeight" -> 0.6, 
      "ArcHalfWidth" -> 2.6, "ArcStep" -> 0.12, "ImageSize" -> 520}, 
    "Attributes" -> {Protected}, "FullName" -> "VilTeX`DiagramaFuncion"|>, 
   False]]], "Output",
 CellChangeTimes->{3.966968439592716*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"45e7e7cd-0ad2-483c-ac89-9e78b53a2d2e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 1", "Subsection",
 CellChangeTimes->{{3.966968453206786*^9, 
  3.966968457107958*^9}},ExpressionUUID->"142fa854-08fc-4aa1-b330-\
0b9d053d6185"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"diagrfun1", "=", 
  RowBox[{"DiagramaFuncion", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "->", "a"}], ",", 
      RowBox[{"2", "->", "c"}], ",", 
      RowBox[{"3", "->", "b"}], ",", 
      RowBox[{"3", "->", "d"}]}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZ", "[", 
   RowBox[{
   "diagrfun1", ",", "\"\<diagrfun1.tex\>\"", ",", "False", 
    ",", "\"\<black\>\"", ",", "False"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.966968540134017*^9, 3.966968723163636*^9}},
 CellLabel->"In[58]:=",ExpressionUUID->"2dd67d44-0109-4edc-a4e6-cddcf05b67dc"],

Cell[BoxData[
 GraphicsBox[
  {EdgeForm[GrayLevel[0]], FaceForm[None], DiskBox[{-3, 0}, {1.5, 3.}], 
   DiskBox[{3, 0}, {1.5, 3.}], InsetBox[
    StyleBox["\<\"A\"\>",
     StripOnInput->False,
     FontSize->14,
     FontWeight->Bold], {-3, 3.5}], InsetBox[
    StyleBox["\<\"B\"\>",
     StripOnInput->False,
     FontSize->14,
     FontWeight->Bold], {3, 3.5}], {InsetBox[
     StyleBox["1",
      StripOnInput->False,
      FontSize->14], {-3, 2.3}], InsetBox[
     StyleBox["2",
      StripOnInput->False,
      FontSize->14], {-3, 0.7666666666666668}], InsetBox[
     StyleBox["3",
      StripOnInput->False,
      FontSize->14], {-3, -0.7666666666666665}], InsetBox[
     StyleBox["4",
      StripOnInput->False,
      FontSize->14], {-3, -2.3}]}, {InsetBox[
     StyleBox["a",
      StripOnInput->False,
      FontSize->14], {3, 2.3}], InsetBox[
     StyleBox["b",
      StripOnInput->False,
      FontSize->14], {3, 0.7666666666666668}], InsetBox[
     StyleBox["c",
      StripOnInput->False,
      FontSize->14], {3, -0.7666666666666665}], InsetBox[
     StyleBox["d",
      StripOnInput->False,
      FontSize->14], {3, -2.3}]}, {ArrowBox[{{-2.8, 2.3}, {2.8, 2.3}}], 
    ArrowBox[{{-2.8, 0.7666666666666668}, {2.8, -0.7666666666666665}}], 
    ArrowBox[{{-2.8, -0.7666666666666665}, {2.8, 0.7666666666666668}}], 
    ArrowBox[{{-2.8, -0.7666666666666665}, {2.8, -2.3}}]}, {
    ArrowBox[CompressedData["
1:eJwtUm1Ik1EU3qa4931v/gmzDyUQiaRcGBISVvcQlBIEuh+iOaJkqYHgRwZt
pggZDgxmgh9LSps2kcoUk8R+3DWXJE7DsImhmGK63Edqzc+a7Z564HI53HOe
5znn3JicQvUNhUwmiw8efo86OEKtiQglTLYVnZUmQ6wxqoVGhVkJ8/qIrpQ5
hTXDoh+pJwJ40vsP33fLrZ+erI96CgVYj9MYbX6ZtSEys0X5UQDZP1jN4S10
MU6EfcFqfUSA+e+NdBnKRTjG0+N+M6NuxuNziHBO4orbrNg3sXVgvwRqTp++
yR7N93wO00iQl8uxzqSM0sr+Zgnucjv6X8yWGr2tckpQG2TTGNfYu4HO83mE
QDu337bChBfRV7TJBEp4WORlDdG34UgugWYTx3dWsKfX31lDwM7Lbd+Yocyp
W3tOwIv9zTHvzVlHYIhAPPqdZqbJUd/YNIEK1J9gD+xPZ3O8BFqRb5gNJWS3
DGwSMOD7a4b2AgSuYdxO91ZX1PTtEijF2E5ji11vMncIuFBvnJZ9SeplqwQa
kG+KRg0WlC/PEzBjP1+p4nh15NQYAR3WL9AEJCSQhvNyUcudgj55I4Gj6NdD
tVeT3ibfIhDY5fhB8weXjKcvEVhGvVXa11GeuBNFwIn7/klTydazSpcEOE6b
n8b6spaGX0nwkq+va4NeTGvdcBZL0IT+tmj3SYez44QEVW5OuEOv181UnVkU
Ae0W/aFZJRPy+iYRsrkdzS41jXdf7rkgAsq1ySCmuyT/oVcApDPJYSX8kPpU
rQCYblRAmNsiPVYJ//lDQJtysO7DeyXgd9SHgogDVMJfdRRXgw==
     "]], InsetBox[
     StyleBox["\<\"f\"\>",
      StripOnInput->False,
      FontSize->14,
      FontSlant->Italic], {0, 3.75}]}},
  ImageSize->520,
  PlotRange->{{-6, 6}, {-4.5, 5.5}}]], "Output",
 CellChangeTimes->{
  3.9669685883372593`*^9, 3.966968676937479*^9, {3.966968712972436*^9, 
   3.966968723989891*^9}, 3.966968993144656*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"2e7d4148-f6c5-41e0-9345-4cedf466fa9a"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Textos extra\[IAcute]dos autom\[AAcute]ticamente: 11 \
elementos\"\>"], "Print",
 CellChangeTimes->{
  3.966968676943096*^9, {3.966968712976264*^9, 3.9669687239943447`*^9}, 
   3.966968993148685*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[58]:=",ExpressionUUID->"c7185e35-920b-40dc-93c6-a8f92f8dde53"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966968676943096*^9, {3.966968712976264*^9, 3.9669687239943447`*^9}, 
   3.966968993149765*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[58]:=",ExpressionUUID->"690eb15a-3a5d-4778-8dbc-384d48b86cc6"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.966968676943096*^9, {3.966968712976264*^9, 3.9669687239943447`*^9}, 
   3.966968993150346*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[58]:=",ExpressionUUID->"39bd88fd-f909-477b-9339-e2156230989b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966968676943096*^9, {3.966968712976264*^9, 3.9669687239943447`*^9}, 
   3.9669689931507473`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[58]:=",ExpressionUUID->"2d163c81-fa98-4ed7-863a-eea766b761a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966968676943096*^9, {3.966968712976264*^9, 3.9669687239943447`*^9}, 
   3.966968993151187*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[58]:=",ExpressionUUID->"651e6cbf-0d81-4dc8-bc36-965f99d593c5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966968676943096*^9, {3.966968712976264*^9, 3.9669687239943447`*^9}, 
   3.966968993151581*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[58]:=",ExpressionUUID->"436d14ac-dafe-4fc1-b119-384a2cb822d0"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.966968676943096*^9, {3.966968712976264*^9, 3.9669687239943447`*^9}, 
   3.966968993290592*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[58]:=",ExpressionUUID->"c385b669-ca81-4a55-8fac-de923db01c87"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.966968676943096*^9, {3.966968712976264*^9, 3.9669687239943447`*^9}, 
   3.966968994296606*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[58]:=",ExpressionUUID->"3a217080-5441-4a34-bb4d-9f0cc748f779"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/diagrfun1/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/diagrfun1/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966968676943096*^9, {3.966968712976264*^9, 3.9669687239943447`*^9}, 
   3.966968994299189*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[58]:=",ExpressionUUID->"4cfec908-9c0b-43d2-b57f-f4bc23f7dda9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"diagrfun1\"\>"}],
  SequenceForm["Archivo: ", "diagrfun1"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966968676943096*^9, {3.966968712976264*^9, 3.9669687239943447`*^9}, 
   3.966968994300836*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[58]:=",ExpressionUUID->"33d79e7d-ad2b-43c9-a130-b8520e3ff793"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.966968676943096*^9, {3.966968712976264*^9, 3.9669687239943447`*^9}, 
   3.966968994990041*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[58]:=",ExpressionUUID->"6f11ca7b-4b25-4283-a170-f3d9839be8bc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/diagrfun1/diagrfun1.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/diagrfun1/diagrfun1.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966968676943096*^9, {3.966968712976264*^9, 3.9669687239943447`*^9}, 
   3.96696899499054*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[58]:=",ExpressionUUID->"37257f70-71d8-4c66-ae7c-a1d3c891ef64"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/diagrfun1/diagrfun1.\
pdf\"\>"], "Output",
 CellChangeTimes->{
  3.9669685883372593`*^9, 3.966968676937479*^9, {3.966968712972436*^9, 
   3.966968723989891*^9}, 3.966968995003161*^9},
 CellLabel->"Out[60]=",ExpressionUUID->"29f970f8-2328-411a-b030-865c61654f44"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 2: f(x)=x\.b2 para n\[UAcute]meros peque\[NTilde]os", \
"Subsection",
 CellChangeTimes->{{3.966968453206786*^9, 3.966968457107958*^9}, {
   3.966968746065219*^9, 3.966968746563121*^9}, 3.966969067552109*^9, {
   3.966969104448854*^9, 3.96696910645361*^9}, 
   3.966969165771031*^9},ExpressionUUID->"a4accb24-a7b5-4d11-85a1-\
21ee031693ab"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"diagrfun2", "=", 
  RowBox[{"DiagramaFuncion", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "9", ",", "16", ",", "25"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "->", "1"}], ",", 
      RowBox[{"2", "->", "4"}], ",", 
      RowBox[{"3", "->", "9"}], ",", 
      RowBox[{"4", "->", "16"}]}], "}"}], ",", 
    RowBox[{"\"\<Labels\>\"", "->", 
     RowBox[{"{", 
      RowBox[{"\"\<N\[UAcute]meros\>\"", ",", "\"\<Cuadrados\>\""}], "}"}]}], 
    ",", 
    RowBox[{"\"\<FontSize\>\"", "->", "16"}], ",", 
    RowBox[{"\"\<EllipseRadii\>\"", "->", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2.5"}], "}"}]}], ",", 
    RowBox[{"\"\<CenterGap\>\"", "->", "8"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZ", "[", 
   RowBox[{"diagrfun2", ",", "\"\<diagrfun2.tex\>\"", ",", "False", ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"RandomChoice", "[", 
         RowBox[{"{", 
          
          RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", 
           ",", "\"\<dotted\>\"", ",", "\"\<dashdotted\>\"", 
           ",", "\"\<thick\>\""}], "}"}], "]"}], ",", 
        RowBox[{"RandomChoice", "[", 
         RowBox[{"{", 
          
          RowBox[{"\"\<red\>\"", ",", "\"\<blue\>\"", ",", "\"\<green\>\"", 
           ",", "\"\<orange\>\"", ",", "\"\<purple\>\"", ",", "\"\<black\>\"",
            ",", "\"\<brown\>\"", ",", "\"\<pink\>\"", ",", "\"\<gray\>\"", 
           ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<yellow\>\"",
            ",", "\"\<lime\>\"", ",", "\"\<olive\>\"", ",", "\"\<teal\>\""}], 
          "}"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "6"}], "}"}]}], "]"}], ",", "False"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9669690892399197`*^9, 3.96696912345611*^9}, {
   3.966969205661579*^9, 3.96696930620045*^9}, {3.966969336633791*^9, 
   3.9669693403844757`*^9}, 3.966969410816182*^9, 3.96696945714314*^9},
 CellLabel->"In[76]:=",ExpressionUUID->"dd3319cd-2b2a-43e0-8cc9-62a1d65d3554"],

Cell[BoxData[
 GraphicsBox[
  {EdgeForm[GrayLevel[0]], FaceForm[None], DiskBox[{-4, 0}, {2., 2.5}], 
   DiskBox[{4, 0}, {2., 2.5}], InsetBox[
    StyleBox["\<\"N\[UAcute]meros\"\>",
     StripOnInput->False,
     FontSize->16,
     FontWeight->Bold], {-4, 3.}], InsetBox[
    StyleBox["\<\"Cuadrados\"\>",
     StripOnInput->False,
     FontSize->16,
     FontWeight->Bold], {4, 3.}], {InsetBox[
     StyleBox["1",
      StripOnInput->False,
      FontSize->16], {-4, 1.8}], InsetBox[
     StyleBox["2",
      StripOnInput->False,
      FontSize->16], {-4, 0.6000000000000002}], InsetBox[
     StyleBox["3",
      StripOnInput->False,
      FontSize->16], {-4, -0.5999999999999999}], InsetBox[
     StyleBox["4",
      StripOnInput->False,
      FontSize->16], {-4, -1.8}]}, {InsetBox[
     StyleBox["1",
      StripOnInput->False,
      FontSize->16], {4, 1.8}], InsetBox[
     StyleBox["4",
      StripOnInput->False,
      FontSize->16], {4, 0.9}], InsetBox[
     StyleBox["9",
      StripOnInput->False,
      FontSize->16], {4, 0.}], InsetBox[
     StyleBox["16",
      StripOnInput->False,
      FontSize->16], {4, -0.9000000000000001}], InsetBox[
     StyleBox["25",
      StripOnInput->False,
      FontSize->16], {4, -1.8}]}, {ArrowBox[{{-3.8, 1.8}, {3.8, 1.8}}], 
    ArrowBox[{{-3.8, 0.6000000000000002}, {3.8, 0.9}}], 
    ArrowBox[{{-3.8, -0.5999999999999999}, {3.8, 0.}}], 
    ArrowBox[{{-3.8, -1.8}, {3.8, -0.9000000000000001}}]}, {
    ArrowBox[CompressedData["
1:eJwtUm1Ik1EU3qa4931v/gmzDyUQiaRcGBISVvcQlBIEuh+iOaJkqYHgRwZt
pggZDgxmgh9LSps2kcoUk8R+3DWXJE7DsImhmGK63Edqzc+a7Z564HI53HOe
5znn3JicQvUNhUwmiw8efo86OEKtiQglTLYVnZUmQ6wxqoVGhVkJ8/qIrpQ5
hTXDoh+pJwJ40vsP33fLrZ+erI96CgVYj9MYbX6ZtSEys0X5UQDZP1jN4S10
MU6EfcFqfUSA+e+NdBnKRTjG0+N+M6NuxuNziHBO4orbrNg3sXVgvwRqTp++
yR7N93wO00iQl8uxzqSM0sr+Zgnucjv6X8yWGr2tckpQG2TTGNfYu4HO83mE
QDu337bChBfRV7TJBEp4WORlDdG34UgugWYTx3dWsKfX31lDwM7Lbd+Yocyp
W3tOwIv9zTHvzVlHYIhAPPqdZqbJUd/YNIEK1J9gD+xPZ3O8BFqRb5gNJWS3
DGwSMOD7a4b2AgSuYdxO91ZX1PTtEijF2E5ji11vMncIuFBvnJZ9SeplqwQa
kG+KRg0WlC/PEzBjP1+p4nh15NQYAR3WL9AEJCSQhvNyUcudgj55I4Gj6NdD
tVeT3ibfIhDY5fhB8weXjKcvEVhGvVXa11GeuBNFwIn7/klTydazSpcEOE6b
n8b6spaGX0nwkq+va4NeTGvdcBZL0IT+tmj3SYez44QEVW5OuEOv181UnVkU
Ae0W/aFZJRPy+iYRsrkdzS41jXdf7rkgAsq1ySCmuyT/oVcApDPJYSX8kPpU
rQCYblRAmNsiPVYJ//lDQJtysO7DeyXgd9SHgogDVMJfdRRXgw==
     "]], InsetBox[
     StyleBox["\<\"f\"\>",
      StripOnInput->False,
      FontSize->16,
      FontSlant->Italic], {0, 3.75}]}},
  ImageSize->520,
  PlotRange->{{-8, 8}, {-4., 5.}}]], "Output",
 CellChangeTimes->{{3.966969228758112*^9, 3.966969272125115*^9}, {
  3.966969483829712*^9, 3.966969496576551*^9}},
 CellLabel->"Out[76]=",ExpressionUUID->"3044e41d-20a2-489d-9fd1-2dc69ce02384"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Textos extra\[IAcute]dos autom\[AAcute]ticamente: 12 \
elementos\"\>"], "Print",
 CellChangeTimes->{{3.966969228772887*^9, 3.966969272130434*^9}, {
  3.966969483886092*^9, 3.966969496584202*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[76]:=",ExpressionUUID->"9cdf4ebd-a732-4458-9197-eee35867b746"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966969228772887*^9, 3.966969272130434*^9}, {
  3.966969483886092*^9, 3.966969496585112*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[76]:=",ExpressionUUID->"971f77d4-df77-4acf-ab55-98670c544d9e"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.966969228772887*^9, 3.966969272130434*^9}, {
  3.966969483886092*^9, 3.966969496585651*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[76]:=",ExpressionUUID->"ab254478-fde1-4e68-9e4b-03c9fef628a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966969228772887*^9, 3.966969272130434*^9}, {
  3.966969483886092*^9, 3.9669694965859957`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[76]:=",ExpressionUUID->"bc02f00b-404c-48bd-9ad6-d5b6b1da8468"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966969228772887*^9, 3.966969272130434*^9}, {
  3.966969483886092*^9, 3.966969496586363*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[76]:=",ExpressionUUID->"5a13118d-ecc7-458a-b7ea-2c918d8d06b3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966969228772887*^9, 3.966969272130434*^9}, {
  3.966969483886092*^9, 3.9669694965867357`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[76]:=",ExpressionUUID->"850cd6d6-248e-4639-aad3-ec18b4644c51"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.966969228772887*^9, 3.966969272130434*^9}, {
  3.966969483886092*^9, 3.966969496665189*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[76]:=",ExpressionUUID->"23f2faaa-27db-4a63-acf6-a72ca9231f68"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.966969228772887*^9, 3.966969272130434*^9}, {
  3.966969483886092*^9, 3.9669694976713257`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[76]:=",ExpressionUUID->"fd27690f-3ab1-48c7-a5f3-992acb38328b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/diagrfun2/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/diagrfun2/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966969228772887*^9, 3.966969272130434*^9}, {
  3.966969483886092*^9, 3.966969497674314*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[76]:=",ExpressionUUID->"55a6f692-56f4-4075-9bef-0c58a032ae39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"diagrfun2\"\>"}],
  SequenceForm["Archivo: ", "diagrfun2"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966969228772887*^9, 3.966969272130434*^9}, {
  3.966969483886092*^9, 3.966969497675495*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[76]:=",ExpressionUUID->"9a9964f2-b99c-441a-b6cf-1d0be0d6e639"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.966969228772887*^9, 3.966969272130434*^9}, {
  3.966969483886092*^9, 3.966969498341434*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[76]:=",ExpressionUUID->"4ca099ac-02e3-4c10-8f3c-b726ef54b475"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/diagrfun2/diagrfun2.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/diagrfun2/diagrfun2.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966969228772887*^9, 3.966969272130434*^9}, {
  3.966969483886092*^9, 3.966969498341978*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[76]:=",ExpressionUUID->"ea8e45c6-7d9f-499d-960e-9b6a54003a8b"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/diagrfun2/diagrfun2.\
pdf\"\>"], "Output",
 CellChangeTimes->{{3.966969228758112*^9, 3.966969272125115*^9}, {
  3.966969483829712*^9, 3.9669694983551826`*^9}},
 CellLabel->"Out[78]=",ExpressionUUID->"34422594-73b6-4852-88c3-d7658ce8e2c6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 3: estudiantes y sus calificaciones", "Subsection",
 CellChangeTimes->{{3.966968453206786*^9, 3.966968457107958*^9}, {
   3.966968746065219*^9, 3.966968746563121*^9}, 3.966969071069881*^9, {
   3.966969179394763*^9, 3.9669691798271646`*^9}, {3.966969532275894*^9, 
   3.966969536236882*^9}},ExpressionUUID->"f479520f-18f7-48a0-ada0-\
9cf715ac8293"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"diagrfun3", "=", 
  RowBox[{"DiagramaFuncion", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<Ana\>\"", ",", "\"\<Bob\>\"", ",", "\"\<Carlos\>\"", 
      ",", "\"\<Diana\>\"", ",", "\"\<Eva\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\"", ",", "\"\<C\>\"", ",", "\"\<D\>\"",
       ",", "\"\<F\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<Ana\>\"", "->", "\"\<A\>\""}], ",", 
      RowBox[{"\"\<Bob\>\"", "->", "\"\<B\>\""}], ",", 
      RowBox[{"\"\<Carlos\>\"", "->", "\"\<B\>\""}], ",", 
      RowBox[{"\"\<Diana\>\"", "->", "\"\<A\>\""}], ",", 
      RowBox[{"\"\<Eva\>\"", "->", "\"\<C\>\""}]}], "}"}], ",", 
    RowBox[{"\"\<Labels\>\"", "->", 
     RowBox[{"{", 
      RowBox[{"\"\<Estudiantes\>\"", ",", "\"\<Calificaciones\>\""}], "}"}]}],
     ",", 
    RowBox[{"\"\<FontSize\>\"", "->", "12"}], ",", 
    RowBox[{"\"\<EllipseRadii\>\"", "->", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "3"}], "}"}]}], ",", 
    RowBox[{"\"\<CenterGap\>\"", "->", "10"}], ",", 
    RowBox[{"\"\<TextGapLeft\>\"", "->", "0.9"}], ",", 
    RowBox[{"\"\<TextGapRight\>\"", "->", "0.9"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZ", "[", 
   RowBox[{"diagrfun3", ",", "\"\<diagrfun3.tex\>\"", ",", "False", ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"RandomChoice", "[", 
         RowBox[{"{", 
          
          RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", 
           ",", "\"\<dotted\>\"", ",", "\"\<dashdotted\>\"", 
           ",", "\"\<thick\>\""}], "}"}], "]"}], ",", 
        RowBox[{"RandomChoice", "[", 
         RowBox[{"{", 
          
          RowBox[{"\"\<red\>\"", ",", "\"\<blue\>\"", ",", "\"\<green\>\"", 
           ",", "\"\<orange\>\"", ",", "\"\<purple\>\"", ",", "\"\<black\>\"",
            ",", "\"\<brown\>\"", ",", "\"\<pink\>\"", ",", "\"\<gray\>\"", 
           ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<yellow\>\"",
            ",", "\"\<lime\>\"", ",", "\"\<olive\>\"", ",", "\"\<teal\>\""}], 
          "}"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "6"}], "}"}]}], "]"}], ",", "False"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.966969524462736*^9, 3.966969540406763*^9}, {
  3.96696958561677*^9, 3.96696962538656*^9}, {3.966969674141459*^9, 
  3.966969696601152*^9}, {3.966969770732052*^9, 3.966969870651928*^9}},
 CellLabel->
  "In[100]:=",ExpressionUUID->"e6d45f51-42c6-4072-9252-7f48b2184bb9"],

Cell[BoxData[
 GraphicsBox[
  {EdgeForm[GrayLevel[0]], FaceForm[None], DiskBox[{-5, 0}, {2.5, 3.}], 
   DiskBox[{5, 0}, {2.5, 3.}], InsetBox[
    StyleBox["\<\"Estudiantes\"\>",
     StripOnInput->False,
     FontSize->12,
     FontWeight->Bold], {-5, 3.5}], InsetBox[
    StyleBox["\<\"Calificaciones\"\>",
     StripOnInput->False,
     FontSize->12,
     FontWeight->Bold], {5, 3.5}], {InsetBox[
     StyleBox["\<\"Ana\"\>",
      StripOnInput->False,
      FontSize->12], {-5, 2.3}], InsetBox[
     StyleBox["\<\"Bob\"\>",
      StripOnInput->False,
      FontSize->12], {-5, 1.15}], InsetBox[
     StyleBox["\<\"Carlos\"\>",
      StripOnInput->False,
      FontSize->12], {-5, 0.}], InsetBox[
     StyleBox["\<\"Diana\"\>",
      StripOnInput->False,
      FontSize->12], {-5, -1.15}], InsetBox[
     StyleBox["\<\"Eva\"\>",
      StripOnInput->False,
      FontSize->12], {-5, -2.3}]}, {InsetBox[
     StyleBox["\<\"A\"\>",
      StripOnInput->False,
      FontSize->12], {5, 2.3}], InsetBox[
     StyleBox["\<\"B\"\>",
      StripOnInput->False,
      FontSize->12], {5, 1.15}], InsetBox[
     StyleBox["\<\"C\"\>",
      StripOnInput->False,
      FontSize->12], {5, 0.}], InsetBox[
     StyleBox["\<\"D\"\>",
      StripOnInput->False,
      FontSize->12], {5, -1.15}], InsetBox[
     StyleBox["\<\"F\"\>",
      StripOnInput->False,
      FontSize->12], {5, -2.3}]}, {ArrowBox[{{-4.1, 2.3}, {4.1, 2.3}}], 
    ArrowBox[{{-4.1, 1.15}, {4.1, 1.15}}], 
    ArrowBox[{{-4.1, 0.}, {4.1, 1.15}}], 
    ArrowBox[{{-4.1, -1.15}, {4.1, 2.3}}], 
    ArrowBox[{{-4.1, -2.3}, {4.1, 0.}}]}, {ArrowBox[CompressedData["
1:eJwtUm1Ik1EU3qa4931v/gmzDyUQiaRcGBISVvcQlBIEuh+iOaJkqYHgRwZt
pggZDgxmgh9LSps2kcoUk8R+3DWXJE7DsImhmGK63Edqzc+a7Z564HI53HOe
5znn3JicQvUNhUwmiw8efo86OEKtiQglTLYVnZUmQ6wxqoVGhVkJ8/qIrpQ5
hTXDoh+pJwJ40vsP33fLrZ+erI96CgVYj9MYbX6ZtSEys0X5UQDZP1jN4S10
MU6EfcFqfUSA+e+NdBnKRTjG0+N+M6NuxuNziHBO4orbrNg3sXVgvwRqTp++
yR7N93wO00iQl8uxzqSM0sr+Zgnucjv6X8yWGr2tckpQG2TTGNfYu4HO83mE
QDu337bChBfRV7TJBEp4WORlDdG34UgugWYTx3dWsKfX31lDwM7Lbd+Yocyp
W3tOwIv9zTHvzVlHYIhAPPqdZqbJUd/YNIEK1J9gD+xPZ3O8BFqRb5gNJWS3
DGwSMOD7a4b2AgSuYdxO91ZX1PTtEijF2E5ji11vMncIuFBvnJZ9SeplqwQa
kG+KRg0WlC/PEzBjP1+p4nh15NQYAR3WL9AEJCSQhvNyUcudgj55I4Gj6NdD
tVeT3ibfIhDY5fhB8weXjKcvEVhGvVXa11GeuBNFwIn7/klTydazSpcEOE6b
n8b6spaGX0nwkq+va4NeTGvdcBZL0IT+tmj3SYez44QEVW5OuEOv181UnVkU
Ae0W/aFZJRPy+iYRsrkdzS41jXdf7rkgAsq1ySCmuyT/oVcApDPJYSX8kPpU
rQCYblRAmNsiPVYJ//lDQJtysO7DeyXgd9SHgogDVMJfdRRXgw==
     "]], InsetBox[
     StyleBox["\<\"f\"\>",
      StripOnInput->False,
      FontSize->12,
      FontSlant->Italic], {0, 3.75}]}},
  ImageSize->520,
  PlotRange->{{-10, 10}, {-4.5, 5.5}}]], "Output",
 CellChangeTimes->{
  3.966969642072427*^9, {3.966969677853898*^9, 3.966969696917214*^9}, {
   3.966969805459095*^9, 3.9669698711461153`*^9}},
 CellLabel->
  "Out[100]=",ExpressionUUID->"6fe61658-bad3-4a56-86b8-34e7968d205d"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Textos extra\[IAcute]dos autom\[AAcute]ticamente: 13 \
elementos\"\>"], "Print",
 CellChangeTimes->{
  3.966969642076766*^9, {3.966969677861532*^9, 3.966969696924158*^9}, {
   3.966969805460865*^9, 3.966969871155509*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[100]:=",ExpressionUUID->"c0a49e11-bf43-4956-91bb-caf9bedaf283"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966969642076766*^9, {3.966969677861532*^9, 3.966969696924158*^9}, {
   3.966969805460865*^9, 3.9669698711561117`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[100]:=",ExpressionUUID->"00bf5e55-589a-401d-8a9f-e4a8e02a0d11"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.966969642076766*^9, {3.966969677861532*^9, 3.966969696924158*^9}, {
   3.966969805460865*^9, 3.966969871156726*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[100]:=",ExpressionUUID->"0757b475-13f4-442d-859c-2e3c40ab7666"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966969642076766*^9, {3.966969677861532*^9, 3.966969696924158*^9}, {
   3.966969805460865*^9, 3.966969871157105*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[100]:=",ExpressionUUID->"ddf20578-102d-4de5-af40-4046dc54865a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966969642076766*^9, {3.966969677861532*^9, 3.966969696924158*^9}, {
   3.966969805460865*^9, 3.966969871157505*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[100]:=",ExpressionUUID->"5184947d-f591-4098-8773-5ec63d282239"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966969642076766*^9, {3.966969677861532*^9, 3.966969696924158*^9}, {
   3.966969805460865*^9, 3.966969871157921*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[100]:=",ExpressionUUID->"253f0b81-bc51-4424-8587-98f0f623b419"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.966969642076766*^9, {3.966969677861532*^9, 3.966969696924158*^9}, {
   3.966969805460865*^9, 3.966969871267542*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[100]:=",ExpressionUUID->"50b0f5a4-4f64-4f90-bffd-4516c69b86ba"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.966969642076766*^9, {3.966969677861532*^9, 3.966969696924158*^9}, {
   3.966969805460865*^9, 3.966969872272493*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[100]:=",ExpressionUUID->"774823ba-f706-4374-b04f-c3616e5cd558"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/diagrfun3/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/diagrfun3/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966969642076766*^9, {3.966969677861532*^9, 3.966969696924158*^9}, {
   3.966969805460865*^9, 3.966969872275141*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[100]:=",ExpressionUUID->"40dfd374-0646-4edb-b119-69ace184b590"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"diagrfun3\"\>"}],
  SequenceForm["Archivo: ", "diagrfun3"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966969642076766*^9, {3.966969677861532*^9, 3.966969696924158*^9}, {
   3.966969805460865*^9, 3.966969872277076*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[100]:=",ExpressionUUID->"acba11f8-d600-4e6f-8857-2bda5eae09f8"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.966969642076766*^9, {3.966969677861532*^9, 3.966969696924158*^9}, {
   3.966969805460865*^9, 3.9669698729317408`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[100]:=",ExpressionUUID->"a827ecab-29a7-4251-8f13-ed2d71f2a5e9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/diagrfun3/diagrfun3.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/diagrfun3/diagrfun3.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966969642076766*^9, {3.966969677861532*^9, 3.966969696924158*^9}, {
   3.966969805460865*^9, 3.966969872932349*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[100]:=",ExpressionUUID->"7acb33a0-01f5-415b-a5f2-380b9ea4106c"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/diagrfun3/diagrfun3.\
pdf\"\>"], "Output",
 CellChangeTimes->{
  3.966969642072427*^9, {3.966969677853898*^9, 3.966969696917214*^9}, {
   3.966969805459095*^9, 3.966969872945301*^9}},
 CellLabel->
  "Out[102]=",ExpressionUUID->"ed12e01f-ff7c-4e59-9e32-4376d1c30a8b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 4: codificaci\[OAcute]n de d\[IAcute]as", "Subsection",
 CellChangeTimes->{{3.966968453206786*^9, 3.966968457107958*^9}, {
   3.966968746065219*^9, 3.966968746563121*^9}, 3.9669690744800863`*^9, 
   3.96696918248337*^9, {3.966969912561507*^9, 
   3.966969921367104*^9}},ExpressionUUID->"654d2935-fcd6-4c87-a0c2-\
15037109fe72"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"diagrfun4", "=", 
  RowBox[{"DiagramaFuncion", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<Lun\>\"", ",", "\"\<Mar\>\"", ",", "\"\<Mi\[EAcute]\>\"", 
      ",", "\"\<Jue\>\"", ",", "\"\<Vie\>\"", ",", "\"\<S\[AAcute]b\>\"", 
      ",", "\"\<Dom\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7"}], "}"}],
     ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<Lun\>\"", "->", "1"}], ",", 
      RowBox[{"\"\<Mar\>\"", "->", "2"}], ",", 
      RowBox[{"\"\<Mi\[EAcute]\>\"", "->", "3"}], ",", 
      RowBox[{"\"\<Jue\>\"", "->", "4"}], ",", 
      RowBox[{"\"\<Vie\>\"", "->", "5"}], ",", 
      RowBox[{"\"\<S\[AAcute]b\>\"", "->", "6"}], ",", 
      RowBox[{"\"\<Dom\>\"", "->", "7"}]}], "}"}], ",", 
    RowBox[{"\"\<Labels\>\"", "->", 
     RowBox[{"{", 
      RowBox[{"\"\<D\[IAcute]as\>\"", ",", "\"\<C\[OAcute]digos\>\""}], 
      "}"}]}], ",", 
    RowBox[{"\"\<FontSize\>\"", "->", "11"}], ",", 
    RowBox[{"\"\<EllipseRadii\>\"", "->", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1.5"}], "}"}]}], ",", 
    RowBox[{"\"\<CenterGap\>\"", "->", "9"}], ",", 
    RowBox[{"\"\<ImageSize\>\"", "->", "600"}], ",", 
    RowBox[{"\"\<TextGapLeft\>\"", "->", "0.9"}], ",", 
    RowBox[{"\"\<TextGapRight\>\"", "->", "0.9"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZ", "[", 
   RowBox[{"diagrfun4", ",", "\"\<diagrfun4.tex\>\"", ",", "False", ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<solid\>\"", ",", "\"\<red\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "10"}], "}"}]}], "]"}], ",", "False"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.966969903995977*^9, 3.966970001308715*^9}, {
   3.966970033923314*^9, 3.966970034346341*^9}, 3.966970087058497*^9},
 CellLabel->
  "In[109]:=",ExpressionUUID->"b86dbf86-533d-43bb-a740-f95da78e53fc"],

Cell[BoxData[
 GraphicsBox[
  {EdgeForm[GrayLevel[0]], FaceForm[None], 
   DiskBox[NCache[{Rational[-9, 2], 0}, {-4.5, 0}], {2., 1.5}], 
   DiskBox[NCache[{Rational[9, 2], 0}, {4.5, 0}], {2., 1.5}], InsetBox[
    StyleBox["\<\"D\[IAcute]as\"\>",
     StripOnInput->False,
     FontSize->11,
     FontWeight->Bold], NCache[{Rational[-9, 2], 2.}, {-4.5, 2.}]], InsetBox[
    StyleBox["\<\"C\[OAcute]digos\"\>",
     StripOnInput->False,
     FontSize->11,
     FontWeight->Bold], NCache[{Rational[9, 2], 2.}, {4.5, 2.}]], {InsetBox[
     StyleBox["\<\"Lun\"\>",
      StripOnInput->False,
      FontSize->11], NCache[{Rational[-9, 2], 0.8}, {-4.5, 0.8}]], InsetBox[
     StyleBox["\<\"Mar\"\>",
      StripOnInput->False,
      FontSize->11], 
     NCache[{Rational[-9, 2], 0.5333333333333334}, {-4.5, 
      0.5333333333333334}]], InsetBox[
     StyleBox["\<\"Mi\[EAcute]\"\>",
      StripOnInput->False,
      FontSize->11], 
     NCache[{Rational[-9, 2], 0.2666666666666668}, {-4.5, 
      0.2666666666666668}]], InsetBox[
     StyleBox["\<\"Jue\"\>",
      StripOnInput->False,
      FontSize->11], NCache[{Rational[-9, 2], 0.}, {-4.5, 0.}]], InsetBox[
     StyleBox["\<\"Vie\"\>",
      StripOnInput->False,
      FontSize->11], 
     NCache[{Rational[-9, 
        2], -0.2666666666666666}, {-4.5, -0.2666666666666666}]], InsetBox[
     StyleBox["\<\"S\[AAcute]b\"\>",
      StripOnInput->False,
      FontSize->11], 
     NCache[{Rational[-9, 
        2], -0.5333333333333332}, {-4.5, -0.5333333333333332}]], InsetBox[
     StyleBox["\<\"Dom\"\>",
      StripOnInput->False,
      FontSize->11], NCache[{Rational[-9, 2], -0.8}, {-4.5, -0.8}]]}, {
    InsetBox[
     StyleBox["1",
      StripOnInput->False,
      FontSize->11], NCache[{Rational[9, 2], 0.8}, {4.5, 0.8}]], InsetBox[
     StyleBox["2",
      StripOnInput->False,
      FontSize->11], 
     NCache[{Rational[9, 2], 0.5333333333333334}, {4.5, 0.5333333333333334}]],
     InsetBox[
     StyleBox["3",
      StripOnInput->False,
      FontSize->11], 
     NCache[{Rational[9, 2], 0.2666666666666668}, {4.5, 0.2666666666666668}]],
     InsetBox[
     StyleBox["4",
      StripOnInput->False,
      FontSize->11], NCache[{Rational[9, 2], 0.}, {4.5, 0.}]], InsetBox[
     StyleBox["5",
      StripOnInput->False,
      FontSize->11], 
     NCache[{Rational[9, 2], -0.2666666666666666}, {
      4.5, -0.2666666666666666}]], InsetBox[
     StyleBox["6",
      StripOnInput->False,
      FontSize->11], 
     NCache[{Rational[9, 2], -0.5333333333333332}, {
      4.5, -0.5333333333333332}]], InsetBox[
     StyleBox["7",
      StripOnInput->False,
      FontSize->11], NCache[{Rational[9, 2], -0.8}, {4.5, -0.8}]]}, {
    ArrowBox[{{-3.6, 0.8}, {3.6, 0.8}}], 
    ArrowBox[{{-3.6, 0.5333333333333334}, {3.6, 0.5333333333333334}}], 
    ArrowBox[{{-3.6, 0.2666666666666668}, {3.6, 0.2666666666666668}}], 
    ArrowBox[{{-3.6, 0.}, {3.6, 0.}}], 
    ArrowBox[{{-3.6, -0.2666666666666666}, {3.6, -0.2666666666666666}}], 
    ArrowBox[{{-3.6, -0.5333333333333332}, {3.6, -0.5333333333333332}}], 
    ArrowBox[{{-3.6, -0.8}, {3.6, -0.8}}]}, {ArrowBox[CompressedData["
1:eJwtUm1Ik1EU3qa4931v/gmzDyUQiaRcGBISVvcQlBIEuh+iOaJkqYHgRwZt
pggZDgxmgh9LSps2kcoUk8R+3DWXJE7DsImhmGK63Edqzc+a7Z564HI53HOe
5znn3JicQvUNhUwmiw8efo86OEKtiQglTLYVnZUmQ6wxqoVGhVkJ8/qIrpQ5
hTXDoh+pJwJ40vsP33fLrZ+erI96CgVYj9MYbX6ZtSEys0X5UQDZP1jN4S10
MU6EfcFqfUSA+e+NdBnKRTjG0+N+M6NuxuNziHBO4orbrNg3sXVgvwRqTp++
yR7N93wO00iQl8uxzqSM0sr+Zgnucjv6X8yWGr2tckpQG2TTGNfYu4HO83mE
QDu337bChBfRV7TJBEp4WORlDdG34UgugWYTx3dWsKfX31lDwM7Lbd+Yocyp
W3tOwIv9zTHvzVlHYIhAPPqdZqbJUd/YNIEK1J9gD+xPZ3O8BFqRb5gNJWS3
DGwSMOD7a4b2AgSuYdxO91ZX1PTtEijF2E5ji11vMncIuFBvnJZ9SeplqwQa
kG+KRg0WlC/PEzBjP1+p4nh15NQYAR3WL9AEJCSQhvNyUcudgj55I4Gj6NdD
tVeT3ibfIhDY5fhB8weXjKcvEVhGvVXa11GeuBNFwIn7/klTydazSpcEOE6b
n8b6spaGX0nwkq+va4NeTGvdcBZL0IT+tmj3SYez44QEVW5OuEOv181UnVkU
Ae0W/aFZJRPy+iYRsrkdzS41jXdf7rkgAsq1ySCmuyT/oVcApDPJYSX8kPpU
rQCYblRAmNsiPVYJ//lDQJtysO7DeyXgd9SHgogDVMJfdRRXgw==
     "]], InsetBox[
     StyleBox["\<\"f\"\>",
      StripOnInput->False,
      FontSize->11,
      FontSlant->Italic], {0, 3.75}]}},
  ImageSize->600,
  PlotRange->{{-9, 9}, {-3., 4.}}]], "Output",
 CellChangeTimes->{{3.966970008625248*^9, 3.9669700354939737`*^9}, 
   3.96697008743157*^9},
 CellLabel->
  "Out[109]=",ExpressionUUID->"a6dcd7ad-9830-4f90-a53e-149436654054"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Textos extra\[IAcute]dos autom\[AAcute]ticamente: 17 \
elementos\"\>"], "Print",
 CellChangeTimes->{{3.966970008628193*^9, 3.966970035500448*^9}, 
   3.966970087442398*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[109]:=",ExpressionUUID->"dfc7b61f-f61c-4e8b-97b4-ffc401e0858d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966970008628193*^9, 3.966970035500448*^9}, 
   3.966970087442967*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[109]:=",ExpressionUUID->"2e58dcd3-a85b-49a7-8ca1-620c95a6eb8f"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.966970008628193*^9, 3.966970035500448*^9}, 
   3.966970087443617*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[109]:=",ExpressionUUID->"f1e1e667-172e-4fa3-973d-afefa756bab5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966970008628193*^9, 3.966970035500448*^9}, 
   3.966970087444009*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[109]:=",ExpressionUUID->"f89deef5-d446-46fa-a11d-f8e9f6b0cff7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966970008628193*^9, 3.966970035500448*^9}, 
   3.9669700874444227`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[109]:=",ExpressionUUID->"9b93c8ea-e162-4dc2-a9ba-12ee33e4ae8f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966970008628193*^9, 3.966970035500448*^9}, 
   3.9669700874448338`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[109]:=",ExpressionUUID->"72517311-fc7e-48bb-bb63-1458f2b5901e"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.966970008628193*^9, 3.966970035500448*^9}, 
   3.966970087528204*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[109]:=",ExpressionUUID->"7df170cd-6270-488d-9515-6258c2e1b1ec"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.966970008628193*^9, 3.966970035500448*^9}, 
   3.96697008853413*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[109]:=",ExpressionUUID->"9f2673b7-bc3d-47ea-8c06-078ac1f7f343"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/diagrfun4/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/diagrfun4/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966970008628193*^9, 3.966970035500448*^9}, 
   3.966970088535989*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[109]:=",ExpressionUUID->"b93507a1-d80c-46b5-b195-16f1d20b8e75"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"diagrfun4\"\>"}],
  SequenceForm["Archivo: ", "diagrfun4"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966970008628193*^9, 3.966970035500448*^9}, 
   3.966970088537571*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[109]:=",ExpressionUUID->"dd01933b-b20e-47f3-84f5-d8819a21d7f6"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.966970008628193*^9, 3.966970035500448*^9}, 
   3.9669700892204647`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[109]:=",ExpressionUUID->"9da85193-3184-4b8a-a68e-6200319851e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/diagrfun4/diagrfun4.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/diagrfun4/diagrfun4.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966970008628193*^9, 3.966970035500448*^9}, 
   3.96697008922106*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[109]:=",ExpressionUUID->"8ce6d5f1-901b-4825-96f7-efddbf76e1e0"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/diagrfun4/diagrfun4.\
pdf\"\>"], "Output",
 CellChangeTimes->{{3.966970008625248*^9, 3.9669700354939737`*^9}, 
   3.9669700892340937`*^9},
 CellLabel->
  "Out[111]=",ExpressionUUID->"4f56bb65-9419-463c-adbe-c4b43e06900e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 5", "Subsection",
 CellChangeTimes->{{3.966968453206786*^9, 3.966968457107958*^9}, {
   3.966968746065219*^9, 3.966968746563121*^9}, 
   3.966969184568652*^9},ExpressionUUID->"c42be68c-0743-47df-9fdb-\
e9f8ac34f578"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<a\>\"", ",", "\"\<b\>\"", ",", "\"\<c\>\"", ",", "\"\<d\>\"",
      ",", "\"\<j\>\"", ",", "k", ",", "l"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "14", ",", "p", ",", "w", ",", 
     "h"}], "}"}]}], ";"}], "\n", 
 RowBox[{"diagrfun5", "=", 
  RowBox[{"DiagramaFuncion", "[", 
   RowBox[{"A", ",", "B", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<a\>\"", "->", "3"}], ",", 
      RowBox[{"\"\<b\>\"", "->", "1"}], ",", 
      RowBox[{"\"\<c\>\"", "->", "4"}], ",", 
      RowBox[{"\"\<d\>\"", "->", "2"}], ",", 
      RowBox[{"\"\<j\>\"", "->", "14"}], ",", 
      RowBox[{"k", "->", "p"}], ",", 
      RowBox[{"l", "->", "h"}]}], "}"}], ",", 
    RowBox[{"\"\<TextGapLeft\>\"", "->", "0.18"}], ",", 
    RowBox[{"\"\<TextGapRight\>\"", "->", "0.18"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"ExportToTikZ", "[", 
   RowBox[{"diagrfun5", ",", "\"\<diagrfun5.tex\>\"", ",", "False", ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<solid\>\"", ",", "\"\<blue\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "10"}], "}"}]}], "]"}], ",", "False"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{
  3.9669687595134087`*^9, {3.966968818402954*^9, 3.9669688732557917`*^9}, {
   3.966968934779031*^9, 3.966968967368087*^9}, {3.966969190738394*^9, 
   3.966969196300864*^9}},
 CellLabel->
  "In[112]:=",ExpressionUUID->"357738dd-5db3-4bf3-834d-fe7a2dca976b"],

Cell[BoxData[
 GraphicsBox[
  {EdgeForm[GrayLevel[0]], FaceForm[None], DiskBox[{-3, 0}, {1.5, 3.}], 
   DiskBox[{3, 0}, {1.5, 3.}], InsetBox[
    StyleBox["\<\"A\"\>",
     StripOnInput->False,
     FontSize->14,
     FontWeight->Bold], {-3, 3.5}], InsetBox[
    StyleBox["\<\"B\"\>",
     StripOnInput->False,
     FontSize->14,
     FontWeight->Bold], {3, 3.5}], {InsetBox[
     StyleBox["\<\"a\"\>",
      StripOnInput->False,
      FontSize->14], {-3, 2.3}], InsetBox[
     StyleBox["\<\"b\"\>",
      StripOnInput->False,
      FontSize->14], {-3, 1.5333333333333332}], InsetBox[
     StyleBox["\<\"c\"\>",
      StripOnInput->False,
      FontSize->14], {-3, 0.7666666666666668}], InsetBox[
     StyleBox["\<\"d\"\>",
      StripOnInput->False,
      FontSize->14], {-3, 0.}], InsetBox[
     StyleBox["\<\"j\"\>",
      StripOnInput->False,
      FontSize->14], {-3, -0.7666666666666665}], InsetBox[
     StyleBox["k",
      StripOnInput->False,
      FontSize->14], {-3, -1.5333333333333328}], InsetBox[
     StyleBox["l",
      StripOnInput->False,
      FontSize->14], {-3, -2.3}]}, {InsetBox[
     StyleBox["1",
      StripOnInput->False,
      FontSize->14], {3, 2.3}], InsetBox[
     StyleBox["2",
      StripOnInput->False,
      FontSize->14], {3, 1.642857142857143}], InsetBox[
     StyleBox["3",
      StripOnInput->False,
      FontSize->14], {3, 0.9857142857142858}], InsetBox[
     StyleBox["4",
      StripOnInput->False,
      FontSize->14], {3, 0.32857142857142857}], InsetBox[
     StyleBox["14",
      StripOnInput->False,
      FontSize->14], {3, -0.32857142857142835}], InsetBox[
     StyleBox["p",
      StripOnInput->False,
      FontSize->14], {3, -0.9857142857142852}], InsetBox[
     StyleBox["w",
      StripOnInput->False,
      FontSize->14], {3, -1.6428571428571423}], InsetBox[
     StyleBox["h",
      StripOnInput->False,
      FontSize->14], {3, -2.3}]}, {
    ArrowBox[{{-2.82, 2.3}, {2.82, 0.9857142857142858}}], 
    ArrowBox[{{-2.82, 1.5333333333333332`}, {2.82, 2.3}}], 
    ArrowBox[{{-2.82, 0.7666666666666668}, {2.82, 0.32857142857142857`}}], 
    ArrowBox[{{-2.82, 0.}, {2.82, 1.642857142857143}}], 
    ArrowBox[{{-2.82, -0.7666666666666665}, {2.82, -0.32857142857142835`}}], 
    ArrowBox[{{-2.82, -1.5333333333333328`}, {2.82, -0.9857142857142852}}], 
    ArrowBox[{{-2.82, -2.3}, {2.82, -2.3}}]}, {ArrowBox[CompressedData["
1:eJwtUm1Ik1EU3qa4931v/gmzDyUQiaRcGBISVvcQlBIEuh+iOaJkqYHgRwZt
pggZDgxmgh9LSps2kcoUk8R+3DWXJE7DsImhmGK63Edqzc+a7Z564HI53HOe
5znn3JicQvUNhUwmiw8efo86OEKtiQglTLYVnZUmQ6wxqoVGhVkJ8/qIrpQ5
hTXDoh+pJwJ40vsP33fLrZ+erI96CgVYj9MYbX6ZtSEys0X5UQDZP1jN4S10
MU6EfcFqfUSA+e+NdBnKRTjG0+N+M6NuxuNziHBO4orbrNg3sXVgvwRqTp++
yR7N93wO00iQl8uxzqSM0sr+Zgnucjv6X8yWGr2tckpQG2TTGNfYu4HO83mE
QDu337bChBfRV7TJBEp4WORlDdG34UgugWYTx3dWsKfX31lDwM7Lbd+Yocyp
W3tOwIv9zTHvzVlHYIhAPPqdZqbJUd/YNIEK1J9gD+xPZ3O8BFqRb5gNJWS3
DGwSMOD7a4b2AgSuYdxO91ZX1PTtEijF2E5ji11vMncIuFBvnJZ9SeplqwQa
kG+KRg0WlC/PEzBjP1+p4nh15NQYAR3WL9AEJCSQhvNyUcudgj55I4Gj6NdD
tVeT3ibfIhDY5fhB8weXjKcvEVhGvVXa11GeuBNFwIn7/klTydazSpcEOE6b
n8b6spaGX0nwkq+va4NeTGvdcBZL0IT+tmj3SYez44QEVW5OuEOv181UnVkU
Ae0W/aFZJRPy+iYRsrkdzS41jXdf7rkgAsq1ySCmuyT/oVcApDPJYSX8kPpU
rQCYblRAmNsiPVYJ//lDQJtysO7DeyXgd9SHgogDVMJfdRRXgw==
     "]], InsetBox[
     StyleBox["\<\"f\"\>",
      StripOnInput->False,
      FontSize->14,
      FontSlant->Italic], {0, 3.75}]}},
  ImageSize->520,
  PlotRange->{{-6, 6}, {-4.5, 5.5}}]], "Output",
 CellChangeTimes->{
  3.966968885947556*^9, {3.96696893634186*^9, 3.9669689680301323`*^9}, 
   3.9669701098331413`*^9},
 CellLabel->
  "Out[114]=",ExpressionUUID->"040f9cf7-dc2b-4d2d-b6bf-0edeb7aff77d"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Textos extra\[IAcute]dos autom\[AAcute]ticamente: 18 \
elementos\"\>"], "Print",
 CellChangeTimes->{
  3.966968885958107*^9, {3.966968936348876*^9, 3.9669689680357933`*^9}, 
   3.966970109837681*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"9de7135b-c68d-4508-a4aa-f976722fe1df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966968885958107*^9, {3.966968936348876*^9, 3.9669689680357933`*^9}, 
   3.966970109838705*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"61d118dc-d611-49e7-94a0-70cee22db7f2"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.966968885958107*^9, {3.966968936348876*^9, 3.9669689680357933`*^9}, 
   3.9669701098392963`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"d01c19bd-4b14-442b-84bb-6ca6f6cd6908"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966968885958107*^9, {3.966968936348876*^9, 3.9669689680357933`*^9}, 
   3.966970109839675*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"a42a3535-6b4c-43d8-b3bd-2e3c3e99bec5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966968885958107*^9, {3.966968936348876*^9, 3.9669689680357933`*^9}, 
   3.966970109840076*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"7df20577-a007-4cb6-b6cd-0b04207f2341"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966968885958107*^9, {3.966968936348876*^9, 3.9669689680357933`*^9}, 
   3.966970109840467*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"f02d6a7e-a319-4405-809d-91515800a8ec"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.966968885958107*^9, {3.966968936348876*^9, 3.9669689680357933`*^9}, 
   3.96697010992031*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"f50fddd3-dcdd-4cfa-a8fd-1ba0c3f6d1de"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.966968885958107*^9, {3.966968936348876*^9, 3.9669689680357933`*^9}, 
   3.966970110926526*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"08c0cbe4-a07e-4230-8e34-b1d5bf90d22a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/diagrfun5/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/diagrfun5/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966968885958107*^9, {3.966968936348876*^9, 3.9669689680357933`*^9}, 
   3.966970110930197*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"ba39e455-504e-49fd-8861-dd79e0b94f54"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"diagrfun5\"\>"}],
  SequenceForm["Archivo: ", "diagrfun5"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966968885958107*^9, {3.966968936348876*^9, 3.9669689680357933`*^9}, 
   3.966970110932065*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"abc687fa-9758-45da-9aca-0d35208d6e8e"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.966968885958107*^9, {3.966968936348876*^9, 3.9669689680357933`*^9}, 
   3.966970111631206*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"3db82203-d545-4e70-ab03-80ba0f3ae2a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/diagrfun5/diagrfun5.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/diagrfun5/diagrfun5.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966968885958107*^9, {3.966968936348876*^9, 3.9669689680357933`*^9}, 
   3.966970111631765*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[112]:=",ExpressionUUID->"4a493ee9-0a4c-4c2e-8247-8a5771a86047"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/diagrfun5/diagrfun5.\
pdf\"\>"], "Output",
 CellChangeTimes->{
  3.966968885947556*^9, {3.96696893634186*^9, 3.9669689680301323`*^9}, 
   3.9669701116445227`*^9},
 CellLabel->
  "Out[116]=",ExpressionUUID->"8040d1bc-e9ec-436b-9f8a-26cfde6fdcee"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DiagramaCuadricula", "Section",
 CellChangeTimes->{
  3.966970174981942*^9},ExpressionUUID->"bb5c793c-6bb5-4fab-b75e-\
14f42afdc8a5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "DiagramaCuadricula"}]], "Input",
 CellChangeTimes->{{3.9669703782823973`*^9, 3.966970385332217*^9}},
 CellLabel->
  "In[121]:=",ExpressionUUID->"a480a174-c7e5-4c3a-80d2-4ab260645352"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DiagramaCuadricula[labels, opts] crea un diagrama \
en forma de cuadr\[IAcute]cula con cajas rectangulares que contienen \
etiquetas, opcionalmente conectadas con \
flechas.\\n\\nPAR\[CapitalAAcute]METROS:\\n- labels: Lista de etiquetas/texto \
que aparecer\[AAcute]n dentro de cada caja\\n- opts: Opciones adicionales \
para personalizar el diagrama (ver OPCIONES)\\n\\nOPCIONES:\\n- \\\"Grid\\\" \
-> {2, 3}: Lista {filas, columnas} que define la disposici\[OAcute]n de la \
cuadr\[IAcute]cula (por defecto {2, 3})\\n- \\\"BoxSize\\\" -> {2, 1}: Lista \
{ancho, alto} que especifica las dimensiones de cada caja (por defecto {2, \
1})\\n- \\\"Gap\\\" -> {1, 1}: Lista {separaci\[OAcute]n_horizontal, separaci\
\[OAcute]n_vertical} entre cajas (por defecto {1, 1})\\n- \\\"StartPos\\\" -> \
{0, 0}: Lista {x, y} que define la posici\[OAcute]n inicial de la primera \
caja (esquina inferior-izquierda) (por defecto {0, 0})\\n- \\\"BoxStyle\\\" \
-> {EdgeForm[Black], FaceForm[LightYellow]}: Estilo de los \
rect\[AAcute]ngulos (borde y relleno) (por defecto borde negro con relleno \
amarillo claro)\\n- \\\"LabelStyle\\\" -> Directive[Black, 14, Bold]: Estilo \
del texto de las etiquetas (color, tama\[NTilde]o, formato) (por defecto \
negro, tama\[NTilde]o 14, negrita)\\n- \\\"Connect\\\" -> True: True/False \
para mostrar flechas conectando cajas horizontalmente en la misma fila (por \
defecto True)\\n- \\\"ArrowStyle\\\" -> Thick: Estilo de las flechas de \
conexi\[OAcute]n (por defecto grosor Thick)\\n\\nFUNCIONALIDAD:\\n- Crea una \
cuadr\[IAcute]cula organizada con el n\[UAcute]mero especificado de filas y \
columnas\\n- Coloca las etiquetas en orden de izquierda a derecha, de arriba \
hacia abajo\\n- Si hay m\[AAcute]s etiquetas que posiciones en la cuadr\
\[IAcute]cula, usa solo las primeras n etiquetas\\n- Si hay menos etiquetas \
que posiciones, solo crea las cajas necesarias\\n- Las flechas conectan cajas \
consecutivas en la misma fila (horizontal)\\n- NO hay conexiones verticales \
entre filas\\n- Genera un objeto Graphics de Mathematica listo para \
mostrar\\n\\nVALOR DE RETORNO:\\nRetorna un objeto Graphics que puede \
mostrarse directamente o exportarse.\\n\\nEJEMPLOS:\\n- \
DiagramaCuadricula[{\\\"A\\\", \\\"B\\\", \\\"C\\\", \\\"D\\\"}]\\n  % Crea \
cuadr\[IAcute]cula 2\[Times]3 con 4 cajas etiquetadas\\n- \
DiagramaCuadricula[{\\\"Inicio\\\", \\\"Proceso\\\", \\\"Fin\\\"}, \\\"Grid\\\
\" -> {1, 3}, \\\"Connect\\\" -> True]\\n  % Crea una fila horizontal de 3 \
cajas conectadas\\n- DiagramaCuadricula[{\\\"1\\\", \\\"2\\\", \\\"3\\\", \
\\\"4\\\", \\\"5\\\", \\\"6\\\"}, \\\"Grid\\\" -> {2, 3}, \\\"BoxSize\\\" -> \
{3, 1.5}, \\\"Gap\\\" -> {0.5, 0.8}]\\n  % Cuadr\[IAcute]cula 2\[Times]3 \
completa con cajas m\[AAcute]s grandes y separaci\[OAcute]n personalizada\\n- \
DiagramaCuadricula[{\\\"A\\\", \\\"B\\\", \\\"C\\\"}, \\\"BoxStyle\\\" -> \
{EdgeForm[Red], FaceForm[LightBlue]}, \\\"Connect\\\" -> False]\\n  % Cajas \
con estilo personalizado sin flechas\\n\\nCASOS ESPECIALES:\\n- Si labels \
tiene menos elementos que posiciones en la cuadr\[IAcute]cula, solo se crean \
las cajas necesarias\\n- Si labels tiene m\[AAcute]s elementos que \
posiciones, se usan solo los primeros elementos\\n- Las flechas solo conectan \
cajas adyacentes en la misma fila (no entre filas)\\n- La posici\[OAcute]n se \
calcula desde la esquina inferior-izquierda de cada caja\\n\\nUSO T\
\[CapitalIAcute]PICO:\\nIdeal para crear diagramas de flujo simples, \
organigramas, representaciones de procesos secuenciales, o cualquier \
visualizaci\[OAcute]n que requiera elementos organizados en \
cuadr\[IAcute]cula con conexiones opcionales.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"DiagramaCuadricula", "[", 
                    RowBox[{"VilTeX`Private`labels_List", ",", 
                    RowBox[{"VilTeX`Private`opts", ":", 
                    RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`n", "=", 
                    RowBox[{"Length", "[", "VilTeX`Private`labels", "]"}]}], 
                    ",", "VilTeX`Private`w", ",", "VilTeX`Private`h", ",", 
                    "VilTeX`Private`rows", ",", "VilTeX`Private`cols", ",", 
                    "VilTeX`Private`gx", ",", "VilTeX`Private`gy", ",", 
                    "VilTeX`Private`x0", ",", "VilTeX`Private`y0", ",", 
                    "VilTeX`Private`boxStyle", ",", "VilTeX`Private`labSty", 
                    ",", "VilTeX`Private`connectQ", ",", 
                    "VilTeX`Private`arrSty", ",", "VilTeX`Private`coords", 
                    ",", "VilTeX`Private`boxes", ",", 
                    "VilTeX`Private`centers", ",", "VilTeX`Private`texts", 
                    ",", "VilTeX`Private`arrows"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`rows", ",", 
                    "VilTeX`Private`cols"}], "}"}], "=", 
                    RowBox[{"OptionValue", "[", "\"Grid\"", "]"}]}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`w", ",", "VilTeX`Private`h"}], 
                    "}"}], "=", 
                    RowBox[{"OptionValue", "[", "\"BoxSize\"", "]"}]}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`gx", ",", "VilTeX`Private`gy"}], 
                    "}"}], "=", 
                    RowBox[{"OptionValue", "[", "\"Gap\"", "]"}]}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`x0", ",", "VilTeX`Private`y0"}], 
                    "}"}], "=", 
                    RowBox[{"OptionValue", "[", "\"StartPos\"", "]"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`boxStyle", "=", 
                    RowBox[{"OptionValue", "[", "\"BoxStyle\"", "]"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`labSty", "=", 
                    RowBox[{"OptionValue", "[", "\"LabelStyle\"", "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`connectQ", "=", 
                    RowBox[{"TrueQ", "[", 
                    RowBox[{"OptionValue", "[", "\"Connect\"", "]"}], "]"}]}],
                     ";", 
                    RowBox[{"VilTeX`Private`arrSty", "=", 
                    RowBox[{"OptionValue", "[", "\"ArrowStyle\"", "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`coords", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`x0", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`j", "-", "1"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`w", "+", "VilTeX`Private`gx"}], 
                    ")"}]}]}], ",", 
                    RowBox[{"VilTeX`Private`y0", "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`h", "+", "VilTeX`Private`gy"}], 
                    ")"}]}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", "1", ",", 
                    "VilTeX`Private`rows"}], "}"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`j", ",", "1", ",", 
                    "VilTeX`Private`cols"}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`coords", "=", 
                    RowBox[{"Take", "[", 
                    RowBox[{
                    RowBox[{"Flatten", "[", 
                    RowBox[{"VilTeX`Private`coords", ",", "1"}], "]"}], ",", 
                    "VilTeX`Private`n"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`boxes", "=", 
                    RowBox[{"Join", "[", 
                    RowBox[{"VilTeX`Private`boxStyle", ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Rectangle", "[", 
                    RowBox[{"#1", ",", 
                    RowBox[{"#1", "+", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`w", ",", "VilTeX`Private`h"}], 
                    "}"}]}]}], "]"}], "&"}], ")"}], "/@", 
                    "VilTeX`Private`coords"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`centers", "=", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "+", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["VilTeX`Private`w", "2"], ",", 
                    FractionBox["VilTeX`Private`h", "2"]}], "}"}]}], "&"}], 
                    ")"}], "/@", "VilTeX`Private`coords"}]}], ";", 
                    RowBox[{"VilTeX`Private`texts", "=", 
                    RowBox[{"MapThread", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Text", "[", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#1", ",", "VilTeX`Private`labSty"}], "]"}], ",", 
                    "#2"}], "]"}], "&"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`labels", ",", 
                    "VilTeX`Private`centers"}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`arrows", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`connectQ", ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`arrSty", ",", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Quotient", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ",", 
                    "VilTeX`Private`cols"}], "]"}], "\[Equal]", 
                    RowBox[{"Quotient", "[", 
                    RowBox[{"VilTeX`Private`i", ",", "VilTeX`Private`cols"}], 
                    "]"}]}], ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`coords", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "+", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`w", ",", 
                    FractionBox["VilTeX`Private`h", "2"]}], "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`coords", "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", "+", "1"}], 
                    "\[RightDoubleBracket]"}], "+", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["VilTeX`Private`h", "2"]}], "}"}]}]}], "}"}], 
                    "]"}], ",", "Nothing"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", "1", ",", 
                    RowBox[{"VilTeX`Private`n", "-", "1"}]}], "}"}]}], 
                    "]"}]}], "}"}], ",", 
                    RowBox[{"{", "}"}]}], "]"}]}], ";", 
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`boxes", ",", 
                    "VilTeX`Private`texts", ",", "VilTeX`Private`arrows"}], 
                    "}"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "20"}], ",", 
                    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}]}], 
                    "]"}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   PaneSelectorBox[{True->
                    ButtonBox[
                    PaneSelectorBox[{False->
                    TemplateBox[{"\[ThickSpace]", "\"\[ThickSpace]\"", 
                    StyleBox[
                    "\"Options\"", "InformationRowLabel", StripOnInput -> 
                    False], 
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "DownPointerOpener"]]},
                    "RowWithSeparators"], True->
                    TemplateBox[{"\[ThickSpace]", "\"\[ThickSpace]\"", 
                    StyleBox[
                    "\"Options\"", "InformationRowLabel", StripOnInput -> 
                    False], 
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "DownPointerOpenerHot"]]},
                    "RowWithSeparators"]}, Dynamic[
                    CurrentValue["MouseOver"]],
                    FrameMargins->0,
                    ImageSize->Automatic],
                    Appearance->None,
                    BaseStyle->None,
                    
                    ButtonFunction:>(Part[System`InformationDump`open$$, 3] = 
                    False),
                    Evaluator->Automatic,
                    FrameMargins->0,
                    ImageMargins->0,
                    Method->"Preemptive"], False->
                    ButtonBox[
                    PaneSelectorBox[{False->
                    TemplateBox[{"\[ThickSpace]", "\"\[ThickSpace]\"", 
                    StyleBox[
                    "\"Options\"", "InformationRowLabel", StripOnInput -> 
                    False], 
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "RightPointerOpener"]]},
                    "RowWithSeparators"], True->
                    TemplateBox[{"\[ThickSpace]", "\"\[ThickSpace]\"", 
                    StyleBox[
                    "\"Options\"", "InformationRowLabel", StripOnInput -> 
                    False], 
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "RightPointerOpenerHot"]]},
                    "RowWithSeparators"]}, Dynamic[
                    CurrentValue["MouseOver"]],
                    FrameMargins->0,
                    ImageSize->Automatic],
                    Appearance->None,
                    BaseStyle->None,
                    
                    ButtonFunction:>(Part[System`InformationDump`open$$, 3] = 
                    True),
                    Evaluator->Automatic,
                    FrameMargins->0,
                    ImageMargins->0,
                    Method->"Preemptive"]}, Dynamic[
                    FEPrivate`Part[System`InformationDump`open$$, 3]]], 
                   PaneSelectorBox[{True->GridBox[{
                    {
                    RowBox[{"\<\"Grid\"\>", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "3"}], "}"}]}]},
                    {
                    RowBox[{"\<\"BoxSize\"\>", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "1"}], "}"}]}]},
                    {
                    RowBox[{"\<\"Gap\"\>", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1"}], "}"}]}]},
                    {
                    RowBox[{"\<\"StartPos\"\>", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}]}]},
                    {
                    RowBox[{"\<\"BoxStyle\"\>", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"EdgeForm", "[", 
                    TemplateBox[<|"color" -> GrayLevel[0]|>,
                    "GrayLevelColorSwatchTemplate"], "]"}], ",", 
                    RowBox[{"FaceForm", "[", 
                    TemplateBox[<|"color" -> RGBColor[1, 1, 0.85]|>,
                    "RGBColorSwatchTemplate"], "]"}]}], "}"}]}]},
                    {
                    RowBox[{"\<\"LabelStyle\"\>", "\[Rule]", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    TemplateBox[<|"color" -> GrayLevel[0]|>,
                    "GrayLevelColorSwatchTemplate"], ",", "14", ",", "Bold"}],
                     "]"}]}]},
                    {
                    RowBox[{"\<\"Connect\"\>", "\[Rule]", "True"}]},
                    {
                    RowBox[{"\<\"ArrowStyle\"\>", "\[Rule]", 
                    RowBox[{"Thickness", "[", "Large", "]"}]}]},
                    {
                    StyleBox[
                    
                    TemplateBox[{
                    "\"(\"", "\"\[InvisibleSpace]\"", "8", "\" total)\""},
                    "RowDefault"], "InformationRowOpener",
                    StripOnInput->False]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{1.}}}], False->
                    RowBox[{
                    RowBox[{"\<\"Grid\"\>", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "3"}], "}"}]}], "\[ThinSpace]", 
                    StyleBox["\<\"\[Ellipsis]\"\>", "InformationRowOpener",
                    StripOnInput->False], "\[ThinSpace]", 
                    StyleBox[
                    
                    TemplateBox[{
                    "\"(\"", "\"\[InvisibleSpace]\"", "8", "\" total)\""},
                    "RowDefault"], "InformationRowOpener",
                    StripOnInput->False]}]}, Dynamic[
                    FEPrivate`Part[System`InformationDump`open$$, 3]],
                    BaselinePosition->Baseline,
                    ImageSize->Automatic]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilTeX`DiagramaCuadricula\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DiagramaCuadricula[labels, opts] crea un diagrama \
en forma de cuadr\[IAcute]cula con cajas rectangulares que contienen \
etiquetas, opcionalmente conectadas con \
flechas.\\n\\nPAR\[CapitalAAcute]METROS:\\n- labels: Lista de etiquetas/texto \
que aparecer\[AAcute]n dentro de cada caja\\n- opts: Opciones adicionales \
para personalizar el diagrama (ver OPCIONES)\\n\\nOPCIONES:\\n- \\\"Grid\\\" \
-> {2, 3}: Lista {filas, columnas} que define la disposici\[OAcute]n de la \
cuadr\[IAcute]cula (por defecto {2, 3})\\n- \\\"BoxSize\\\" -> {2, 1}: Lista \
{ancho, alto} que especifica las dimensiones de cada caja (por defecto {2, \
1})\\n- \\\"Gap\\\" -> {1, 1}: Lista {separaci\[OAcute]n_horizontal, separaci\
\[OAcute]n_vertical} entre cajas (por defecto {1, 1})\\n- \\\"StartPos\\\" -> \
{0, 0}: Lista {x, y} que define la posici\[OAcute]n inicial de la primera \
caja (esquina inferior-izquierda) (por defecto {0, 0})\\n- \\\"BoxStyle\\\" \
-> {EdgeForm[Black], FaceForm[LightYellow]}: Estilo de los \
rect\[AAcute]ngulos (borde y relleno) (por defecto borde negro con relleno \
amarillo claro)\\n- \\\"LabelStyle\\\" -> Directive[Black, 14, Bold]: Estilo \
del texto de las etiquetas (color, tama\[NTilde]o, formato) (por defecto \
negro, tama\[NTilde]o 14, negrita)\\n- \\\"Connect\\\" -> True: True/False \
para mostrar flechas conectando cajas horizontalmente en la misma fila (por \
defecto True)\\n- \\\"ArrowStyle\\\" -> Thick: Estilo de las flechas de \
conexi\[OAcute]n (por defecto grosor Thick)\\n\\nFUNCIONALIDAD:\\n- Crea una \
cuadr\[IAcute]cula organizada con el n\[UAcute]mero especificado de filas y \
columnas\\n- Coloca las etiquetas en orden de izquierda a derecha, de arriba \
hacia abajo\\n- Si hay m\[AAcute]s etiquetas que posiciones en la cuadr\
\[IAcute]cula, usa solo las primeras n etiquetas\\n- Si hay menos etiquetas \
que posiciones, solo crea las cajas necesarias\\n- Las flechas conectan cajas \
consecutivas en la misma fila (horizontal)\\n- NO hay conexiones verticales \
entre filas\\n- Genera un objeto Graphics de Mathematica listo para \
mostrar\\n\\nVALOR DE RETORNO:\\nRetorna un objeto Graphics que puede \
mostrarse directamente o exportarse.\\n\\nEJEMPLOS:\\n- \
DiagramaCuadricula[{\\\"A\\\", \\\"B\\\", \\\"C\\\", \\\"D\\\"}]\\n  % Crea \
cuadr\[IAcute]cula 2\[Times]3 con 4 cajas etiquetadas\\n- \
DiagramaCuadricula[{\\\"Inicio\\\", \\\"Proceso\\\", \\\"Fin\\\"}, \\\"Grid\\\
\" -> {1, 3}, \\\"Connect\\\" -> True]\\n  % Crea una fila horizontal de 3 \
cajas conectadas\\n- DiagramaCuadricula[{\\\"1\\\", \\\"2\\\", \\\"3\\\", \
\\\"4\\\", \\\"5\\\", \\\"6\\\"}, \\\"Grid\\\" -> {2, 3}, \\\"BoxSize\\\" -> \
{3, 1.5}, \\\"Gap\\\" -> {0.5, 0.8}]\\n  % Cuadr\[IAcute]cula 2\[Times]3 \
completa con cajas m\[AAcute]s grandes y separaci\[OAcute]n personalizada\\n- \
DiagramaCuadricula[{\\\"A\\\", \\\"B\\\", \\\"C\\\"}, \\\"BoxStyle\\\" -> \
{EdgeForm[Red], FaceForm[LightBlue]}, \\\"Connect\\\" -> False]\\n  % Cajas \
con estilo personalizado sin flechas\\n\\nCASOS ESPECIALES:\\n- Si labels \
tiene menos elementos que posiciones en la cuadr\[IAcute]cula, solo se crean \
las cajas necesarias\\n- Si labels tiene m\[AAcute]s elementos que \
posiciones, se usan solo los primeros elementos\\n- Las flechas solo conectan \
cajas adyacentes en la misma fila (no entre filas)\\n- La posici\[OAcute]n se \
calcula desde la esquina inferior-izquierda de cada caja\\n\\nUSO T\
\[CapitalIAcute]PICO:\\nIdeal para crear diagramas de flujo simples, \
organigramas, representaciones de procesos secuenciales, o cualquier \
visualizaci\[OAcute]n que requiera elementos organizados en \
cuadr\[IAcute]cula con conexiones opcionales.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}},
            ScrollPosition->{0., 0.}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "DiagramaCuadricula[labels, opts] crea un diagrama en forma de cuadr\
\[IAcute]cula con cajas rectangulares que contienen etiquetas, opcionalmente \
conectadas con flechas.\n\nPAR\[CapitalAAcute]METROS:\n- labels: Lista de \
etiquetas/texto que aparecer\[AAcute]n dentro de cada caja\n- opts: Opciones \
adicionales para personalizar el diagrama (ver OPCIONES)\n\nOPCIONES:\n- \
\"Grid\" -> {2, 3}: Lista {filas, columnas} que define la disposici\[OAcute]n \
de la cuadr\[IAcute]cula (por defecto {2, 3})\n- \"BoxSize\" -> {2, 1}: Lista \
{ancho, alto} que especifica las dimensiones de cada caja (por defecto {2, \
1})\n- \"Gap\" -> {1, 1}: Lista {separaci\[OAcute]n_horizontal, separaci\
\[OAcute]n_vertical} entre cajas (por defecto {1, 1})\n- \"StartPos\" -> {0, \
0}: Lista {x, y} que define la posici\[OAcute]n inicial de la primera caja \
(esquina inferior-izquierda) (por defecto {0, 0})\n- \"BoxStyle\" -> \
{EdgeForm[Black], FaceForm[LightYellow]}: Estilo de los rect\[AAcute]ngulos \
(borde y relleno) (por defecto borde negro con relleno amarillo claro)\n- \
\"LabelStyle\" -> Directive[Black, 14, Bold]: Estilo del texto de las \
etiquetas (color, tama\[NTilde]o, formato) (por defecto negro, tama\[NTilde]o \
14, negrita)\n- \"Connect\" -> True: True/False para mostrar flechas \
conectando cajas horizontalmente en la misma fila (por defecto True)\n- \
\"ArrowStyle\" -> Thick: Estilo de las flechas de conexi\[OAcute]n (por \
defecto grosor Thick)\n\nFUNCIONALIDAD:\n- Crea una cuadr\[IAcute]cula \
organizada con el n\[UAcute]mero especificado de filas y columnas\n- Coloca \
las etiquetas en orden de izquierda a derecha, de arriba hacia abajo\n- Si \
hay m\[AAcute]s etiquetas que posiciones en la cuadr\[IAcute]cula, usa solo \
las primeras n etiquetas\n- Si hay menos etiquetas que posiciones, solo crea \
las cajas necesarias\n- Las flechas conectan cajas consecutivas en la misma \
fila (horizontal)\n- NO hay conexiones verticales entre filas\n- Genera un \
objeto Graphics de Mathematica listo para mostrar\n\nVALOR DE RETORNO:\n\
Retorna un objeto Graphics que puede mostrarse directamente o exportarse.\n\n\
EJEMPLOS:\n- DiagramaCuadricula[{\"A\", \"B\", \"C\", \"D\"}]\n  % Crea cuadr\
\[IAcute]cula 2\[Times]3 con 4 cajas etiquetadas\n- \
DiagramaCuadricula[{\"Inicio\", \"Proceso\", \"Fin\"}, \"Grid\" -> {1, 3}, \
\"Connect\" -> True]\n  % Crea una fila horizontal de 3 cajas conectadas\n- \
DiagramaCuadricula[{\"1\", \"2\", \"3\", \"4\", \"5\", \"6\"}, \"Grid\" -> \
{2, 3}, \"BoxSize\" -> {3, 1.5}, \"Gap\" -> {0.5, 0.8}]\n  % \
Cuadr\[IAcute]cula 2\[Times]3 completa con cajas m\[AAcute]s grandes y \
separaci\[OAcute]n personalizada\n- DiagramaCuadricula[{\"A\", \"B\", \"C\"}, \
\"BoxStyle\" -> {EdgeForm[Red], FaceForm[LightBlue]}, \"Connect\" -> False]\n \
 % Cajas con estilo personalizado sin flechas\n\nCASOS ESPECIALES:\n- Si \
labels tiene menos elementos que posiciones en la cuadr\[IAcute]cula, solo se \
crean las cajas necesarias\n- Si labels tiene m\[AAcute]s elementos que \
posiciones, se usan solo los primeros elementos\n- Las flechas solo conectan \
cajas adyacentes en la misma fila (no entre filas)\n- La posici\[OAcute]n se \
calcula desde la esquina inferior-izquierda de cada caja\n\nUSO T\
\[CapitalIAcute]PICO:\nIdeal para crear diagramas de flujo simples, \
organigramas, representaciones de procesos secuenciales, o cualquier \
visualizaci\[OAcute]n que requiera elementos organizados en \
cuadr\[IAcute]cula con conexiones opcionales.", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilTeX`DiagramaCuadricula, {VilTeX`DiagramaCuadricula[
         Pattern[VilTeX`Private`labels, 
          Blank[List]], 
         Pattern[VilTeX`Private`opts, 
          OptionsPattern[]]] :> 
       Module[{VilTeX`Private`n = Length[VilTeX`Private`labels], 
          VilTeX`Private`w, VilTeX`Private`h, VilTeX`Private`rows, 
          VilTeX`Private`cols, VilTeX`Private`gx, VilTeX`Private`gy, 
          VilTeX`Private`x0, VilTeX`Private`y0, VilTeX`Private`boxStyle, 
          VilTeX`Private`labSty, VilTeX`Private`connectQ, 
          VilTeX`Private`arrSty, VilTeX`Private`coords, VilTeX`Private`boxes, 
          VilTeX`Private`centers, VilTeX`Private`texts, 
          VilTeX`Private`arrows}, {VilTeX`Private`rows, VilTeX`Private`cols} = 
          OptionValue["Grid"]; {VilTeX`Private`w, VilTeX`Private`h} = 
          OptionValue["BoxSize"]; {VilTeX`Private`gx, VilTeX`Private`gy} = 
          OptionValue["Gap"]; {VilTeX`Private`x0, VilTeX`Private`y0} = 
          OptionValue["StartPos"]; 
         VilTeX`Private`boxStyle = OptionValue["BoxStyle"]; 
         VilTeX`Private`labSty = OptionValue["LabelStyle"]; 
         VilTeX`Private`connectQ = TrueQ[
            OptionValue["Connect"]]; 
         VilTeX`Private`arrSty = OptionValue["ArrowStyle"]; 
         VilTeX`Private`coords = 
          Table[{VilTeX`Private`x0 + (VilTeX`Private`j - 1) (VilTeX`Private`w + 
               VilTeX`Private`gx), 
             VilTeX`Private`y0 - (VilTeX`Private`i - 1) (VilTeX`Private`h + 
              VilTeX`Private`gy)}, {
            VilTeX`Private`i, 1, VilTeX`Private`rows}, {
            VilTeX`Private`j, 1, VilTeX`Private`cols}]; 
         VilTeX`Private`coords = Take[
            Flatten[VilTeX`Private`coords, 1], VilTeX`Private`n]; 
         VilTeX`Private`boxes = Join[VilTeX`Private`boxStyle, 
            Map[
            Rectangle[#, # + {VilTeX`Private`w, VilTeX`Private`h}]& , 
             VilTeX`Private`coords]]; 
         VilTeX`Private`centers = 
          Map[# + {VilTeX`Private`w/2, VilTeX`Private`h/2}& , 
            VilTeX`Private`coords]; VilTeX`Private`texts = MapThread[Text[
             Style[#, VilTeX`Private`labSty], #2]& , {
            VilTeX`Private`labels, VilTeX`Private`centers}]; 
         VilTeX`Private`arrows = 
          If[VilTeX`Private`connectQ, {VilTeX`Private`arrSty, 
             Table[
              If[
              Quotient[VilTeX`Private`i - 1, VilTeX`Private`cols] == 
               Quotient[VilTeX`Private`i, VilTeX`Private`cols], 
               
               Arrow[{Part[VilTeX`Private`coords, VilTeX`Private`i] + {
                  VilTeX`Private`w, VilTeX`Private`h/2}, 
                 Part[VilTeX`Private`coords, VilTeX`Private`i + 1] + {
                  0, VilTeX`Private`h/2}}], Nothing], {
              VilTeX`Private`i, 1, VilTeX`Private`n - 1}]}, {}]; 
         Graphics[{
           VilTeX`Private`boxes, VilTeX`Private`texts, VilTeX`Private`arrows},
            ImagePadding -> 20, PlotRange -> All]]}], "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> {
     "Grid" -> {2, 3}, "BoxSize" -> {2, 1}, "Gap" -> {1, 1}, 
      "StartPos" -> {0, 0}, "BoxStyle" -> {
        EdgeForm[
         GrayLevel[0]], 
        FaceForm[
         RGBColor[1, 1, 0.85]]}, "LabelStyle" -> Directive[
        GrayLevel[0], 14, Bold], "Connect" -> True, "ArrowStyle" -> 
      Thickness[Large]}, "Attributes" -> {Protected}, "FullName" -> 
    "VilTeX`DiagramaCuadricula"|>, False]]], "Output",
 CellChangeTimes->{3.966970386295149*^9},
 CellLabel->
  "Out[121]=",ExpressionUUID->"43257195-08a6-414d-ba97-6dd0e4f50ca9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 1: uso b\[AAcute]sico", "Subsection",
 CellChangeTimes->{{3.966970304822545*^9, 
  3.966970315516439*^9}},ExpressionUUID->"121841cd-42d1-4f9e-bb72-\
c71d2d2807f5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"labels", "=", 
    RowBox[{"{", 
     RowBox[{"\"\<Inicio\>\"", ",", "\"\<Paso 1\>\"", ",", "\"\<Paso 2\>\"", 
      ",", "\"\<Paso 3\>\"", ",", "\"\<Revisi\[OAcute]n\>\"", 
      ",", "\"\<Fin\>\""}], "}"}]}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{"diagrcuad1", "=", 
  RowBox[{"DiagramaCuadricula", "[", 
   RowBox[{"labels", ",", 
    RowBox[{"\"\<Grid\>\"", "->", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], ",", 
    RowBox[{"\"\<BoxSize\>\"", "->", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}]}], ",", 
    RowBox[{"\"\<Gap\>\"", "->", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], ",", 
    RowBox[{"\"\<Connect\>\"", "->", "False"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZ", "[", 
   RowBox[{
   "diagrcuad1", ",", "\"\<diagrcuad1.tex\>\"", ",", "False", 
    ",", "\"\<black\>\"", ",", "False"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.966954359546886*^9, 3.966954359952547*^9}, {
  3.966970200550798*^9, 3.966970246937057*^9}},
 CellLabel->
  "In[264]:=",ExpressionUUID->"95771df8-5adb-4eac-a521-33f3fddc89d1"],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[GrayLevel[0]], FaceForm[RGBColor[1, 1, 0.85]], 
    RectangleBox[{0, 0}, {2, 1}], RectangleBox[{3, 0}, {5, 1}], 
    RectangleBox[{6, 0}, {8, 1}], RectangleBox[{0, -2}, {2, -1}], 
    RectangleBox[{3, -2}, {5, -1}], RectangleBox[{6, -2}, {8, -1}]}, {InsetBox[
     StyleBox["\<\"Inicio\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->14,
      FontWeight->Bold,
      FontColor->GrayLevel[0]], NCache[{1, Rational[1, 2]}, {1, 0.5}]], 
    InsetBox[
     StyleBox["\<\"Paso 1\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->14,
      FontWeight->Bold,
      FontColor->GrayLevel[0]], NCache[{4, Rational[1, 2]}, {4, 0.5}]], 
    InsetBox[
     StyleBox["\<\"Paso 2\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->14,
      FontWeight->Bold,
      FontColor->GrayLevel[0]], NCache[{7, Rational[1, 2]}, {7, 0.5}]], 
    InsetBox[
     StyleBox["\<\"Paso 3\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->14,
      FontWeight->Bold,
      FontColor->GrayLevel[0]], NCache[{1, Rational[-3, 2]}, {1, -1.5}]], 
    InsetBox[
     StyleBox["\<\"Revisi\[OAcute]n\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->14,
      FontWeight->Bold,
      FontColor->GrayLevel[0]], NCache[{4, Rational[-3, 2]}, {4, -1.5}]], 
    InsetBox[
     StyleBox["\<\"Fin\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->14,
      FontWeight->Bold,
      FontColor->GrayLevel[0]], NCache[{7, Rational[-3, 2]}, {7, -1.5}]]}, {}},
  ImagePadding->20,
  PlotRange->All]], "Output",
 CellChangeTimes->{3.9669702736088142`*^9, 3.9669721181438313`*^9},
 CellLabel->
  "Out[265]=",ExpressionUUID->"e5d5d5ab-4945-4a2f-83c7-780c8a2fb943"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Textos extra\[IAcute]dos autom\[AAcute]ticamente: 6 \
elementos\"\>"], "Print",
 CellChangeTimes->{3.966970273610219*^9, 3.966972118145199*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[264]:=",ExpressionUUID->"83c68e08-e5dc-4afe-b449-cef5f3088346"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966970273610219*^9, 3.9669721181458406`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[264]:=",ExpressionUUID->"e0d7cb80-c568-4364-9977-5eb9679603d0"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.966970273610219*^9, 3.9669721181466103`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[264]:=",ExpressionUUID->"92aa0923-1ac4-49c3-bd38-3c179539c9fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966970273610219*^9, 3.966972118147081*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[264]:=",ExpressionUUID->"580fdbea-8b00-464b-a805-8c70fcfb1579"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966970273610219*^9, 3.966972118147546*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[264]:=",ExpressionUUID->"430145a5-c8d9-40d4-8eb0-5306b323d190"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.966970273610219*^9, 3.966972118147991*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[264]:=",ExpressionUUID->"c2fa5499-e3da-4364-b043-21d2fa96b39f"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.966970273610219*^9, 3.966972118240012*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[264]:=",ExpressionUUID->"0ce7da85-852a-474f-b5dc-2a41a26bce43"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.966970273610219*^9, 3.966972119247224*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[264]:=",ExpressionUUID->"4d449f8a-7b11-48d2-ae11-4cd08608e61c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/diagrcuad1/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/diagrcuad1/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966970273610219*^9, 3.966972119250598*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[264]:=",ExpressionUUID->"4be1ea8a-22c1-420e-bd3c-d544dffd2857"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"diagrcuad1\"\>"}],
  SequenceForm["Archivo: ", "diagrcuad1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966970273610219*^9, 3.966972119252269*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[264]:=",ExpressionUUID->"36dea168-48d5-42aa-bcb2-fbedb66c767d"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.966970273610219*^9, 3.96697211983147*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[264]:=",ExpressionUUID->"75069e9e-0378-49a1-a34d-dd513494cb7e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/diagrcuad1/diagrcuad1.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/diagrcuad1/diagrcuad1.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966970273610219*^9, 3.966972119832128*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[264]:=",ExpressionUUID->"f9d46b14-75fd-4c5a-99f8-4ba30905feb1"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/diagrcuad1/\
diagrcuad1.pdf\"\>"], "Output",
 CellChangeTimes->{3.9669702736088142`*^9, 3.966972119844186*^9},
 CellLabel->
  "Out[267]=",ExpressionUUID->"0f64bfd7-4522-4304-944a-2792b529b59b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 2: proceso de desarrollo de software", "Subsection",
 CellChangeTimes->{{3.966970322927779*^9, 
  3.966970339293765*^9}},ExpressionUUID->"15a6b371-fb7b-431c-85f7-\
5f283acb8565"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"diagrcuad2", "=", 
  RowBox[{"DiagramaCuadricula", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<An\[AAcute]lisis\>\"", ",", "\"\<Dise\[NTilde]o\>\"", 
      ",", "\"\<Codificaci\[OAcute]n\>\"", ",", "\"\<Pruebas\>\"", 
      ",", "\"\<Despliegue\>\"", ",", "\"\<Mantenimiento\>\""}], "}"}], ",", 
    RowBox[{"\"\<Grid\>\"", "->", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], ",", 
    RowBox[{"\"\<BoxSize\>\"", "->", 
     RowBox[{"{", 
      RowBox[{"5", ",", "1.2"}], "}"}]}], ",", 
    RowBox[{"\"\<Gap\>\"", "->", 
     RowBox[{"{", 
      RowBox[{"0.8", ",", "1.5"}], "}"}]}], ",", 
    RowBox[{"\"\<BoxStyle\>\"", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"EdgeForm", "[", 
        RowBox[{"{", 
         RowBox[{"Thick", ",", "Blue"}], "}"}], "]"}], ",", 
       RowBox[{"FaceForm", "[", "LightBlue", "]"}]}], "}"}]}], ",", 
    RowBox[{"\"\<LabelStyle\>\"", "->", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "12", ",", "Bold"}], "]"}]}], ",", 
    RowBox[{"\"\<Connect\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<ArrowStyle\>\"", "->", 
     RowBox[{"{", 
      RowBox[{"Thick", ",", "Blue"}], "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZ", "[", 
   RowBox[{"diagrcuad2", ",", "\"\<diagrcuad2.tex\>\"", ",", "False", ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"RandomChoice", "[", 
         RowBox[{"{", 
          
          RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", 
           ",", "\"\<dotted\>\"", ",", "\"\<dashdotted\>\"", 
           ",", "\"\<thick\>\""}], "}"}], "]"}], ",", 
        RowBox[{"RandomChoice", "[", 
         RowBox[{"{", 
          
          RowBox[{"\"\<red\>\"", ",", "\"\<blue\>\"", ",", "\"\<green\>\"", 
           ",", "\"\<orange\>\"", ",", "\"\<purple\>\"", ",", "\"\<black\>\"",
            ",", "\"\<brown\>\"", ",", "\"\<pink\>\"", ",", "\"\<gray\>\"", 
           ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<yellow\>\"",
            ",", "\"\<lime\>\"", ",", "\"\<olive\>\"", ",", "\"\<teal\>\""}], 
          "}"}], "]"}]}], "}"}], ",", "6"}], "]"}], ",", "False"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.966970329662854*^9, 3.966970329664316*^9}, {
   3.96697041176825*^9, 3.966970426452932*^9}, {3.966970464843917*^9, 
   3.9669704758138113`*^9}, {3.9669705267050543`*^9, 3.966970575621141*^9}, 
   3.9669710613488207`*^9},
 CellLabel->
  "In[261]:=",ExpressionUUID->"7e74554f-7b17-4edc-98de-087c068a2d5d"],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[{RGBColor[0, 0, 1], Thickness[Large]}], FaceForm[RGBColor[
    0.87, 0.94, 1]], RectangleBox[{0., 0.}, {5., 1.2}], 
    RectangleBox[{5.8, 0.}, {10.8, 1.2}], 
    RectangleBox[{11.6, 0.}, {16.6, 1.2}], 
    RectangleBox[{0., -2.7}, {5., -1.5000000000000002}], 
    RectangleBox[{5.8, -2.7}, {10.8, -1.5000000000000002}], 
    RectangleBox[{11.6, -2.7}, {16.6, -1.5000000000000002}]}, {InsetBox[
     StyleBox["\<\"An\[AAcute]lisis\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->12,
      FontWeight->Bold,
      FontColor->GrayLevel[0]], {2.5, 0.6}], InsetBox[
     StyleBox["\<\"Dise\[NTilde]o\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->12,
      FontWeight->Bold,
      FontColor->GrayLevel[0]], {8.3, 0.6}], InsetBox[
     StyleBox["\<\"Codificaci\[OAcute]n\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->12,
      FontWeight->Bold,
      FontColor->GrayLevel[0]], {14.1, 0.6}], InsetBox[
     StyleBox["\<\"Pruebas\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->12,
      FontWeight->Bold,
      FontColor->GrayLevel[0]], {2.5, -2.1}], InsetBox[
     StyleBox["\<\"Despliegue\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->12,
      FontWeight->Bold,
      FontColor->GrayLevel[0]], {8.3, -2.1}], InsetBox[
     StyleBox["\<\"Mantenimiento\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->12,
      FontWeight->Bold,
      FontColor->GrayLevel[0]], {14.1, -2.1}]}, {
    {RGBColor[0, 0, 1], Thickness[Large]}, {ArrowBox[{{5., 0.6}, {5.8, 0.6}}],
      ArrowBox[{{10.8, 0.6}, {11.6, 0.6}}], 
     ArrowBox[{{5., -2.1}, {5.8, -2.1}}], 
     ArrowBox[{{10.8, -2.1}, {11.6, -2.1}}]}}},
  ImagePadding->20,
  PlotRange->All]], "Output",
 CellChangeTimes->{
  3.9669704762439737`*^9, {3.966970527484385*^9, 3.966970576076936*^9}, 
   3.966972111519135*^9},
 CellLabel->
  "Out[261]=",ExpressionUUID->"ade0505b-112e-4d7d-9c70-11727d2fe119"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Textos extra\[IAcute]dos autom\[AAcute]ticamente: 6 \
elementos\"\>"], "Print",
 CellChangeTimes->{
  3.9669704762523947`*^9, {3.96697052748627*^9, 3.966970576078426*^9}, 
   3.966972111520805*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[261]:=",ExpressionUUID->"fbf88ed4-d25c-4c16-8901-10ba1126b73b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9669704762523947`*^9, {3.96697052748627*^9, 3.966970576078426*^9}, 
   3.966972111521429*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[261]:=",ExpressionUUID->"c8e87713-eb1b-4d77-85bf-a7436a5bfb45"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.9669704762523947`*^9, {3.96697052748627*^9, 3.966970576078426*^9}, 
   3.966972111522163*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[261]:=",ExpressionUUID->"810db17e-0382-4f7d-8f4f-c36cc41af302"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9669704762523947`*^9, {3.96697052748627*^9, 3.966970576078426*^9}, 
   3.9669721115226088`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[261]:=",ExpressionUUID->"0841b657-8bc9-4da7-af21-6e17c9350107"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9669704762523947`*^9, {3.96697052748627*^9, 3.966970576078426*^9}, 
   3.96697211152306*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[261]:=",ExpressionUUID->"abf3d629-7611-4e9c-b1d1-4349c0fe5abf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9669704762523947`*^9, {3.96697052748627*^9, 3.966970576078426*^9}, 
   3.966972111523521*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[261]:=",ExpressionUUID->"b79a6c83-6576-43b4-a16c-80c3faa6d27f"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.9669704762523947`*^9, {3.96697052748627*^9, 3.966970576078426*^9}, 
   3.966972111596168*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[261]:=",ExpressionUUID->"fe765648-ff99-4a40-89f6-0738d4e83e30"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.9669704762523947`*^9, {3.96697052748627*^9, 3.966970576078426*^9}, 
   3.9669721126034117`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[261]:=",ExpressionUUID->"382fb7ff-9dba-45ed-b1a4-bbae9e7f3072"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/diagrcuad2/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/diagrcuad2/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9669704762523947`*^9, {3.96697052748627*^9, 3.966970576078426*^9}, 
   3.96697211260686*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[261]:=",ExpressionUUID->"74ee4fd8-260f-4520-b46d-c1f6542c7b56"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"diagrcuad2\"\>"}],
  SequenceForm["Archivo: ", "diagrcuad2"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9669704762523947`*^9, {3.96697052748627*^9, 3.966970576078426*^9}, 
   3.9669721126098223`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[261]:=",ExpressionUUID->"641ae8e0-9ba7-47a6-8e3f-36ed3ad36bd1"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.9669704762523947`*^9, {3.96697052748627*^9, 3.966970576078426*^9}, 
   3.966972113207877*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[261]:=",ExpressionUUID->"4a5bd7b5-066d-453e-abc8-b6cc3cc4def5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/diagrcuad2/diagrcuad2.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/diagrcuad2/diagrcuad2.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9669704762523947`*^9, {3.96697052748627*^9, 3.966970576078426*^9}, 
   3.966972113208557*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[261]:=",ExpressionUUID->"1159270e-e0c7-44c0-9592-3f5e63cf329a"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/diagrcuad2/\
diagrcuad2.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.9669704762439737`*^9, {3.966970527484385*^9, 3.966970576076936*^9}, 
   3.9669721132210693`*^9},
 CellLabel->
  "Out[263]=",ExpressionUUID->"a3312f0b-3362-48b8-82b4-cef2dbb20f26"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 3: organigrama de una empresa", "Subsection",
 CellChangeTimes->{{3.9669706125949917`*^9, 
  3.966970627356934*^9}},ExpressionUUID->"d90289de-e95c-4882-a13a-\
95914723bbb5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"diagrcuad3", "=", 
  RowBox[{"DiagramaCuadricula", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<CEO\>\"", ",", "\"\<CTO\>\"", ",", "\"\<CFO\>\"", 
      ",", "\"\<Desarrolladores\>\"", ",", "\"\<Marketing\>\"", 
      ",", "\"\<Finanzas\>\""}], "}"}], ",", 
    RowBox[{"\"\<Grid\>\"", "->", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}]}], ",", 
    RowBox[{"\"\<BoxSize\>\"", "->", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "1"}], "}"}]}], ",", 
    RowBox[{"\"\<Gap\>\"", "->", 
     RowBox[{"{", 
      RowBox[{"1.2", ",", "0.8"}], "}"}]}], ",", 
    RowBox[{"\"\<StartPos\>\"", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "3"}], "}"}]}], ",", 
    RowBox[{"\"\<BoxStyle\>\"", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
       RowBox[{"FaceForm", "[", "LightGreen", "]"}]}], "}"}]}], ",", 
    RowBox[{"\"\<LabelStyle\>\"", "->", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "10", ",", "Bold"}], "]"}]}], ",", 
    RowBox[{"\"\<Connect\>\"", "->", "False"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZ", "[", 
   RowBox[{"diagrcuad3", ",", "\"\<diagrcuad3.tex\>\"", ",", "False", ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"RandomChoice", "[", 
         RowBox[{"{", 
          
          RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", 
           ",", "\"\<dotted\>\"", ",", "\"\<dashdotted\>\"", 
           ",", "\"\<thick\>\""}], "}"}], "]"}], ",", 
        RowBox[{"RandomChoice", "[", 
         RowBox[{"{", 
          
          RowBox[{"\"\<red\>\"", ",", "\"\<blue\>\"", ",", "\"\<green\>\"", 
           ",", "\"\<orange\>\"", ",", "\"\<purple\>\"", ",", "\"\<black\>\"",
            ",", "\"\<brown\>\"", ",", "\"\<pink\>\"", ",", "\"\<gray\>\"", 
           ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<yellow\>\"",
            ",", "\"\<lime\>\"", ",", "\"\<olive\>\"", ",", "\"\<teal\>\""}], 
          "}"}], "]"}]}], "}"}], ",", "6"}], "]"}], ",", "False"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.966970633498516*^9, 3.9669706335008593`*^9}, {
   3.96697067504939*^9, 3.9669707184617577`*^9}, {3.966970750895772*^9, 
   3.966970751321958*^9}, 3.9669710493188143`*^9},
 CellLabel->
  "In[258]:=",ExpressionUUID->"42eb0246-8c78-49e4-885f-c683517b37cb"],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[GrayLevel[0]], FaceForm[RGBColor[0.88, 1, 0.88]], 
    RectangleBox[{-2., 3.}, {0.5, 4.}], 
    RectangleBox[{1.7000000000000002, 3.}, {4.2, 4.}], 
    RectangleBox[{-2., 1.2}, {0.5, 2.2}], 
    RectangleBox[{1.7000000000000002, 1.2}, {4.2, 2.2}], 
    RectangleBox[{-2., -0.6000000000000001}, {0.5, 0.3999999999999999}], 
    RectangleBox[{1.7000000000000002, -0.6000000000000001}, \
{4.2, 0.3999999999999999}]}, {InsetBox[
     StyleBox["\<\"CEO\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->10,
      FontWeight->Bold,
      FontColor->GrayLevel[0]], {-0.75, 3.5}], InsetBox[
     StyleBox["\<\"CTO\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->10,
      FontWeight->Bold,
      FontColor->GrayLevel[0]], {2.95, 3.5}], InsetBox[
     StyleBox["\<\"CFO\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->10,
      FontWeight->Bold,
      FontColor->GrayLevel[0]], {-0.75, 1.7}], InsetBox[
     StyleBox["\<\"Desarrolladores\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->10,
      FontWeight->Bold,
      FontColor->GrayLevel[0]], {2.95, 1.7}], InsetBox[
     StyleBox["\<\"Marketing\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->10,
      FontWeight->Bold,
      FontColor->GrayLevel[0]], {-0.75, -0.10000000000000009}], InsetBox[
     StyleBox["\<\"Finanzas\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->10,
      FontWeight->Bold,
      FontColor->GrayLevel[0]], {2.95, -0.10000000000000009}]}, {}},
  ImagePadding->20,
  PlotRange->All]], "Output",
 CellChangeTimes->{3.966970720987698*^9, 3.966970752379942*^9, 
  3.9669721032261267`*^9},
 CellLabel->
  "Out[258]=",ExpressionUUID->"2fb441f6-fcba-4048-82dd-217e89de2f2e"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Textos extra\[IAcute]dos autom\[AAcute]ticamente: 6 \
elementos\"\>"], "Print",
 CellChangeTimes->{3.966970720990259*^9, 3.966970752381374*^9, 
  3.966972103227544*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[258]:=",ExpressionUUID->"7dc845df-6119-43be-a15f-e4892dc3e730"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966970720990259*^9, 3.966970752381374*^9, 
  3.9669721032281523`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[258]:=",ExpressionUUID->"8ab67dd2-4953-4c80-8881-ca60ae36da2b"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.966970720990259*^9, 3.966970752381374*^9, 
  3.966972103228861*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[258]:=",ExpressionUUID->"4dfaf936-9e97-4891-91ac-62e50682ae11"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966970720990259*^9, 3.966970752381374*^9, 
  3.966972103229306*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[258]:=",ExpressionUUID->"6c4d0b34-978d-400a-ab66-7050190e58fd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966970720990259*^9, 3.966970752381374*^9, 
  3.9669721032297697`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[258]:=",ExpressionUUID->"cfe8c2d5-e3ac-4e8b-b65b-067e71306097"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.966970720990259*^9, 3.966970752381374*^9, 
  3.966972103230241*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[258]:=",ExpressionUUID->"96f93a42-2803-46e8-85fc-9f2b3e6e46ca"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.966970720990259*^9, 3.966970752381374*^9, 
  3.9669721033056993`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[258]:=",ExpressionUUID->"2832f5d9-ea21-4585-9125-51c8be1b6714"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.966970720990259*^9, 3.966970752381374*^9, 
  3.966972104309133*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[258]:=",ExpressionUUID->"a8e92997-4cee-4b15-9717-884ca39ea9f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/diagrcuad3/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/diagrcuad3/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966970720990259*^9, 3.966970752381374*^9, 
  3.9669721043126183`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[258]:=",ExpressionUUID->"4078e9ab-04e3-4425-8df2-61c1d7a635f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"diagrcuad3\"\>"}],
  SequenceForm["Archivo: ", "diagrcuad3"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966970720990259*^9, 3.966970752381374*^9, 
  3.966972104314962*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[258]:=",ExpressionUUID->"160c9e8e-ac94-40ff-8d6b-3bba5ac5d113"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.966970720990259*^9, 3.966970752381374*^9, 
  3.9669721048918667`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[258]:=",ExpressionUUID->"f93331ce-037a-4102-a59e-26b8d42b936b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/diagrcuad3/diagrcuad3.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/diagrcuad3/diagrcuad3.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966970720990259*^9, 3.966970752381374*^9, 
  3.9669721048924923`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[258]:=",ExpressionUUID->"5e582bf1-9268-4a2e-8fe0-9d3fb997c365"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/diagrcuad3/\
diagrcuad3.pdf\"\>"], "Output",
 CellChangeTimes->{3.966970720987698*^9, 3.966970752379942*^9, 
  3.966972104904725*^9},
 CellLabel->
  "Out[260]=",ExpressionUUID->"455c933a-f5af-41d9-86b5-43c8be3d81ec"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 4: timeline de proyecto", "Subsection",
 CellChangeTimes->{{3.966970805728293*^9, 
  3.966970821300915*^9}},ExpressionUUID->"a28f782b-e5b4-4f6a-8293-\
397c2dc84274"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"diagrcuad4", "=", 
  RowBox[{"DiagramaCuadricula", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<Semana 1\>\"", ",", "\"\<Semana 2\>\"", 
      ",", "\"\<Semana 3\>\"", ",", "\"\<Semana 4\>\""}], "}"}], ",", 
    RowBox[{"\"\<Grid\>\"", "->", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], ",", 
    RowBox[{"\"\<BoxSize\>\"", "->", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}]}], ",", 
    RowBox[{"\"\<Gap\>\"", "->", 
     RowBox[{"{", 
      RowBox[{"0.5", ",", "0"}], "}"}]}], ",", 
    RowBox[{"\"\<BoxStyle\>\"", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"EdgeForm", "[", 
        RowBox[{"{", 
         RowBox[{"Thick", ",", "Blue"}], "}"}], "]"}], ",", 
       RowBox[{"FaceForm", "[", "LightPink", "]"}]}], "}"}]}], ",", 
    RowBox[{"\"\<LabelStyle\>\"", "->", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "14", ",", "Bold"}], "]"}]}], ",", 
    RowBox[{"\"\<ArrowStyle\>\"", "->", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"RGBColor", "[", 
        RowBox[{"0.2", ",", "0.4", ",", "0.8"}], "]"}], ",", "Dotted", ",", 
       RowBox[{"Arrowheads", "[", "Small", "]"}]}], "]"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZ", "[", 
   RowBox[{"diagrcuad4", ",", "\"\<diagrcuad4.tex\>\"", ",", "False", ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"RandomChoice", "[", 
         RowBox[{"{", 
          
          RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", 
           ",", "\"\<dotted\>\"", ",", "\"\<dashdotted\>\"", 
           ",", "\"\<thick\>\""}], "}"}], "]"}], ",", 
        RowBox[{"RandomChoice", "[", 
         RowBox[{"{", 
          
          RowBox[{"\"\<red\>\"", ",", "\"\<blue\>\"", ",", "\"\<green\>\"", 
           ",", "\"\<orange\>\"", ",", "\"\<purple\>\"", ",", "\"\<black\>\"",
            ",", "\"\<brown\>\"", ",", "\"\<pink\>\"", ",", "\"\<gray\>\"", 
           ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<yellow\>\"",
            ",", "\"\<lime\>\"", ",", "\"\<olive\>\"", ",", "\"\<teal\>\""}], 
          "}"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "7"}], "}"}]}], "]"}], ",", "False"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.966970810245113*^9, 3.966970858041068*^9}, {
   3.9669708973905354`*^9, 3.966970967875937*^9}, 3.966971112655076*^9, {
   3.9669711569560013`*^9, 3.966971239648588*^9}, {3.966971274272635*^9, 
   3.9669713715360203`*^9}, {3.966971443880843*^9, 3.966971582209815*^9}, 
   3.966971612235284*^9, {3.966971643701941*^9, 3.966971735302917*^9}, {
   3.966971826042035*^9, 3.9669718265503902`*^9}, {3.966971868723544*^9, 
   3.966971875380866*^9}},
 CellLabel->
  "In[244]:=",ExpressionUUID->"16dfc47f-e01e-4b53-a7f2-7b11a3d202da"],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[{RGBColor[0, 0, 1], Thickness[Large]}], FaceForm[RGBColor[
    1, 0.925, 0.925]], RectangleBox[{0., 0}, {2., 1}], 
    RectangleBox[{2.5, 0}, {4.5, 1}], RectangleBox[{0., -1}, {2., 0}], 
    RectangleBox[{2.5, -1}, {4.5, 0}]}, {InsetBox[
     StyleBox["\<\"Semana 1\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->14,
      FontWeight->Bold,
      FontColor->GrayLevel[0]], NCache[{1., Rational[1, 2]}, {1., 0.5}]], 
    InsetBox[
     StyleBox["\<\"Semana 2\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->14,
      FontWeight->Bold,
      FontColor->GrayLevel[0]], NCache[{3.5, Rational[1, 2]}, {3.5, 0.5}]], 
    InsetBox[
     StyleBox["\<\"Semana 3\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->14,
      FontWeight->Bold,
      FontColor->GrayLevel[0]], NCache[{1., Rational[-1, 2]}, {1., -0.5}]], 
    InsetBox[
     StyleBox["\<\"Semana 4\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->14,
      FontWeight->Bold,
      FontColor->GrayLevel[0]], NCache[{3.5, Rational[-1, 2]}, {3.5, -0.5}]]}, 
   {RGBColor[0.2, 0.4, 0.8], Dashing[{0, Small}], Arrowheads[Small], 
    ArrowBox[NCache[{{2., Rational[1, 2]}, {2.5, Rational[1, 2]}}, {{2., 
      0.5}, {2.5, 0.5}}]], 
    ArrowBox[NCache[{{2., Rational[-1, 2]}, {2.5, Rational[-1, 2]}}, {{
      2., -0.5}, {2.5, -0.5}}]]}},
  ImagePadding->20,
  PlotRange->All]], "Output",
 CellChangeTimes->{{3.966970908524281*^9, 3.966970968320078*^9}, 
   3.9669711142406263`*^9, {3.9669711904190807`*^9, 3.966971240406518*^9}, {
   3.966971274752206*^9, 3.966971283600155*^9}, {3.9669713278519287`*^9, 
   3.966971375774239*^9}, {3.9669714455259657`*^9, 3.9669714738465033`*^9}, {
   3.966971515216332*^9, 3.966971543888538*^9}, {3.96697157448179*^9, 
   3.9669715836149178`*^9}, 3.966971614297361*^9, {3.9669716458981037`*^9, 
   3.9669717547083178`*^9}, 3.9669718273540163`*^9, {3.966971869451932*^9, 
   3.966971875824951*^9}},
 CellLabel->
  "Out[244]=",ExpressionUUID->"0921ff73-4e23-432e-b55e-9ac32ff0f8d7"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Textos extra\[IAcute]dos autom\[AAcute]ticamente: 4 \
elementos\"\>"], "Print",
 CellChangeTimes->{{3.966970908526844*^9, 3.966970968321603*^9}, 
   3.966971114242345*^9, {3.9669711904391117`*^9, 3.96697124040807*^9}, {
   3.966971274753669*^9, 3.966971283604699*^9}, {3.9669713278535547`*^9, 
   3.966971375775687*^9}, {3.966971445527671*^9, 3.966971473848363*^9}, {
   3.966971515218033*^9, 3.966971543890061*^9}, {3.966971574483554*^9, 
   3.966971583616626*^9}, 3.966971614299025*^9, {3.966971645911697*^9, 
   3.966971754709714*^9}, 3.96697182736602*^9, {3.96697186945366*^9, 
   3.9669718758266277`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[244]:=",ExpressionUUID->"653ed761-5eed-4472-a1fb-84ee36b0c2c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966970908526844*^9, 3.966970968321603*^9}, 
   3.966971114242345*^9, {3.9669711904391117`*^9, 3.96697124040807*^9}, {
   3.966971274753669*^9, 3.966971283604699*^9}, {3.9669713278535547`*^9, 
   3.966971375775687*^9}, {3.966971445527671*^9, 3.966971473848363*^9}, {
   3.966971515218033*^9, 3.966971543890061*^9}, {3.966971574483554*^9, 
   3.966971583616626*^9}, 3.966971614299025*^9, {3.966971645911697*^9, 
   3.966971754709714*^9}, 3.96697182736602*^9, {3.96697186945366*^9, 
   3.966971875827298*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[244]:=",ExpressionUUID->"b3d6538c-9921-4afc-b013-7fc1e6ff18f4"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.966970908526844*^9, 3.966970968321603*^9}, 
   3.966971114242345*^9, {3.9669711904391117`*^9, 3.96697124040807*^9}, {
   3.966971274753669*^9, 3.966971283604699*^9}, {3.9669713278535547`*^9, 
   3.966971375775687*^9}, {3.966971445527671*^9, 3.966971473848363*^9}, {
   3.966971515218033*^9, 3.966971543890061*^9}, {3.966971574483554*^9, 
   3.966971583616626*^9}, 3.966971614299025*^9, {3.966971645911697*^9, 
   3.966971754709714*^9}, 3.96697182736602*^9, {3.96697186945366*^9, 
   3.966971875828045*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[244]:=",ExpressionUUID->"87c7a4da-3530-4b37-8fcb-332fbfcb9e05"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966970908526844*^9, 3.966970968321603*^9}, 
   3.966971114242345*^9, {3.9669711904391117`*^9, 3.96697124040807*^9}, {
   3.966971274753669*^9, 3.966971283604699*^9}, {3.9669713278535547`*^9, 
   3.966971375775687*^9}, {3.966971445527671*^9, 3.966971473848363*^9}, {
   3.966971515218033*^9, 3.966971543890061*^9}, {3.966971574483554*^9, 
   3.966971583616626*^9}, 3.966971614299025*^9, {3.966971645911697*^9, 
   3.966971754709714*^9}, 3.96697182736602*^9, {3.96697186945366*^9, 
   3.966971875828518*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[244]:=",ExpressionUUID->"c47492ab-616c-4a99-8e81-06c78bd3ad7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966970908526844*^9, 3.966970968321603*^9}, 
   3.966971114242345*^9, {3.9669711904391117`*^9, 3.96697124040807*^9}, {
   3.966971274753669*^9, 3.966971283604699*^9}, {3.9669713278535547`*^9, 
   3.966971375775687*^9}, {3.966971445527671*^9, 3.966971473848363*^9}, {
   3.966971515218033*^9, 3.966971543890061*^9}, {3.966971574483554*^9, 
   3.966971583616626*^9}, 3.966971614299025*^9, {3.966971645911697*^9, 
   3.966971754709714*^9}, 3.96697182736602*^9, {3.96697186945366*^9, 
   3.966971875829011*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[244]:=",ExpressionUUID->"c1feea1a-acc5-4c30-aa20-8fa7c4ebcf41"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966970908526844*^9, 3.966970968321603*^9}, 
   3.966971114242345*^9, {3.9669711904391117`*^9, 3.96697124040807*^9}, {
   3.966971274753669*^9, 3.966971283604699*^9}, {3.9669713278535547`*^9, 
   3.966971375775687*^9}, {3.966971445527671*^9, 3.966971473848363*^9}, {
   3.966971515218033*^9, 3.966971543890061*^9}, {3.966971574483554*^9, 
   3.966971583616626*^9}, 3.966971614299025*^9, {3.966971645911697*^9, 
   3.966971754709714*^9}, 3.96697182736602*^9, {3.96697186945366*^9, 
   3.9669718758295107`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[244]:=",ExpressionUUID->"ae953497-e2d5-405c-b8d4-b3b361c9761c"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.966970908526844*^9, 3.966970968321603*^9}, 
   3.966971114242345*^9, {3.9669711904391117`*^9, 3.96697124040807*^9}, {
   3.966971274753669*^9, 3.966971283604699*^9}, {3.9669713278535547`*^9, 
   3.966971375775687*^9}, {3.966971445527671*^9, 3.966971473848363*^9}, {
   3.966971515218033*^9, 3.966971543890061*^9}, {3.966971574483554*^9, 
   3.966971583616626*^9}, 3.966971614299025*^9, {3.966971645911697*^9, 
   3.966971754709714*^9}, 3.96697182736602*^9, {3.96697186945366*^9, 
   3.9669718759035683`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[244]:=",ExpressionUUID->"1a666d81-9b75-4116-b554-7ce083e72d03"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.966970908526844*^9, 3.966970968321603*^9}, 
   3.966971114242345*^9, {3.9669711904391117`*^9, 3.96697124040807*^9}, {
   3.966971274753669*^9, 3.966971283604699*^9}, {3.9669713278535547`*^9, 
   3.966971375775687*^9}, {3.966971445527671*^9, 3.966971473848363*^9}, {
   3.966971515218033*^9, 3.966971543890061*^9}, {3.966971574483554*^9, 
   3.966971583616626*^9}, 3.966971614299025*^9, {3.966971645911697*^9, 
   3.966971754709714*^9}, 3.96697182736602*^9, {3.96697186945366*^9, 
   3.966971876910627*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[244]:=",ExpressionUUID->"256ac942-84f5-4a1f-b8b8-0a739ef231ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/diagrcuad4/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/diagrcuad4/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966970908526844*^9, 3.966970968321603*^9}, 
   3.966971114242345*^9, {3.9669711904391117`*^9, 3.96697124040807*^9}, {
   3.966971274753669*^9, 3.966971283604699*^9}, {3.9669713278535547`*^9, 
   3.966971375775687*^9}, {3.966971445527671*^9, 3.966971473848363*^9}, {
   3.966971515218033*^9, 3.966971543890061*^9}, {3.966971574483554*^9, 
   3.966971583616626*^9}, 3.966971614299025*^9, {3.966971645911697*^9, 
   3.966971754709714*^9}, 3.96697182736602*^9, {3.96697186945366*^9, 
   3.966971876913456*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[244]:=",ExpressionUUID->"a7fc34bf-4bb4-4d7c-88f4-6354eaf6acc4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"diagrcuad4\"\>"}],
  SequenceForm["Archivo: ", "diagrcuad4"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966970908526844*^9, 3.966970968321603*^9}, 
   3.966971114242345*^9, {3.9669711904391117`*^9, 3.96697124040807*^9}, {
   3.966971274753669*^9, 3.966971283604699*^9}, {3.9669713278535547`*^9, 
   3.966971375775687*^9}, {3.966971445527671*^9, 3.966971473848363*^9}, {
   3.966971515218033*^9, 3.966971543890061*^9}, {3.966971574483554*^9, 
   3.966971583616626*^9}, 3.966971614299025*^9, {3.966971645911697*^9, 
   3.966971754709714*^9}, 3.96697182736602*^9, {3.96697186945366*^9, 
   3.9669718769158497`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[244]:=",ExpressionUUID->"b30ce917-56b3-4d92-9392-b4980c9a51f7"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.966970908526844*^9, 3.966970968321603*^9}, 
   3.966971114242345*^9, {3.9669711904391117`*^9, 3.96697124040807*^9}, {
   3.966971274753669*^9, 3.966971283604699*^9}, {3.9669713278535547`*^9, 
   3.966971375775687*^9}, {3.966971445527671*^9, 3.966971473848363*^9}, {
   3.966971515218033*^9, 3.966971543890061*^9}, {3.966971574483554*^9, 
   3.966971583616626*^9}, 3.966971614299025*^9, {3.966971645911697*^9, 
   3.966971754709714*^9}, 3.96697182736602*^9, {3.96697186945366*^9, 
   3.966971877494172*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[244]:=",ExpressionUUID->"67105d66-6ee7-4009-9eba-a261f1efbd8b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/diagrcuad4/diagrcuad4.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/diagrcuad4/diagrcuad4.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966970908526844*^9, 3.966970968321603*^9}, 
   3.966971114242345*^9, {3.9669711904391117`*^9, 3.96697124040807*^9}, {
   3.966971274753669*^9, 3.966971283604699*^9}, {3.9669713278535547`*^9, 
   3.966971375775687*^9}, {3.966971445527671*^9, 3.966971473848363*^9}, {
   3.966971515218033*^9, 3.966971543890061*^9}, {3.966971574483554*^9, 
   3.966971583616626*^9}, 3.966971614299025*^9, {3.966971645911697*^9, 
   3.966971754709714*^9}, 3.96697182736602*^9, {3.96697186945366*^9, 
   3.966971877494821*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[244]:=",ExpressionUUID->"45723f8d-cf7e-4f8c-84cc-b63effe95d3d"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/diagrcuad4/\
diagrcuad4.pdf\"\>"], "Output",
 CellChangeTimes->{{3.966970908524281*^9, 3.966970968320078*^9}, 
   3.9669711142406263`*^9, {3.9669711904190807`*^9, 3.966971240406518*^9}, {
   3.966971274752206*^9, 3.966971283600155*^9}, {3.9669713278519287`*^9, 
   3.966971375774239*^9}, {3.9669714455259657`*^9, 3.9669714738465033`*^9}, {
   3.966971515216332*^9, 3.966971543888538*^9}, {3.96697157448179*^9, 
   3.9669715836149178`*^9}, 3.966971614297361*^9, {3.9669716458981037`*^9, 
   3.9669717547083178`*^9}, 3.9669718273540163`*^9, {3.966971869451932*^9, 
   3.966971877508459*^9}},
 CellLabel->
  "Out[246]=",ExpressionUUID->"86fb3193-8931-434b-8160-b72471c8f9b6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 5: proceso de aprendizaje", "Subsection",
 CellChangeTimes->{{3.966971891246883*^9, 
  3.966971905572789*^9}},ExpressionUUID->"1c3c42f1-7c3b-4a32-91aa-\
d3f6b3b3190d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"diagrcuad5", "=", 
  RowBox[{"DiagramaCuadricula", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<Lectura\>\"", ",", "\"\<Pr\[AAcute]ctica\>\"", 
      ",", "\"\<Evaluaci\[OAcute]n\>\"", ",", "\"\<Reflexi\[OAcute]n\>\"", 
      ",", "\"\<Aplicaci\[OAcute]n\>\""}], "}"}], ",", 
    RowBox[{"\"\<Grid\>\"", "->", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], ",", 
    RowBox[{"\"\<BoxSize\>\"", "->", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "1.3"}], "}"}]}], ",", 
    RowBox[{"\"\<Gap\>\"", "->", 
     RowBox[{"{", 
      RowBox[{"0.3", ",", "0.3"}], "}"}]}], ",", 
    RowBox[{"\"\<BoxStyle\>\"", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"EdgeForm", "[", 
        RowBox[{"{", 
         RowBox[{"Thick", ",", "Orange"}], "}"}], "]"}], ",", 
       RowBox[{"FaceForm", "[", "LightYellow", "]"}]}], "}"}]}], ",", 
    RowBox[{"\"\<LabelStyle\>\"", "->", 
     RowBox[{"Directive", "[", 
      RowBox[{"DarkRed", ",", "13", ",", "Bold"}], "]"}]}], ",", 
    RowBox[{"\"\<Connect\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<ArrowStyle\>\"", "->", 
     RowBox[{"Directive", "[", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Orange", ",", "Dashed", ",", 
        RowBox[{"Arrowheads", "[", "Small", "]"}]}], "}"}], "]"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZ", "[", 
   RowBox[{"diagrcuad5", ",", "\"\<diagrcuad5.tex\>\"", ",", "False", ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"RandomChoice", "[", 
         RowBox[{"{", 
          
          RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", 
           ",", "\"\<dotted\>\"", ",", "\"\<dashdotted\>\"", 
           ",", "\"\<thick\>\""}], "}"}], "]"}], ",", 
        RowBox[{"RandomChoice", "[", 
         RowBox[{"{", 
          
          RowBox[{"\"\<red\>\"", ",", "\"\<blue\>\"", ",", "\"\<green\>\"", 
           ",", "\"\<orange\>\"", ",", "\"\<purple\>\"", ",", "\"\<black\>\"",
            ",", "\"\<brown\>\"", ",", "\"\<pink\>\"", ",", "\"\<gray\>\"", 
           ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<yellow\>\"",
            ",", "\"\<lime\>\"", ",", "\"\<olive\>\"", ",", "\"\<teal\>\""}], 
          "}"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "8"}], "}"}]}], "]"}], ",", "False"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.966971911066114*^9, 3.966971969195414*^9}, {
  3.966972015250472*^9, 3.966972078285428*^9}},
 CellLabel->
  "In[255]:=",ExpressionUUID->"f316e933-f3bc-4956-986e-537e1830e295"],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[{RGBColor[1, 0.5, 0], Thickness[Large]}], FaceForm[RGBColor[
    1, 1, 0.85]], RectangleBox[{0., 0.}, {2.5, 1.3}], 
    RectangleBox[{2.8, 0.}, {5.3, 1.3}], RectangleBox[{5.6, 0.}, {8.1, 1.3}], 
    RectangleBox[{0., -1.6}, {2.5, -0.30000000000000004}], 
    RectangleBox[{2.8, -1.6}, {5.3, -0.30000000000000004}]}, {InsetBox[
     StyleBox["\<\"Lectura\"\>",
      StripOnInput->False,
      LineColor->RGBColor[0.48, 0.06, 0.06],
      FrontFaceColor->RGBColor[0.48, 0.06, 0.06],
      BackFaceColor->RGBColor[0.48, 0.06, 0.06],
      GraphicsColor->RGBColor[0.48, 0.06, 0.06],
      FontSize->13,
      FontWeight->Bold,
      FontColor->RGBColor[0.48, 0.06, 0.06]], {1.25, 0.65}], InsetBox[
     StyleBox["\<\"Pr\[AAcute]ctica\"\>",
      StripOnInput->False,
      LineColor->RGBColor[0.48, 0.06, 0.06],
      FrontFaceColor->RGBColor[0.48, 0.06, 0.06],
      BackFaceColor->RGBColor[0.48, 0.06, 0.06],
      GraphicsColor->RGBColor[0.48, 0.06, 0.06],
      FontSize->13,
      FontWeight->Bold,
      FontColor->RGBColor[0.48, 0.06, 0.06]], {4.05, 0.65}], InsetBox[
     StyleBox["\<\"Evaluaci\[OAcute]n\"\>",
      StripOnInput->False,
      LineColor->RGBColor[0.48, 0.06, 0.06],
      FrontFaceColor->RGBColor[0.48, 0.06, 0.06],
      BackFaceColor->RGBColor[0.48, 0.06, 0.06],
      GraphicsColor->RGBColor[0.48, 0.06, 0.06],
      FontSize->13,
      FontWeight->Bold,
      FontColor->RGBColor[0.48, 0.06, 0.06]], {6.85, 0.65}], InsetBox[
     StyleBox["\<\"Reflexi\[OAcute]n\"\>",
      StripOnInput->False,
      LineColor->RGBColor[0.48, 0.06, 0.06],
      FrontFaceColor->RGBColor[0.48, 0.06, 0.06],
      BackFaceColor->RGBColor[0.48, 0.06, 0.06],
      GraphicsColor->RGBColor[0.48, 0.06, 0.06],
      FontSize->13,
      FontWeight->Bold,
      FontColor->RGBColor[0.48, 0.06, 0.06]], {1.25, -0.9500000000000001}], 
    InsetBox[
     StyleBox["\<\"Aplicaci\[OAcute]n\"\>",
      StripOnInput->False,
      LineColor->RGBColor[0.48, 0.06, 0.06],
      FrontFaceColor->RGBColor[0.48, 0.06, 0.06],
      BackFaceColor->RGBColor[0.48, 0.06, 0.06],
      GraphicsColor->RGBColor[0.48, 0.06, 0.06],
      FontSize->13,
      FontWeight->Bold,
      FontColor->RGBColor[0.48, 0.06, 0.06]], {4.05, -0.9500000000000001}]}, 
   {RGBColor[1, 0.5, 0], Thickness[Large], Dashing[{Small, Small}], 
    Arrowheads[Small], ArrowBox[{{2.5, 0.65}, {2.8, 0.65}}], 
    ArrowBox[{{5.3, 0.65}, {5.6, 0.65}}], 
    ArrowBox[{{2.5, -0.9500000000000001}, {2.8, -0.9500000000000001}}]}},
  ImagePadding->20,
  PlotRange->All]], "Output",
 CellChangeTimes->{{3.9669719439535503`*^9, 3.966971970007269*^9}, 
   3.966972016810657*^9, {3.966972062092554*^9, 3.966972078710287*^9}},
 CellLabel->
  "Out[255]=",ExpressionUUID->"a79656a9-70ab-4221-bf41-54a5cacf144b"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Textos extra\[IAcute]dos autom\[AAcute]ticamente: 5 \
elementos\"\>"], "Print",
 CellChangeTimes->{{3.966972062094235*^9, 3.966972078711887*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[255]:=",ExpressionUUID->"d29bd9cc-3837-479e-8407-ec774f27bed4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966972062094235*^9, 3.9669720787124863`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[255]:=",ExpressionUUID->"469d41cd-44fc-4e84-adf5-99607153e9f5"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.966972062094235*^9, 3.9669720787131567`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[255]:=",ExpressionUUID->"e3eb1ad4-a2c4-4896-9c31-de51f20bcd2c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966972062094235*^9, 3.966972078713583*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[255]:=",ExpressionUUID->"78e8ec72-9eb7-48a2-8ef8-23dbced2efb9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966972062094235*^9, 3.966972078714037*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[255]:=",ExpressionUUID->"63a1fa29-b8e3-4c7c-b6da-8173498f4562"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966972062094235*^9, 3.966972078714499*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[255]:=",ExpressionUUID->"20ff08ae-f0be-4ed9-bb23-c6d4e47b2d14"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.966972062094235*^9, 3.966972078796204*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[255]:=",ExpressionUUID->"c327f377-c5d2-43ca-bb52-f4929d1c4616"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.966972062094235*^9, 3.966972079803549*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[255]:=",ExpressionUUID->"53e64311-e516-4de4-9f3f-4fa0b2a02362"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/diagrcuad5/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/diagrcuad5/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966972062094235*^9, 3.96697207980764*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[255]:=",ExpressionUUID->"2d25938d-49d5-4561-ba27-03a77cbe84b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"diagrcuad5\"\>"}],
  SequenceForm["Archivo: ", "diagrcuad5"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966972062094235*^9, 3.966972079810543*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[255]:=",ExpressionUUID->"485431c8-cab3-43b6-ac6c-5419566a47da"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.966972062094235*^9, 3.966972080394793*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[255]:=",ExpressionUUID->"99552ad0-4241-494b-a981-03bf97c3338d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/diagrcuad5/diagrcuad5.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/diagrcuad5/diagrcuad5.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966972062094235*^9, 3.9669720803954287`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[255]:=",ExpressionUUID->"ba60fb3e-9859-4eb3-922e-96d174d5d514"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/diagrcuad5/\
diagrcuad5.pdf\"\>"], "Output",
 CellChangeTimes->{{3.9669719439535503`*^9, 3.966971970007269*^9}, 
   3.966972016810657*^9, {3.966972062092554*^9, 3.966972080407666*^9}},
 CellLabel->
  "Out[257]=",ExpressionUUID->"ef2e37d8-88f6-41ed-a6cf-337fcb478f87"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["InterSets", "Section",
 CellChangeTimes->{
  3.966972190492538*^9},ExpressionUUID->"5d566734-7e28-48e7-8e78-\
4285bebf82f4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "InterSets"}]], "Input",
 CellChangeTimes->{{3.966972192001233*^9, 3.9669721935909348`*^9}},
 CellLabel->
  "In[268]:=",ExpressionUUID->"f4b0f577-65a7-4eb8-9a34-bd8ccf4334e0"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"InterSets[filename, labels, fillColor, scale, \
showIntersectionLabel, ellipseSize] crea un diagrama de intersecci\[OAcute]n \
de conjuntos en formato TikZ/LaTeX y lo exporta como archivo .tex en la \
carpeta Downloads/InterSets.\\n\\nPAR\[CapitalAAcute]METROS:\\n- filename: \
String que especifica el nombre del archivo de salida (debe terminar en \
\\\".tex\\\")\\n- labels: Lista de etiquetas para identificar cada conjunto \
(m\[IAcute]nimo 2 elementos)\\n- fillColor: String que especifica el color de \
relleno de la intersecci\[OAcute]n (opcional, por defecto \\\"gray\\\")\\n- \
scale: Real que define la escala del diagrama completo (opcional, por defecto \
1.2)\\n- showIntersectionLabel: True/False para mostrar la etiqueta matem\
\[AAcute]tica de la intersecci\[OAcute]n (opcional, por defecto False)\\n- \
ellipseSize: Lista {rx, ry} que define el radio horizontal y vertical de las \
elipses (opcional, por defecto {1.5, 1.8})\\n\\nCOLORES PREDEFINIDOS:\\nLos \
siguientes colores se convierten autom\[AAcute]ticamente a tonos TikZ \
apropiados:\\n- \\\"blue\\\" -> \\\"blue!50\\\"     \[Bullet] \\\"red\\\" -> \
\\\"red!50\\\"       \[Bullet] \\\"green\\\" -> \\\"green!50\\\"\\n- \
\\\"yellow\\\" -> \\\"yellow!60\\\" \[Bullet] \\\"orange\\\" -> \\\"orange!50\
\\\" \[Bullet] \\\"purple\\\" -> \\\"purple!50\\\"\\n- \\\"violet\\\" -> \
\\\"violet!50\\\" \[Bullet] \\\"cyan\\\" -> \\\"cyan!50\\\"     \[Bullet] \
\\\"magenta\\\" -> \\\"magenta!50\\\"\\n- \\\"pink\\\" -> \\\"pink!50\\\"     \
\[Bullet] \\\"brown\\\" -> \\\"brown!50\\\"   \[Bullet] \\\"black\\\" -> \
\\\"black!30\\\"\\n- \\\"gray\\\"/\\\"grey\\\" -> \\\"gray!85\\\"\\n- \
Cualquier otro string se usa directamente como color TikZ\\n\\nDISPOSICI\
\[CapitalOAcute]N AUTOM\[CapitalAAcute]TICA DE CONJUNTOS:\\n- 2 conjuntos: \
Disposici\[OAcute]n horizontal\\n- 3 conjuntos: Disposici\[OAcute]n \
triangular\\n- 4 conjuntos: Disposici\[OAcute]n en cuadrado\\n- 5 conjuntos: \
Disposici\[OAcute]n pentagonal\\n- 6+ conjuntos: Disposici\[OAcute]n circular \
autom\[AAcute]tica\\n\\nFUNCIONALIDAD:\\n- Genera c\[OAcute]digo TikZ \
completo con documento LaTeX standalone\\n- Sombreia la intersecci\[OAcute]n \
de TODOS los conjuntos especificados\\n- Posiciona autom\[AAcute]ticamente \
las etiquetas fuera de las elipses\\n- Crea la carpeta Downloads/InterSets si \
no existe\\n- Exporta el archivo .tex listo para \
compilar\\n\\nVALIDACIONES:\\n- El filename debe terminar obligatoriamente en \
\\\".tex\\\"\\n- La lista ellipseSize debe contener exactamente 2 \
elementos\\n- La lista labels debe contener al menos 2 elementos\\n- Retorna \
$Failed si alguna validaci\[OAcute]n falla\\n\\nVALOR DE RETORNO:\\nRetorna \
la ruta completa del archivo exportado, o $Failed en caso de \
error.\\n\\nEJEMPLOS:\\n- InterSets[\\\"diagrama.tex\\\", {\\\"A\\\", \\\"B\\\
\"}]\\n- InterSets[\\\"conjuntos.tex\\\", {\\\"X\\\", \\\"Y\\\", \\\"Z\\\"}, \
\\\"blue\\\", 1.5, True]\\n- InterSets[\\\"ejemplo.tex\\\", {\\\"A\\\", \\\"B\
\\\", \\\"C\\\", \\\"D\\\"}, \\\"red\\\", 1.0, False, {2.0, 2.5}]\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"InterSets", "[", 
                    
                    RowBox[{
                    "VilTeX`Private`filename_String", ",", 
                    "VilTeX`Private`labels_List", ",", 
                    
                    RowBox[{
                    "VilTeX`Private`fillColor_String", ":", "\"gray\""}], ",", 
                    RowBox[{"VilTeX`Private`scale_Real", ":", "1.2`"}], ",", 
                    
                    RowBox[{
                    "VilTeX`Private`showIntersectionLabel_", ":", "False"}], 
                    ",", 
                    RowBox[{"VilTeX`Private`ellipseSize_List", ":", 
                    RowBox[{"{", 
                    RowBox[{"1.5`", ",", "1.8`"}], "}"}]}]}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", ",", 
                    "VilTeX`Private`fullDocument", ",", 
                    "VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`folderPath", ",", "VilTeX`Private`rx", 
                    ",", "VilTeX`Private`ry", ",", 
                    "VilTeX`Private`processedColor", ",", 
                    "VilTeX`Private`numSets", ",", "VilTeX`Private`positions",
                     ",", "VilTeX`Private`ellipseDefinitions", ",", 
                    "VilTeX`Private`intersectionCode", ",", 
                    "VilTeX`Private`labelsCode", ",", 
                    "VilTeX`Private`intersectionLabelCode"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringEndsQ", "[", 
                    RowBox[{"VilTeX`Private`filename", ",", "\".tex\""}], 
                    "]"}]}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`ellipseSize", 
                    "]"}], "\[NotEqual]", "2"}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`labels", "]"}], 
                    "<", "2"}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`rx", ",", "VilTeX`Private`ry"}], 
                    "}"}], "=", "VilTeX`Private`ellipseSize"}], ";", 
                    RowBox[{"VilTeX`Private`numSets", "=", 
                    RowBox[{"Length", "[", "VilTeX`Private`labels", "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`processedColor", "=", 
                    RowBox[{"Switch", "[", 
                    
                    RowBox[{"VilTeX`Private`fillColor", ",", "\"blue\"", ",", 
                    "\"blue!50\"", ",", "\"red\"", ",", "\"red!50\"", ",", 
                    "\"green\"", ",", "\"green!50\"", ",", "\"yellow\"", ",", 
                    "\"yellow!60\"", ",", "\"orange\"", ",", "\"orange!50\"", 
                    ",", "\"purple\"", ",", "\"purple!50\"", ",", 
                    "\"violet\"", ",", "\"violet!50\"", ",", "\"cyan\"", ",", 
                    "\"cyan!50\"", ",", "\"magenta\"", ",", "\"magenta!50\"", 
                    ",", "\"pink\"", ",", "\"pink!50\"", ",", "\"brown\"", 
                    ",", "\"brown!50\"", ",", "\"black\"", ",", 
                    "\"black!30\"", ",", "\"gray\"", ",", "\"gray!85\"", ",", 
                    "\"grey\"", ",", "\"gray!85\"", ",", "_", ",", 
                    "VilTeX`Private`fillColor"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`positions", "=", 
                    RowBox[{"Switch", "[", 
                    RowBox[{"VilTeX`Private`numSets", ",", "2", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.8`"}], ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.8`", ",", "0"}], "}"}]}], "}"}], ",", "3", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.8`"}], ",", "0.6`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.8`", ",", "0.6`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{"-", "0.8`"}]}], "}"}]}], "}"}], ",", "4", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.8`"}], ",", "0.8`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.8`", ",", "0.8`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.8`"}], ",", 
                    RowBox[{"-", "0.8`"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.8`", ",", 
                    RowBox[{"-", "0.8`"}]}], "}"}]}], "}"}], ",", "5", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1.2`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"1.1`", ",", "0.37`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.68`", ",", 
                    RowBox[{"-", "0.97`"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.68`"}], ",", 
                    RowBox[{"-", "0.97`"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1.1`"}], ",", "0.37`"}], "}"}]}], "}"}], 
                    ",", "_", ",", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"1.2`", " ", 
                    RowBox[{"Cos", "[", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ")"}]}], 
                    "VilTeX`Private`numSets"], "]"}]}], ",", 
                    RowBox[{"1.2`", " ", 
                    RowBox[{"Sin", "[", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ")"}]}], 
                    "VilTeX`Private`numSets"], "]"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numSets"}], "}"}]}], "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`ellipseDefinitions", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"\\\\def\\\\ellipse\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "<>", 
                    "\"{(\"", "<>", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\") ellipse (\"",
                     "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`rx", "]"}], "<>",
                     "\" and \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`ry", "]"}], "<>",
                     "\")}\\n\""}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numSets"}], "}"}]}], "]"}], "]"}]}], ";", 
                    
                    
                    RowBox[{"VilTeX`Private`intersectionCode", "=", 
                    "\"% Sombrear la intersecci\[OAcute]n de todos los \
conjuntos\\n\\\\begin{scope}\\n\""}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`intersectionCode", "=", 
                    
                    RowBox[{"VilTeX`Private`intersectionCode", "<>", 
                    "\"    \\\\clip \\\\ellipse\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "<>", 
                    "\";\\n\""}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"VilTeX`Private`numSets", "-", "1"}]}], "}"}]}], 
                    "]"}], ";", 
                    RowBox[{"VilTeX`Private`intersectionCode", "=", 
                    
                    RowBox[{"VilTeX`Private`intersectionCode", "<>", 
                    "\"    \\\\fill[\"", "<>", 
                    "VilTeX`Private`processedColor", "<>", 
                    "\"] \\\\ellipse\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`numSets", "\[RightDoubleBracket]"}], "<>",
                     "\";\\n\\\\end{scope}\\n\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`labelsCode", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"\\\\node at (\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "+", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "<", "0"}], ",", 
                    RowBox[{
                    RowBox[{"-", "VilTeX`Private`rx"}], " ", "0.8`"}], ",", 
                    RowBox[{"VilTeX`Private`rx", " ", "0.8`"}]}], "]"}]}], 
                    "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", 
                    "\") {\\\\Large $\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "<>", 
                    "\"$};\\n\""}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numSets"}], "}"}]}], "]"}], "]"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`intersectionLabelCode", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`showIntersectionLabel", ",", 
                    
                    RowBox[{
                    "\"% Etiqueta para la intersecci\[OAcute]n\\n\\\\node at \
(0,\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    RowBox[{"-", "VilTeX`Private`ry"}], " ", "0.3`"}], "]"}], 
                    "<>", "\") {\\\\small $\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{"VilTeX`Private`labels", ",", "\" \\\\cap \""}], 
                    "]"}], "<>", "\"$};\\n\\n\""}], ",", "\"\""}], "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\\\\begin{tikzpicture}[scale=\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`scale", "]"}], 
                    "<>", "\"]\\n\\n\""}], ",", 
                    "\"% Definir las elipses\\n\"", ",", 
                    "VilTeX`Private`ellipseDefinitions", ",", "\"\\n\"", ",", 
                    "VilTeX`Private`intersectionCode", ",", 
                    "\"% Dibujar los contornos\\n\"", ",", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"\\\\draw[black, thick] \\\\ellipse\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "<>", 
                    "\";\\n\""}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numSets"}], "}"}]}], "]"}], "]"}], ",", 
                    "\"\\n\"", ",", "\"% Etiquetas\\n\"", ",", 
                    "VilTeX`Private`labelsCode", ",", "\"\\n\"", ",", 
                    "VilTeX`Private`intersectionLabelCode", ",", 
                    "\"\\\\end{tikzpicture}\""}], "}"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`fullDocument", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{
                    "\"\\\\documentclass[border=5mm]{standalone}\\n\"", ",", 
                    "\"\\\\usepackage{tikz}\\n\"", ",", 
                    "\"\\\\usepackage{amsmath}\\n\"", ",", 
                    "\"\\\\usetikzlibrary{patterns}\\n\\n\"", ",", 
                    "\"\\\\begin{document}\\n\"", ",", 
                    "VilTeX`Private`tikzCode", ",", 
                    "\"\\n\\\\end{document}\""}], "}"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`folderPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"$HomeDirectory", ",", "\"Downloads\"", ",", 
                    "\"InterSets\""}], "}"}], "]"}]}], ";", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"DirectoryQ", "[", "VilTeX`Private`folderPath", 
                    "]"}]}], ",", 
                    
                    RowBox[{"CreateDirectory", "[", 
                    "VilTeX`Private`folderPath", "]"}]}], "]"}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`downloadPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`folderPath", ",", 
                    "VilTeX`Private`filename"}], "}"}], "]"}]}], ";", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"Export", "[", 
                    
                    RowBox[{"VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`fullDocument", ",", "\"Text\""}], "]"}], 
                    "]"}], ";", "VilTeX`Private`downloadPath"}]}], "]"}]}]}, {
                   " "}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilTeX`InterSets\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"InterSets[filename, labels, fillColor, scale, \
showIntersectionLabel, ellipseSize] crea un diagrama de intersecci\[OAcute]n \
de conjuntos en formato TikZ/LaTeX y lo exporta como archivo .tex en la \
carpeta Downloads/InterSets.\\n\\nPAR\[CapitalAAcute]METROS:\\n- filename: \
String que especifica el nombre del archivo de salida (debe terminar en \
\\\".tex\\\")\\n- labels: Lista de etiquetas para identificar cada conjunto \
(m\[IAcute]nimo 2 elementos)\\n- fillColor: String que especifica el color de \
relleno de la intersecci\[OAcute]n (opcional, por defecto \\\"gray\\\")\\n- \
scale: Real que define la escala del diagrama completo (opcional, por defecto \
1.2)\\n- showIntersectionLabel: True/False para mostrar la etiqueta matem\
\[AAcute]tica de la intersecci\[OAcute]n (opcional, por defecto False)\\n- \
ellipseSize: Lista {rx, ry} que define el radio horizontal y vertical de las \
elipses (opcional, por defecto {1.5, 1.8})\\n\\nCOLORES PREDEFINIDOS:\\nLos \
siguientes colores se convierten autom\[AAcute]ticamente a tonos TikZ \
apropiados:\\n- \\\"blue\\\" -> \\\"blue!50\\\"     \[Bullet] \\\"red\\\" -> \
\\\"red!50\\\"       \[Bullet] \\\"green\\\" -> \\\"green!50\\\"\\n- \
\\\"yellow\\\" -> \\\"yellow!60\\\" \[Bullet] \\\"orange\\\" -> \\\"orange!50\
\\\" \[Bullet] \\\"purple\\\" -> \\\"purple!50\\\"\\n- \\\"violet\\\" -> \
\\\"violet!50\\\" \[Bullet] \\\"cyan\\\" -> \\\"cyan!50\\\"     \[Bullet] \
\\\"magenta\\\" -> \\\"magenta!50\\\"\\n- \\\"pink\\\" -> \\\"pink!50\\\"     \
\[Bullet] \\\"brown\\\" -> \\\"brown!50\\\"   \[Bullet] \\\"black\\\" -> \
\\\"black!30\\\"\\n- \\\"gray\\\"/\\\"grey\\\" -> \\\"gray!85\\\"\\n- \
Cualquier otro string se usa directamente como color TikZ\\n\\nDISPOSICI\
\[CapitalOAcute]N AUTOM\[CapitalAAcute]TICA DE CONJUNTOS:\\n- 2 conjuntos: \
Disposici\[OAcute]n horizontal\\n- 3 conjuntos: Disposici\[OAcute]n \
triangular\\n- 4 conjuntos: Disposici\[OAcute]n en cuadrado\\n- 5 conjuntos: \
Disposici\[OAcute]n pentagonal\\n- 6+ conjuntos: Disposici\[OAcute]n circular \
autom\[AAcute]tica\\n\\nFUNCIONALIDAD:\\n- Genera c\[OAcute]digo TikZ \
completo con documento LaTeX standalone\\n- Sombreia la intersecci\[OAcute]n \
de TODOS los conjuntos especificados\\n- Posiciona autom\[AAcute]ticamente \
las etiquetas fuera de las elipses\\n- Crea la carpeta Downloads/InterSets si \
no existe\\n- Exporta el archivo .tex listo para \
compilar\\n\\nVALIDACIONES:\\n- El filename debe terminar obligatoriamente en \
\\\".tex\\\"\\n- La lista ellipseSize debe contener exactamente 2 \
elementos\\n- La lista labels debe contener al menos 2 elementos\\n- Retorna \
$Failed si alguna validaci\[OAcute]n falla\\n\\nVALOR DE RETORNO:\\nRetorna \
la ruta completa del archivo exportado, o $Failed en caso de \
error.\\n\\nEJEMPLOS:\\n- InterSets[\\\"diagrama.tex\\\", {\\\"A\\\", \\\"B\\\
\"}]\\n- InterSets[\\\"conjuntos.tex\\\", {\\\"X\\\", \\\"Y\\\", \\\"Z\\\"}, \
\\\"blue\\\", 1.5, True]\\n- InterSets[\\\"ejemplo.tex\\\", {\\\"A\\\", \\\"B\
\\\", \\\"C\\\", \\\"D\\\"}, \\\"red\\\", 1.0, False, {2.0, 2.5}]\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}},
            ScrollPosition->{0., 0.}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "InterSets[filename, labels, fillColor, scale, showIntersectionLabel, \
ellipseSize] crea un diagrama de intersecci\[OAcute]n de conjuntos en formato \
TikZ/LaTeX y lo exporta como archivo .tex en la carpeta Downloads/InterSets.\n\
\nPAR\[CapitalAAcute]METROS:\n- filename: String que especifica el nombre del \
archivo de salida (debe terminar en \".tex\")\n- labels: Lista de etiquetas \
para identificar cada conjunto (m\[IAcute]nimo 2 elementos)\n- fillColor: \
String que especifica el color de relleno de la intersecci\[OAcute]n \
(opcional, por defecto \"gray\")\n- scale: Real que define la escala del \
diagrama completo (opcional, por defecto 1.2)\n- showIntersectionLabel: \
True/False para mostrar la etiqueta matem\[AAcute]tica de la intersecci\
\[OAcute]n (opcional, por defecto False)\n- ellipseSize: Lista {rx, ry} que \
define el radio horizontal y vertical de las elipses (opcional, por defecto \
{1.5, 1.8})\n\nCOLORES PREDEFINIDOS:\nLos siguientes colores se convierten \
autom\[AAcute]ticamente a tonos TikZ apropiados:\n- \"blue\" -> \"blue!50\"   \
  \[Bullet] \"red\" -> \"red!50\"       \[Bullet] \"green\" -> \"green!50\"\n\
- \"yellow\" -> \"yellow!60\" \[Bullet] \"orange\" -> \"orange!50\" \[Bullet] \
\"purple\" -> \"purple!50\"\n- \"violet\" -> \"violet!50\" \[Bullet] \"cyan\" \
-> \"cyan!50\"     \[Bullet] \"magenta\" -> \"magenta!50\"\n- \"pink\" -> \
\"pink!50\"     \[Bullet] \"brown\" -> \"brown!50\"   \[Bullet] \"black\" -> \
\"black!30\"\n- \"gray\"/\"grey\" -> \"gray!85\"\n- Cualquier otro string se \
usa directamente como color TikZ\n\nDISPOSICI\[CapitalOAcute]N AUTOM\
\[CapitalAAcute]TICA DE CONJUNTOS:\n- 2 conjuntos: Disposici\[OAcute]n \
horizontal\n- 3 conjuntos: Disposici\[OAcute]n triangular\n- 4 conjuntos: \
Disposici\[OAcute]n en cuadrado\n- 5 conjuntos: Disposici\[OAcute]n \
pentagonal\n- 6+ conjuntos: Disposici\[OAcute]n circular autom\[AAcute]tica\n\
\nFUNCIONALIDAD:\n- Genera c\[OAcute]digo TikZ completo con documento LaTeX \
standalone\n- Sombreia la intersecci\[OAcute]n de TODOS los conjuntos \
especificados\n- Posiciona autom\[AAcute]ticamente las etiquetas fuera de las \
elipses\n- Crea la carpeta Downloads/InterSets si no existe\n- Exporta el \
archivo .tex listo para compilar\n\nVALIDACIONES:\n- El filename debe \
terminar obligatoriamente en \".tex\"\n- La lista ellipseSize debe contener \
exactamente 2 elementos\n- La lista labels debe contener al menos 2 elementos\
\n- Retorna $Failed si alguna validaci\[OAcute]n falla\n\nVALOR DE RETORNO:\n\
Retorna la ruta completa del archivo exportado, o $Failed en caso de error.\n\
\nEJEMPLOS:\n- InterSets[\"diagrama.tex\", {\"A\", \"B\"}]\n- \
InterSets[\"conjuntos.tex\", {\"X\", \"Y\", \"Z\"}, \"blue\", 1.5, True]\n- \
InterSets[\"ejemplo.tex\", {\"A\", \"B\", \"C\", \"D\"}, \"red\", 1.0, False, \
{2.0, 2.5}]", "Documentation" -> None, "OwnValues" -> None, "UpValues" -> 
    None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilTeX`InterSets, {VilTeX`InterSets[
         Pattern[VilTeX`Private`filename, 
          Blank[String]], 
         Pattern[VilTeX`Private`labels, 
          Blank[List]], 
         Optional[
          Pattern[VilTeX`Private`fillColor, 
           Blank[String]], "gray"], 
         Optional[
          Pattern[VilTeX`Private`scale, 
           Blank[Real]], 1.2], 
         Optional[
          Pattern[VilTeX`Private`showIntersectionLabel, 
           Blank[]], False], 
         Optional[
          Pattern[VilTeX`Private`ellipseSize, 
           Blank[List]], {1.5, 1.8}]] :> 
       Module[{VilTeX`Private`tikzCode, VilTeX`Private`fullDocument, 
          VilTeX`Private`downloadPath, VilTeX`Private`folderPath, 
          VilTeX`Private`rx, VilTeX`Private`ry, VilTeX`Private`processedColor,
           VilTeX`Private`numSets, VilTeX`Private`positions, 
          VilTeX`Private`ellipseDefinitions, VilTeX`Private`intersectionCode, 
          VilTeX`Private`labelsCode, VilTeX`Private`intersectionLabelCode}, If[
           Not[
            StringEndsQ[VilTeX`Private`filename, ".tex"]], 
           Return[$Failed]]; If[Length[VilTeX`Private`ellipseSize] != 2, 
           Return[$Failed]]; If[Length[VilTeX`Private`labels] < 2, 
           Return[$Failed]]; {VilTeX`Private`rx, VilTeX`Private`ry} = 
          VilTeX`Private`ellipseSize; 
         VilTeX`Private`numSets = Length[VilTeX`Private`labels]; 
         VilTeX`Private`processedColor = 
          Switch[VilTeX`Private`fillColor, "blue", "blue!50", "red", "red!50",
             "green", "green!50", "yellow", "yellow!60", "orange", 
            "orange!50", "purple", "purple!50", "violet", "violet!50", "cyan",
             "cyan!50", "magenta", "magenta!50", "pink", "pink!50", "brown", 
            "brown!50", "black", "black!30", "gray", "gray!85", "grey", 
            "gray!85", 
            Blank[], VilTeX`Private`fillColor]; 
         VilTeX`Private`positions = 
          Switch[VilTeX`Private`numSets, 2, {{-0.8, 0}, {0.8, 0}}, 
            3, {{-0.8, 0.6}, {0.8, 0.6}, {0, -0.8}}, 4, {{-0.8, 0.8}, {0.8, 
            0.8}, {-0.8, -0.8}, {0.8, -0.8}}, 
            5, {{0, 1.2}, {1.1, 0.37}, {0.68, -0.97}, {-0.68, -0.97}, {-1.1, 
             0.37}}, 
            Blank[], 
            
            Table[{1.2 
              Cos[2 Pi ((VilTeX`Private`i - 1)/VilTeX`Private`numSets)], 1.2 
              Sin[2 Pi ((VilTeX`Private`i - 1)/VilTeX`Private`numSets)]}, {
             VilTeX`Private`i, VilTeX`Private`numSets}]]; 
         VilTeX`Private`ellipseDefinitions = StringJoin[
            Table[
            "\\def\\ellipse" <> Part[VilTeX`Private`labels, VilTeX`Private`i] <> 
             "{(" <> ToString[
               Part[VilTeX`Private`positions, VilTeX`Private`i, 1]] <> "," <> 
             ToString[
               Part[VilTeX`Private`positions, VilTeX`Private`i, 2]] <> 
             ") ellipse (" <> ToString[VilTeX`Private`rx] <> " and " <> 
             ToString[VilTeX`Private`ry] <> ")}\n", {
             VilTeX`Private`i, VilTeX`Private`numSets}]]; 
         VilTeX`Private`intersectionCode = 
          "% Sombrear la intersecci\[OAcute]n de todos los conjuntos\n\
\\begin{scope}\n"; 
         Do[VilTeX`Private`intersectionCode = 
           VilTeX`Private`intersectionCode <> "    \\clip \\ellipse" <> 
            Part[VilTeX`Private`labels, VilTeX`Private`i] <> ";\n", {
           VilTeX`Private`i, VilTeX`Private`numSets - 1}]; 
         VilTeX`Private`intersectionCode = 
          VilTeX`Private`intersectionCode <> "    \\fill[" <> 
           VilTeX`Private`processedColor <> "] \\ellipse" <> 
           Part[VilTeX`Private`labels, VilTeX`Private`numSets] <> 
           ";\n\\end{scope}\n\n"; VilTeX`Private`labelsCode = StringJoin[
            Table[
            "\\node at (" <> 
             ToString[
              Part[VilTeX`Private`positions, VilTeX`Private`i, 1] + 
               If[Part[VilTeX`Private`positions, VilTeX`Private`i, 1] < 
                 0, (-VilTeX`Private`rx) 0.8, VilTeX`Private`rx 0.8]] <> "," <> 
             ToString[
               Part[VilTeX`Private`positions, VilTeX`Private`i, 2]] <> 
             ") {\\Large $" <> Part[VilTeX`Private`labels, VilTeX`Private`i] <> 
             "$};\n", {VilTeX`Private`i, VilTeX`Private`numSets}]]; 
         VilTeX`Private`intersectionLabelCode = 
          If[VilTeX`Private`showIntersectionLabel, 
            "% Etiqueta para la intersecci\[OAcute]n\n\\node at (0," <> 
            ToString[(-VilTeX`Private`ry) 0.3] <> ") {\\small $" <> 
            StringRiffle[VilTeX`Private`labels, " \\cap "] <> "$};\n\n", ""]; 
         VilTeX`Private`tikzCode = 
          StringJoin[{
            "\\begin{tikzpicture}[scale=" <> ToString[VilTeX`Private`scale] <> 
             "]\n\n", "% Definir las elipses\n", 
             VilTeX`Private`ellipseDefinitions, "\n", 
             VilTeX`Private`intersectionCode, "% Dibujar los contornos\n", 
             StringJoin[
              Table[
              "\\draw[black, thick] \\ellipse" <> 
               Part[VilTeX`Private`labels, VilTeX`Private`i] <> ";\n", {
               VilTeX`Private`i, VilTeX`Private`numSets}]], "\n", 
             "% Etiquetas\n", VilTeX`Private`labelsCode, "\n", 
             VilTeX`Private`intersectionLabelCode, "\\end{tikzpicture}"}]; 
         VilTeX`Private`fullDocument = 
          StringJoin[{
            "\\documentclass[border=5mm]{standalone}\n", 
             "\\usepackage{tikz}\n", "\\usepackage{amsmath}\n", 
             "\\usetikzlibrary{patterns}\n\n", "\\begin{document}\n", 
             VilTeX`Private`tikzCode, "\n\\end{document}"}]; 
         VilTeX`Private`folderPath = 
          FileNameJoin[{$HomeDirectory, "Downloads", "InterSets"}]; Quiet[
           If[
            Not[
             DirectoryQ[VilTeX`Private`folderPath]], 
            CreateDirectory[VilTeX`Private`folderPath]]]; 
         VilTeX`Private`downloadPath = 
          FileNameJoin[{VilTeX`Private`folderPath, VilTeX`Private`filename}]; 
         Quiet[
           Export[
           VilTeX`Private`downloadPath, VilTeX`Private`fullDocument, "Text"]]; 
         VilTeX`Private`downloadPath]}], "SubValues" -> None, "DefaultValues" -> 
    None, "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {Protected}, "FullName" -> "VilTeX`InterSets"|>, 
   False]]], "Output",
 CellChangeTimes->{3.966972194705412*^9},
 CellLabel->
  "Out[268]=",ExpressionUUID->"7f9b53b7-048c-4403-a83b-3eb3f05a46d6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 1: dos conjuntos", "Subsection",
 CellChangeTimes->{{3.9669722155811577`*^9, 3.966972227370956*^9}, {
  3.96697269501637*^9, 
  3.966972698074332*^9}},ExpressionUUID->"02aa5d92-b5d8-4c52-92ab-\
5f7f52d58c48"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"InterSets", "[", 
   RowBox[{"\"\<intersets1.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}], ",", "\"\<blue\>\""}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9669722482833633`*^9, 3.9669722833538523`*^9}, 
   3.9670216469253817`*^9},ExpressionUUID->"caf81824-d67c-440f-8e67-\
3d9bd2cbf85b"],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/InterSets/intersets1.\
tex\"\>"], "Output",
 CellChangeTimes->{3.966972249850747*^9, 3.966972287786994*^9},
 CellLabel->
  "Out[271]=",ExpressionUUID->"b2ccad9f-94a0-40b0-bb68-5bc72ea2f137"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966972249852028*^9, 3.966972287788006*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[271]:=",ExpressionUUID->"465272ac-799d-4695-a5d9-8d87787e1e9f"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.966972249852028*^9, 3.966972287788623*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[271]:=",ExpressionUUID->"8e2b5c2f-b3ab-4379-9f25-5dbda1ee10eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966972249852028*^9, 3.9669722877893333`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[271]:=",ExpressionUUID->"db19d262-3310-4a14-a82b-133f98c98395"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966972249852028*^9, 3.966972287789806*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[271]:=",ExpressionUUID->"e6934e23-5224-4ddf-9624-314af03618c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.966972249852028*^9, 3.9669722877902803`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[271]:=",ExpressionUUID->"185f56ed-0f01-4c0e-96e2-8b16f94a4bc4"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.966972249852028*^9, 3.966972287843049*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[271]:=",ExpressionUUID->"36f45219-5e68-4d5f-9e4e-e799a275bd57"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.966972249852028*^9, 3.96697228884986*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[271]:=",ExpressionUUID->"3f02e063-99e2-4ec8-8fda-977bac149c93"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/InterSets/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/InterSets/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966972249852028*^9, 3.96697228885314*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[271]:=",ExpressionUUID->"00c9f176-9bdd-4685-bfc7-9562b8f0d965"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"intersets1\"\>"}],
  SequenceForm["Archivo: ", "intersets1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966972249852028*^9, 3.966972288855568*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[271]:=",ExpressionUUID->"decf57b4-0218-409d-b67d-7a80c35e10a2"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.966972249852028*^9, 3.96697228929906*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[271]:=",ExpressionUUID->"0f9342d6-9841-457a-99a8-465d9186bf4b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/InterSets/intersets1.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/InterSets/intersets1.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966972249852028*^9, 3.9669722892997007`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[271]:=",ExpressionUUID->"8777e3f4-9bed-442a-8432-6428f187917e"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/InterSets/intersets1.\
pdf\"\>"], "Output",
 CellChangeTimes->{3.966972249850747*^9, 3.966972289311941*^9},
 CellLabel->
  "Out[272]=",ExpressionUUID->"ca7074ca-bffe-430f-9e8f-720dc3f02999"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 2: tres conjuntos", "Subsection",
 CellChangeTimes->{{3.966972340239303*^9, 3.966972341932577*^9}, {
  3.966972701542218*^9, 
  3.966972705302333*^9}},ExpressionUUID->"c0f27890-6627-440d-903e-\
d12440c352c0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"InterSets", "[", 
   RowBox[{"\"\<intersets2.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\"", ",", "\"\<C\>\""}], "}"}], 
    ",", "\"\<red\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.966972369814867*^9, 3.96697238069593*^9}, {
   3.966972416010339*^9, 3.9669725765182056`*^9}, {3.966972623384383*^9, 
   3.966972641004035*^9}, {3.9669726873369837`*^9, 3.9669727096091223`*^9}, 
   3.967021642760371*^9},ExpressionUUID->"c3fe9ebf-77ed-4b29-af5a-\
d860209d9049"],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/InterSets/intersets2.\
tex\"\>"], "Output",
 CellChangeTimes->{
  3.966972446123686*^9, 3.966972481234953*^9, 3.9669725126514883`*^9, {
   3.966972545005412*^9, 3.966972577094351*^9}, {3.966972629305056*^9, 
   3.9669726413374662`*^9}, 3.9669727125274076`*^9},
 CellLabel->
  "Out[290]=",ExpressionUUID->"60350c7f-8d3e-487d-82ac-436e12bf66e4"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966972446125174*^9, 3.9669724812361403`*^9, 3.9669725126524887`*^9, {
   3.966972545006545*^9, 3.96697257709558*^9}, {3.9669726293061953`*^9, 
   3.966972641338768*^9}, 3.966972712529044*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[290]:=",ExpressionUUID->"c70f3cec-610d-471a-84f6-31b2dacf2451"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.966972446125174*^9, 3.9669724812361403`*^9, 3.9669725126524887`*^9, {
   3.966972545006545*^9, 3.96697257709558*^9}, {3.9669726293061953`*^9, 
   3.966972641338768*^9}, 3.966972712529808*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[290]:=",ExpressionUUID->"94629dfb-7a7c-4373-832f-93b5b148cc93"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966972446125174*^9, 3.9669724812361403`*^9, 3.9669725126524887`*^9, {
   3.966972545006545*^9, 3.96697257709558*^9}, {3.9669726293061953`*^9, 
   3.966972641338768*^9}, 3.966972712530603*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[290]:=",ExpressionUUID->"e886fde2-e217-4313-82ea-874d02ed4463"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966972446125174*^9, 3.9669724812361403`*^9, 3.9669725126524887`*^9, {
   3.966972545006545*^9, 3.96697257709558*^9}, {3.9669726293061953`*^9, 
   3.966972641338768*^9}, 3.966972712531128*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[290]:=",ExpressionUUID->"92bd044a-9154-4180-868f-c6aa4eb881fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966972446125174*^9, 3.9669724812361403`*^9, 3.9669725126524887`*^9, {
   3.966972545006545*^9, 3.96697257709558*^9}, {3.9669726293061953`*^9, 
   3.966972641338768*^9}, 3.966972712531665*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[290]:=",ExpressionUUID->"1a3df339-45e9-459d-b196-ea38380f3542"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.966972446125174*^9, 3.9669724812361403`*^9, 3.9669725126524887`*^9, {
   3.966972545006545*^9, 3.96697257709558*^9}, {3.9669726293061953`*^9, 
   3.966972641338768*^9}, 3.966972712614458*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[290]:=",ExpressionUUID->"8bec6d8e-2633-4415-a614-d20429213b17"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.966972446125174*^9, 3.9669724812361403`*^9, 3.9669725126524887`*^9, {
   3.966972545006545*^9, 3.96697257709558*^9}, {3.9669726293061953`*^9, 
   3.966972641338768*^9}, 3.966972713621871*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[290]:=",ExpressionUUID->"02701fdc-bb91-4105-9099-650dbc062d84"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/InterSets/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/InterSets/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966972446125174*^9, 3.9669724812361403`*^9, 3.9669725126524887`*^9, {
   3.966972545006545*^9, 3.96697257709558*^9}, {3.9669726293061953`*^9, 
   3.966972641338768*^9}, 3.966972713625537*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[290]:=",ExpressionUUID->"d69ccb1a-a0db-47ab-8ab3-d0ecb14314a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"intersets2\"\>"}],
  SequenceForm["Archivo: ", "intersets2"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966972446125174*^9, 3.9669724812361403`*^9, 3.9669725126524887`*^9, {
   3.966972545006545*^9, 3.96697257709558*^9}, {3.9669726293061953`*^9, 
   3.966972641338768*^9}, 3.966972713627862*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[290]:=",ExpressionUUID->"e0486530-9c27-4458-ac51-c90b0e219bd6"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.966972446125174*^9, 3.9669724812361403`*^9, 3.9669725126524887`*^9, {
   3.966972545006545*^9, 3.96697257709558*^9}, {3.9669726293061953`*^9, 
   3.966972641338768*^9}, 3.96697271407166*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[290]:=",ExpressionUUID->"e42c5de8-e1dd-4c0a-966a-3c23f0577313"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/InterSets/intersets2.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/InterSets/intersets2.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.966972446125174*^9, 3.9669724812361403`*^9, 3.9669725126524887`*^9, {
   3.966972545006545*^9, 3.96697257709558*^9}, {3.9669726293061953`*^9, 
   3.966972641338768*^9}, 3.966972714072328*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[290]:=",ExpressionUUID->"dbd28a5e-6067-4af3-b471-f65d03c91f24"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/InterSets/intersets2.\
pdf\"\>"], "Output",
 CellChangeTimes->{
  3.966972446123686*^9, 3.966972481234953*^9, 3.9669725126514883`*^9, {
   3.966972545005412*^9, 3.966972577094351*^9}, {3.966972629305056*^9, 
   3.9669726413374662`*^9}, 3.9669727140844097`*^9},
 CellLabel->
  "Out[291]=",ExpressionUUID->"cc057756-b5f0-400f-95d6-8ac63da042c2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 3: cuatro conjuntos", "Subsection",
 CellChangeTimes->{{3.9669727242198887`*^9, 
  3.9669727459122753`*^9}},ExpressionUUID->"2144af5f-f973-473b-ad35-\
40c9cc8a4a2a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"InterSets", "[", 
   RowBox[{"\"\<intersets3.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<W\>\"", ",", "\"\<X\>\"", ",", "\"\<Y\>\"", 
      ",", "\"\<Z\>\""}], "}"}], ",", "\"\<green\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.966972787928582*^9, 3.966972800062563*^9}, 
   3.96702163827535*^9},ExpressionUUID->"a69638c0-8622-450b-b891-\
b49f58349566"],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/InterSets/intersets3.\
tex\"\>"], "Output",
 CellChangeTimes->{3.96697280158084*^9},
 CellLabel->
  "Out[292]=",ExpressionUUID->"d11d3f43-f2b8-4f08-a176-c94e664fdd47"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966972801582327*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[292]:=",ExpressionUUID->"bbaa3d92-fa73-41b2-9e91-ae996861d6bb"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.9669728015829773`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[292]:=",ExpressionUUID->"0d37d9db-5e43-48b4-b890-1b91a1518087"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966972801583889*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[292]:=",ExpressionUUID->"f463b03e-244c-4526-8fce-0b1883e18554"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966972801584436*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[292]:=",ExpressionUUID->"e300f8a0-0479-47ce-a90e-d8180de648ac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.966972801584968*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[292]:=",ExpressionUUID->"c9da8d7e-3e44-4689-81ea-19810e0e1846"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.96697280166846*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[292]:=",ExpressionUUID->"76f13222-89f7-4a83-aa37-6f5c01751160"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.966972802675439*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[292]:=",ExpressionUUID->"6dcffaf7-8720-4a57-8527-6cb1a286f1f0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/InterSets/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/InterSets/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669728026794367`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[292]:=",ExpressionUUID->"dc966b2d-9891-4f65-84a3-7717fc2f31a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"intersets3\"\>"}],
  SequenceForm["Archivo: ", "intersets3"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966972802682188*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[292]:=",ExpressionUUID->"f8a07d96-6416-4b6a-b772-411b83583eef"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.966972803120213*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[292]:=",ExpressionUUID->"11b58314-4c77-4756-8e6b-826fed5a0af3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/InterSets/intersets3.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/InterSets/intersets3.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966972803120936*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[292]:=",ExpressionUUID->"55377019-45d8-4902-91bf-b997760da0d8"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/InterSets/intersets3.\
pdf\"\>"], "Output",
 CellChangeTimes->{3.966972803133304*^9},
 CellLabel->
  "Out[293]=",ExpressionUUID->"a90ec2f1-d88c-4506-8055-d84bdba55900"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 4: cinco conjuntos", "Subsection",
 CellChangeTimes->{{3.9669727242198887`*^9, 3.9669727459122753`*^9}, {
  3.966972846491487*^9, 
  3.9669728670266542`*^9}},ExpressionUUID->"df0ad50c-ea26-4012-8254-\
e65ec4179d38"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"InterSets", "[", 
   RowBox[{"\"\<intersets4.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\"", ",", "\"\<C\>\"", ",", "\"\<D\>\"",
       ",", "\"\<E\>\""}], "}"}], ",", "\"\<purple\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9669728276351767`*^9, 3.966972839068131*^9}, 
   3.9670216350458612`*^9},ExpressionUUID->"2e50f056-d3dd-444a-ae76-\
d8182ec29b3d"],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/InterSets/intersets4.\
tex\"\>"], "Output",
 CellChangeTimes->{3.966972852827985*^9},
 CellLabel->
  "Out[294]=",ExpressionUUID->"c1f08763-6304-4ca9-9af4-77759aff32f4"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669728528299007`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[294]:=",ExpressionUUID->"b95ec913-a623-4539-b510-0c5895f872be"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.966972852830619*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[294]:=",ExpressionUUID->"6e700bfa-3779-49de-89b0-147c3da908a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966972852831723*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[294]:=",ExpressionUUID->"2eb956a4-c959-4ab9-a823-b7e73b892957"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966972852832353*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[294]:=",ExpressionUUID->"e2a1dfdd-f247-4187-bf7c-995318982e97"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.966972852832979*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[294]:=",ExpressionUUID->"dad6610e-abd5-46f1-8ea8-a80271b5e579"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.9669728529294*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[294]:=",ExpressionUUID->"7f3073e1-ba96-4585-842d-9dfe676ad089"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.966972853936002*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[294]:=",ExpressionUUID->"9316bcf3-965d-48d1-a6a8-6d7fd81cf4dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/InterSets/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/InterSets/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966972853939197*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[294]:=",ExpressionUUID->"fe5570cc-35e4-4cd2-b530-d9ef7cb11e1c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"intersets4\"\>"}],
  SequenceForm["Archivo: ", "intersets4"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669728539418087`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[294]:=",ExpressionUUID->"afa8d10e-619c-4c34-8035-90c206d87d93"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.966972854393115*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[294]:=",ExpressionUUID->"60817dc2-a471-4129-9851-10224573f0a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/InterSets/intersets4.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/InterSets/intersets4.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669728543937807`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[294]:=",ExpressionUUID->"afca2996-a947-4b73-bfcf-c490536e9f01"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/InterSets/intersets4.\
pdf\"\>"], "Output",
 CellChangeTimes->{3.9669728544053926`*^9},
 CellLabel->
  "Out[295]=",ExpressionUUID->"869128b8-c730-4458-be62-5f5985f297aa"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 5: con etiqueta de intersecci\[OAcute]n", "Subsection",
 CellChangeTimes->{{3.9669727242198887`*^9, 3.9669727459122753`*^9}, {
  3.966972846491487*^9, 3.9669728944803247`*^9}, {3.967021790770426*^9, 
  3.967021791084135*^9}},ExpressionUUID->"4fe5ae14-d64f-431a-b9bd-\
25d7904a97a7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"InterSets", "[", 
   RowBox[{"\"\<intersets5.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<X\>\"", ",", "\"\<Y\>\"", ",", "\"\<Z\>\""}], "}"}], 
    ",", "\"\<orange\>\"", ",", "1.3", ",", "True"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.966972899881795*^9, 3.966972943353767*^9}, 
   3.9670216316848707`*^9},ExpressionUUID->"4fef6e39-2204-4b23-99a7-\
53bb1198d3ed"],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/InterSets/intersets5.\
tex\"\>"], "Output",
 CellChangeTimes->{3.966972923543713*^9, 3.966972956568531*^9},
 CellLabel->
  "Out[298]=",ExpressionUUID->"747f1e12-6f4f-44a0-8bad-3a2a82dbe6fe"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966972923545569*^9, 3.966972956569899*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[298]:=",ExpressionUUID->"abe5d08e-549e-4f1c-a831-6a454602191d"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.966972923545569*^9, 3.966972956570657*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[298]:=",ExpressionUUID->"835149f7-9dd4-4a75-a8a1-7aec92261130"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966972923545569*^9, 3.966972956571533*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[298]:=",ExpressionUUID->"a2a8ada4-321b-4041-a2c2-c6d5299e3730"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966972923545569*^9, 3.966972956572096*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[298]:=",ExpressionUUID->"3afd638b-2933-4759-9ef0-4f8da1fead54"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.966972923545569*^9, 3.966972956572637*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[298]:=",ExpressionUUID->"434b7c1c-0273-4d5a-8d0e-1699598a97b7"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.966972923545569*^9, 3.966972956645091*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[298]:=",ExpressionUUID->"c575358d-e7b6-489d-b422-9e6f4f79ca29"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.966972923545569*^9, 3.96697295765177*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[298]:=",ExpressionUUID->"ebe3a645-2aa7-4e14-8332-78eb062acc11"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/InterSets/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/InterSets/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966972923545569*^9, 3.966972957655374*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[298]:=",ExpressionUUID->"def3c953-1134-474b-a687-0dce646d7a57"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"intersets5\"\>"}],
  SequenceForm["Archivo: ", "intersets5"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966972923545569*^9, 3.9669729576579247`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[298]:=",ExpressionUUID->"eaf37767-c172-4ca4-bf83-d8004b306521"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.966972923545569*^9, 3.966972958107245*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[298]:=",ExpressionUUID->"f2a31696-866b-4db6-8c24-30b0af188cb8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/InterSets/intersets5.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/InterSets/intersets5.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966972923545569*^9, 3.966972958107983*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[298]:=",ExpressionUUID->"89f75fbf-a3b3-4ece-82b9-92687eca5147"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/InterSets/intersets5.\
pdf\"\>"], "Output",
 CellChangeTimes->{3.966972923543713*^9, 3.966972958120779*^9},
 CellLabel->
  "Out[299]=",ExpressionUUID->"88e4feed-b760-4b32-a096-22bfa750ab27"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 6: elipses m\[AAcute]s grandes", "Subsection",
 CellChangeTimes->{{3.966972976577314*^9, 3.966972992119813*^9}, 
   3.967021480369932*^9},ExpressionUUID->"2274ce49-0182-437a-8e0f-\
2220a35745e3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"InterSets", "[", 
   RowBox[{"\"\<intersets6.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\"", ",", "\"\<C\>\""}], "}"}], 
    ",", "\"\<cyan\>\"", ",", "1.8", ",", "False", ",", 
    RowBox[{"{", 
     RowBox[{"1.8", ",", "2.0"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9669729954778337`*^9, 3.966973012716609*^9}, 
   3.967021627399441*^9},ExpressionUUID->"ca32495f-fc09-427d-b5f2-\
b43b3cbd83d3"],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/InterSets/intersets6.\
tex\"\>"], "Output",
 CellChangeTimes->{3.966973019685166*^9},
 CellLabel->
  "Out[300]=",ExpressionUUID->"e16dc375-71c8-4057-b04e-70b26697d92b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966973019686936*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[300]:=",ExpressionUUID->"f21e2922-671e-42f1-a628-9f7d71cbfea8"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.966973019687583*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[300]:=",ExpressionUUID->"fc072192-d257-4780-9df7-afe609cff44c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966973019688684*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[300]:=",ExpressionUUID->"99b9633c-2ec4-49ba-91d1-79fdb447c864"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966973019689208*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[300]:=",ExpressionUUID->"ccf25841-165a-4803-b2d4-3ea2cb7290ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.966973019689727*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[300]:=",ExpressionUUID->"5cc6e392-b9b6-4ac2-a917-3e40bc032a75"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.966973019760985*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[300]:=",ExpressionUUID->"3a279d63-7dec-4dc1-ab7c-d72286676f88"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.966973020766317*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[300]:=",ExpressionUUID->"eaa800a7-93f0-4fd5-bb49-35a3d7889d18"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/InterSets/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/InterSets/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966973020770125*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[300]:=",ExpressionUUID->"33e5ebed-df39-446f-9989-d7d46f518756"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"intersets6\"\>"}],
  SequenceForm["Archivo: ", "intersets6"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966973020772798*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[300]:=",ExpressionUUID->"8618c72e-0626-4156-92a0-1127b0d6bcf1"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.966973021201035*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[300]:=",ExpressionUUID->"0198a8ee-5ebe-4eb9-b272-3d9c6aeb3dbc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/InterSets/intersets6.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/InterSets/intersets6.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.96697302120179*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[300]:=",ExpressionUUID->"4300066f-99fc-48c8-b72a-2cd3badaf815"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/InterSets/intersets6.\
pdf\"\>"], "Output",
 CellChangeTimes->{3.966973021214334*^9},
 CellLabel->
  "Out[301]=",ExpressionUUID->"9c37f586-3324-406c-8c35-94a901021a0f"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["UnionComplement", "Section",
 CellChangeTimes->{
  3.966973099505282*^9},ExpressionUUID->"6a3c9199-a724-4c87-ab79-\
991775005aaa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "UnionComplement"}]], "Input",
 CellChangeTimes->{{3.9669731011013927`*^9, 3.966973104014728*^9}},
 CellLabel->
  "In[302]:=",ExpressionUUID->"d0073ad3-77b2-4a18-8e62-528abafe3eb9"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"UnionComplement[filename, labels, fillColor, scale, \
showComplementLabel, ellipseSize, universeSize] crea un diagrama del \
complemento de la uni\[OAcute]n de conjuntos en formato TikZ/LaTeX y lo \
exporta como archivo .tex en la carpeta Downloads/UnionComplement.\\n\\nPAR\
\[CapitalAAcute]METROS:\\n- filename: String que especifica el nombre del \
archivo de salida (debe terminar en \\\".tex\\\")\\n- labels: Lista de \
etiquetas para identificar cada conjunto (m\[IAcute]nimo 2 elementos)\\n- \
fillColor: String que especifica el color de relleno del complemento \
(opcional, por defecto \\\"gray\\\")\\n- scale: Real que define la escala del \
diagrama completo (opcional, por defecto 1.2)\\n- showComplementLabel: \
True/False para mostrar la etiqueta matem\[AAcute]tica del complemento \
(opcional, por defecto False)\\n- ellipseSize: Lista {rx, ry} que define el \
radio horizontal y vertical de las elipses (opcional, por defecto {1.5, 1.8})\
\\n- universeSize: Lista {ux, uy} que define las dimensiones del \
rect\[AAcute]ngulo del universo (opcional, por defecto {4, 3})\\n\\nCOLORES \
PREDEFINIDOS:\\nLos siguientes colores se convierten autom\[AAcute]ticamente \
a tonos TikZ apropiados:\\n- \\\"blue\\\" -> \\\"blue!50\\\"     \[Bullet] \\\
\"red\\\" -> \\\"red!50\\\"       \[Bullet] \\\"green\\\" -> \\\"green!50\\\"\
\\n- \\\"yellow\\\" -> \\\"yellow!60\\\" \[Bullet] \\\"orange\\\" -> \
\\\"orange!50\\\" \[Bullet] \\\"purple\\\" -> \\\"purple!50\\\"\\n- \
\\\"violet\\\" -> \\\"violet!50\\\" \[Bullet] \\\"cyan\\\" -> \\\"cyan!50\\\" \
    \[Bullet] \\\"magenta\\\" -> \\\"magenta!50\\\"\\n- \\\"pink\\\" -> \
\\\"pink!50\\\"     \[Bullet] \\\"brown\\\" -> \\\"brown!50\\\"   \[Bullet] \
\\\"black\\\" -> \\\"black!30\\\"\\n- \\\"gray\\\"/\\\"grey\\\" -> \
\\\"gray!85\\\"\\n- Cualquier otro string se usa directamente como color TikZ\
\\n\\nDISPOSICI\[CapitalOAcute]N AUTOM\[CapitalAAcute]TICA DE CONJUNTOS:\\n- \
2 conjuntos: Disposici\[OAcute]n horizontal\\n- 3 conjuntos: Disposici\
\[OAcute]n triangular\\n- 4 conjuntos: Disposici\[OAcute]n en cuadrado\\n- 5 \
conjuntos: Disposici\[OAcute]n pentagonal\\n- 6+ conjuntos: \
Disposici\[OAcute]n circular autom\[AAcute]tica\\n\\nFUNCIONALIDAD:\\n- \
Genera c\[OAcute]digo TikZ completo con documento LaTeX standalone\\n- Dibuja \
un rect\[AAcute]ngulo (universo) completamente sombreado\\n- \\\"Borra\\\" \
las elipses de los conjuntos (las dibuja en blanco) para mostrar el \
complemento de la uni\[OAcute]n\\n- El resultado visual es el complemento de \
A\:222aB\:222aC\:222a... (la regi\[OAcute]n sombreada es todo lo que NO est\
\[AAcute] en ning\[UAcute]n conjunto)\\n- Posiciona autom\[AAcute]ticamente \
las etiquetas fuera de las elipses\\n- Crea la carpeta \
Downloads/UnionComplement si no existe\\n- Exporta el archivo .tex listo para \
compilar\\n\\nVALIDACIONES:\\n- El filename debe terminar obligatoriamente en \
\\\".tex\\\"\\n- La lista ellipseSize debe contener exactamente 2 \
elementos\\n- La lista universeSize debe contener exactamente 2 elementos\\n- \
La lista labels debe contener al menos 2 elementos\\n- Retorna $Failed si \
alguna validaci\[OAcute]n falla\\n\\nVALOR DE RETORNO:\\nRetorna la ruta \
completa del archivo exportado, o $Failed en caso de \
error.\\n\\nEJEMPLOS:\\n- UnionComplement[\\\"complemento.tex\\\", \
{\\\"A\\\", \\\"B\\\"}]\\n- UnionComplement[\\\"comp_tres.tex\\\", \
{\\\"X\\\", \\\"Y\\\", \\\"Z\\\"}, \\\"blue\\\", 1.5, True]\\n- \
UnionComplement[\\\"ejemplo.tex\\\", {\\\"A\\\", \\\"B\\\", \\\"C\\\"}, \
\\\"red\\\", 1.0, False, {2.0, 2.5}, {5, 4}]\\n\\nNOTA \
MATEM\[CapitalAAcute]TICA:\\nEsta funci\[OAcute]n visualiza (A \:222a B \
\:222a C \:222a ...)^c, es decir, el complemento de la uni\[OAcute]n de todos \
los conjuntos especificados.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"UnionComplement", "[", 
                    
                    RowBox[{
                    "VilTeX`Private`filename_String", ",", 
                    "VilTeX`Private`labels_List", ",", 
                    
                    RowBox[{
                    "VilTeX`Private`fillColor_String", ":", "\"gray\""}], ",", 
                    RowBox[{"VilTeX`Private`scale_Real", ":", "1.2`"}], ",", 
                    
                    RowBox[{
                    "VilTeX`Private`showComplementLabel_", ":", "False"}], 
                    ",", 
                    RowBox[{"VilTeX`Private`ellipseSize_List", ":", 
                    RowBox[{"{", 
                    RowBox[{"1.5`", ",", "1.8`"}], "}"}]}], ",", 
                    RowBox[{"VilTeX`Private`universeSize_List", ":", 
                    RowBox[{"{", 
                    RowBox[{"4", ",", "3"}], "}"}]}]}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", ",", 
                    "VilTeX`Private`fullDocument", ",", 
                    "VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`folderPath", ",", "VilTeX`Private`rx", 
                    ",", "VilTeX`Private`ry", ",", 
                    "VilTeX`Private`processedColor", ",", 
                    "VilTeX`Private`numSets", ",", "VilTeX`Private`positions",
                     ",", "VilTeX`Private`ellipseDefinitions", ",", 
                    "VilTeX`Private`complementCode", ",", 
                    "VilTeX`Private`labelsCode", ",", 
                    "VilTeX`Private`complementLabelCode", ",", 
                    "VilTeX`Private`ux", ",", "VilTeX`Private`uy"}], "}"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringEndsQ", "[", 
                    RowBox[{"VilTeX`Private`filename", ",", "\".tex\""}], 
                    "]"}]}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`ellipseSize", 
                    "]"}], "\[NotEqual]", "2"}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`universeSize", 
                    "]"}], "\[NotEqual]", "2"}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`labels", "]"}], 
                    "<", "2"}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`rx", ",", "VilTeX`Private`ry"}], 
                    "}"}], "=", "VilTeX`Private`ellipseSize"}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`ux", ",", "VilTeX`Private`uy"}], 
                    "}"}], "=", "VilTeX`Private`universeSize"}], ";", 
                    RowBox[{"VilTeX`Private`numSets", "=", 
                    RowBox[{"Length", "[", "VilTeX`Private`labels", "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`processedColor", "=", 
                    RowBox[{"Switch", "[", 
                    
                    RowBox[{"VilTeX`Private`fillColor", ",", "\"blue\"", ",", 
                    "\"blue!50\"", ",", "\"red\"", ",", "\"red!50\"", ",", 
                    "\"green\"", ",", "\"green!50\"", ",", "\"yellow\"", ",", 
                    "\"yellow!60\"", ",", "\"orange\"", ",", "\"orange!50\"", 
                    ",", "\"purple\"", ",", "\"purple!50\"", ",", 
                    "\"violet\"", ",", "\"violet!50\"", ",", "\"cyan\"", ",", 
                    "\"cyan!50\"", ",", "\"magenta\"", ",", "\"magenta!50\"", 
                    ",", "\"pink\"", ",", "\"pink!50\"", ",", "\"brown\"", 
                    ",", "\"brown!50\"", ",", "\"black\"", ",", 
                    "\"black!30\"", ",", "\"gray\"", ",", "\"gray!85\"", ",", 
                    "\"grey\"", ",", "\"gray!85\"", ",", "_", ",", 
                    "VilTeX`Private`fillColor"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`positions", "=", 
                    RowBox[{"Switch", "[", 
                    RowBox[{"VilTeX`Private`numSets", ",", "2", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.8`"}], ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.8`", ",", "0"}], "}"}]}], "}"}], ",", "3", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.8`"}], ",", "0.6`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.8`", ",", "0.6`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{"-", "0.8`"}]}], "}"}]}], "}"}], ",", "4", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.8`"}], ",", "0.8`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.8`", ",", "0.8`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.8`"}], ",", 
                    RowBox[{"-", "0.8`"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.8`", ",", 
                    RowBox[{"-", "0.8`"}]}], "}"}]}], "}"}], ",", "5", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1.2`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"1.1`", ",", "0.37`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.68`", ",", 
                    RowBox[{"-", "0.97`"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.68`"}], ",", 
                    RowBox[{"-", "0.97`"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1.1`"}], ",", "0.37`"}], "}"}]}], "}"}], 
                    ",", "_", ",", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"1.2`", " ", 
                    RowBox[{"Cos", "[", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ")"}]}], 
                    "VilTeX`Private`numSets"], "]"}]}], ",", 
                    RowBox[{"1.2`", " ", 
                    RowBox[{"Sin", "[", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ")"}]}], 
                    "VilTeX`Private`numSets"], "]"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numSets"}], "}"}]}], "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`ellipseDefinitions", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"\\\\def\\\\ellipse\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "<>", 
                    "\"{(\"", "<>", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\") ellipse (\"",
                     "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`rx", "]"}], "<>",
                     "\" and \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`ry", "]"}], "<>",
                     "\")}\\n\""}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numSets"}], "}"}]}], "]"}], "]"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`complementCode", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"\"% Dibujar el universo completo sombreado\\n\"",
                     ",", 
                    
                    RowBox[{"\"\\\\fill[\"", "<>", 
                    "VilTeX`Private`processedColor", "<>", "\"] (\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"-", "VilTeX`Private`ux"}], "]"}], "<>", "\",\"", 
                    "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"-", "VilTeX`Private`uy"}], "]"}], "<>", 
                    "\") rectangle (\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`ux", "]"}], "<>",
                     "\",\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`uy", "]"}], "<>",
                     "\");\\n\\n\""}], ",", 
                    "\"% Borrar la uni\[OAcute]n (dibujar elipses en \
blanco)\\n\"", ",", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"\\\\fill[white] \\\\ellipse\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "<>", 
                    "\";\\n\""}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numSets"}], "}"}]}], "]"}], "]"}], ",", 
                    "\"\\n\"", ",", "\"% Dibujar el borde del universo\\n\"", 
                    ",", 
                    RowBox[{"\"\\\\draw[black, thick] (\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"-", "VilTeX`Private`ux"}], "]"}], "<>", "\",\"", 
                    "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"-", "VilTeX`Private`uy"}], "]"}], "<>", 
                    "\") rectangle (\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`ux", "]"}], "<>",
                     "\",\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`uy", "]"}], "<>",
                     "\");\\n\\n\""}]}], "}"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`labelsCode", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"\\\\node at (\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "+", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "<", "0"}], ",", 
                    RowBox[{
                    RowBox[{"-", "VilTeX`Private`rx"}], " ", "0.6`"}], ",", 
                    RowBox[{"VilTeX`Private`rx", " ", "0.6`"}]}], "]"}]}], 
                    "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", 
                    "\") {\\\\Large $\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "<>", 
                    "\"$};\\n\""}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numSets"}], "}"}]}], "]"}], "]"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`complementLabelCode", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`showComplementLabel", ",", 
                    
                    RowBox[{
                    "\"% Etiqueta para el complemento\\n\\\\node at (\"", 
                    "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilTeX`Private`ux", " ", "0.8`"}], "]"}], "<>", 
                    "\",\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilTeX`Private`uy", " ", "0.8`"}], "]"}], "<>", 
                    "\") {\\\\small $(\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{"VilTeX`Private`labels", ",", "\" \\\\cup \""}], 
                    "]"}], "<>", "\")^c$};\\n\\n\""}], ",", "\"\""}], "]"}]}],
                     ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\\\\begin{tikzpicture}[scale=\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`scale", "]"}], 
                    "<>", "\"]\\n\\n\""}], ",", 
                    "\"% Definir las elipses\\n\"", ",", 
                    "VilTeX`Private`ellipseDefinitions", ",", "\"\\n\"", ",", 
                    "VilTeX`Private`complementCode", ",", 
                    "\"% Dibujar los contornos de las elipses\\n\"", ",", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"\\\\draw[black, thick] \\\\ellipse\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "<>", 
                    "\";\\n\""}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numSets"}], "}"}]}], "]"}], "]"}], ",", 
                    "\"\\n\"", ",", "\"% Etiquetas\\n\"", ",", 
                    "VilTeX`Private`labelsCode", ",", "\"\\n\"", ",", 
                    "VilTeX`Private`complementLabelCode", ",", 
                    "\"\\\\end{tikzpicture}\""}], "}"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`fullDocument", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{
                    "\"\\\\documentclass[border=5mm]{standalone}\\n\"", ",", 
                    "\"\\\\usepackage{tikz}\\n\"", ",", 
                    "\"\\\\usepackage{amsmath}\\n\"", ",", 
                    "\"\\\\usetikzlibrary{patterns}\\n\\n\"", ",", 
                    "\"\\\\begin{document}\\n\"", ",", 
                    "VilTeX`Private`tikzCode", ",", 
                    "\"\\n\\\\end{document}\""}], "}"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`folderPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"$HomeDirectory", ",", "\"Downloads\"", ",", 
                    "\"UnionComplement\""}], "}"}], "]"}]}], ";", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"DirectoryQ", "[", "VilTeX`Private`folderPath", 
                    "]"}]}], ",", 
                    
                    RowBox[{"CreateDirectory", "[", 
                    "VilTeX`Private`folderPath", "]"}]}], "]"}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`downloadPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`folderPath", ",", 
                    "VilTeX`Private`filename"}], "}"}], "]"}]}], ";", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"Export", "[", 
                    
                    RowBox[{"VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`fullDocument", ",", "\"Text\""}], "]"}], 
                    "]"}], ";", "VilTeX`Private`downloadPath"}]}], "]"}]}]}, {
                   " "}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilTeX`UnionComplement\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"UnionComplement[filename, labels, fillColor, scale, \
showComplementLabel, ellipseSize, universeSize] crea un diagrama del \
complemento de la uni\[OAcute]n de conjuntos en formato TikZ/LaTeX y lo \
exporta como archivo .tex en la carpeta Downloads/UnionComplement.\\n\\nPAR\
\[CapitalAAcute]METROS:\\n- filename: String que especifica el nombre del \
archivo de salida (debe terminar en \\\".tex\\\")\\n- labels: Lista de \
etiquetas para identificar cada conjunto (m\[IAcute]nimo 2 elementos)\\n- \
fillColor: String que especifica el color de relleno del complemento \
(opcional, por defecto \\\"gray\\\")\\n- scale: Real que define la escala del \
diagrama completo (opcional, por defecto 1.2)\\n- showComplementLabel: \
True/False para mostrar la etiqueta matem\[AAcute]tica del complemento \
(opcional, por defecto False)\\n- ellipseSize: Lista {rx, ry} que define el \
radio horizontal y vertical de las elipses (opcional, por defecto {1.5, 1.8})\
\\n- universeSize: Lista {ux, uy} que define las dimensiones del \
rect\[AAcute]ngulo del universo (opcional, por defecto {4, 3})\\n\\nCOLORES \
PREDEFINIDOS:\\nLos siguientes colores se convierten autom\[AAcute]ticamente \
a tonos TikZ apropiados:\\n- \\\"blue\\\" -> \\\"blue!50\\\"     \[Bullet] \\\
\"red\\\" -> \\\"red!50\\\"       \[Bullet] \\\"green\\\" -> \\\"green!50\\\"\
\\n- \\\"yellow\\\" -> \\\"yellow!60\\\" \[Bullet] \\\"orange\\\" -> \
\\\"orange!50\\\" \[Bullet] \\\"purple\\\" -> \\\"purple!50\\\"\\n- \
\\\"violet\\\" -> \\\"violet!50\\\" \[Bullet] \\\"cyan\\\" -> \\\"cyan!50\\\" \
    \[Bullet] \\\"magenta\\\" -> \\\"magenta!50\\\"\\n- \\\"pink\\\" -> \
\\\"pink!50\\\"     \[Bullet] \\\"brown\\\" -> \\\"brown!50\\\"   \[Bullet] \
\\\"black\\\" -> \\\"black!30\\\"\\n- \\\"gray\\\"/\\\"grey\\\" -> \
\\\"gray!85\\\"\\n- Cualquier otro string se usa directamente como color TikZ\
\\n\\nDISPOSICI\[CapitalOAcute]N AUTOM\[CapitalAAcute]TICA DE CONJUNTOS:\\n- \
2 conjuntos: Disposici\[OAcute]n horizontal\\n- 3 conjuntos: Disposici\
\[OAcute]n triangular\\n- 4 conjuntos: Disposici\[OAcute]n en cuadrado\\n- 5 \
conjuntos: Disposici\[OAcute]n pentagonal\\n- 6+ conjuntos: \
Disposici\[OAcute]n circular autom\[AAcute]tica\\n\\nFUNCIONALIDAD:\\n- \
Genera c\[OAcute]digo TikZ completo con documento LaTeX standalone\\n- Dibuja \
un rect\[AAcute]ngulo (universo) completamente sombreado\\n- \\\"Borra\\\" \
las elipses de los conjuntos (las dibuja en blanco) para mostrar el \
complemento de la uni\[OAcute]n\\n- El resultado visual es el complemento de \
A\:222aB\:222aC\:222a... (la regi\[OAcute]n sombreada es todo lo que NO est\
\[AAcute] en ning\[UAcute]n conjunto)\\n- Posiciona autom\[AAcute]ticamente \
las etiquetas fuera de las elipses\\n- Crea la carpeta \
Downloads/UnionComplement si no existe\\n- Exporta el archivo .tex listo para \
compilar\\n\\nVALIDACIONES:\\n- El filename debe terminar obligatoriamente en \
\\\".tex\\\"\\n- La lista ellipseSize debe contener exactamente 2 \
elementos\\n- La lista universeSize debe contener exactamente 2 elementos\\n- \
La lista labels debe contener al menos 2 elementos\\n- Retorna $Failed si \
alguna validaci\[OAcute]n falla\\n\\nVALOR DE RETORNO:\\nRetorna la ruta \
completa del archivo exportado, o $Failed en caso de \
error.\\n\\nEJEMPLOS:\\n- UnionComplement[\\\"complemento.tex\\\", \
{\\\"A\\\", \\\"B\\\"}]\\n- UnionComplement[\\\"comp_tres.tex\\\", \
{\\\"X\\\", \\\"Y\\\", \\\"Z\\\"}, \\\"blue\\\", 1.5, True]\\n- \
UnionComplement[\\\"ejemplo.tex\\\", {\\\"A\\\", \\\"B\\\", \\\"C\\\"}, \
\\\"red\\\", 1.0, False, {2.0, 2.5}, {5, 4}]\\n\\nNOTA \
MATEM\[CapitalAAcute]TICA:\\nEsta funci\[OAcute]n visualiza (A \:222a B \
\:222a C \:222a ...)^c, es decir, el complemento de la uni\[OAcute]n de todos \
los conjuntos especificados.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}},
            ScrollPosition->{0., 0.}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "UnionComplement[filename, labels, fillColor, scale, showComplementLabel, \
ellipseSize, universeSize] crea un diagrama del complemento de la \
uni\[OAcute]n de conjuntos en formato TikZ/LaTeX y lo exporta como archivo \
.tex en la carpeta Downloads/UnionComplement.\n\nPAR\[CapitalAAcute]METROS:\n\
- filename: String que especifica el nombre del archivo de salida (debe \
terminar en \".tex\")\n- labels: Lista de etiquetas para identificar cada \
conjunto (m\[IAcute]nimo 2 elementos)\n- fillColor: String que especifica el \
color de relleno del complemento (opcional, por defecto \"gray\")\n- scale: \
Real que define la escala del diagrama completo (opcional, por defecto 1.2)\n\
- showComplementLabel: True/False para mostrar la etiqueta matem\[AAcute]tica \
del complemento (opcional, por defecto False)\n- ellipseSize: Lista {rx, ry} \
que define el radio horizontal y vertical de las elipses (opcional, por \
defecto {1.5, 1.8})\n- universeSize: Lista {ux, uy} que define las \
dimensiones del rect\[AAcute]ngulo del universo (opcional, por defecto {4, \
3})\n\nCOLORES PREDEFINIDOS:\nLos siguientes colores se convierten autom\
\[AAcute]ticamente a tonos TikZ apropiados:\n- \"blue\" -> \"blue!50\"     \
\[Bullet] \"red\" -> \"red!50\"       \[Bullet] \"green\" -> \"green!50\"\n- \
\"yellow\" -> \"yellow!60\" \[Bullet] \"orange\" -> \"orange!50\" \[Bullet] \
\"purple\" -> \"purple!50\"\n- \"violet\" -> \"violet!50\" \[Bullet] \"cyan\" \
-> \"cyan!50\"     \[Bullet] \"magenta\" -> \"magenta!50\"\n- \"pink\" -> \
\"pink!50\"     \[Bullet] \"brown\" -> \"brown!50\"   \[Bullet] \"black\" -> \
\"black!30\"\n- \"gray\"/\"grey\" -> \"gray!85\"\n- Cualquier otro string se \
usa directamente como color TikZ\n\nDISPOSICI\[CapitalOAcute]N AUTOM\
\[CapitalAAcute]TICA DE CONJUNTOS:\n- 2 conjuntos: Disposici\[OAcute]n \
horizontal\n- 3 conjuntos: Disposici\[OAcute]n triangular\n- 4 conjuntos: \
Disposici\[OAcute]n en cuadrado\n- 5 conjuntos: Disposici\[OAcute]n \
pentagonal\n- 6+ conjuntos: Disposici\[OAcute]n circular autom\[AAcute]tica\n\
\nFUNCIONALIDAD:\n- Genera c\[OAcute]digo TikZ completo con documento LaTeX \
standalone\n- Dibuja un rect\[AAcute]ngulo (universo) completamente sombreado\
\n- \"Borra\" las elipses de los conjuntos (las dibuja en blanco) para \
mostrar el complemento de la uni\[OAcute]n\n- El resultado visual es el \
complemento de A\:222aB\:222aC\:222a... (la regi\[OAcute]n sombreada es todo \
lo que NO est\[AAcute] en ning\[UAcute]n conjunto)\n- Posiciona \
autom\[AAcute]ticamente las etiquetas fuera de las elipses\n- Crea la carpeta \
Downloads/UnionComplement si no existe\n- Exporta el archivo .tex listo para \
compilar\n\nVALIDACIONES:\n- El filename debe terminar obligatoriamente en \
\".tex\"\n- La lista ellipseSize debe contener exactamente 2 elementos\n- La \
lista universeSize debe contener exactamente 2 elementos\n- La lista labels \
debe contener al menos 2 elementos\n- Retorna $Failed si alguna validaci\
\[OAcute]n falla\n\nVALOR DE RETORNO:\nRetorna la ruta completa del archivo \
exportado, o $Failed en caso de error.\n\nEJEMPLOS:\n- \
UnionComplement[\"complemento.tex\", {\"A\", \"B\"}]\n- \
UnionComplement[\"comp_tres.tex\", {\"X\", \"Y\", \"Z\"}, \"blue\", 1.5, \
True]\n- UnionComplement[\"ejemplo.tex\", {\"A\", \"B\", \"C\"}, \"red\", \
1.0, False, {2.0, 2.5}, {5, 4}]\n\nNOTA MATEM\[CapitalAAcute]TICA:\nEsta \
funci\[OAcute]n visualiza (A \:222a B \:222a C \:222a ...)^c, es decir, el \
complemento de la uni\[OAcute]n de todos los conjuntos especificados.", 
    "Documentation" -> None, "OwnValues" -> None, "UpValues" -> None, 
    "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilTeX`UnionComplement, {VilTeX`UnionComplement[
         Pattern[VilTeX`Private`filename, 
          Blank[String]], 
         Pattern[VilTeX`Private`labels, 
          Blank[List]], 
         Optional[
          Pattern[VilTeX`Private`fillColor, 
           Blank[String]], "gray"], 
         Optional[
          Pattern[VilTeX`Private`scale, 
           Blank[Real]], 1.2], 
         Optional[
          Pattern[VilTeX`Private`showComplementLabel, 
           Blank[]], False], 
         Optional[
          Pattern[VilTeX`Private`ellipseSize, 
           Blank[List]], {1.5, 1.8}], 
         Optional[
          Pattern[VilTeX`Private`universeSize, 
           Blank[List]], {4, 3}]] :> 
       Module[{VilTeX`Private`tikzCode, VilTeX`Private`fullDocument, 
          VilTeX`Private`downloadPath, VilTeX`Private`folderPath, 
          VilTeX`Private`rx, VilTeX`Private`ry, VilTeX`Private`processedColor,
           VilTeX`Private`numSets, VilTeX`Private`positions, 
          VilTeX`Private`ellipseDefinitions, VilTeX`Private`complementCode, 
          VilTeX`Private`labelsCode, VilTeX`Private`complementLabelCode, 
          VilTeX`Private`ux, VilTeX`Private`uy}, If[
           Not[
            StringEndsQ[VilTeX`Private`filename, ".tex"]], 
           Return[$Failed]]; If[Length[VilTeX`Private`ellipseSize] != 2, 
           Return[$Failed]]; If[Length[VilTeX`Private`universeSize] != 2, 
           Return[$Failed]]; If[Length[VilTeX`Private`labels] < 2, 
           Return[$Failed]]; {VilTeX`Private`rx, VilTeX`Private`ry} = 
          VilTeX`Private`ellipseSize; {VilTeX`Private`ux, VilTeX`Private`uy} = 
          VilTeX`Private`universeSize; 
         VilTeX`Private`numSets = Length[VilTeX`Private`labels]; 
         VilTeX`Private`processedColor = 
          Switch[VilTeX`Private`fillColor, "blue", "blue!50", "red", "red!50",
             "green", "green!50", "yellow", "yellow!60", "orange", 
            "orange!50", "purple", "purple!50", "violet", "violet!50", "cyan",
             "cyan!50", "magenta", "magenta!50", "pink", "pink!50", "brown", 
            "brown!50", "black", "black!30", "gray", "gray!85", "grey", 
            "gray!85", 
            Blank[], VilTeX`Private`fillColor]; 
         VilTeX`Private`positions = 
          Switch[VilTeX`Private`numSets, 2, {{-0.8, 0}, {0.8, 0}}, 
            3, {{-0.8, 0.6}, {0.8, 0.6}, {0, -0.8}}, 4, {{-0.8, 0.8}, {0.8, 
            0.8}, {-0.8, -0.8}, {0.8, -0.8}}, 
            5, {{0, 1.2}, {1.1, 0.37}, {0.68, -0.97}, {-0.68, -0.97}, {-1.1, 
             0.37}}, 
            Blank[], 
            
            Table[{1.2 
              Cos[2 Pi ((VilTeX`Private`i - 1)/VilTeX`Private`numSets)], 1.2 
              Sin[2 Pi ((VilTeX`Private`i - 1)/VilTeX`Private`numSets)]}, {
             VilTeX`Private`i, VilTeX`Private`numSets}]]; 
         VilTeX`Private`ellipseDefinitions = StringJoin[
            Table[
            "\\def\\ellipse" <> Part[VilTeX`Private`labels, VilTeX`Private`i] <> 
             "{(" <> ToString[
               Part[VilTeX`Private`positions, VilTeX`Private`i, 1]] <> "," <> 
             ToString[
               Part[VilTeX`Private`positions, VilTeX`Private`i, 2]] <> 
             ") ellipse (" <> ToString[VilTeX`Private`rx] <> " and " <> 
             ToString[VilTeX`Private`ry] <> ")}\n", {
             VilTeX`Private`i, VilTeX`Private`numSets}]]; 
         VilTeX`Private`complementCode = 
          StringJoin[{
            "% Dibujar el universo completo sombreado\n", "\\fill[" <> 
             VilTeX`Private`processedColor <> "] (" <> 
             ToString[-VilTeX`Private`ux] <> "," <> 
             ToString[-VilTeX`Private`uy] <> ") rectangle (" <> 
             ToString[VilTeX`Private`ux] <> "," <> 
             ToString[VilTeX`Private`uy] <> ");\n\n", 
             "% Borrar la uni\[OAcute]n (dibujar elipses en blanco)\n", 
             StringJoin[
              Table[
              "\\fill[white] \\ellipse" <> 
               Part[VilTeX`Private`labels, VilTeX`Private`i] <> ";\n", {
               VilTeX`Private`i, VilTeX`Private`numSets}]], "\n", 
             "% Dibujar el borde del universo\n", "\\draw[black, thick] (" <> 
             ToString[-VilTeX`Private`ux] <> "," <> 
             ToString[-VilTeX`Private`uy] <> ") rectangle (" <> 
             ToString[VilTeX`Private`ux] <> "," <> 
             ToString[VilTeX`Private`uy] <> ");\n\n"}]; 
         VilTeX`Private`labelsCode = StringJoin[
            Table[
            "\\node at (" <> 
             ToString[
              Part[VilTeX`Private`positions, VilTeX`Private`i, 1] + 
               If[Part[VilTeX`Private`positions, VilTeX`Private`i, 1] < 
                 0, (-VilTeX`Private`rx) 0.6, VilTeX`Private`rx 0.6]] <> "," <> 
             ToString[
               Part[VilTeX`Private`positions, VilTeX`Private`i, 2]] <> 
             ") {\\Large $" <> Part[VilTeX`Private`labels, VilTeX`Private`i] <> 
             "$};\n", {VilTeX`Private`i, VilTeX`Private`numSets}]]; 
         VilTeX`Private`complementLabelCode = 
          If[VilTeX`Private`showComplementLabel, 
            "% Etiqueta para el complemento\n\\node at (" <> 
            ToString[VilTeX`Private`ux 0.8] <> "," <> 
            ToString[VilTeX`Private`uy 0.8] <> ") {\\small $(" <> 
            StringRiffle[VilTeX`Private`labels, " \\cup "] <> ")^c$};\n\n", 
            ""]; VilTeX`Private`tikzCode = 
          StringJoin[{
            "\\begin{tikzpicture}[scale=" <> ToString[VilTeX`Private`scale] <> 
             "]\n\n", "% Definir las elipses\n", 
             VilTeX`Private`ellipseDefinitions, "\n", 
             VilTeX`Private`complementCode, 
             "% Dibujar los contornos de las elipses\n", 
             StringJoin[
              Table[
              "\\draw[black, thick] \\ellipse" <> 
               Part[VilTeX`Private`labels, VilTeX`Private`i] <> ";\n", {
               VilTeX`Private`i, VilTeX`Private`numSets}]], "\n", 
             "% Etiquetas\n", VilTeX`Private`labelsCode, "\n", 
             VilTeX`Private`complementLabelCode, "\\end{tikzpicture}"}]; 
         VilTeX`Private`fullDocument = 
          StringJoin[{
            "\\documentclass[border=5mm]{standalone}\n", 
             "\\usepackage{tikz}\n", "\\usepackage{amsmath}\n", 
             "\\usetikzlibrary{patterns}\n\n", "\\begin{document}\n", 
             VilTeX`Private`tikzCode, "\n\\end{document}"}]; 
         VilTeX`Private`folderPath = 
          FileNameJoin[{$HomeDirectory, "Downloads", "UnionComplement"}]; 
         Quiet[
           If[
            Not[
             DirectoryQ[VilTeX`Private`folderPath]], 
            CreateDirectory[VilTeX`Private`folderPath]]]; 
         VilTeX`Private`downloadPath = 
          FileNameJoin[{VilTeX`Private`folderPath, VilTeX`Private`filename}]; 
         Quiet[
           Export[
           VilTeX`Private`downloadPath, VilTeX`Private`fullDocument, "Text"]]; 
         VilTeX`Private`downloadPath]}], "SubValues" -> None, "DefaultValues" -> 
    None, "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {Protected}, "FullName" -> "VilTeX`UnionComplement"|>, 
   False]]], "Output",
 CellChangeTimes->{3.9669731050080357`*^9},
 CellLabel->
  "Out[302]=",ExpressionUUID->"3e90bd91-5cbd-4603-9981-47cbb510e7de"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 1: dos conjuntos", "Subsection",
 CellChangeTimes->{{3.9669722155811577`*^9, 3.966972227370956*^9}, {
  3.96697269501637*^9, 
  3.966972698074332*^9}},ExpressionUUID->"387e4bd4-4590-4985-88fa-\
4fd86d6a4c62"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"UnionComplement", "[", 
   RowBox[{"\"\<unioncomsets1.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}], ",", "\"\<blue\>\""}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967021500218103*^9, 3.967021539009901*^9}, 
   3.967021672805071*^9, 
   3.967022628154372*^9},ExpressionUUID->"07de0cc4-28e9-4d99-9bbe-\
8640a73b1ca1"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967021547344459*^9, 3.967021673547818*^9, 
  3.967022262668971*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[45]:=",ExpressionUUID->"39af42cf-aa97-4c05-ba93-95b3956f7232"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.967021547344459*^9, 3.967021673547818*^9, 
  3.967022262669751*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[45]:=",ExpressionUUID->"5e57ccd1-e66b-4fb3-ae61-59f8d223a94c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967021547344459*^9, 3.967021673547818*^9, 
  3.967022262670535*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[45]:=",ExpressionUUID->"33652413-4508-49c0-9c18-7c5d46b397fc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967021547344459*^9, 3.967021673547818*^9, 
  3.967022262671011*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[45]:=",ExpressionUUID->"286b3646-fe29-4024-869f-d6d6d717ae27"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.967021547344459*^9, 3.967021673547818*^9, 
  3.967022262671466*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[45]:=",ExpressionUUID->"0932291d-70ee-42df-a9db-6f7d8f1c249e"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967021547344459*^9, 3.967021673547818*^9, 
  3.967022262736577*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[45]:=",ExpressionUUID->"a20fd338-c760-46bf-af29-7fddedad39f9"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.967021547344459*^9, 3.967021673547818*^9, 
  3.967022263743573*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[45]:=",ExpressionUUID->"c271c0bb-a58e-4b88-a126-aa21dd50ba9f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/UnionComplement/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/UnionComplement/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967021547344459*^9, 3.967021673547818*^9, 
  3.96702226374856*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[45]:=",ExpressionUUID->"eba16fa8-89f0-4727-aaa7-bc4f68e4266d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"unionsets1\"\>"}],
  SequenceForm["Archivo: ", "unionsets1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967021547344459*^9, 3.967021673547818*^9, 
  3.9670222637510366`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[45]:=",ExpressionUUID->"350465ee-3a13-4508-a1df-d6ddfa41f3e6"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.967021547344459*^9, 3.967021673547818*^9, 
  3.9670222642256527`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[45]:=",ExpressionUUID->"1f0bece0-6f60-4bf0-925d-086b88e31521"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/UnionComplement/unionsets1.pdf\"\>\
"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/UnionComplement/unionsets1.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967021547344459*^9, 3.967021673547818*^9, 
  3.967022264226276*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[45]:=",ExpressionUUID->"b7ca88ba-11b3-4acd-944d-66f761fea980"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/UnionComplement/\
unionsets1.pdf\"\>"], "Output",
 CellChangeTimes->{3.967021547343791*^9, 3.9670216751020308`*^9, 
  3.967022264239236*^9},
 CellLabel->"Out[46]=",ExpressionUUID->"f7b6364d-8d8d-41e5-9d64-ba05872ccebf"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 2: tres conjuntos", "Subsection",
 CellChangeTimes->{{3.9669722155811577`*^9, 3.966972227370956*^9}, {
  3.96697269501637*^9, 3.966972698074332*^9}, {3.967021692623477*^9, 
  3.967021693203027*^9}, {3.967021739781867*^9, 
  3.967021740308218*^9}},ExpressionUUID->"3dfaca2f-d54b-4cf5-adfa-\
2e6220093b5d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"UnionComplement", "[", 
   RowBox[{"\"\<unioncomsets2.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\"", ",", "\"\<C\>\""}], "}"}], 
    ",", "\"\<red\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967021500218103*^9, 3.967021539009901*^9}, 
   3.967021672805071*^9, {3.967021723404994*^9, 3.9670217365279837`*^9}, 
   3.9670226239255533`*^9},ExpressionUUID->"0cb82a32-daad-4bec-9057-\
fd42b7255303"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967021911367667*^9, 3.967022275367241*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"ae98ce22-08d2-4960-8493-6df98e2c6935"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.967021911367667*^9, 3.9670222753680563`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"4e43aadc-e44b-4562-9400-09bb58fbafa4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967021911367667*^9, 3.967022275369006*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"c94a1cd1-c333-4ccf-bc74-ac1bb0d9e1c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967021911367667*^9, 3.967022275369522*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"1ea4c0ad-f82a-4a57-9dac-99f58b415c00"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.967021911367667*^9, 3.967022275370023*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"ba25cea9-291b-4566-8650-7b449c3061d9"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967021911367667*^9, 3.9670222754343367`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"c7a9ccb1-6de5-493b-aaaf-c316a107fb4c"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.967021911367667*^9, 3.967022276441045*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"1232a62c-e76d-4a97-933e-e93adb645f2b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/UnionComplement/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/UnionComplement/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967021911367667*^9, 3.9670222764443502`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"7e4f98b2-5210-45d8-a868-41f65d59f1d7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"unionsets2\"\>"}],
  SequenceForm["Archivo: ", "unionsets2"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967021911367667*^9, 3.967022276446414*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"60bb8b45-a654-4698-bd29-b8f6142d890e"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.967021911367667*^9, 3.967022276894837*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"3202df4b-aeda-4660-a048-0d508e8428ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/UnionComplement/unionsets2.pdf\"\>\
"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/UnionComplement/unionsets2.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967021911367667*^9, 3.967022276895507*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"0dccf9b1-8ed6-4fc2-a04e-7617bef0e9bb"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/UnionComplement/\
unionsets2.pdf\"\>"], "Output",
 CellChangeTimes->{3.967021912932475*^9, 3.9670222769087477`*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"fa1e2d61-0159-466a-ab5f-15627f4bae59"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 3: cuatro conjuntos", "Subsection",
 CellChangeTimes->{{3.9669722155811577`*^9, 3.966972227370956*^9}, {
  3.96697269501637*^9, 3.966972698074332*^9}, {3.967021692623477*^9, 
  3.967021693203027*^9}, {3.967021739781867*^9, 3.967021740308218*^9}, {
  3.9670220235241613`*^9, 
  3.967022026511013*^9}},ExpressionUUID->"cbe86854-59e1-4301-bbf0-\
8a2184eaa46f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"UnionComplement", "[", 
   RowBox[{"\"\<unioncomsets3.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\"", ",", "\"\<C\>\"", 
      ",", "\"\<D\>\""}], "}"}], ",", "\"\<orange\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967021500218103*^9, 3.967021539009901*^9}, 
   3.967021672805071*^9, {3.967021723404994*^9, 3.9670217365279837`*^9}, 
   3.967022030968194*^9, {3.967022064956696*^9, 3.967022065287479*^9}, {
   3.9670222461414547`*^9, 3.967022249781415*^9}, {3.967022290032826*^9, 
   3.967022291774508*^9}, 
   3.967022619169518*^9},ExpressionUUID->"8ea71e06-2ead-4091-9886-\
2a466aaa3d95"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022293378134*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"a03836b6-a168-40a4-8a39-1ffe792de7e9"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.967022293379469*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"23e1026f-fe0a-43f4-ac6e-afd873ba33ff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022293380394*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"030b9a0f-2128-4530-b76a-1412231b29c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022293380897*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"3134a530-f58e-49fc-9b9f-c603a3c186c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022293381366*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"7e610862-9cde-49e2-a89c-3cca61c98d7c"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967022293464427*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"9bb54fa8-2958-4966-ba3d-123b6e08115a"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.967022294470744*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"75869614-cd8b-4cf5-9ade-d2976b8ea25e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/UnionComplement/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/UnionComplement/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022294474099*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"88d2423a-0444-4def-8c04-eb780f26438c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"unionsets3\"\>"}],
  SequenceForm["Archivo: ", "unionsets3"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022294476387*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"3d3f2a56-66b1-4dd6-a519-412a284c4f59"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.967022294928318*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"c94fe75d-da66-4a81-85d5-fce072677439"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/UnionComplement/unionsets3.pdf\"\>\
"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/UnionComplement/unionsets3.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670222949288263`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"22c92d24-a312-4d98-ab81-d7d4ec117ba0"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/UnionComplement/\
unionsets3.pdf\"\>"], "Output",
 CellChangeTimes->{3.967022294942165*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"9086f567-84ca-4a50-84e3-9be11b5ef3ae"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 4: con etiqueta de complemento", "Subsection",
 CellChangeTimes->{{3.9669722155811577`*^9, 3.966972227370956*^9}, {
   3.96697269501637*^9, 3.966972698074332*^9}, {3.967021692623477*^9, 
   3.967021693203027*^9}, {3.967021739781867*^9, 3.967021754858276*^9}, {
   3.967021813019991*^9, 3.967021818163364*^9}, 3.967022105184704*^9, 
   3.967022214304068*^9},ExpressionUUID->"5ac4bcb4-9d00-467d-9de8-\
4ef98ad130ab"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"UnionComplement", "[", 
   RowBox[{"\"\<unioncomsets4.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<X\>\"", ",", "\"\<Y\>\""}], "}"}], ",", "\"\<green\>\"", ",",
     "1.3", ",", "True"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967021500218103*^9, 3.967021539009901*^9}, 
   3.967021672805071*^9, {3.967021723404994*^9, 3.9670217365279837`*^9}, {
   3.967021772154702*^9, 3.9670217724637127`*^9}, {3.967021824945944*^9, 
   3.9670218349035807`*^9}, {3.967021871834454*^9, 3.967021905603507*^9}, 
   3.9670222209400387`*^9, 
   3.967022614728163*^9},ExpressionUUID->"260cdff0-feb9-4a07-a947-\
6abaa6c38141"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022320586019*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[51]:=",ExpressionUUID->"4c314af7-aeb8-4e31-b7c7-fac0713fef03"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.967022320587193*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[51]:=",ExpressionUUID->"3e166578-52ae-4d01-af65-f1d32022d370"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670223205883102`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[51]:=",ExpressionUUID->"0ce6b2e5-8051-4737-a132-ff0f6d6737fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670223205888987`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[51]:=",ExpressionUUID->"e01baf12-cf68-4c84-b917-c1f8713e9785"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022320589472*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[51]:=",ExpressionUUID->"e7d7fc88-0867-4dae-b14b-cd2d6e127c6f"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967022320659924*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[51]:=",ExpressionUUID->"7474528f-7254-42b8-b6cd-0e9d7e72904f"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.9670223216656837`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[51]:=",ExpressionUUID->"5b6048eb-0131-463f-a89b-de5a39e1c661"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/UnionComplement/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/UnionComplement/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022321669145*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[51]:=",ExpressionUUID->"24044ed8-378b-4090-83f6-032b0ce42a87"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"unionsets4\"\>"}],
  SequenceForm["Archivo: ", "unionsets4"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670223216717777`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[51]:=",ExpressionUUID->"d3ae227c-d01c-4497-afa1-eb56d265da3d"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.9670223221184483`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[51]:=",ExpressionUUID->"2b8d388e-4fc0-4c4b-b15b-67a4cff66a4f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/UnionComplement/unionsets4.pdf\"\>\
"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/UnionComplement/unionsets4.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022322119145*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[51]:=",ExpressionUUID->"ccca79b7-c6f1-4ea7-acb8-598ced2fe5d5"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/UnionComplement/\
unionsets4.pdf\"\>"], "Output",
 CellChangeTimes->{3.967022322131588*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"e4c3e8ac-5944-4388-a8a5-6bfdd0258ed4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 5: universo m\[AAcute]s grande", "Subsection",
 CellChangeTimes->{{3.9669722155811577`*^9, 3.966972227370956*^9}, {
   3.96697269501637*^9, 3.966972698074332*^9}, {3.967021692623477*^9, 
   3.967021693203027*^9}, {3.967021739781867*^9, 3.967021754858276*^9}, {
   3.967021813019991*^9, 3.967021818163364*^9}, {3.96702196939318*^9, 
   3.96702197150316*^9}, 3.967022108517112*^9, 
   3.9670221980273943`*^9},ExpressionUUID->"70ada017-e8ad-49ba-bf99-\
cc4dc9bfd8ab"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"UnionComplement", "[", 
   RowBox[{"\"\<unioncomsets5.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<P\>\"", ",", "\"\<Q\>\"", ",", "\"\<R\>\""}], "}"}], 
    ",", "\"\<cyan\>\"", ",", "1.5", ",", "True", ",", 
    RowBox[{"{", 
     RowBox[{"1.5", ",", "1.8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "4"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967021500218103*^9, 3.967021539009901*^9}, 
   3.967021672805071*^9, {3.967021723404994*^9, 3.9670217365279837`*^9}, {
   3.967021772154702*^9, 3.9670217724637127`*^9}, {3.967021824945944*^9, 
   3.9670218349035807`*^9}, {3.967021871834454*^9, 3.967021905603507*^9}, {
   3.967022045350721*^9, 3.967022045686844*^9}, {3.967022158668399*^9, 
   3.967022209067857*^9}, 3.9670223300486383`*^9, {3.967022604749751*^9, 
   3.9670226051239443`*^9}},ExpressionUUID->"4f25737d-3209-43a6-b239-\
4ef9081d06ad"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967021926225597*^9, 3.967022336376895*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[53]:=",ExpressionUUID->"1e830e6e-ed48-4ec0-a75a-26211c4c510d"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.967021926225597*^9, 3.967022336377762*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[53]:=",ExpressionUUID->"f8627e92-13a6-48bf-9b4c-7b8ab9d1d057"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967021926225597*^9, 3.9670223363786087`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[53]:=",ExpressionUUID->"1a29bf9b-c3ea-490d-b5db-8267ba08d496"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967021926225597*^9, 3.967022336379128*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[53]:=",ExpressionUUID->"68366a2c-7b70-4221-b73c-3c9d6c743f15"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.967021926225597*^9, 3.967022336379623*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[53]:=",ExpressionUUID->"65df46ba-9895-46d1-9896-5717229f7dc6"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967021926225597*^9, 3.967022336431665*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[53]:=",ExpressionUUID->"8d86d7de-c6f4-4757-8ca0-3d195ecb6067"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.967021926225597*^9, 3.967022337438223*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[53]:=",ExpressionUUID->"dcece3fe-effb-48c1-9aa7-5de4896118f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/UnionComplement/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/UnionComplement/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967021926225597*^9, 3.967022337441483*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[53]:=",ExpressionUUID->"b620116a-e9db-4ad8-b97f-01b086814955"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"unionsets5\"\>"}],
  SequenceForm["Archivo: ", "unionsets5"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967021926225597*^9, 3.9670223374437428`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[53]:=",ExpressionUUID->"d9a169f3-2268-4a81-9bf7-e2c972da453b"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.967021926225597*^9, 3.967022337894188*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[53]:=",ExpressionUUID->"6e22fed3-b6d3-4c42-bdc3-7eb0724b6035"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/UnionComplement/unionsets5.pdf\"\>\
"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/UnionComplement/unionsets5.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967021926225597*^9, 3.967022337894979*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[53]:=",ExpressionUUID->"1f857dde-d9db-4209-9605-795f4ea789af"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/UnionComplement/\
unionsets5.pdf\"\>"], "Output",
 CellChangeTimes->{3.967021893001811*^9, 3.967021927809107*^9, 
  3.967022337908025*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"3231050e-de8b-4951-84ff-65bd8e010d3f"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["UnionSets", "Section",
 CellChangeTimes->{
  3.967022362615698*^9},ExpressionUUID->"5e7abf01-d96a-4759-a294-\
1255a83b34d7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "UnionSets"}]], "Input",
 CellChangeTimes->{{3.967022365377117*^9, 3.967022366145885*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"65dfb182-3b1a-42a7-bde0-c09765c6c5ff"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"UnionSets[filename, labels, fillColor, scale, \
showUnionLabel, ellipseSize] crea un diagrama de la uni\[OAcute]n de \
conjuntos en formato TikZ/LaTeX y lo exporta como archivo .tex en la carpeta \
Downloads/UnionSets.\\n\\nPAR\[CapitalAAcute]METROS:\\n- filename: String que \
especifica el nombre del archivo de salida (debe terminar en \
\\\".tex\\\")\\n- labels: Lista de etiquetas para identificar cada conjunto \
(m\[IAcute]nimo 2 elementos)\\n- fillColor: String que especifica el color de \
relleno de la uni\[OAcute]n (opcional, por defecto \\\"gray\\\")\\n- scale: \
Real que define la escala del diagrama completo (opcional, por defecto \
1.2)\\n- showUnionLabel: True/False para mostrar la etiqueta \
matem\[AAcute]tica de la uni\[OAcute]n (opcional, por defecto False)\\n- \
ellipseSize: Lista {rx, ry} que define el radio horizontal y vertical de las \
elipses (opcional, por defecto {1.5, 1.8})\\n\\nCOLORES PREDEFINIDOS:\\nLos \
siguientes colores se convierten autom\[AAcute]ticamente a tonos TikZ \
apropiados:\\n- \\\"blue\\\" -> \\\"blue!50\\\"     \[Bullet] \\\"red\\\" -> \
\\\"red!50\\\"       \[Bullet] \\\"green\\\" -> \\\"green!50\\\"\\n- \
\\\"yellow\\\" -> \\\"yellow!60\\\" \[Bullet] \\\"orange\\\" -> \\\"orange!50\
\\\" \[Bullet] \\\"purple\\\" -> \\\"purple!50\\\"\\n- \\\"violet\\\" -> \
\\\"violet!50\\\" \[Bullet] \\\"cyan\\\" -> \\\"cyan!50\\\"     \[Bullet] \
\\\"magenta\\\" -> \\\"magenta!50\\\"\\n- \\\"pink\\\" -> \\\"pink!50\\\"     \
\[Bullet] \\\"brown\\\" -> \\\"brown!50\\\"   \[Bullet] \\\"black\\\" -> \
\\\"black!30\\\"\\n- \\\"gray\\\"/\\\"grey\\\" -> \\\"gray!85\\\"\\n- \
Cualquier otro string se usa directamente como color TikZ\\n\\nDISPOSICI\
\[CapitalOAcute]N AUTOM\[CapitalAAcute]TICA DE CONJUNTOS:\\n- 2 conjuntos: \
Disposici\[OAcute]n horizontal\\n- 3 conjuntos: Disposici\[OAcute]n \
triangular\\n- 4 conjuntos: Disposici\[OAcute]n en cuadrado\\n- 5 conjuntos: \
Disposici\[OAcute]n pentagonal\\n- 6+ conjuntos: Disposici\[OAcute]n circular \
autom\[AAcute]tica\\n\\nFUNCIONALIDAD:\\n- Genera c\[OAcute]digo TikZ \
completo con documento LaTeX standalone\\n- Sombreia completamente TODAS las \
elipses de los conjuntos especificados\\n- El resultado visual es la uni\
\[OAcute]n A\:222aB\:222aC\:222a... (toda la regi\[OAcute]n cubierta por al \
menos un conjunto)\\n- Dibuja los contornos de todas las elipses con l\
\[IAcute]neas negras gruesas\\n- Posiciona autom\[AAcute]ticamente las \
etiquetas fuera de las elipses\\n- La etiqueta de uni\[OAcute]n (si est\
\[AAcute] habilitada) se coloca en la parte superior del diagrama\\n- Crea la \
carpeta Downloads/UnionSets si no existe\\n- Exporta el archivo .tex listo \
para compilar\\n\\nVALIDACIONES:\\n- El filename debe terminar \
obligatoriamente en \\\".tex\\\"\\n- La lista ellipseSize debe contener \
exactamente 2 elementos\\n- La lista labels debe contener al menos 2 \
elementos\\n- Retorna $Failed si alguna validaci\[OAcute]n falla\\n\\nVALOR \
DE RETORNO:\\nRetorna la ruta completa del archivo exportado, o $Failed en \
caso de error.\\n\\nEJEMPLOS:\\n- UnionSets[\\\"union.tex\\\", {\\\"A\\\", \\\
\"B\\\"}]\\n- UnionSets[\\\"union_tres.tex\\\", {\\\"X\\\", \\\"Y\\\", \
\\\"Z\\\"}, \\\"blue\\\", 1.5, True]\\n- UnionSets[\\\"ejemplo.tex\\\", \
{\\\"A\\\", \\\"B\\\", \\\"C\\\", \\\"D\\\"}, \\\"red\\\", 1.0, False, {2.0, \
2.5}]\\n\\nNOTA MATEM\[CapitalAAcute]TICA:\\nEsta funci\[OAcute]n visualiza A \
\:222a B \:222a C \:222a ..., es decir, la uni\[OAcute]n de todos los \
conjuntos especificados. Toda la regi\[OAcute]n sombreada representa \
elementos que pertenecen a al menos uno de los conjuntos.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"UnionSets", "[", 
                    
                    RowBox[{
                    "VilTeX`Private`filename_String", ",", 
                    "VilTeX`Private`labels_List", ",", 
                    
                    RowBox[{
                    "VilTeX`Private`fillColor_String", ":", "\"gray\""}], ",", 
                    RowBox[{"VilTeX`Private`scale_Real", ":", "1.2`"}], ",", 
                    RowBox[{"VilTeX`Private`showUnionLabel_", ":", "False"}], 
                    ",", 
                    RowBox[{"VilTeX`Private`ellipseSize_List", ":", 
                    RowBox[{"{", 
                    RowBox[{"1.5`", ",", "1.8`"}], "}"}]}]}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", ",", 
                    "VilTeX`Private`fullDocument", ",", 
                    "VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`folderPath", ",", "VilTeX`Private`rx", 
                    ",", "VilTeX`Private`ry", ",", 
                    "VilTeX`Private`processedColor", ",", 
                    "VilTeX`Private`numSets", ",", "VilTeX`Private`positions",
                     ",", "VilTeX`Private`ellipseDefinitions", ",", 
                    "VilTeX`Private`unionCode", ",", 
                    "VilTeX`Private`labelsCode", ",", 
                    "VilTeX`Private`unionLabelCode"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringEndsQ", "[", 
                    RowBox[{"VilTeX`Private`filename", ",", "\".tex\""}], 
                    "]"}]}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`ellipseSize", 
                    "]"}], "\[NotEqual]", "2"}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`labels", "]"}], 
                    "<", "2"}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`rx", ",", "VilTeX`Private`ry"}], 
                    "}"}], "=", "VilTeX`Private`ellipseSize"}], ";", 
                    RowBox[{"VilTeX`Private`numSets", "=", 
                    RowBox[{"Length", "[", "VilTeX`Private`labels", "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`processedColor", "=", 
                    RowBox[{"Switch", "[", 
                    
                    RowBox[{"VilTeX`Private`fillColor", ",", "\"blue\"", ",", 
                    "\"blue!50\"", ",", "\"red\"", ",", "\"red!50\"", ",", 
                    "\"green\"", ",", "\"green!50\"", ",", "\"yellow\"", ",", 
                    "\"yellow!60\"", ",", "\"orange\"", ",", "\"orange!50\"", 
                    ",", "\"purple\"", ",", "\"purple!50\"", ",", 
                    "\"violet\"", ",", "\"violet!50\"", ",", "\"cyan\"", ",", 
                    "\"cyan!50\"", ",", "\"magenta\"", ",", "\"magenta!50\"", 
                    ",", "\"pink\"", ",", "\"pink!50\"", ",", "\"brown\"", 
                    ",", "\"brown!50\"", ",", "\"black\"", ",", 
                    "\"black!30\"", ",", "\"gray\"", ",", "\"gray!85\"", ",", 
                    "\"grey\"", ",", "\"gray!85\"", ",", "_", ",", 
                    "VilTeX`Private`fillColor"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`positions", "=", 
                    RowBox[{"Switch", "[", 
                    RowBox[{"VilTeX`Private`numSets", ",", "2", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.8`"}], ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.8`", ",", "0"}], "}"}]}], "}"}], ",", "3", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.8`"}], ",", "0.6`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.8`", ",", "0.6`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{"-", "0.8`"}]}], "}"}]}], "}"}], ",", "4", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.8`"}], ",", "0.8`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.8`", ",", "0.8`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.8`"}], ",", 
                    RowBox[{"-", "0.8`"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.8`", ",", 
                    RowBox[{"-", "0.8`"}]}], "}"}]}], "}"}], ",", "5", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1.2`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"1.1`", ",", "0.37`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.68`", ",", 
                    RowBox[{"-", "0.97`"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.68`"}], ",", 
                    RowBox[{"-", "0.97`"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1.1`"}], ",", "0.37`"}], "}"}]}], "}"}], 
                    ",", "_", ",", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"1.2`", " ", 
                    RowBox[{"Cos", "[", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ")"}]}], 
                    "VilTeX`Private`numSets"], "]"}]}], ",", 
                    RowBox[{"1.2`", " ", 
                    RowBox[{"Sin", "[", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ")"}]}], 
                    "VilTeX`Private`numSets"], "]"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numSets"}], "}"}]}], "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`ellipseDefinitions", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"\\\\def\\\\ellipse\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "<>", 
                    "\"{(\"", "<>", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\") ellipse (\"",
                     "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`rx", "]"}], "<>",
                     "\" and \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`ry", "]"}], "<>",
                     "\")}\\n\""}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numSets"}], "}"}]}], "]"}], "]"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`unionCode", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{
                    "\"% Sombrear la uni\[OAcute]n de todos los \
conjuntos\\n\"", ",", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    
                    RowBox[{"\"\\\\fill[\"", "<>", 
                    "VilTeX`Private`processedColor", "<>", 
                    "\"] \\\\ellipse\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "<>", 
                    "\";\\n\""}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numSets"}], "}"}]}], "]"}], "]"}], ",", 
                    "\"\\n\""}], "}"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`labelsCode", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"\\\\node at (\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "+", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "<", "0"}], ",", 
                    RowBox[{
                    RowBox[{"-", "VilTeX`Private`rx"}], " ", "0.8`"}], ",", 
                    RowBox[{"VilTeX`Private`rx", " ", "0.8`"}]}], "]"}]}], 
                    "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", 
                    "\") {\\\\Large $\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "<>", 
                    "\"$};\\n\""}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numSets"}], "}"}]}], "]"}], "]"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`unionLabelCode", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`showUnionLabel", ",", 
                    
                    RowBox[{
                    "\"% Etiqueta para la uni\[OAcute]n\\n\\\\node at (0,\"", 
                    "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilTeX`Private`ry", " ", "1.8`"}], "]"}], "<>", 
                    "\") {\\\\small $\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{"VilTeX`Private`labels", ",", "\" \\\\cup \""}], 
                    "]"}], "<>", "\"$};\\n\\n\""}], ",", "\"\""}], "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\\\\begin{tikzpicture}[scale=\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`scale", "]"}], 
                    "<>", "\"]\\n\\n\""}], ",", 
                    "\"% Definir las elipses\\n\"", ",", 
                    "VilTeX`Private`ellipseDefinitions", ",", "\"\\n\"", ",", 
                    "VilTeX`Private`unionCode", ",", 
                    "\"% Dibujar los contornos de las elipses\\n\"", ",", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"\\\\draw[black, thick] \\\\ellipse\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "<>", 
                    "\";\\n\""}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numSets"}], "}"}]}], "]"}], "]"}], ",", 
                    "\"\\n\"", ",", "\"% Etiquetas\\n\"", ",", 
                    "VilTeX`Private`labelsCode", ",", "\"\\n\"", ",", 
                    "VilTeX`Private`unionLabelCode", ",", 
                    "\"\\\\end{tikzpicture}\""}], "}"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`fullDocument", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{
                    "\"\\\\documentclass[border=5mm]{standalone}\\n\"", ",", 
                    "\"\\\\usepackage{tikz}\\n\"", ",", 
                    "\"\\\\usepackage{amsmath}\\n\"", ",", 
                    "\"\\\\usetikzlibrary{patterns}\\n\\n\"", ",", 
                    "\"\\\\begin{document}\\n\"", ",", 
                    "VilTeX`Private`tikzCode", ",", 
                    "\"\\n\\\\end{document}\""}], "}"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`folderPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"$HomeDirectory", ",", "\"Downloads\"", ",", 
                    "\"UnionSets\""}], "}"}], "]"}]}], ";", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"DirectoryQ", "[", "VilTeX`Private`folderPath", 
                    "]"}]}], ",", 
                    
                    RowBox[{"CreateDirectory", "[", 
                    "VilTeX`Private`folderPath", "]"}]}], "]"}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`downloadPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`folderPath", ",", 
                    "VilTeX`Private`filename"}], "}"}], "]"}]}], ";", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"Export", "[", 
                    
                    RowBox[{"VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`fullDocument", ",", "\"Text\""}], "]"}], 
                    "]"}], ";", "VilTeX`Private`downloadPath"}]}], "]"}]}]}, {
                   " "}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilTeX`UnionSets\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"UnionSets[filename, labels, fillColor, scale, \
showUnionLabel, ellipseSize] crea un diagrama de la uni\[OAcute]n de \
conjuntos en formato TikZ/LaTeX y lo exporta como archivo .tex en la carpeta \
Downloads/UnionSets.\\n\\nPAR\[CapitalAAcute]METROS:\\n- filename: String que \
especifica el nombre del archivo de salida (debe terminar en \
\\\".tex\\\")\\n- labels: Lista de etiquetas para identificar cada conjunto \
(m\[IAcute]nimo 2 elementos)\\n- fillColor: String que especifica el color de \
relleno de la uni\[OAcute]n (opcional, por defecto \\\"gray\\\")\\n- scale: \
Real que define la escala del diagrama completo (opcional, por defecto \
1.2)\\n- showUnionLabel: True/False para mostrar la etiqueta \
matem\[AAcute]tica de la uni\[OAcute]n (opcional, por defecto False)\\n- \
ellipseSize: Lista {rx, ry} que define el radio horizontal y vertical de las \
elipses (opcional, por defecto {1.5, 1.8})\\n\\nCOLORES PREDEFINIDOS:\\nLos \
siguientes colores se convierten autom\[AAcute]ticamente a tonos TikZ \
apropiados:\\n- \\\"blue\\\" -> \\\"blue!50\\\"     \[Bullet] \\\"red\\\" -> \
\\\"red!50\\\"       \[Bullet] \\\"green\\\" -> \\\"green!50\\\"\\n- \
\\\"yellow\\\" -> \\\"yellow!60\\\" \[Bullet] \\\"orange\\\" -> \\\"orange!50\
\\\" \[Bullet] \\\"purple\\\" -> \\\"purple!50\\\"\\n- \\\"violet\\\" -> \
\\\"violet!50\\\" \[Bullet] \\\"cyan\\\" -> \\\"cyan!50\\\"     \[Bullet] \
\\\"magenta\\\" -> \\\"magenta!50\\\"\\n- \\\"pink\\\" -> \\\"pink!50\\\"     \
\[Bullet] \\\"brown\\\" -> \\\"brown!50\\\"   \[Bullet] \\\"black\\\" -> \
\\\"black!30\\\"\\n- \\\"gray\\\"/\\\"grey\\\" -> \\\"gray!85\\\"\\n- \
Cualquier otro string se usa directamente como color TikZ\\n\\nDISPOSICI\
\[CapitalOAcute]N AUTOM\[CapitalAAcute]TICA DE CONJUNTOS:\\n- 2 conjuntos: \
Disposici\[OAcute]n horizontal\\n- 3 conjuntos: Disposici\[OAcute]n \
triangular\\n- 4 conjuntos: Disposici\[OAcute]n en cuadrado\\n- 5 conjuntos: \
Disposici\[OAcute]n pentagonal\\n- 6+ conjuntos: Disposici\[OAcute]n circular \
autom\[AAcute]tica\\n\\nFUNCIONALIDAD:\\n- Genera c\[OAcute]digo TikZ \
completo con documento LaTeX standalone\\n- Sombreia completamente TODAS las \
elipses de los conjuntos especificados\\n- El resultado visual es la uni\
\[OAcute]n A\:222aB\:222aC\:222a... (toda la regi\[OAcute]n cubierta por al \
menos un conjunto)\\n- Dibuja los contornos de todas las elipses con l\
\[IAcute]neas negras gruesas\\n- Posiciona autom\[AAcute]ticamente las \
etiquetas fuera de las elipses\\n- La etiqueta de uni\[OAcute]n (si est\
\[AAcute] habilitada) se coloca en la parte superior del diagrama\\n- Crea la \
carpeta Downloads/UnionSets si no existe\\n- Exporta el archivo .tex listo \
para compilar\\n\\nVALIDACIONES:\\n- El filename debe terminar \
obligatoriamente en \\\".tex\\\"\\n- La lista ellipseSize debe contener \
exactamente 2 elementos\\n- La lista labels debe contener al menos 2 \
elementos\\n- Retorna $Failed si alguna validaci\[OAcute]n falla\\n\\nVALOR \
DE RETORNO:\\nRetorna la ruta completa del archivo exportado, o $Failed en \
caso de error.\\n\\nEJEMPLOS:\\n- UnionSets[\\\"union.tex\\\", {\\\"A\\\", \\\
\"B\\\"}]\\n- UnionSets[\\\"union_tres.tex\\\", {\\\"X\\\", \\\"Y\\\", \
\\\"Z\\\"}, \\\"blue\\\", 1.5, True]\\n- UnionSets[\\\"ejemplo.tex\\\", \
{\\\"A\\\", \\\"B\\\", \\\"C\\\", \\\"D\\\"}, \\\"red\\\", 1.0, False, {2.0, \
2.5}]\\n\\nNOTA MATEM\[CapitalAAcute]TICA:\\nEsta funci\[OAcute]n visualiza A \
\:222a B \:222a C \:222a ..., es decir, la uni\[OAcute]n de todos los \
conjuntos especificados. Toda la regi\[OAcute]n sombreada representa \
elementos que pertenecen a al menos uno de los conjuntos.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}},
            ScrollPosition->{0., 0.}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "UnionSets[filename, labels, fillColor, scale, showUnionLabel, \
ellipseSize] crea un diagrama de la uni\[OAcute]n de conjuntos en formato \
TikZ/LaTeX y lo exporta como archivo .tex en la carpeta Downloads/UnionSets.\n\
\nPAR\[CapitalAAcute]METROS:\n- filename: String que especifica el nombre del \
archivo de salida (debe terminar en \".tex\")\n- labels: Lista de etiquetas \
para identificar cada conjunto (m\[IAcute]nimo 2 elementos)\n- fillColor: \
String que especifica el color de relleno de la uni\[OAcute]n (opcional, por \
defecto \"gray\")\n- scale: Real que define la escala del diagrama completo \
(opcional, por defecto 1.2)\n- showUnionLabel: True/False para mostrar la \
etiqueta matem\[AAcute]tica de la uni\[OAcute]n (opcional, por defecto False)\
\n- ellipseSize: Lista {rx, ry} que define el radio horizontal y vertical de \
las elipses (opcional, por defecto {1.5, 1.8})\n\nCOLORES PREDEFINIDOS:\nLos \
siguientes colores se convierten autom\[AAcute]ticamente a tonos TikZ \
apropiados:\n- \"blue\" -> \"blue!50\"     \[Bullet] \"red\" -> \"red!50\"    \
   \[Bullet] \"green\" -> \"green!50\"\n- \"yellow\" -> \"yellow!60\" \
\[Bullet] \"orange\" -> \"orange!50\" \[Bullet] \"purple\" -> \"purple!50\"\n\
- \"violet\" -> \"violet!50\" \[Bullet] \"cyan\" -> \"cyan!50\"     \[Bullet] \
\"magenta\" -> \"magenta!50\"\n- \"pink\" -> \"pink!50\"     \[Bullet] \
\"brown\" -> \"brown!50\"   \[Bullet] \"black\" -> \"black!30\"\n- \
\"gray\"/\"grey\" -> \"gray!85\"\n- Cualquier otro string se usa directamente \
como color TikZ\n\nDISPOSICI\[CapitalOAcute]N AUTOM\[CapitalAAcute]TICA DE \
CONJUNTOS:\n- 2 conjuntos: Disposici\[OAcute]n horizontal\n- 3 conjuntos: \
Disposici\[OAcute]n triangular\n- 4 conjuntos: Disposici\[OAcute]n en \
cuadrado\n- 5 conjuntos: Disposici\[OAcute]n pentagonal\n- 6+ conjuntos: \
Disposici\[OAcute]n circular autom\[AAcute]tica\n\nFUNCIONALIDAD:\n- Genera c\
\[OAcute]digo TikZ completo con documento LaTeX standalone\n- Sombreia \
completamente TODAS las elipses de los conjuntos especificados\n- El \
resultado visual es la uni\[OAcute]n A\:222aB\:222aC\:222a... (toda la regi\
\[OAcute]n cubierta por al menos un conjunto)\n- Dibuja los contornos de \
todas las elipses con l\[IAcute]neas negras gruesas\n- Posiciona autom\
\[AAcute]ticamente las etiquetas fuera de las elipses\n- La etiqueta de uni\
\[OAcute]n (si est\[AAcute] habilitada) se coloca en la parte superior del \
diagrama\n- Crea la carpeta Downloads/UnionSets si no existe\n- Exporta el \
archivo .tex listo para compilar\n\nVALIDACIONES:\n- El filename debe \
terminar obligatoriamente en \".tex\"\n- La lista ellipseSize debe contener \
exactamente 2 elementos\n- La lista labels debe contener al menos 2 elementos\
\n- Retorna $Failed si alguna validaci\[OAcute]n falla\n\nVALOR DE RETORNO:\n\
Retorna la ruta completa del archivo exportado, o $Failed en caso de error.\n\
\nEJEMPLOS:\n- UnionSets[\"union.tex\", {\"A\", \"B\"}]\n- \
UnionSets[\"union_tres.tex\", {\"X\", \"Y\", \"Z\"}, \"blue\", 1.5, True]\n- \
UnionSets[\"ejemplo.tex\", {\"A\", \"B\", \"C\", \"D\"}, \"red\", 1.0, False, \
{2.0, 2.5}]\n\nNOTA MATEM\[CapitalAAcute]TICA:\nEsta funci\[OAcute]n \
visualiza A \:222a B \:222a C \:222a ..., es decir, la uni\[OAcute]n de todos \
los conjuntos especificados. Toda la regi\[OAcute]n sombreada representa \
elementos que pertenecen a al menos uno de los conjuntos.", "Documentation" -> 
    None, "OwnValues" -> None, "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilTeX`UnionSets, {VilTeX`UnionSets[
         Pattern[VilTeX`Private`filename, 
          Blank[String]], 
         Pattern[VilTeX`Private`labels, 
          Blank[List]], 
         Optional[
          Pattern[VilTeX`Private`fillColor, 
           Blank[String]], "gray"], 
         Optional[
          Pattern[VilTeX`Private`scale, 
           Blank[Real]], 1.2], 
         Optional[
          Pattern[VilTeX`Private`showUnionLabel, 
           Blank[]], False], 
         Optional[
          Pattern[VilTeX`Private`ellipseSize, 
           Blank[List]], {1.5, 1.8}]] :> 
       Module[{VilTeX`Private`tikzCode, VilTeX`Private`fullDocument, 
          VilTeX`Private`downloadPath, VilTeX`Private`folderPath, 
          VilTeX`Private`rx, VilTeX`Private`ry, VilTeX`Private`processedColor,
           VilTeX`Private`numSets, VilTeX`Private`positions, 
          VilTeX`Private`ellipseDefinitions, VilTeX`Private`unionCode, 
          VilTeX`Private`labelsCode, VilTeX`Private`unionLabelCode}, If[
           Not[
            StringEndsQ[VilTeX`Private`filename, ".tex"]], 
           Return[$Failed]]; If[Length[VilTeX`Private`ellipseSize] != 2, 
           Return[$Failed]]; If[Length[VilTeX`Private`labels] < 2, 
           Return[$Failed]]; {VilTeX`Private`rx, VilTeX`Private`ry} = 
          VilTeX`Private`ellipseSize; 
         VilTeX`Private`numSets = Length[VilTeX`Private`labels]; 
         VilTeX`Private`processedColor = 
          Switch[VilTeX`Private`fillColor, "blue", "blue!50", "red", "red!50",
             "green", "green!50", "yellow", "yellow!60", "orange", 
            "orange!50", "purple", "purple!50", "violet", "violet!50", "cyan",
             "cyan!50", "magenta", "magenta!50", "pink", "pink!50", "brown", 
            "brown!50", "black", "black!30", "gray", "gray!85", "grey", 
            "gray!85", 
            Blank[], VilTeX`Private`fillColor]; 
         VilTeX`Private`positions = 
          Switch[VilTeX`Private`numSets, 2, {{-0.8, 0}, {0.8, 0}}, 
            3, {{-0.8, 0.6}, {0.8, 0.6}, {0, -0.8}}, 4, {{-0.8, 0.8}, {0.8, 
            0.8}, {-0.8, -0.8}, {0.8, -0.8}}, 
            5, {{0, 1.2}, {1.1, 0.37}, {0.68, -0.97}, {-0.68, -0.97}, {-1.1, 
             0.37}}, 
            Blank[], 
            
            Table[{1.2 
              Cos[2 Pi ((VilTeX`Private`i - 1)/VilTeX`Private`numSets)], 1.2 
              Sin[2 Pi ((VilTeX`Private`i - 1)/VilTeX`Private`numSets)]}, {
             VilTeX`Private`i, VilTeX`Private`numSets}]]; 
         VilTeX`Private`ellipseDefinitions = StringJoin[
            Table[
            "\\def\\ellipse" <> Part[VilTeX`Private`labels, VilTeX`Private`i] <> 
             "{(" <> ToString[
               Part[VilTeX`Private`positions, VilTeX`Private`i, 1]] <> "," <> 
             ToString[
               Part[VilTeX`Private`positions, VilTeX`Private`i, 2]] <> 
             ") ellipse (" <> ToString[VilTeX`Private`rx] <> " and " <> 
             ToString[VilTeX`Private`ry] <> ")}\n", {
             VilTeX`Private`i, VilTeX`Private`numSets}]]; 
         VilTeX`Private`unionCode = 
          StringJoin[{
            "% Sombrear la uni\[OAcute]n de todos los conjuntos\n", 
             StringJoin[
              Table[
              "\\fill[" <> VilTeX`Private`processedColor <> "] \\ellipse" <> 
               Part[VilTeX`Private`labels, VilTeX`Private`i] <> ";\n", {
               VilTeX`Private`i, VilTeX`Private`numSets}]], "\n"}]; 
         VilTeX`Private`labelsCode = StringJoin[
            Table[
            "\\node at (" <> 
             ToString[
              Part[VilTeX`Private`positions, VilTeX`Private`i, 1] + 
               If[Part[VilTeX`Private`positions, VilTeX`Private`i, 1] < 
                 0, (-VilTeX`Private`rx) 0.8, VilTeX`Private`rx 0.8]] <> "," <> 
             ToString[
               Part[VilTeX`Private`positions, VilTeX`Private`i, 2]] <> 
             ") {\\Large $" <> Part[VilTeX`Private`labels, VilTeX`Private`i] <> 
             "$};\n", {VilTeX`Private`i, VilTeX`Private`numSets}]]; 
         VilTeX`Private`unionLabelCode = 
          If[VilTeX`Private`showUnionLabel, 
            "% Etiqueta para la uni\[OAcute]n\n\\node at (0," <> 
            ToString[VilTeX`Private`ry 1.8] <> ") {\\small $" <> 
            StringRiffle[VilTeX`Private`labels, " \\cup "] <> "$};\n\n", ""]; 
         VilTeX`Private`tikzCode = 
          StringJoin[{
            "\\begin{tikzpicture}[scale=" <> ToString[VilTeX`Private`scale] <> 
             "]\n\n", "% Definir las elipses\n", 
             VilTeX`Private`ellipseDefinitions, "\n", 
             VilTeX`Private`unionCode, 
             "% Dibujar los contornos de las elipses\n", 
             StringJoin[
              Table[
              "\\draw[black, thick] \\ellipse" <> 
               Part[VilTeX`Private`labels, VilTeX`Private`i] <> ";\n", {
               VilTeX`Private`i, VilTeX`Private`numSets}]], "\n", 
             "% Etiquetas\n", VilTeX`Private`labelsCode, "\n", 
             VilTeX`Private`unionLabelCode, "\\end{tikzpicture}"}]; 
         VilTeX`Private`fullDocument = 
          StringJoin[{
            "\\documentclass[border=5mm]{standalone}\n", 
             "\\usepackage{tikz}\n", "\\usepackage{amsmath}\n", 
             "\\usetikzlibrary{patterns}\n\n", "\\begin{document}\n", 
             VilTeX`Private`tikzCode, "\n\\end{document}"}]; 
         VilTeX`Private`folderPath = 
          FileNameJoin[{$HomeDirectory, "Downloads", "UnionSets"}]; Quiet[
           If[
            Not[
             DirectoryQ[VilTeX`Private`folderPath]], 
            CreateDirectory[VilTeX`Private`folderPath]]]; 
         VilTeX`Private`downloadPath = 
          FileNameJoin[{VilTeX`Private`folderPath, VilTeX`Private`filename}]; 
         Quiet[
           Export[
           VilTeX`Private`downloadPath, VilTeX`Private`fullDocument, "Text"]]; 
         VilTeX`Private`downloadPath]}], "SubValues" -> None, "DefaultValues" -> 
    None, "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {Protected}, "FullName" -> "VilTeX`UnionSets"|>, 
   False]]], "Output",
 CellChangeTimes->{3.967022367066444*^9},
 CellLabel->"Out[55]=",ExpressionUUID->"763a9f92-b826-486d-83c7-d7468f21200e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 1: dos conjuntos", "Subsection",
 CellChangeTimes->{{3.9669722155811577`*^9, 3.966972227370956*^9}, {
  3.96697269501637*^9, 
  3.966972698074332*^9}},ExpressionUUID->"85b00c57-7527-4fdd-a854-\
bacc6342c9fe"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"UnionSets", "[", 
   RowBox[{"\"\<unionsets1.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}], ",", "\"\<blue\>\""}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967021500218103*^9, 3.967021539009901*^9}, 
   3.967021672805071*^9, {3.967022571658849*^9, 3.967022571928604*^9}, {
   3.967022915122939*^9, 3.9670229233377743`*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"8d6e99dc-deea-4f64-9b51-0ac7016201fb"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022933351695*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[59]:=",ExpressionUUID->"63dc9963-0a2d-4f8c-b242-150055e8b98d"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.967022933352708*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[59]:=",ExpressionUUID->"219d1df9-a8d4-462e-896c-1a4384a5ba78"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022933353693*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[59]:=",ExpressionUUID->"49a16f78-ac8b-4225-9eb1-fe2e41303f2e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022933354244*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[59]:=",ExpressionUUID->"21b8ee65-1c8d-4795-adaf-f544f7e8265c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670229333547773`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[59]:=",ExpressionUUID->"18962334-2c78-4cfa-91fc-da6fa0cb49ca"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967022933440176*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[59]:=",ExpressionUUID->"aeea8ab7-88b3-4dce-ac0c-aea2ca5b1f6c"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.967022934446314*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[59]:=",ExpressionUUID->"b78958a7-2aba-4eb2-b580-f78a7ce4cca8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/UnionSets/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/UnionSets/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022934450419*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[59]:=",ExpressionUUID->"180cee67-df19-4e5b-aead-7808a00a0329"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"unionsets1\"\>"}],
  SequenceForm["Archivo: ", "unionsets1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022934453054*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[59]:=",ExpressionUUID->"cd1c495d-6b51-41c5-a505-c21d91d092fe"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.967022934899329*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[59]:=",ExpressionUUID->"2ebcfa71-7657-42df-b4b6-c2b020fbd4e8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/UnionSets/unionsets1.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/UnionSets/unionsets1.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022934899979*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[59]:=",ExpressionUUID->"7ce23dba-7e6c-494e-acbf-b65bbe6d78e2"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/UnionSets/unionsets1.\
pdf\"\>"], "Output",
 CellChangeTimes->{3.9670229349127817`*^9},
 CellLabel->"Out[60]=",ExpressionUUID->"fe9418e5-88dc-4bfe-828b-32bf313313d1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 2: tres conjuntos", "Subsection",
 CellChangeTimes->{{3.9669722155811577`*^9, 3.966972227370956*^9}, {
  3.96697269501637*^9, 3.966972698074332*^9}, {3.967021692623477*^9, 
  3.967021693203027*^9}, {3.967021739781867*^9, 
  3.967021740308218*^9}},ExpressionUUID->"a8917821-97f3-467e-8244-\
89bf80398904"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"UnionSets", "[", 
   RowBox[{"\"\<unionsets2.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\"", ",", "\"\<C\>\""}], "}"}], 
    ",", "\"\<red\>\""}], "]"}], ";"}], "\n", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967021500218103*^9, 3.967021539009901*^9}, 
   3.967021672805071*^9, {3.967021723404994*^9, 3.9670217365279837`*^9}, {
   3.9670226675891743`*^9, 3.96702266792097*^9}, {3.967022900182078*^9, 
   3.967022908083435*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"8cf2435f-824e-4261-a8e2-64ebdd4d8c0f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022952182856*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[61]:=",ExpressionUUID->"f0290a0b-8785-4148-9f66-243a2d2fb31d"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.9670229521841373`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[61]:=",ExpressionUUID->"a828bde4-60ec-4119-9494-d7efc31a8669"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022952185232*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[61]:=",ExpressionUUID->"e1361f41-14da-4fea-a12c-b8b09e282d72"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022952185871*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[61]:=",ExpressionUUID->"f25d4fe4-8c41-447f-a98c-821aebb92b1e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022952186482*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[61]:=",ExpressionUUID->"5d103d99-995f-45ef-8de3-4e47c90c089e"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967022952255965*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[61]:=",ExpressionUUID->"fbab3376-6c7f-47d9-9213-8bdb2ba01444"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.967022953262336*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[61]:=",ExpressionUUID->"fbcd32ad-231a-477d-8190-42f925f871d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/UnionSets/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/UnionSets/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.96702295326663*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[61]:=",ExpressionUUID->"116140a3-d99a-4fb7-b089-9acf511b275c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"unionsets2\"\>"}],
  SequenceForm["Archivo: ", "unionsets2"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022953269177*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[61]:=",ExpressionUUID->"13f15732-aa81-4a22-b6f0-031d9f979e63"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.967022953714838*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[61]:=",ExpressionUUID->"a706fc69-0212-4861-899f-5f17b059b4e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/UnionSets/unionsets2.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/UnionSets/unionsets2.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022953715499*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[61]:=",ExpressionUUID->"f5e08ac2-660f-465f-b12c-f59573df7e55"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/UnionSets/unionsets2.\
pdf\"\>"], "Output",
 CellChangeTimes->{3.967022953729438*^9},
 CellLabel->"Out[62]=",ExpressionUUID->"ef7607cf-0f03-4453-b971-d489e9283424"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 3: cuatro conjuntos", "Subsection",
 CellChangeTimes->{{3.9669722155811577`*^9, 3.966972227370956*^9}, {
  3.96697269501637*^9, 3.966972698074332*^9}, {3.967021692623477*^9, 
  3.967021693203027*^9}, {3.967021739781867*^9, 3.967021740308218*^9}, {
  3.9670220235241613`*^9, 
  3.967022026511013*^9}},ExpressionUUID->"0d5957b7-e0a8-44b7-b219-\
59c691c4365b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"UnionSets", "[", 
   RowBox[{"\"\<unionsets3.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<P\>\"", ",", "\"\<Q\>\"", ",", "\"\<R\>\"", 
      ",", "\"\<S\>\""}], "}"}], ",", "\"\<purple\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967021500218103*^9, 3.967021539009901*^9}, 
   3.967021672805071*^9, {3.967021723404994*^9, 3.9670217365279837`*^9}, 
   3.967022030968194*^9, {3.967022064956696*^9, 3.967022065287479*^9}, {
   3.9670222461414547`*^9, 3.967022249781415*^9}, {3.967022290032826*^9, 
   3.967022291774508*^9}, {3.967022565207052*^9, 3.967022569484043*^9}, {
   3.967022688501742*^9, 3.967022691330716*^9}, {3.967022880605894*^9, 
   3.967022892369725*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"0c4cc2b3-499e-4817-b7a1-83b764c6f784"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022961760462*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[63]:=",ExpressionUUID->"d1f26d3e-636f-4712-a37f-e856cf4b2c86"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.967022961762041*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[63]:=",ExpressionUUID->"37892d87-68ae-4a7f-9bc3-df6fd62d795b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670229617632313`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[63]:=",ExpressionUUID->"249d7d21-bbcc-455f-9eee-c1c52c330927"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670229617638283`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[63]:=",ExpressionUUID->"ba9eee72-99b9-425c-ae47-d7f65f736367"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022961764413*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[63]:=",ExpressionUUID->"7b6ad74e-1b9d-4e25-aaac-5effb382cbb5"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967022961826311*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[63]:=",ExpressionUUID->"875c6cb8-780b-40d1-a022-0bcc33bb0fb5"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.9670229628333197`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[63]:=",ExpressionUUID->"1341e086-c390-4eb3-8f12-4d522226d58c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/UnionSets/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/UnionSets/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022962836996*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[63]:=",ExpressionUUID->"e0072520-ed7b-4e97-b32c-184f05e4dbde"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"unionsets3\"\>"}],
  SequenceForm["Archivo: ", "unionsets3"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022962840114*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[63]:=",ExpressionUUID->"35b01c48-9a12-47a1-b972-a45d4e51c817"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.9670229632895*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[63]:=",ExpressionUUID->"b0d1cab8-796e-436a-b68a-d4e468d2fb62"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/UnionSets/unionsets3.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/UnionSets/unionsets3.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670229632902813`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[63]:=",ExpressionUUID->"77f49161-3a5a-4ffc-b4d8-e1541d6dbc22"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/UnionSets/unionsets3.\
pdf\"\>"], "Output",
 CellChangeTimes->{3.967022963302738*^9},
 CellLabel->"Out[64]=",ExpressionUUID->"d68a52a7-4e5e-4852-a251-db6db7478586"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 4: cinco conjuntos", "Subsection",
 CellChangeTimes->{{3.9669722155811577`*^9, 3.966972227370956*^9}, {
  3.96697269501637*^9, 3.966972698074332*^9}, {3.967021692623477*^9, 
  3.967021693203027*^9}, {3.967021739781867*^9, 3.967021740308218*^9}, {
  3.9670220235241613`*^9, 3.967022026511013*^9}, {3.9670227014582376`*^9, 
  3.967022727634679*^9}, {3.9670228628394213`*^9, 
  3.9670228632514143`*^9}},ExpressionUUID->"5ea6e5f9-c50f-45e3-95ed-\
07dca297b3a1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"UnionSets", "[", 
   RowBox[{"\"\<unionsets4.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\"", ",", "\"\<C\>\"", ",", "\"\<D\>\"",
       ",", "\"\<E\>\""}], "}"}], ",", "\"\<orange\>\"", ",", "1.5"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967021500218103*^9, 3.967021539009901*^9}, 
   3.967021672805071*^9, {3.967021723404994*^9, 3.9670217365279837`*^9}, 
   3.967022030968194*^9, {3.967022064956696*^9, 3.967022065287479*^9}, {
   3.9670222461414547`*^9, 3.967022249781415*^9}, {3.967022290032826*^9, 
   3.967022291774508*^9}, {3.967022565207052*^9, 3.967022569484043*^9}, {
   3.967022688501742*^9, 3.967022691330716*^9}, 3.967022732665717*^9, {
   3.9670228602619*^9, 3.967022872995895*^9}},
 CellLabel->"In[65]:=",ExpressionUUID->"28c698e7-5407-476e-b81d-5ba8f6f136ab"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670229841951313`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[65]:=",ExpressionUUID->"994781e9-a08d-492c-bc60-7c10f350f965"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.9670229841963167`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[65]:=",ExpressionUUID->"5a11063c-693d-452e-9bc6-7fad3d160eab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670229841974773`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[65]:=",ExpressionUUID->"0f3b7cef-ba0b-46da-8bb3-c250ba6a5290"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022984198138*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[65]:=",ExpressionUUID->"86d390a8-278d-4b44-a3e3-cefc40686869"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022984198792*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[65]:=",ExpressionUUID->"14b5b3c6-4888-428e-888e-59ca7939eb6f"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.9670229842854853`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[65]:=",ExpressionUUID->"b88f9d9d-39e3-416b-94be-b7bc233518fd"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.9670229852912693`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[65]:=",ExpressionUUID->"54874ea0-4c55-492c-bcf4-87acf361ae68"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/UnionSets/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/UnionSets/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022985294346*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[65]:=",ExpressionUUID->"5c1806f1-a978-40e8-9040-fd15a9a18b9d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"unionsets4\"\>"}],
  SequenceForm["Archivo: ", "unionsets4"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967022985296644*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[65]:=",ExpressionUUID->"3c3bcf18-0b9b-4e18-9891-8afe7612b5f1"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.967022985742588*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[65]:=",ExpressionUUID->"575334b9-ffdd-4633-bc19-fbcaf811884a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/UnionSets/unionsets4.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/UnionSets/unionsets4.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.96702298574337*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[65]:=",ExpressionUUID->"cb5ed6f6-d48d-4178-87ba-73740c10a291"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/UnionSets/unionsets4.\
pdf\"\>"], "Output",
 CellChangeTimes->{3.967022985755986*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"1524e130-e050-470e-be0a-4fa0d8582350"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 5: con etiqueta de uni\[OAcute]n", "Subsection",
 CellChangeTimes->{{3.9669722155811577`*^9, 3.966972227370956*^9}, {
   3.96697269501637*^9, 3.966972698074332*^9}, {3.967021692623477*^9, 
   3.967021693203027*^9}, {3.967021739781867*^9, 3.967021754858276*^9}, {
   3.967021813019991*^9, 3.967021818163364*^9}, 3.967022105184704*^9, 
   3.967022214304068*^9, 3.96702273954676*^9, {3.967022999169161*^9, 
   3.96702300428316*^9}},ExpressionUUID->"18827a01-d412-429a-8e5d-\
c917f8c2e70c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"UnionSets", "[", 
   RowBox[{"\"\<unionsets5.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<X\>\"", ",", "\"\<Y\>\""}], "}"}], ",", "\"\<green\>\"", ",",
     "1.2", ",", "True"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967021500218103*^9, 3.967021539009901*^9}, 
   3.967021672805071*^9, {3.967021723404994*^9, 3.9670217365279837`*^9}, {
   3.967021772154702*^9, 3.9670217724637127`*^9}, {3.967021824945944*^9, 
   3.9670218349035807`*^9}, {3.967021871834454*^9, 3.967021905603507*^9}, 
   3.9670222209400387`*^9, {3.967022677598493*^9, 3.967022677909186*^9}, {
   3.967022838661956*^9, 3.967022852595186*^9}},
 CellLabel->"In[67]:=",ExpressionUUID->"5bca4029-115b-40ba-acb2-435e3e9a7ec8"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023008896944*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[67]:=",ExpressionUUID->"46cf0108-1604-4f95-9bc0-68e472f90362"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.967023008898551*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[67]:=",ExpressionUUID->"6672ee70-f6d8-4ded-b348-6d0757cde872"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023008900062*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[67]:=",ExpressionUUID->"15a8c315-349f-4937-922a-0ac769fa4aa8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023008900782*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[67]:=",ExpressionUUID->"92d16b97-63d5-41d0-b92a-10eb08972992"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670230089015217`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[67]:=",ExpressionUUID->"dc04358d-8fea-48ca-8776-e66c950554c3"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967023008987378*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[67]:=",ExpressionUUID->"a9c9378b-2584-4622-8c93-fd7aa7561a57"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.9670230099940434`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[67]:=",ExpressionUUID->"1d9c7724-34be-45e0-b6d6-c5e69871a46c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/UnionSets/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/UnionSets/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023009997897*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[67]:=",ExpressionUUID->"02744aa5-716b-4e3d-9d4a-c1c36c137c05"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"unionsets5\"\>"}],
  SequenceForm["Archivo: ", "unionsets5"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023010000803*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[67]:=",ExpressionUUID->"5e64efa1-ab0b-4631-aa9f-4ed5a12bf583"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.9670230104553833`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[67]:=",ExpressionUUID->"15e9e439-96ac-46c6-b18c-4b150ffb76da"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/UnionSets/unionsets5.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/UnionSets/unionsets5.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023010456284*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[67]:=",ExpressionUUID->"c6234200-7032-4ce7-8a96-b55c1084ecb0"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/UnionSets/unionsets5.\
pdf\"\>"], "Output",
 CellChangeTimes->{3.967023010468952*^9},
 CellLabel->"Out[68]=",ExpressionUUID->"2c7bce9b-15b1-4d2c-847f-584e9a6d47bb"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 6: elipses m\[AAcute]s grandes", "Subsection",
 CellChangeTimes->{{3.9669722155811577`*^9, 3.966972227370956*^9}, {
   3.96697269501637*^9, 3.966972698074332*^9}, {3.967021692623477*^9, 
   3.967021693203027*^9}, {3.967021739781867*^9, 3.967021754858276*^9}, {
   3.967021813019991*^9, 3.967021818163364*^9}, {3.96702196939318*^9, 
   3.96702197150316*^9}, 3.967022108517112*^9, 3.9670221980273943`*^9, 
   3.967022742847982*^9, 
   3.967022807789008*^9},ExpressionUUID->"87b9d4a0-3292-464d-b936-\
c1b8b5a4e667"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"UnionSets", "[", 
   RowBox[{"\"\<unionsets6.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<X\>\"", ",", "\"\<Y\>\"", ",", "\"\<Z\>\""}], "}"}], 
    ",", "\"\<cyan\>\"", ",", "1.3", ",", "True", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2.3"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967021500218103*^9, 3.967021539009901*^9}, 
   3.967021672805071*^9, {3.967021723404994*^9, 3.9670217365279837`*^9}, {
   3.967021772154702*^9, 3.9670217724637127`*^9}, {3.967021824945944*^9, 
   3.9670218349035807`*^9}, {3.967021871834454*^9, 3.967021905603507*^9}, {
   3.967022045350721*^9, 3.967022045686844*^9}, {3.967022158668399*^9, 
   3.967022209067857*^9}, 3.9670223300486383`*^9, {3.967022754728014*^9, 
   3.9670227550770082`*^9}, {3.9670228199585123`*^9, 
   3.9670228300625668`*^9}, {3.967023037032612*^9, 3.9670230443241034`*^9}},
 CellLabel->"In[73]:=",ExpressionUUID->"271d9989-db4b-4396-b5bb-2d6ed1945706"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670230220192347`*^9, 3.967023044761005*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[73]:=",ExpressionUUID->"6efce56f-760f-48e1-a126-58e68325a790"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.9670230220192347`*^9, 3.967023044762004*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[73]:=",ExpressionUUID->"3607ada3-5268-435d-a120-f8002871ad1c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670230220192347`*^9, 3.967023044762973*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[73]:=",ExpressionUUID->"dab279ed-2ded-4967-9253-46dd8a9bbe78"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670230220192347`*^9, 3.967023044763582*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[73]:=",ExpressionUUID->"b12a729d-d1a0-444d-8044-5de325fad878"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670230220192347`*^9, 3.967023044764174*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[73]:=",ExpressionUUID->"a9ae8c3c-42ff-4ba4-8c1b-e120fc2aec26"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.9670230220192347`*^9, 3.96702304483255*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[73]:=",ExpressionUUID->"9db9a3e2-47b6-4b9b-b83e-8c428d14e2ae"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.9670230220192347`*^9, 3.967023045839473*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[73]:=",ExpressionUUID->"212aa568-1a42-4572-b778-dd32a075e940"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/UnionSets/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/UnionSets/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670230220192347`*^9, 3.9670230458439207`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[73]:=",ExpressionUUID->"e73acdeb-b566-4653-841f-89b601951717"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"unionsets6\"\>"}],
  SequenceForm["Archivo: ", "unionsets6"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670230220192347`*^9, 3.9670230458467617`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[73]:=",ExpressionUUID->"00aa2441-743d-4fc2-af48-e9ad43146df9"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.9670230220192347`*^9, 3.967023046296032*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[73]:=",ExpressionUUID->"794b1692-f507-4f51-aea3-880706c4edd3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/UnionSets/unionsets6.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/UnionSets/unionsets6.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670230220192347`*^9, 3.967023046296875*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[73]:=",ExpressionUUID->"cdabfa81-2a05-44a0-8806-73ffd30bf1d1"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/UnionSets/unionsets6.\
pdf\"\>"], "Output",
 CellChangeTimes->{{3.9670230235549717`*^9, 3.967023046310792*^9}},
 CellLabel->"Out[74]=",ExpressionUUID->"2852064c-9528-4c1e-9aa5-8fea6e64c467"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DifferenceSets", "Section",
 CellChangeTimes->{
  3.967022448522291*^9},ExpressionUUID->"e1a4cafa-3a9d-4ffe-9513-\
29cca6e21af4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "DifferenceSets"}]], "Input",
 CellChangeTimes->{{3.9670224503624268`*^9, 3.967022472601482*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"bf60816e-3e28-4ef5-9136-d7407bb845e5"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DifferenceSets[filename, labels, fillColor, scale, \
showDifferenceLabel, ellipseSize] crea un diagrama de la diferencia de \
conjuntos en formato TikZ/LaTeX y lo exporta como archivo .tex en la carpeta \
Downloads/DifferenceSets.\\n\\nPAR\[CapitalAAcute]METROS:\\n- filename: \
String que especifica el nombre del archivo de salida (debe terminar en \
\\\".tex\\\")\\n- labels: Lista de etiquetas para identificar cada conjunto \
(m\[IAcute]nimo 2 elementos)\\n- fillColor: String que especifica el color de \
relleno de la diferencia (opcional, por defecto \\\"gray\\\")\\n- scale: Real \
que define la escala del diagrama completo (opcional, por defecto 1.2)\\n- \
showDifferenceLabel: True/False para mostrar la etiqueta matem\[AAcute]tica \
de la diferencia (opcional, por defecto False)\\n- ellipseSize: Lista {rx, \
ry} que define el radio horizontal y vertical de las elipses (opcional, por \
defecto {1.5, 1.8})\\n\\nCOLORES PREDEFINIDOS:\\nLos siguientes colores se \
convierten autom\[AAcute]ticamente a tonos TikZ apropiados:\\n- \\\"blue\\\" \
-> \\\"blue!50\\\"     \[Bullet] \\\"red\\\" -> \\\"red!50\\\"       \
\[Bullet] \\\"green\\\" -> \\\"green!50\\\"\\n- \\\"yellow\\\" -> \
\\\"yellow!60\\\" \[Bullet] \\\"orange\\\" -> \\\"orange!50\\\" \[Bullet] \
\\\"purple\\\" -> \\\"purple!50\\\"\\n- \\\"violet\\\" -> \\\"violet!50\\\" \
\[Bullet] \\\"cyan\\\" -> \\\"cyan!50\\\"     \[Bullet] \\\"magenta\\\" -> \\\
\"magenta!50\\\"\\n- \\\"pink\\\" -> \\\"pink!50\\\"     \[Bullet] \
\\\"brown\\\" -> \\\"brown!50\\\"   \[Bullet] \\\"black\\\" -> \\\"black!30\\\
\"\\n- \\\"gray\\\"/\\\"grey\\\" -> \\\"gray!85\\\"\\n- Cualquier otro string \
se usa directamente como color TikZ\\n\\nDISPOSICI\[CapitalOAcute]N AUTOM\
\[CapitalAAcute]TICA DE CONJUNTOS:\\n- 2 conjuntos: Disposici\[OAcute]n \
horizontal\\n- 3 conjuntos: Disposici\[OAcute]n triangular\\n- 4 conjuntos: \
Disposici\[OAcute]n en cuadrado\\n- 5 conjuntos: Disposici\[OAcute]n \
pentagonal\\n- 6+ conjuntos: Disposici\[OAcute]n circular \
autom\[AAcute]tica\\n\\nFUNCIONALIDAD:\\n- Genera c\[OAcute]digo TikZ \
completo con documento LaTeX standalone\\n- Sombreia completamente el PRIMER \
conjunto de la lista (A)\\n- \\\"Borra\\\" (dibuja en blanco) las \
intersecciones del primer conjunto con todos los dem\[AAcute]s\\n- El \
resultado visual es A \\\\ (B \:222a C \:222a ...), es decir, los elementos \
que est\[AAcute]n en A pero NO en ninguno de los otros conjuntos\\n- Dibuja \
los contornos de todas las elipses con l\[IAcute]neas negras gruesas\\n- \
Posiciona autom\[AAcute]ticamente las etiquetas fuera de las elipses\\n- La \
etiqueta de diferencia (si est\[AAcute] habilitada) se coloca cerca del \
primer conjunto\\n- Crea la carpeta Downloads/DifferenceSets si no existe\\n- \
Exporta el archivo .tex listo para compilar\\n\\nVALIDACIONES:\\n- El \
filename debe terminar obligatoriamente en \\\".tex\\\"\\n- La lista \
ellipseSize debe contener exactamente 2 elementos\\n- La lista labels debe \
contener al menos 2 elementos\\n- Retorna $Failed si alguna \
validaci\[OAcute]n falla\\n\\nVALOR DE RETORNO:\\nRetorna la ruta completa \
del archivo exportado, o $Failed en caso de error.\\n\\nEJEMPLOS:\\n- \
DifferenceSets[\\\"diferencia.tex\\\", {\\\"A\\\", \\\"B\\\"}] \\n  % Muestra \
A \\\\ B\\n- DifferenceSets[\\\"dif_tres.tex\\\", {\\\"X\\\", \\\"Y\\\", \
\\\"Z\\\"}, \\\"blue\\\", 1.5, True]\\n  % Muestra X \\\\ (Y \:222a Z)\\n- \
DifferenceSets[\\\"ejemplo.tex\\\", {\\\"A\\\", \\\"B\\\", \\\"C\\\", \\\"D\\\
\"}, \\\"red\\\", 1.0, False, {2.0, 2.5}]\\n  % Muestra A \\\\ (B \:222a C \
\:222a D)\\n\\nNOTA MATEM\[CapitalAAcute]TICA:\\nEsta funci\[OAcute]n \
visualiza A \\\\ (B \:222a C \:222a D \:222a ...), es decir, la diferencia \
del primer conjunto con la uni\[OAcute]n de todos los dem\[AAcute]s \
conjuntos. La regi\[OAcute]n sombreada representa elementos que pertenecen \
exclusivamente al primer conjunto (A) y a ninguno de los otros \
conjuntos.\\n\\nORDEN IMPORTANTE:\\nEl primer elemento de la lista 'labels' \
siempre representa el conjunto del cual se sustraen los dem\[AAcute]s. El \
orden de los elementos en la lista determina cu\[AAcute]l ser\[AAcute] el \
conjunto 'minuendo' en la operaci\[OAcute]n de diferencia.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"DifferenceSets", "[", 
                    
                    RowBox[{
                    "VilTeX`Private`filename_String", ",", 
                    "VilTeX`Private`labels_List", ",", 
                    
                    RowBox[{
                    "VilTeX`Private`fillColor_String", ":", "\"gray\""}], ",", 
                    RowBox[{"VilTeX`Private`scale_Real", ":", "1.2`"}], ",", 
                    
                    RowBox[{
                    "VilTeX`Private`showDifferenceLabel_", ":", "False"}], 
                    ",", 
                    RowBox[{"VilTeX`Private`ellipseSize_List", ":", 
                    RowBox[{"{", 
                    RowBox[{"1.5`", ",", "1.8`"}], "}"}]}]}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", ",", 
                    "VilTeX`Private`fullDocument", ",", 
                    "VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`folderPath", ",", "VilTeX`Private`rx", 
                    ",", "VilTeX`Private`ry", ",", 
                    "VilTeX`Private`processedColor", ",", 
                    "VilTeX`Private`numSets", ",", "VilTeX`Private`positions",
                     ",", "VilTeX`Private`ellipseDefinitions", ",", 
                    "VilTeX`Private`differenceCode", ",", 
                    "VilTeX`Private`labelsCode", ",", 
                    "VilTeX`Private`differenceLabelCode"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringEndsQ", "[", 
                    RowBox[{"VilTeX`Private`filename", ",", "\".tex\""}], 
                    "]"}]}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`ellipseSize", 
                    "]"}], "\[NotEqual]", "2"}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`labels", "]"}], 
                    "<", "2"}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`rx", ",", "VilTeX`Private`ry"}], 
                    "}"}], "=", "VilTeX`Private`ellipseSize"}], ";", 
                    RowBox[{"VilTeX`Private`numSets", "=", 
                    RowBox[{"Length", "[", "VilTeX`Private`labels", "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`processedColor", "=", 
                    RowBox[{"Switch", "[", 
                    
                    RowBox[{"VilTeX`Private`fillColor", ",", "\"blue\"", ",", 
                    "\"blue!50\"", ",", "\"red\"", ",", "\"red!50\"", ",", 
                    "\"green\"", ",", "\"green!50\"", ",", "\"yellow\"", ",", 
                    "\"yellow!60\"", ",", "\"orange\"", ",", "\"orange!50\"", 
                    ",", "\"purple\"", ",", "\"purple!50\"", ",", 
                    "\"violet\"", ",", "\"violet!50\"", ",", "\"cyan\"", ",", 
                    "\"cyan!50\"", ",", "\"magenta\"", ",", "\"magenta!50\"", 
                    ",", "\"pink\"", ",", "\"pink!50\"", ",", "\"brown\"", 
                    ",", "\"brown!50\"", ",", "\"black\"", ",", 
                    "\"black!30\"", ",", "\"gray\"", ",", "\"gray!85\"", ",", 
                    "\"grey\"", ",", "\"gray!85\"", ",", "_", ",", 
                    "VilTeX`Private`fillColor"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`positions", "=", 
                    RowBox[{"Switch", "[", 
                    RowBox[{"VilTeX`Private`numSets", ",", "2", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.8`"}], ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.8`", ",", "0"}], "}"}]}], "}"}], ",", "3", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.8`"}], ",", "0.6`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.8`", ",", "0.6`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{"-", "0.8`"}]}], "}"}]}], "}"}], ",", "4", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.8`"}], ",", "0.8`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.8`", ",", "0.8`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.8`"}], ",", 
                    RowBox[{"-", "0.8`"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.8`", ",", 
                    RowBox[{"-", "0.8`"}]}], "}"}]}], "}"}], ",", "5", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1.2`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"1.1`", ",", "0.37`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.68`", ",", 
                    RowBox[{"-", "0.97`"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.68`"}], ",", 
                    RowBox[{"-", "0.97`"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1.1`"}], ",", "0.37`"}], "}"}]}], "}"}], 
                    ",", "_", ",", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"1.2`", " ", 
                    RowBox[{"Cos", "[", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ")"}]}], 
                    "VilTeX`Private`numSets"], "]"}]}], ",", 
                    RowBox[{"1.2`", " ", 
                    RowBox[{"Sin", "[", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ")"}]}], 
                    "VilTeX`Private`numSets"], "]"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numSets"}], "}"}]}], "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`ellipseDefinitions", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"\\\\def\\\\ellipse\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "<>", 
                    "\"{(\"", "<>", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\") ellipse (\"",
                     "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`rx", "]"}], "<>",
                     "\" and \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`ry", "]"}], "<>",
                     "\")}\\n\""}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numSets"}], "}"}]}], "]"}], "]"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`differenceCode", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"% Sombrear el primer conjunto (A)\\n\"", ",", 
                    
                    RowBox[{"\"\\\\fill[\"", "<>", 
                    "VilTeX`Private`processedColor", "<>", 
                    "\"] \\\\ellipse\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "<>", "\";\\n\\n\""}], 
                    ",", "\"% Borrar la intersecci\[OAcute]n con los dem\
\[AAcute]s conjuntos\\n\"", ",", "\"\\\\begin{scope}\\n\"", ",", 
                    RowBox[{"\"    \\\\clip \\\\ellipse\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "<>", "\";\\n\""}], ",", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"    \\\\fill[white] \\\\ellipse\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "<>", 
                    "\";\\n\""}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", "2", ",", 
                    "VilTeX`Private`numSets"}], "}"}]}], "]"}], "]"}], ",", 
                    "\"\\\\end{scope}\\n\\n\""}], "}"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`labelsCode", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"\\\\node at (\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "+", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "<", "0"}], ",", 
                    RowBox[{
                    RowBox[{"-", "VilTeX`Private`rx"}], " ", "0.8`"}], ",", 
                    RowBox[{"VilTeX`Private`rx", " ", "0.8`"}]}], "]"}]}], 
                    "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", 
                    "\") {\\\\Large $\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "<>", 
                    "\"$};\\n\""}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numSets"}], "}"}]}], "]"}], "]"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`differenceLabelCode", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`showDifferenceLabel", ",", 
                    
                    RowBox[{
                    "\"% Etiqueta para la diferencia\\n\\\\node at (\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}], "-", 
                    RowBox[{"VilTeX`Private`rx", " ", "0.3`"}]}], "]"}], "<>",
                     "\",\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"1", ",", "2"}], "\[RightDoubleBracket]"}], "+", 
                    RowBox[{"VilTeX`Private`ry", " ", "1.2`"}]}], "]"}], "<>",
                     "\") {\\\\small $\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "<>", 
                    "\" \\\\setminus (\"", "<>", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`numSets", "\[Equal]", "2"}], ",", 
                    
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    RowBox[{"2", ";;", 
                    RowBox[{"-", "1"}]}], "\[RightDoubleBracket]"}], ",", 
                    "\" \\\\cup \""}], "]"}]}], "]"}], "<>", 
                    "\")$};\\n\\n\""}], ",", "\"\""}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\\\\begin{tikzpicture}[scale=\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`scale", "]"}], 
                    "<>", "\"]\\n\\n\""}], ",", 
                    "\"% Definir las elipses\\n\"", ",", 
                    "VilTeX`Private`ellipseDefinitions", ",", "\"\\n\"", ",", 
                    "VilTeX`Private`differenceCode", ",", 
                    "\"% Dibujar los contornos de las elipses\\n\"", ",", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"\\\\draw[black, thick] \\\\ellipse\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "<>", 
                    "\";\\n\""}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numSets"}], "}"}]}], "]"}], "]"}], ",", 
                    "\"\\n\"", ",", "\"% Etiquetas\\n\"", ",", 
                    "VilTeX`Private`labelsCode", ",", "\"\\n\"", ",", 
                    "VilTeX`Private`differenceLabelCode", ",", 
                    "\"\\\\end{tikzpicture}\""}], "}"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`fullDocument", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{
                    "\"\\\\documentclass[border=5mm]{standalone}\\n\"", ",", 
                    "\"\\\\usepackage{tikz}\\n\"", ",", 
                    "\"\\\\usepackage{amsmath}\\n\"", ",", 
                    "\"\\\\usetikzlibrary{patterns}\\n\\n\"", ",", 
                    "\"\\\\begin{document}\\n\"", ",", 
                    "VilTeX`Private`tikzCode", ",", 
                    "\"\\n\\\\end{document}\""}], "}"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`folderPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"$HomeDirectory", ",", "\"Downloads\"", ",", 
                    "\"DifferenceSets\""}], "}"}], "]"}]}], ";", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"DirectoryQ", "[", "VilTeX`Private`folderPath", 
                    "]"}]}], ",", 
                    
                    RowBox[{"CreateDirectory", "[", 
                    "VilTeX`Private`folderPath", "]"}]}], "]"}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`downloadPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`folderPath", ",", 
                    "VilTeX`Private`filename"}], "}"}], "]"}]}], ";", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"Export", "[", 
                    
                    RowBox[{"VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`fullDocument", ",", "\"Text\""}], "]"}], 
                    "]"}], ";", "VilTeX`Private`downloadPath"}]}], "]"}]}]}, {
                   " "}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilTeX`DifferenceSets\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DifferenceSets[filename, labels, fillColor, scale, \
showDifferenceLabel, ellipseSize] crea un diagrama de la diferencia de \
conjuntos en formato TikZ/LaTeX y lo exporta como archivo .tex en la carpeta \
Downloads/DifferenceSets.\\n\\nPAR\[CapitalAAcute]METROS:\\n- filename: \
String que especifica el nombre del archivo de salida (debe terminar en \
\\\".tex\\\")\\n- labels: Lista de etiquetas para identificar cada conjunto \
(m\[IAcute]nimo 2 elementos)\\n- fillColor: String que especifica el color de \
relleno de la diferencia (opcional, por defecto \\\"gray\\\")\\n- scale: Real \
que define la escala del diagrama completo (opcional, por defecto 1.2)\\n- \
showDifferenceLabel: True/False para mostrar la etiqueta matem\[AAcute]tica \
de la diferencia (opcional, por defecto False)\\n- ellipseSize: Lista {rx, \
ry} que define el radio horizontal y vertical de las elipses (opcional, por \
defecto {1.5, 1.8})\\n\\nCOLORES PREDEFINIDOS:\\nLos siguientes colores se \
convierten autom\[AAcute]ticamente a tonos TikZ apropiados:\\n- \\\"blue\\\" \
-> \\\"blue!50\\\"     \[Bullet] \\\"red\\\" -> \\\"red!50\\\"       \
\[Bullet] \\\"green\\\" -> \\\"green!50\\\"\\n- \\\"yellow\\\" -> \
\\\"yellow!60\\\" \[Bullet] \\\"orange\\\" -> \\\"orange!50\\\" \[Bullet] \
\\\"purple\\\" -> \\\"purple!50\\\"\\n- \\\"violet\\\" -> \\\"violet!50\\\" \
\[Bullet] \\\"cyan\\\" -> \\\"cyan!50\\\"     \[Bullet] \\\"magenta\\\" -> \\\
\"magenta!50\\\"\\n- \\\"pink\\\" -> \\\"pink!50\\\"     \[Bullet] \
\\\"brown\\\" -> \\\"brown!50\\\"   \[Bullet] \\\"black\\\" -> \\\"black!30\\\
\"\\n- \\\"gray\\\"/\\\"grey\\\" -> \\\"gray!85\\\"\\n- Cualquier otro string \
se usa directamente como color TikZ\\n\\nDISPOSICI\[CapitalOAcute]N AUTOM\
\[CapitalAAcute]TICA DE CONJUNTOS:\\n- 2 conjuntos: Disposici\[OAcute]n \
horizontal\\n- 3 conjuntos: Disposici\[OAcute]n triangular\\n- 4 conjuntos: \
Disposici\[OAcute]n en cuadrado\\n- 5 conjuntos: Disposici\[OAcute]n \
pentagonal\\n- 6+ conjuntos: Disposici\[OAcute]n circular \
autom\[AAcute]tica\\n\\nFUNCIONALIDAD:\\n- Genera c\[OAcute]digo TikZ \
completo con documento LaTeX standalone\\n- Sombreia completamente el PRIMER \
conjunto de la lista (A)\\n- \\\"Borra\\\" (dibuja en blanco) las \
intersecciones del primer conjunto con todos los dem\[AAcute]s\\n- El \
resultado visual es A \\\\ (B \:222a C \:222a ...), es decir, los elementos \
que est\[AAcute]n en A pero NO en ninguno de los otros conjuntos\\n- Dibuja \
los contornos de todas las elipses con l\[IAcute]neas negras gruesas\\n- \
Posiciona autom\[AAcute]ticamente las etiquetas fuera de las elipses\\n- La \
etiqueta de diferencia (si est\[AAcute] habilitada) se coloca cerca del \
primer conjunto\\n- Crea la carpeta Downloads/DifferenceSets si no existe\\n- \
Exporta el archivo .tex listo para compilar\\n\\nVALIDACIONES:\\n- El \
filename debe terminar obligatoriamente en \\\".tex\\\"\\n- La lista \
ellipseSize debe contener exactamente 2 elementos\\n- La lista labels debe \
contener al menos 2 elementos\\n- Retorna $Failed si alguna \
validaci\[OAcute]n falla\\n\\nVALOR DE RETORNO:\\nRetorna la ruta completa \
del archivo exportado, o $Failed en caso de error.\\n\\nEJEMPLOS:\\n- \
DifferenceSets[\\\"diferencia.tex\\\", {\\\"A\\\", \\\"B\\\"}] \\n  % Muestra \
A \\\\ B\\n- DifferenceSets[\\\"dif_tres.tex\\\", {\\\"X\\\", \\\"Y\\\", \
\\\"Z\\\"}, \\\"blue\\\", 1.5, True]\\n  % Muestra X \\\\ (Y \:222a Z)\\n- \
DifferenceSets[\\\"ejemplo.tex\\\", {\\\"A\\\", \\\"B\\\", \\\"C\\\", \\\"D\\\
\"}, \\\"red\\\", 1.0, False, {2.0, 2.5}]\\n  % Muestra A \\\\ (B \:222a C \
\:222a D)\\n\\nNOTA MATEM\[CapitalAAcute]TICA:\\nEsta funci\[OAcute]n \
visualiza A \\\\ (B \:222a C \:222a D \:222a ...), es decir, la diferencia \
del primer conjunto con la uni\[OAcute]n de todos los dem\[AAcute]s \
conjuntos. La regi\[OAcute]n sombreada representa elementos que pertenecen \
exclusivamente al primer conjunto (A) y a ninguno de los otros \
conjuntos.\\n\\nORDEN IMPORTANTE:\\nEl primer elemento de la lista 'labels' \
siempre representa el conjunto del cual se sustraen los dem\[AAcute]s. El \
orden de los elementos en la lista determina cu\[AAcute]l ser\[AAcute] el \
conjunto 'minuendo' en la operaci\[OAcute]n de diferencia.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}},
            ScrollPosition->{0., 0.}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "DifferenceSets[filename, labels, fillColor, scale, showDifferenceLabel, \
ellipseSize] crea un diagrama de la diferencia de conjuntos en formato \
TikZ/LaTeX y lo exporta como archivo .tex en la carpeta \
Downloads/DifferenceSets.\n\nPAR\[CapitalAAcute]METROS:\n- filename: String \
que especifica el nombre del archivo de salida (debe terminar en \".tex\")\n- \
labels: Lista de etiquetas para identificar cada conjunto (m\[IAcute]nimo 2 \
elementos)\n- fillColor: String que especifica el color de relleno de la \
diferencia (opcional, por defecto \"gray\")\n- scale: Real que define la \
escala del diagrama completo (opcional, por defecto 1.2)\n- \
showDifferenceLabel: True/False para mostrar la etiqueta matem\[AAcute]tica \
de la diferencia (opcional, por defecto False)\n- ellipseSize: Lista {rx, ry} \
que define el radio horizontal y vertical de las elipses (opcional, por \
defecto {1.5, 1.8})\n\nCOLORES PREDEFINIDOS:\nLos siguientes colores se \
convierten autom\[AAcute]ticamente a tonos TikZ apropiados:\n- \"blue\" -> \
\"blue!50\"     \[Bullet] \"red\" -> \"red!50\"       \[Bullet] \"green\" -> \
\"green!50\"\n- \"yellow\" -> \"yellow!60\" \[Bullet] \"orange\" -> \
\"orange!50\" \[Bullet] \"purple\" -> \"purple!50\"\n- \"violet\" -> \
\"violet!50\" \[Bullet] \"cyan\" -> \"cyan!50\"     \[Bullet] \"magenta\" -> \
\"magenta!50\"\n- \"pink\" -> \"pink!50\"     \[Bullet] \"brown\" -> \
\"brown!50\"   \[Bullet] \"black\" -> \"black!30\"\n- \"gray\"/\"grey\" -> \
\"gray!85\"\n- Cualquier otro string se usa directamente como color TikZ\n\n\
DISPOSICI\[CapitalOAcute]N AUTOM\[CapitalAAcute]TICA DE CONJUNTOS:\n- 2 \
conjuntos: Disposici\[OAcute]n horizontal\n- 3 conjuntos: Disposici\[OAcute]n \
triangular\n- 4 conjuntos: Disposici\[OAcute]n en cuadrado\n- 5 conjuntos: \
Disposici\[OAcute]n pentagonal\n- 6+ conjuntos: Disposici\[OAcute]n circular \
autom\[AAcute]tica\n\nFUNCIONALIDAD:\n- Genera c\[OAcute]digo TikZ completo \
con documento LaTeX standalone\n- Sombreia completamente el PRIMER conjunto \
de la lista (A)\n- \"Borra\" (dibuja en blanco) las intersecciones del primer \
conjunto con todos los dem\[AAcute]s\n- El resultado visual es A \\ (B \:222a \
C \:222a ...), es decir, los elementos que est\[AAcute]n en A pero NO en \
ninguno de los otros conjuntos\n- Dibuja los contornos de todas las elipses \
con l\[IAcute]neas negras gruesas\n- Posiciona autom\[AAcute]ticamente las \
etiquetas fuera de las elipses\n- La etiqueta de diferencia (si est\[AAcute] \
habilitada) se coloca cerca del primer conjunto\n- Crea la carpeta \
Downloads/DifferenceSets si no existe\n- Exporta el archivo .tex listo para \
compilar\n\nVALIDACIONES:\n- El filename debe terminar obligatoriamente en \
\".tex\"\n- La lista ellipseSize debe contener exactamente 2 elementos\n- La \
lista labels debe contener al menos 2 elementos\n- Retorna $Failed si alguna \
validaci\[OAcute]n falla\n\nVALOR DE RETORNO:\nRetorna la ruta completa del \
archivo exportado, o $Failed en caso de error.\n\nEJEMPLOS:\n- \
DifferenceSets[\"diferencia.tex\", {\"A\", \"B\"}] \n  % Muestra A \\ B\n- \
DifferenceSets[\"dif_tres.tex\", {\"X\", \"Y\", \"Z\"}, \"blue\", 1.5, True]\n\
  % Muestra X \\ (Y \:222a Z)\n- DifferenceSets[\"ejemplo.tex\", {\"A\", \
\"B\", \"C\", \"D\"}, \"red\", 1.0, False, {2.0, 2.5}]\n  % Muestra A \\ (B \
\:222a C \:222a D)\n\nNOTA MATEM\[CapitalAAcute]TICA:\nEsta funci\[OAcute]n \
visualiza A \\ (B \:222a C \:222a D \:222a ...), es decir, la diferencia del \
primer conjunto con la uni\[OAcute]n de todos los dem\[AAcute]s conjuntos. La \
regi\[OAcute]n sombreada representa elementos que pertenecen exclusivamente \
al primer conjunto (A) y a ninguno de los otros conjuntos.\n\nORDEN \
IMPORTANTE:\nEl primer elemento de la lista 'labels' siempre representa el \
conjunto del cual se sustraen los dem\[AAcute]s. El orden de los elementos en \
la lista determina cu\[AAcute]l ser\[AAcute] el conjunto 'minuendo' en la \
operaci\[OAcute]n de diferencia.", "Documentation" -> None, "OwnValues" -> 
    None, "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilTeX`DifferenceSets, {VilTeX`DifferenceSets[
         Pattern[VilTeX`Private`filename, 
          Blank[String]], 
         Pattern[VilTeX`Private`labels, 
          Blank[List]], 
         Optional[
          Pattern[VilTeX`Private`fillColor, 
           Blank[String]], "gray"], 
         Optional[
          Pattern[VilTeX`Private`scale, 
           Blank[Real]], 1.2], 
         Optional[
          Pattern[VilTeX`Private`showDifferenceLabel, 
           Blank[]], False], 
         Optional[
          Pattern[VilTeX`Private`ellipseSize, 
           Blank[List]], {1.5, 1.8}]] :> 
       Module[{VilTeX`Private`tikzCode, VilTeX`Private`fullDocument, 
          VilTeX`Private`downloadPath, VilTeX`Private`folderPath, 
          VilTeX`Private`rx, VilTeX`Private`ry, VilTeX`Private`processedColor,
           VilTeX`Private`numSets, VilTeX`Private`positions, 
          VilTeX`Private`ellipseDefinitions, VilTeX`Private`differenceCode, 
          VilTeX`Private`labelsCode, VilTeX`Private`differenceLabelCode}, If[
           Not[
            StringEndsQ[VilTeX`Private`filename, ".tex"]], 
           Return[$Failed]]; If[Length[VilTeX`Private`ellipseSize] != 2, 
           Return[$Failed]]; If[Length[VilTeX`Private`labels] < 2, 
           Return[$Failed]]; {VilTeX`Private`rx, VilTeX`Private`ry} = 
          VilTeX`Private`ellipseSize; 
         VilTeX`Private`numSets = Length[VilTeX`Private`labels]; 
         VilTeX`Private`processedColor = 
          Switch[VilTeX`Private`fillColor, "blue", "blue!50", "red", "red!50",
             "green", "green!50", "yellow", "yellow!60", "orange", 
            "orange!50", "purple", "purple!50", "violet", "violet!50", "cyan",
             "cyan!50", "magenta", "magenta!50", "pink", "pink!50", "brown", 
            "brown!50", "black", "black!30", "gray", "gray!85", "grey", 
            "gray!85", 
            Blank[], VilTeX`Private`fillColor]; 
         VilTeX`Private`positions = 
          Switch[VilTeX`Private`numSets, 2, {{-0.8, 0}, {0.8, 0}}, 
            3, {{-0.8, 0.6}, {0.8, 0.6}, {0, -0.8}}, 4, {{-0.8, 0.8}, {0.8, 
            0.8}, {-0.8, -0.8}, {0.8, -0.8}}, 
            5, {{0, 1.2}, {1.1, 0.37}, {0.68, -0.97}, {-0.68, -0.97}, {-1.1, 
             0.37}}, 
            Blank[], 
            
            Table[{1.2 
              Cos[2 Pi ((VilTeX`Private`i - 1)/VilTeX`Private`numSets)], 1.2 
              Sin[2 Pi ((VilTeX`Private`i - 1)/VilTeX`Private`numSets)]}, {
             VilTeX`Private`i, VilTeX`Private`numSets}]]; 
         VilTeX`Private`ellipseDefinitions = StringJoin[
            Table[
            "\\def\\ellipse" <> Part[VilTeX`Private`labels, VilTeX`Private`i] <> 
             "{(" <> ToString[
               Part[VilTeX`Private`positions, VilTeX`Private`i, 1]] <> "," <> 
             ToString[
               Part[VilTeX`Private`positions, VilTeX`Private`i, 2]] <> 
             ") ellipse (" <> ToString[VilTeX`Private`rx] <> " and " <> 
             ToString[VilTeX`Private`ry] <> ")}\n", {
             VilTeX`Private`i, VilTeX`Private`numSets}]]; 
         VilTeX`Private`differenceCode = 
          StringJoin[{
            "% Sombrear el primer conjunto (A)\n", "\\fill[" <> 
             VilTeX`Private`processedColor <> "] \\ellipse" <> 
             Part[VilTeX`Private`labels, 1] <> ";\n\n", 
             "% Borrar la intersecci\[OAcute]n con los dem\[AAcute]s \
conjuntos\n", "\\begin{scope}\n", "    \\clip \\ellipse" <> 
             Part[VilTeX`Private`labels, 1] <> ";\n", 
             StringJoin[
              Table[
              "    \\fill[white] \\ellipse" <> 
               Part[VilTeX`Private`labels, VilTeX`Private`i] <> ";\n", {
               VilTeX`Private`i, 2, VilTeX`Private`numSets}]], 
             "\\end{scope}\n\n"}]; VilTeX`Private`labelsCode = StringJoin[
            Table[
            "\\node at (" <> 
             ToString[
              Part[VilTeX`Private`positions, VilTeX`Private`i, 1] + 
               If[Part[VilTeX`Private`positions, VilTeX`Private`i, 1] < 
                 0, (-VilTeX`Private`rx) 0.8, VilTeX`Private`rx 0.8]] <> "," <> 
             ToString[
               Part[VilTeX`Private`positions, VilTeX`Private`i, 2]] <> 
             ") {\\Large $" <> Part[VilTeX`Private`labels, VilTeX`Private`i] <> 
             "$};\n", {VilTeX`Private`i, VilTeX`Private`numSets}]]; 
         VilTeX`Private`differenceLabelCode = 
          If[VilTeX`Private`showDifferenceLabel, 
            "% Etiqueta para la diferencia\n\\node at (" <> 
            ToString[
             Part[VilTeX`Private`positions, 1, 1] - VilTeX`Private`rx 0.3] <> 
            "," <> ToString[
             Part[VilTeX`Private`positions, 1, 2] + VilTeX`Private`ry 1.2] <> 
            ") {\\small $" <> Part[VilTeX`Private`labels, 1] <> 
            " \\setminus (" <> If[VilTeX`Private`numSets == 2, 
              Part[VilTeX`Private`labels, 2], 
              StringRiffle[
               Part[VilTeX`Private`labels, 
                Span[2, -1]], " \\cup "]] <> ")$};\n\n", ""]; 
         VilTeX`Private`tikzCode = 
          StringJoin[{
            "\\begin{tikzpicture}[scale=" <> ToString[VilTeX`Private`scale] <> 
             "]\n\n", "% Definir las elipses\n", 
             VilTeX`Private`ellipseDefinitions, "\n", 
             VilTeX`Private`differenceCode, 
             "% Dibujar los contornos de las elipses\n", 
             StringJoin[
              Table[
              "\\draw[black, thick] \\ellipse" <> 
               Part[VilTeX`Private`labels, VilTeX`Private`i] <> ";\n", {
               VilTeX`Private`i, VilTeX`Private`numSets}]], "\n", 
             "% Etiquetas\n", VilTeX`Private`labelsCode, "\n", 
             VilTeX`Private`differenceLabelCode, "\\end{tikzpicture}"}]; 
         VilTeX`Private`fullDocument = 
          StringJoin[{
            "\\documentclass[border=5mm]{standalone}\n", 
             "\\usepackage{tikz}\n", "\\usepackage{amsmath}\n", 
             "\\usetikzlibrary{patterns}\n\n", "\\begin{document}\n", 
             VilTeX`Private`tikzCode, "\n\\end{document}"}]; 
         VilTeX`Private`folderPath = 
          FileNameJoin[{$HomeDirectory, "Downloads", "DifferenceSets"}]; Quiet[
           If[
            Not[
             DirectoryQ[VilTeX`Private`folderPath]], 
            CreateDirectory[VilTeX`Private`folderPath]]]; 
         VilTeX`Private`downloadPath = 
          FileNameJoin[{VilTeX`Private`folderPath, VilTeX`Private`filename}]; 
         Quiet[
           Export[
           VilTeX`Private`downloadPath, VilTeX`Private`fullDocument, "Text"]]; 
         VilTeX`Private`downloadPath]}], "SubValues" -> None, "DefaultValues" -> 
    None, "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {Protected}, "FullName" -> "VilTeX`DifferenceSets"|>, 
   False]]], "Output",
 CellChangeTimes->{3.967022473897202*^9},
 CellLabel->"Out[57]=",ExpressionUUID->"ae59a830-215e-4739-96c3-d4da003aeb5a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 1: diferencia b\[AAcute]sica A\\B", "Subsection",
 CellChangeTimes->{{3.9669722155811577`*^9, 3.966972227370956*^9}, {
  3.96697269501637*^9, 3.966972698074332*^9}, {3.967023148382935*^9, 
  3.967023152953474*^9}},ExpressionUUID->"e5945e16-134c-4ba4-a729-\
cfede4a3e916"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DifferenceSets", "[", 
   RowBox[{"\"\<diferencia1.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}], ",", "\"\<blue\>\""}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967021500218103*^9, 3.967021539009901*^9}, 
   3.967021672805071*^9, {3.967023125807685*^9, 3.967023138872311*^9}},
 CellLabel->"In[75]:=",ExpressionUUID->"30ffe0f8-89df-4f6d-a9e7-cc06ed026659"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023360253193*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[75]:=",ExpressionUUID->"58b682a5-1083-4179-a09c-e90f4e441c60"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.967023360254499*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[75]:=",ExpressionUUID->"5b1ce6f5-76ca-44ec-b270-2eadc738759e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023360255575*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[75]:=",ExpressionUUID->"8d33f8c1-87a0-4e84-8f68-1f428a89bded"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023360256226*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[75]:=",ExpressionUUID->"90699e1b-69f5-438e-bed5-50708c6d1ddd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023360256834*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[75]:=",ExpressionUUID->"e90e72f0-866e-4363-867f-f3ba415e9717"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.96702336032031*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[75]:=",ExpressionUUID->"80687ab6-1d77-4ea0-8d0f-7866596d74a6"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.96702336132784*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[75]:=",ExpressionUUID->"216d3fcf-ea85-42fc-8e51-d39ca07fc92c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/DifferenceSets/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/DifferenceSets/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023361332158*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[75]:=",ExpressionUUID->"7e74909d-0233-4762-982c-21242c9153b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"diferencia1\"\>"}],
  SequenceForm["Archivo: ", "diferencia1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023361335496*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[75]:=",ExpressionUUID->"b290e891-3ee0-4a46-bb53-f5a6769a0cef"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.967023361784958*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[75]:=",ExpressionUUID->"0c934084-c02d-450a-82fd-b2447df7fe74"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/DifferenceSets/diferencia1.pdf\"\>\
"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/DifferenceSets/diferencia1.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023361785617*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[75]:=",ExpressionUUID->"38d35dfe-07fd-4402-8731-0ed919d69425"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/DifferenceSets/\
diferencia1.pdf\"\>"], "Output",
 CellChangeTimes->{3.96702336179867*^9},
 CellLabel->"Out[76]=",ExpressionUUID->"1a09ff6a-f368-4f87-9cd5-fada6f697998"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 2: Diferencia A\\(B \:222a C)", "Subsection",
 CellChangeTimes->{{3.9669722155811577`*^9, 3.966972227370956*^9}, {
  3.96697269501637*^9, 3.966972698074332*^9}, {3.967021692623477*^9, 
  3.967021693203027*^9}, {3.967021739781867*^9, 3.967021740308218*^9}, {
  3.967023164600575*^9, 
  3.967023166640238*^9}},ExpressionUUID->"951bc8ce-eab9-4c95-b5d3-\
66da3c16283f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DifferenceSets", "[", 
   RowBox[{"\"\<diferencia2.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\"", ",", "\"\<C\>\""}], "}"}], 
    ",", "\"\<red\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967021500218103*^9, 3.967021539009901*^9}, 
   3.967021672805071*^9, {3.967021723404994*^9, 3.9670217365279837`*^9}, {
   3.9670231796657257`*^9, 3.967023191214205*^9}},
 CellLabel->"In[77]:=",ExpressionUUID->"9d994794-b2c5-43ce-bcba-ca567cf54540"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023371909666*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[77]:=",ExpressionUUID->"463e9996-28a8-4a62-9b4d-58ba67c18857"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.967023371911276*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[77]:=",ExpressionUUID->"f227a80e-f4cc-4db5-a379-25e63172e1b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023371912591*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[77]:=",ExpressionUUID->"0f3029cd-eeed-4827-b59d-5b62873f06de"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670233719133244`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[77]:=",ExpressionUUID->"2a7e0f96-1d60-416f-9f72-db99cd02ba90"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670233719140377`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[77]:=",ExpressionUUID->"1828c12a-e75f-4bbd-8460-73bc909763d4"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967023371992016*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[77]:=",ExpressionUUID->"934c2245-12a1-4fdf-821c-9ba4989626de"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.9670233729987717`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[77]:=",ExpressionUUID->"749538cc-5581-4e64-9cd7-5dc84cc3773f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/DifferenceSets/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/DifferenceSets/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023373003134*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[77]:=",ExpressionUUID->"6fd85552-833b-4492-9654-b2fd429e46dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"diferencia2\"\>"}],
  SequenceForm["Archivo: ", "diferencia2"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023373006312*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[77]:=",ExpressionUUID->"d583d138-c29d-491b-829b-a029a073667d"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.9670233734616013`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[77]:=",ExpressionUUID->"01bb7f4e-2b09-437f-84b2-99b77e0dd74c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/DifferenceSets/diferencia2.pdf\"\>\
"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/DifferenceSets/diferencia2.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023373462371*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[77]:=",ExpressionUUID->"94308363-7e53-4523-80e7-47d2140485f4"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/DifferenceSets/\
diferencia2.pdf\"\>"], "Output",
 CellChangeTimes->{3.967023373474586*^9},
 CellLabel->"Out[78]=",ExpressionUUID->"5ef1fa31-4889-4b2d-a39b-73686afcf2c7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 3: Diferencia A\\(B \:222a C \:222a D)", "Subsection",
 CellChangeTimes->{{3.9669722155811577`*^9, 3.966972227370956*^9}, {
  3.96697269501637*^9, 3.966972698074332*^9}, {3.967021692623477*^9, 
  3.967021693203027*^9}, {3.967021739781867*^9, 3.967021740308218*^9}, {
  3.9670220235241613`*^9, 3.967022026511013*^9}, {3.9670232336793537`*^9, 
  3.96702323738913*^9}},ExpressionUUID->"484ce8f5-3380-4cd0-89e1-\
2f73bb9fe1de"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DifferenceSets", "[", 
   RowBox[{"\"\<diferencia3.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\"", ",", "\"\<C\>\"", 
      ",", "\"\<D\>\""}], "}"}], ",", "\"\<purple\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967021500218103*^9, 3.967021539009901*^9}, 
   3.967021672805071*^9, {3.967021723404994*^9, 3.9670217365279837`*^9}, 
   3.967022030968194*^9, {3.967022064956696*^9, 3.967022065287479*^9}, {
   3.9670222461414547`*^9, 3.967022249781415*^9}, {3.967022290032826*^9, 
   3.967022291774508*^9}, {3.967023250835189*^9, 3.967023264123765*^9}},
 CellLabel->"In[79]:=",ExpressionUUID->"a67a3090-16a1-4c64-9be8-b4a618c03408"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023387234634*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[79]:=",ExpressionUUID->"a73e836e-e6a1-44b2-b2e7-41c41de4ca0f"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.967023387236293*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[79]:=",ExpressionUUID->"bfd8ebea-b396-4498-835e-f8214aae2753"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670233872375727`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[79]:=",ExpressionUUID->"b05f773a-e3e6-4912-92bc-481319cebb58"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670233872382307`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[79]:=",ExpressionUUID->"b337e5de-b236-4c7a-a489-d2aaaefc977b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023387238845*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[79]:=",ExpressionUUID->"92f90418-7264-41bf-8d8d-92dc3be2e0f2"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.9670233873300467`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[79]:=",ExpressionUUID->"df2882a8-665c-47c5-9d13-50b8c63e4ae1"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.967023388337833*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[79]:=",ExpressionUUID->"7dfb120f-9043-4d3b-bf41-fcd67807d177"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/DifferenceSets/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/DifferenceSets/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023388342647*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[79]:=",ExpressionUUID->"5c78b604-845a-4af2-af82-0aebe775f76c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"diferencia3\"\>"}],
  SequenceForm["Archivo: ", "diferencia3"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023388346064*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[79]:=",ExpressionUUID->"86041328-f231-4193-9fb0-d8a1d8f62180"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.96702338879108*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[79]:=",ExpressionUUID->"762880ef-f2fc-45ce-a790-f6b10cae9b31"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/DifferenceSets/diferencia3.pdf\"\>\
"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/DifferenceSets/diferencia3.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670233887918653`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[79]:=",ExpressionUUID->"e2029752-4c74-474e-98ba-da169a91bf23"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/DifferenceSets/\
diferencia3.pdf\"\>"], "Output",
 CellChangeTimes->{3.967023388804365*^9},
 CellLabel->"Out[80]=",ExpressionUUID->"1ec003f0-3008-465d-8adb-8e396c52e2da"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 4: con etiqueta de diferencia", "Subsection",
 CellChangeTimes->{{3.9669722155811577`*^9, 3.966972227370956*^9}, {
   3.96697269501637*^9, 3.966972698074332*^9}, {3.967021692623477*^9, 
   3.967021693203027*^9}, {3.967021739781867*^9, 3.967021754858276*^9}, {
   3.967021813019991*^9, 3.967021818163364*^9}, 3.967022105184704*^9, 
   3.967022214304068*^9, {3.967023207016006*^9, 
   3.9670232089780207`*^9}},ExpressionUUID->"7d9a9ee1-10d5-412a-a40e-\
ebfacb64b345"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DifferenceSets", "[", 
   RowBox[{"\"\<diferencia4.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<X\>\"", ",", "\"\<Y\>\""}], "}"}], ",", "\"\<green\>\"", ",",
     "1.5", ",", "True"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967021500218103*^9, 3.967021539009901*^9}, 
   3.967021672805071*^9, {3.967021723404994*^9, 3.9670217365279837`*^9}, {
   3.967021772154702*^9, 3.9670217724637127`*^9}, {3.967021824945944*^9, 
   3.9670218349035807`*^9}, {3.967021871834454*^9, 3.967021905603507*^9}, 
   3.9670222209400387`*^9, {3.9670232175621147`*^9, 3.967023221710644*^9}, {
   3.967023254987845*^9, 3.967023272045617*^9}, 3.96702340546408*^9},
 CellLabel->"In[81]:=",ExpressionUUID->"70c8f00c-ffb6-451c-8311-1003eeefa6df"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023406398149*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[81]:=",ExpressionUUID->"a6dd9ac7-2a88-4c1f-b3a6-5460b5807223"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.967023406399328*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[81]:=",ExpressionUUID->"c4d32e64-9e0d-4742-aa75-9ac769ebd524"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670234064004793`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[81]:=",ExpressionUUID->"63074859-b715-4a23-b585-9c3f34ed6180"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.96702340640106*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[81]:=",ExpressionUUID->"befdcc9c-d95a-4d40-b4e2-ce26709c3b52"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670234064016237`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[81]:=",ExpressionUUID->"8694505a-654c-4ec4-9ff5-633e43e1d8c1"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.9670234064775133`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[81]:=",ExpressionUUID->"ae073e26-c7fe-4dc2-98b3-98089dc8ebfa"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.9670234074838448`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[81]:=",ExpressionUUID->"17aa48f5-ad5f-400b-a183-b93ad67969e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/DifferenceSets/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/DifferenceSets/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670234074883633`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[81]:=",ExpressionUUID->"e2c13d62-c1a2-4ab9-bee1-13899efc194c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"diferencia4\"\>"}],
  SequenceForm["Archivo: ", "diferencia4"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023407491403*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[81]:=",ExpressionUUID->"88cfb379-7f1d-4f4f-9cae-17bf03d298f0"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.967023407939423*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[81]:=",ExpressionUUID->"62a40b6a-e125-4c48-8a98-30c33130664b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/DifferenceSets/diferencia4.pdf\"\>\
"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/DifferenceSets/diferencia4.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023407940238*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[81]:=",ExpressionUUID->"ea9e07eb-31be-48ac-b83f-d34aa21bd315"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/DifferenceSets/\
diferencia4.pdf\"\>"], "Output",
 CellChangeTimes->{3.967023407953081*^9},
 CellLabel->"Out[82]=",ExpressionUUID->"a475e9be-bd6a-4187-90d7-c2038849c31c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 5: elipses m\[AAcute]s peque\[NTilde]as", "Subsection",
 CellChangeTimes->{{3.9669722155811577`*^9, 3.966972227370956*^9}, {
   3.96697269501637*^9, 3.966972698074332*^9}, {3.967021692623477*^9, 
   3.967021693203027*^9}, {3.967021739781867*^9, 3.967021754858276*^9}, {
   3.967021813019991*^9, 3.967021818163364*^9}, {3.96702196939318*^9, 
   3.96702197150316*^9}, 3.967022108517112*^9, 3.9670221980273943`*^9, {
   3.967023306486425*^9, 
   3.967023314840683*^9}},ExpressionUUID->"da3fbff4-3a17-4113-b38c-\
5d93994e421a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DifferenceSets", "[", 
   RowBox[{"\"\<diferencia5.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<P\>\"", ",", "\"\<Q\>\"", ",", "\"\<R\>\""}], "}"}], 
    ",", "\"\<orange\>\"", ",", "1.5", ",", "True", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1.2"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967021500218103*^9, 3.967021539009901*^9}, 
   3.967021672805071*^9, {3.967021723404994*^9, 3.9670217365279837`*^9}, {
   3.967021772154702*^9, 3.9670217724637127`*^9}, {3.967021824945944*^9, 
   3.9670218349035807`*^9}, {3.967021871834454*^9, 3.967021905603507*^9}, {
   3.967022045350721*^9, 3.967022045686844*^9}, {3.967022158668399*^9, 
   3.967022209067857*^9}, 3.9670223300486383`*^9, {3.9670233179813633`*^9, 
   3.967023345999831*^9}, {3.967023435378736*^9, 3.96702343860163*^9}},
 CellLabel->"In[85]:=",ExpressionUUID->"23570f9a-f844-4e33-bd9f-b14fef4fe850"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670234224684267`*^9, 3.967023439705166*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[85]:=",ExpressionUUID->"2e1a499d-9d9f-452e-9348-e1accd65ec41"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.9670234224684267`*^9, 3.967023439706276*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[85]:=",ExpressionUUID->"07166ef9-1268-42fa-b51f-08a4fe626484"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670234224684267`*^9, 3.9670234397073717`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[85]:=",ExpressionUUID->"5ea62bb7-53c8-4fe2-8618-e3027301c93e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670234224684267`*^9, 3.967023439708055*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[85]:=",ExpressionUUID->"070b6de4-85f1-4c0d-a4da-e4eb9df321ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670234224684267`*^9, 3.967023439708695*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[85]:=",ExpressionUUID->"07252ab7-6faa-46ce-a1da-7ff94489f144"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.9670234224684267`*^9, 3.967023439761942*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[85]:=",ExpressionUUID->"20948f00-c0e9-4d81-825d-969745f3e48f"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.9670234224684267`*^9, 3.967023440768827*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[85]:=",ExpressionUUID->"8d2f4c04-a866-4934-becd-ee9d432f8e19"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/DifferenceSets/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/DifferenceSets/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670234224684267`*^9, 3.9670234407736053`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[85]:=",ExpressionUUID->"d7a5d1f4-2eea-4eb2-9ede-fa776c75ba0c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"diferencia5\"\>"}],
  SequenceForm["Archivo: ", "diferencia5"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670234224684267`*^9, 3.967023440777113*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[85]:=",ExpressionUUID->"79325e4a-acdf-4c48-917a-5ba2751f177a"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.9670234224684267`*^9, 3.967023441237904*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[85]:=",ExpressionUUID->"dba7aad0-e5b9-49d2-8d21-2763958f5a3f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/DifferenceSets/diferencia5.pdf\"\>\
"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/DifferenceSets/diferencia5.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670234224684267`*^9, 3.9670234412387247`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[85]:=",ExpressionUUID->"eb6f31b9-5e67-4731-9ea5-4833167b6a78"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/DifferenceSets/\
diferencia5.pdf\"\>"], "Output",
 CellChangeTimes->{{3.967023423999666*^9, 3.9670234412518272`*^9}},
 CellLabel->"Out[86]=",ExpressionUUID->"73e34641-cffa-4a92-bf97-d73022c28a91"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SymmetricDif", "Section",
 CellChangeTimes->{
  3.967022494442177*^9},ExpressionUUID->"eae51d1b-eea5-4720-b15c-\
05b255697fac"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "SymmetricDif"}]], "Input",
 CellChangeTimes->{{3.967022496027573*^9, 3.967022496957995*^9}},
 CellLabel->"In[58]:=",ExpressionUUID->"943f52a4-93dc-4a96-b819-64c7607a6609"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"SymmetricDif[filename, labels, fillColor, scale, \
showSymmetricLabel, ellipseSize] crea un diagrama de la diferencia sim\
\[EAcute]trica de conjuntos en formato TikZ/LaTeX y lo exporta como archivo \
.tex en la carpeta \
Downloads/SymmetricDif.\\n\\nPAR\[CapitalAAcute]METROS:\\n- filename: String \
que especifica el nombre del archivo de salida (debe terminar en \
\\\".tex\\\")\\n- labels: Lista de etiquetas para identificar cada conjunto \
(m\[IAcute]nimo 2 elementos)\\n- fillColor: String que especifica el color de \
relleno de la diferencia sim\[EAcute]trica (opcional, por defecto \
\\\"gray\\\")\\n- scale: Real que define la escala del diagrama completo \
(opcional, por defecto 1.2)\\n- showSymmetricLabel: True/False para mostrar \
la etiqueta matem\[AAcute]tica de la diferencia sim\[EAcute]trica (opcional, \
por defecto False)\\n- ellipseSize: Lista {rx, ry} que define el radio \
horizontal y vertical de las elipses (opcional, por defecto {1.5, \
1.8})\\n\\nCOLORES PREDEFINIDOS:\\nLos siguientes colores se convierten autom\
\[AAcute]ticamente a tonos TikZ apropiados:\\n- \\\"blue\\\" -> \\\"blue!50\\\
\"     \[Bullet] \\\"red\\\" -> \\\"red!50\\\"       \[Bullet] \\\"green\\\" \
-> \\\"green!50\\\"\\n- \\\"yellow\\\" -> \\\"yellow!60\\\" \[Bullet] \
\\\"orange\\\" -> \\\"orange!50\\\" \[Bullet] \\\"purple\\\" -> \\\"purple!50\
\\\"\\n- \\\"violet\\\" -> \\\"violet!50\\\" \[Bullet] \\\"cyan\\\" -> \
\\\"cyan!50\\\"     \[Bullet] \\\"magenta\\\" -> \\\"magenta!50\\\"\\n- \
\\\"pink\\\" -> \\\"pink!50\\\"     \[Bullet] \\\"brown\\\" -> \\\"brown!50\\\
\"   \[Bullet] \\\"black\\\" -> \\\"black!30\\\"\\n- \
\\\"gray\\\"/\\\"grey\\\" -> \\\"gray!85\\\"\\n- Cualquier otro string se usa \
directamente como color TikZ\\n\\nDISPOSICI\[CapitalOAcute]N AUTOM\
\[CapitalAAcute]TICA DE CONJUNTOS:\\n- 2 conjuntos: Disposici\[OAcute]n \
horizontal\\n- 3 conjuntos: Disposici\[OAcute]n triangular\\n- 4 conjuntos: \
Disposici\[OAcute]n en cuadrado\\n- 5 conjuntos: Disposici\[OAcute]n \
pentagonal\\n- 6+ conjuntos: Disposici\[OAcute]n circular \
autom\[AAcute]tica\\n\\nFUNCIONALIDAD:\\n- Genera c\[OAcute]digo TikZ \
completo con documento LaTeX standalone\\n- Para 2 conjuntos: Implementa A \
\[EmptyUpTriangle] B = (A \:222a B) \\\\ (A \:2229 B)\\n  - Sombreia ambos \
conjuntos completamente\\n  - \\\"Borra\\\" (dibuja en blanco) la intersecci\
\[OAcute]n entre ellos\\n- Para m\[UAcute]ltiples conjuntos: Implementa \
diferencia sim\[EAcute]trica generalizada\\n  - Sombreia todos los \
conjuntos\\n  - \\\"Borra\\\" todas las intersecciones dobles y \
m\[UAcute]ltiples\\n  - Solo quedan las regiones que pertenecen a exactamente \
UN conjunto\\n- Dibuja los contornos de todas las elipses con l\[IAcute]neas \
negras gruesas\\n- Posiciona autom\[AAcute]ticamente las etiquetas fuera de \
las elipses\\n- La etiqueta de diferencia sim\[EAcute]trica (si est\[AAcute] \
habilitada) se coloca en la parte superior\\n- Crea la carpeta \
Downloads/SymmetricDif si no existe\\n- Exporta el archivo .tex listo para \
compilar\\n\\nVALIDACIONES:\\n- El filename debe terminar obligatoriamente en \
\\\".tex\\\"\\n- La lista ellipseSize debe contener exactamente 2 \
elementos\\n- La lista labels debe contener al menos 2 elementos\\n- Retorna \
$Failed si alguna validaci\[OAcute]n falla\\n\\nVALOR DE RETORNO:\\nRetorna \
la ruta completa del archivo exportado, o $Failed en caso de \
error.\\n\\nEJEMPLOS:\\n- SymmetricDif[\\\"simetrica.tex\\\", {\\\"A\\\", \
\\\"B\\\"}] \\n  % Muestra A \[EmptyUpTriangle] B\\n- \
SymmetricDif[\\\"sim_tres.tex\\\", {\\\"X\\\", \\\"Y\\\", \\\"Z\\\"}, \
\\\"blue\\\", 1.5, True]\\n  % Muestra X \[EmptyUpTriangle] Y \
\[EmptyUpTriangle] Z\\n- SymmetricDif[\\\"ejemplo.tex\\\", {\\\"A\\\", \
\\\"B\\\", \\\"C\\\", \\\"D\\\"}, \\\"red\\\", 1.0, False, {2.0, 2.5}]\\n  % \
Muestra A \[EmptyUpTriangle] B \[EmptyUpTriangle] C \[EmptyUpTriangle] \
D\\n\\nNOTA MATEM\[CapitalAAcute]TICA:\\n- Para 2 conjuntos: A \
\[EmptyUpTriangle] B representa elementos que est\[AAcute]n en A o en B, pero \
NO en ambos\\n- Para m\[UAcute]ltiples conjuntos: A \[EmptyUpTriangle] B \
\[EmptyUpTriangle] C \[EmptyUpTriangle] ... representa elementos que \
pertenecen a exactamente UNO de los conjuntos (no a ninguna \
combinaci\[OAcute]n de dos o m\[AAcute]s conjuntos)\\n- La diferencia sim\
\[EAcute]trica es conmutativa y asociativa\\n- La regi\[OAcute]n sombreada \
muestra elementos con pertenencia \\\"exclusiva\\\" a un solo conjunto\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"SymmetricDif", "[", 
                    
                    RowBox[{
                    "VilTeX`Private`filename_String", ",", 
                    "VilTeX`Private`labels_List", ",", 
                    
                    RowBox[{
                    "VilTeX`Private`fillColor_String", ":", "\"gray\""}], ",", 
                    RowBox[{"VilTeX`Private`scale_Real", ":", "1.2`"}], ",", 
                    
                    RowBox[{
                    "VilTeX`Private`showSymmetricLabel_", ":", "False"}], ",", 
                    RowBox[{"VilTeX`Private`ellipseSize_List", ":", 
                    RowBox[{"{", 
                    RowBox[{"1.5`", ",", "1.8`"}], "}"}]}]}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", ",", 
                    "VilTeX`Private`fullDocument", ",", 
                    "VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`folderPath", ",", "VilTeX`Private`rx", 
                    ",", "VilTeX`Private`ry", ",", 
                    "VilTeX`Private`processedColor", ",", 
                    "VilTeX`Private`numSets", ",", "VilTeX`Private`positions",
                     ",", "VilTeX`Private`ellipseDefinitions", ",", 
                    "VilTeX`Private`symmetricCode", ",", 
                    "VilTeX`Private`labelsCode", ",", 
                    "VilTeX`Private`symmetricLabelCode"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringEndsQ", "[", 
                    RowBox[{"VilTeX`Private`filename", ",", "\".tex\""}], 
                    "]"}]}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`ellipseSize", 
                    "]"}], "\[NotEqual]", "2"}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`labels", "]"}], 
                    "<", "2"}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`rx", ",", "VilTeX`Private`ry"}], 
                    "}"}], "=", "VilTeX`Private`ellipseSize"}], ";", 
                    RowBox[{"VilTeX`Private`numSets", "=", 
                    RowBox[{"Length", "[", "VilTeX`Private`labels", "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`processedColor", "=", 
                    RowBox[{"Switch", "[", 
                    
                    RowBox[{"VilTeX`Private`fillColor", ",", "\"blue\"", ",", 
                    "\"blue!50\"", ",", "\"red\"", ",", "\"red!50\"", ",", 
                    "\"green\"", ",", "\"green!50\"", ",", "\"yellow\"", ",", 
                    "\"yellow!60\"", ",", "\"orange\"", ",", "\"orange!50\"", 
                    ",", "\"purple\"", ",", "\"purple!50\"", ",", 
                    "\"violet\"", ",", "\"violet!50\"", ",", "\"cyan\"", ",", 
                    "\"cyan!50\"", ",", "\"magenta\"", ",", "\"magenta!50\"", 
                    ",", "\"pink\"", ",", "\"pink!50\"", ",", "\"brown\"", 
                    ",", "\"brown!50\"", ",", "\"black\"", ",", 
                    "\"black!30\"", ",", "\"gray\"", ",", "\"gray!85\"", ",", 
                    "\"grey\"", ",", "\"gray!85\"", ",", "_", ",", 
                    "VilTeX`Private`fillColor"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`positions", "=", 
                    RowBox[{"Switch", "[", 
                    RowBox[{"VilTeX`Private`numSets", ",", "2", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.8`"}], ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.8`", ",", "0"}], "}"}]}], "}"}], ",", "3", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.8`"}], ",", "0.6`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.8`", ",", "0.6`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{"-", "0.8`"}]}], "}"}]}], "}"}], ",", "4", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.8`"}], ",", "0.8`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.8`", ",", "0.8`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.8`"}], ",", 
                    RowBox[{"-", "0.8`"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.8`", ",", 
                    RowBox[{"-", "0.8`"}]}], "}"}]}], "}"}], ",", "5", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1.2`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"1.1`", ",", "0.37`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.68`", ",", 
                    RowBox[{"-", "0.97`"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.68`"}], ",", 
                    RowBox[{"-", "0.97`"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1.1`"}], ",", "0.37`"}], "}"}]}], "}"}], 
                    ",", "_", ",", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"1.2`", " ", 
                    RowBox[{"Cos", "[", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ")"}]}], 
                    "VilTeX`Private`numSets"], "]"}]}], ",", 
                    RowBox[{"1.2`", " ", 
                    RowBox[{"Sin", "[", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ")"}]}], 
                    "VilTeX`Private`numSets"], "]"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numSets"}], "}"}]}], "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`ellipseDefinitions", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"\\\\def\\\\ellipse\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "<>", 
                    "\"{(\"", "<>", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\") ellipse (\"",
                     "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`rx", "]"}], "<>",
                     "\" and \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`ry", "]"}], "<>",
                     "\")}\\n\""}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numSets"}], "}"}]}], "]"}], "]"}]}], ";", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`numSets", "\[Equal]", "2"}], ",", 
                    
                    RowBox[{
                    RowBox[{"VilTeX`Private`symmetricCode", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"\"% Sombrear ambos conjuntos (A \:222a B)\\n\"", 
                    ",", 
                    
                    RowBox[{"\"\\\\fill[\"", "<>", 
                    "VilTeX`Private`processedColor", "<>", 
                    "\"] \\\\ellipse\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "<>", "\";\\n\""}], ",", 
                    
                    RowBox[{"\"\\\\fill[\"", "<>", 
                    "VilTeX`Private`processedColor", "<>", 
                    "\"] \\\\ellipse\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "<>", "\";\\n\\n\""}], 
                    ",", "\"% Borrar la intersecci\[OAcute]n A \:2229 B\\n\"",
                     ",", "\"\\\\begin{scope}\\n\"", ",", 
                    RowBox[{"\"    \\\\clip \\\\ellipse\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "<>", "\";\\n\""}], ",", 
                    RowBox[{"\"    \\\\fill[white] \\\\ellipse\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "<>", "\";\\n\""}], ",", 
                    "\"\\\\end{scope}\\n\\n\""}], "}"}], "]"}]}], ";"}], ",", 
                    
                    RowBox[{
                    RowBox[{"VilTeX`Private`symmetricCode", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"% Sombrear todos los conjuntos\\n\"", ",", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    
                    RowBox[{"\"\\\\fill[\"", "<>", 
                    "VilTeX`Private`processedColor", "<>", 
                    "\"] \\\\ellipse\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "<>", 
                    "\";\\n\""}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numSets"}], "}"}]}], "]"}], "]"}], ",", 
                    "\"\\n\"", ",", 
                    "\"% Borrar intersecciones dobles y \
m\[UAcute]ltiples\\n\"", ",", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    
                    RowBox[{"\"\\\\begin{scope}\\n    \\\\clip \\\\ellipse\"",
                     "<>", 
                    RowBox[{
                    "VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "<>", 
                    "\";\\n\"", "<>", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"    \\\\fill[white] \\\\ellipse\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], "<>", 
                    "\";\\n\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    RowBox[{"VilTeX`Private`i", "+", "1"}], ",", 
                    "VilTeX`Private`numSets"}], "}"}]}], "]"}], "]"}], "<>", 
                    "\"\\\\end{scope}\\n\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", "1", ",", 
                    RowBox[{"VilTeX`Private`numSets", "-", "1"}]}], "}"}]}], 
                    "]"}], "]"}], ",", "\"\\n\""}], "}"}], "]"}]}], ";"}]}], 
                    "]"}], ";", 
                    RowBox[{"VilTeX`Private`labelsCode", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"\\\\node at (\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "+", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "<", "0"}], ",", 
                    RowBox[{
                    RowBox[{"-", "VilTeX`Private`rx"}], " ", "0.8`"}], ",", 
                    RowBox[{"VilTeX`Private`rx", " ", "0.8`"}]}], "]"}]}], 
                    "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"VilTeX`Private`positions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", 
                    "\") {\\\\Large $\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "<>", 
                    "\"$};\\n\""}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numSets"}], "}"}]}], "]"}], "]"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`symmetricLabelCode", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`showSymmetricLabel", ",", 
                    
                    RowBox[{
                    "\"% Etiqueta para la diferencia \
sim\[EAcute]trica\\n\\\\node at (0,\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilTeX`Private`ry", " ", "1.8`"}], "]"}], "<>", 
                    "\") {\\\\small $\"", "<>", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`numSets", "\[Equal]", "2"}], ",", 
                    
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "<>", 
                    "\" \\\\triangle \"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"StringRiffle", "[", 
                    
                    RowBox[{"VilTeX`Private`labels", ",", 
                    "\" \\\\triangle \""}], "]"}]}], "]"}], "<>", 
                    "\"$};\\n\\n\""}], ",", "\"\""}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\\\\begin{tikzpicture}[scale=\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`scale", "]"}], 
                    "<>", "\"]\\n\\n\""}], ",", 
                    "\"% Definir las elipses\\n\"", ",", 
                    "VilTeX`Private`ellipseDefinitions", ",", "\"\\n\"", ",", 
                    "VilTeX`Private`symmetricCode", ",", 
                    "\"% Dibujar los contornos de las elipses\\n\"", ",", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"\\\\draw[black, thick] \\\\ellipse\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`labels", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "<>", 
                    "\";\\n\""}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numSets"}], "}"}]}], "]"}], "]"}], ",", 
                    "\"\\n\"", ",", "\"% Etiquetas\\n\"", ",", 
                    "VilTeX`Private`labelsCode", ",", "\"\\n\"", ",", 
                    "VilTeX`Private`symmetricLabelCode", ",", 
                    "\"\\\\end{tikzpicture}\""}], "}"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`fullDocument", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{
                    "\"\\\\documentclass[border=5mm]{standalone}\\n\"", ",", 
                    "\"\\\\usepackage{tikz}\\n\"", ",", 
                    "\"\\\\usepackage{amsmath}\\n\"", ",", 
                    "\"\\\\usetikzlibrary{patterns}\\n\\n\"", ",", 
                    "\"\\\\begin{document}\\n\"", ",", 
                    "VilTeX`Private`tikzCode", ",", 
                    "\"\\n\\\\end{document}\""}], "}"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`folderPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"$HomeDirectory", ",", "\"Downloads\"", ",", 
                    "\"SymmetricDif\""}], "}"}], "]"}]}], ";", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"DirectoryQ", "[", "VilTeX`Private`folderPath", 
                    "]"}]}], ",", 
                    
                    RowBox[{"CreateDirectory", "[", 
                    "VilTeX`Private`folderPath", "]"}]}], "]"}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`downloadPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`folderPath", ",", 
                    "VilTeX`Private`filename"}], "}"}], "]"}]}], ";", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"Export", "[", 
                    
                    RowBox[{"VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`fullDocument", ",", "\"Text\""}], "]"}], 
                    "]"}], ";", "VilTeX`Private`downloadPath"}]}], "]"}]}]}, {
                   " "}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilTeX`SymmetricDif\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"SymmetricDif[filename, labels, fillColor, scale, \
showSymmetricLabel, ellipseSize] crea un diagrama de la diferencia sim\
\[EAcute]trica de conjuntos en formato TikZ/LaTeX y lo exporta como archivo \
.tex en la carpeta \
Downloads/SymmetricDif.\\n\\nPAR\[CapitalAAcute]METROS:\\n- filename: String \
que especifica el nombre del archivo de salida (debe terminar en \
\\\".tex\\\")\\n- labels: Lista de etiquetas para identificar cada conjunto \
(m\[IAcute]nimo 2 elementos)\\n- fillColor: String que especifica el color de \
relleno de la diferencia sim\[EAcute]trica (opcional, por defecto \
\\\"gray\\\")\\n- scale: Real que define la escala del diagrama completo \
(opcional, por defecto 1.2)\\n- showSymmetricLabel: True/False para mostrar \
la etiqueta matem\[AAcute]tica de la diferencia sim\[EAcute]trica (opcional, \
por defecto False)\\n- ellipseSize: Lista {rx, ry} que define el radio \
horizontal y vertical de las elipses (opcional, por defecto {1.5, \
1.8})\\n\\nCOLORES PREDEFINIDOS:\\nLos siguientes colores se convierten autom\
\[AAcute]ticamente a tonos TikZ apropiados:\\n- \\\"blue\\\" -> \\\"blue!50\\\
\"     \[Bullet] \\\"red\\\" -> \\\"red!50\\\"       \[Bullet] \\\"green\\\" \
-> \\\"green!50\\\"\\n- \\\"yellow\\\" -> \\\"yellow!60\\\" \[Bullet] \
\\\"orange\\\" -> \\\"orange!50\\\" \[Bullet] \\\"purple\\\" -> \\\"purple!50\
\\\"\\n- \\\"violet\\\" -> \\\"violet!50\\\" \[Bullet] \\\"cyan\\\" -> \
\\\"cyan!50\\\"     \[Bullet] \\\"magenta\\\" -> \\\"magenta!50\\\"\\n- \
\\\"pink\\\" -> \\\"pink!50\\\"     \[Bullet] \\\"brown\\\" -> \\\"brown!50\\\
\"   \[Bullet] \\\"black\\\" -> \\\"black!30\\\"\\n- \
\\\"gray\\\"/\\\"grey\\\" -> \\\"gray!85\\\"\\n- Cualquier otro string se usa \
directamente como color TikZ\\n\\nDISPOSICI\[CapitalOAcute]N AUTOM\
\[CapitalAAcute]TICA DE CONJUNTOS:\\n- 2 conjuntos: Disposici\[OAcute]n \
horizontal\\n- 3 conjuntos: Disposici\[OAcute]n triangular\\n- 4 conjuntos: \
Disposici\[OAcute]n en cuadrado\\n- 5 conjuntos: Disposici\[OAcute]n \
pentagonal\\n- 6+ conjuntos: Disposici\[OAcute]n circular \
autom\[AAcute]tica\\n\\nFUNCIONALIDAD:\\n- Genera c\[OAcute]digo TikZ \
completo con documento LaTeX standalone\\n- Para 2 conjuntos: Implementa A \
\[EmptyUpTriangle] B = (A \:222a B) \\\\ (A \:2229 B)\\n  - Sombreia ambos \
conjuntos completamente\\n  - \\\"Borra\\\" (dibuja en blanco) la intersecci\
\[OAcute]n entre ellos\\n- Para m\[UAcute]ltiples conjuntos: Implementa \
diferencia sim\[EAcute]trica generalizada\\n  - Sombreia todos los \
conjuntos\\n  - \\\"Borra\\\" todas las intersecciones dobles y \
m\[UAcute]ltiples\\n  - Solo quedan las regiones que pertenecen a exactamente \
UN conjunto\\n- Dibuja los contornos de todas las elipses con l\[IAcute]neas \
negras gruesas\\n- Posiciona autom\[AAcute]ticamente las etiquetas fuera de \
las elipses\\n- La etiqueta de diferencia sim\[EAcute]trica (si est\[AAcute] \
habilitada) se coloca en la parte superior\\n- Crea la carpeta \
Downloads/SymmetricDif si no existe\\n- Exporta el archivo .tex listo para \
compilar\\n\\nVALIDACIONES:\\n- El filename debe terminar obligatoriamente en \
\\\".tex\\\"\\n- La lista ellipseSize debe contener exactamente 2 \
elementos\\n- La lista labels debe contener al menos 2 elementos\\n- Retorna \
$Failed si alguna validaci\[OAcute]n falla\\n\\nVALOR DE RETORNO:\\nRetorna \
la ruta completa del archivo exportado, o $Failed en caso de \
error.\\n\\nEJEMPLOS:\\n- SymmetricDif[\\\"simetrica.tex\\\", {\\\"A\\\", \
\\\"B\\\"}] \\n  % Muestra A \[EmptyUpTriangle] B\\n- \
SymmetricDif[\\\"sim_tres.tex\\\", {\\\"X\\\", \\\"Y\\\", \\\"Z\\\"}, \
\\\"blue\\\", 1.5, True]\\n  % Muestra X \[EmptyUpTriangle] Y \
\[EmptyUpTriangle] Z\\n- SymmetricDif[\\\"ejemplo.tex\\\", {\\\"A\\\", \
\\\"B\\\", \\\"C\\\", \\\"D\\\"}, \\\"red\\\", 1.0, False, {2.0, 2.5}]\\n  % \
Muestra A \[EmptyUpTriangle] B \[EmptyUpTriangle] C \[EmptyUpTriangle] \
D\\n\\nNOTA MATEM\[CapitalAAcute]TICA:\\n- Para 2 conjuntos: A \
\[EmptyUpTriangle] B representa elementos que est\[AAcute]n en A o en B, pero \
NO en ambos\\n- Para m\[UAcute]ltiples conjuntos: A \[EmptyUpTriangle] B \
\[EmptyUpTriangle] C \[EmptyUpTriangle] ... representa elementos que \
pertenecen a exactamente UNO de los conjuntos (no a ninguna \
combinaci\[OAcute]n de dos o m\[AAcute]s conjuntos)\\n- La diferencia sim\
\[EAcute]trica es conmutativa y asociativa\\n- La regi\[OAcute]n sombreada \
muestra elementos con pertenencia \\\"exclusiva\\\" a un solo conjunto\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}},
            ScrollPosition->{0., 0.}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "SymmetricDif[filename, labels, fillColor, scale, showSymmetricLabel, \
ellipseSize] crea un diagrama de la diferencia sim\[EAcute]trica de conjuntos \
en formato TikZ/LaTeX y lo exporta como archivo .tex en la carpeta \
Downloads/SymmetricDif.\n\nPAR\[CapitalAAcute]METROS:\n- filename: String que \
especifica el nombre del archivo de salida (debe terminar en \".tex\")\n- \
labels: Lista de etiquetas para identificar cada conjunto (m\[IAcute]nimo 2 \
elementos)\n- fillColor: String que especifica el color de relleno de la \
diferencia sim\[EAcute]trica (opcional, por defecto \"gray\")\n- scale: Real \
que define la escala del diagrama completo (opcional, por defecto 1.2)\n- \
showSymmetricLabel: True/False para mostrar la etiqueta matem\[AAcute]tica de \
la diferencia sim\[EAcute]trica (opcional, por defecto False)\n- ellipseSize: \
Lista {rx, ry} que define el radio horizontal y vertical de las elipses \
(opcional, por defecto {1.5, 1.8})\n\nCOLORES PREDEFINIDOS:\nLos siguientes \
colores se convierten autom\[AAcute]ticamente a tonos TikZ apropiados:\n- \
\"blue\" -> \"blue!50\"     \[Bullet] \"red\" -> \"red!50\"       \[Bullet] \
\"green\" -> \"green!50\"\n- \"yellow\" -> \"yellow!60\" \[Bullet] \"orange\" \
-> \"orange!50\" \[Bullet] \"purple\" -> \"purple!50\"\n- \"violet\" -> \
\"violet!50\" \[Bullet] \"cyan\" -> \"cyan!50\"     \[Bullet] \"magenta\" -> \
\"magenta!50\"\n- \"pink\" -> \"pink!50\"     \[Bullet] \"brown\" -> \
\"brown!50\"   \[Bullet] \"black\" -> \"black!30\"\n- \"gray\"/\"grey\" -> \
\"gray!85\"\n- Cualquier otro string se usa directamente como color TikZ\n\n\
DISPOSICI\[CapitalOAcute]N AUTOM\[CapitalAAcute]TICA DE CONJUNTOS:\n- 2 \
conjuntos: Disposici\[OAcute]n horizontal\n- 3 conjuntos: Disposici\[OAcute]n \
triangular\n- 4 conjuntos: Disposici\[OAcute]n en cuadrado\n- 5 conjuntos: \
Disposici\[OAcute]n pentagonal\n- 6+ conjuntos: Disposici\[OAcute]n circular \
autom\[AAcute]tica\n\nFUNCIONALIDAD:\n- Genera c\[OAcute]digo TikZ completo \
con documento LaTeX standalone\n- Para 2 conjuntos: Implementa A \
\[EmptyUpTriangle] B = (A \:222a B) \\ (A \:2229 B)\n  - Sombreia ambos \
conjuntos completamente\n  - \"Borra\" (dibuja en blanco) la intersecci\
\[OAcute]n entre ellos\n- Para m\[UAcute]ltiples conjuntos: Implementa \
diferencia sim\[EAcute]trica generalizada\n  - Sombreia todos los conjuntos\n \
 - \"Borra\" todas las intersecciones dobles y m\[UAcute]ltiples\n  - Solo \
quedan las regiones que pertenecen a exactamente UN conjunto\n- Dibuja los \
contornos de todas las elipses con l\[IAcute]neas negras gruesas\n- Posiciona \
autom\[AAcute]ticamente las etiquetas fuera de las elipses\n- La etiqueta de \
diferencia sim\[EAcute]trica (si est\[AAcute] habilitada) se coloca en la \
parte superior\n- Crea la carpeta Downloads/SymmetricDif si no existe\n- \
Exporta el archivo .tex listo para compilar\n\nVALIDACIONES:\n- El filename \
debe terminar obligatoriamente en \".tex\"\n- La lista ellipseSize debe \
contener exactamente 2 elementos\n- La lista labels debe contener al menos 2 \
elementos\n- Retorna $Failed si alguna validaci\[OAcute]n falla\n\nVALOR DE \
RETORNO:\nRetorna la ruta completa del archivo exportado, o $Failed en caso \
de error.\n\nEJEMPLOS:\n- SymmetricDif[\"simetrica.tex\", {\"A\", \"B\"}] \n  \
% Muestra A \[EmptyUpTriangle] B\n- SymmetricDif[\"sim_tres.tex\", {\"X\", \
\"Y\", \"Z\"}, \"blue\", 1.5, True]\n  % Muestra X \[EmptyUpTriangle] Y \
\[EmptyUpTriangle] Z\n- SymmetricDif[\"ejemplo.tex\", {\"A\", \"B\", \"C\", \
\"D\"}, \"red\", 1.0, False, {2.0, 2.5}]\n  % Muestra A \[EmptyUpTriangle] B \
\[EmptyUpTriangle] C \[EmptyUpTriangle] D\n\nNOTA MATEM\[CapitalAAcute]TICA:\n\
- Para 2 conjuntos: A \[EmptyUpTriangle] B representa elementos que est\
\[AAcute]n en A o en B, pero NO en ambos\n- Para m\[UAcute]ltiples conjuntos: \
A \[EmptyUpTriangle] B \[EmptyUpTriangle] C \[EmptyUpTriangle] ... representa \
elementos que pertenecen a exactamente UNO de los conjuntos (no a ninguna \
combinaci\[OAcute]n de dos o m\[AAcute]s conjuntos)\n- La diferencia sim\
\[EAcute]trica es conmutativa y asociativa\n- La regi\[OAcute]n sombreada \
muestra elementos con pertenencia \"exclusiva\" a un solo conjunto", 
    "Documentation" -> None, "OwnValues" -> None, "UpValues" -> None, 
    "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilTeX`SymmetricDif, {VilTeX`SymmetricDif[
         Pattern[VilTeX`Private`filename, 
          Blank[String]], 
         Pattern[VilTeX`Private`labels, 
          Blank[List]], 
         Optional[
          Pattern[VilTeX`Private`fillColor, 
           Blank[String]], "gray"], 
         Optional[
          Pattern[VilTeX`Private`scale, 
           Blank[Real]], 1.2], 
         Optional[
          Pattern[VilTeX`Private`showSymmetricLabel, 
           Blank[]], False], 
         Optional[
          Pattern[VilTeX`Private`ellipseSize, 
           Blank[List]], {1.5, 1.8}]] :> 
       Module[{VilTeX`Private`tikzCode, VilTeX`Private`fullDocument, 
          VilTeX`Private`downloadPath, VilTeX`Private`folderPath, 
          VilTeX`Private`rx, VilTeX`Private`ry, VilTeX`Private`processedColor,
           VilTeX`Private`numSets, VilTeX`Private`positions, 
          VilTeX`Private`ellipseDefinitions, VilTeX`Private`symmetricCode, 
          VilTeX`Private`labelsCode, VilTeX`Private`symmetricLabelCode}, If[
           Not[
            StringEndsQ[VilTeX`Private`filename, ".tex"]], 
           Return[$Failed]]; If[Length[VilTeX`Private`ellipseSize] != 2, 
           Return[$Failed]]; If[Length[VilTeX`Private`labels] < 2, 
           Return[$Failed]]; {VilTeX`Private`rx, VilTeX`Private`ry} = 
          VilTeX`Private`ellipseSize; 
         VilTeX`Private`numSets = Length[VilTeX`Private`labels]; 
         VilTeX`Private`processedColor = 
          Switch[VilTeX`Private`fillColor, "blue", "blue!50", "red", "red!50",
             "green", "green!50", "yellow", "yellow!60", "orange", 
            "orange!50", "purple", "purple!50", "violet", "violet!50", "cyan",
             "cyan!50", "magenta", "magenta!50", "pink", "pink!50", "brown", 
            "brown!50", "black", "black!30", "gray", "gray!85", "grey", 
            "gray!85", 
            Blank[], VilTeX`Private`fillColor]; 
         VilTeX`Private`positions = 
          Switch[VilTeX`Private`numSets, 2, {{-0.8, 0}, {0.8, 0}}, 
            3, {{-0.8, 0.6}, {0.8, 0.6}, {0, -0.8}}, 4, {{-0.8, 0.8}, {0.8, 
            0.8}, {-0.8, -0.8}, {0.8, -0.8}}, 
            5, {{0, 1.2}, {1.1, 0.37}, {0.68, -0.97}, {-0.68, -0.97}, {-1.1, 
             0.37}}, 
            Blank[], 
            
            Table[{1.2 
              Cos[2 Pi ((VilTeX`Private`i - 1)/VilTeX`Private`numSets)], 1.2 
              Sin[2 Pi ((VilTeX`Private`i - 1)/VilTeX`Private`numSets)]}, {
             VilTeX`Private`i, VilTeX`Private`numSets}]]; 
         VilTeX`Private`ellipseDefinitions = StringJoin[
            Table[
            "\\def\\ellipse" <> Part[VilTeX`Private`labels, VilTeX`Private`i] <> 
             "{(" <> ToString[
               Part[VilTeX`Private`positions, VilTeX`Private`i, 1]] <> "," <> 
             ToString[
               Part[VilTeX`Private`positions, VilTeX`Private`i, 2]] <> 
             ") ellipse (" <> ToString[VilTeX`Private`rx] <> " and " <> 
             ToString[VilTeX`Private`ry] <> ")}\n", {
             VilTeX`Private`i, VilTeX`Private`numSets}]]; 
         If[VilTeX`Private`numSets == 2, 
           VilTeX`Private`symmetricCode = 
            StringJoin[{
              "% Sombrear ambos conjuntos (A \:222a B)\n", "\\fill[" <> 
               VilTeX`Private`processedColor <> "] \\ellipse" <> 
               Part[VilTeX`Private`labels, 1] <> ";\n", "\\fill[" <> 
               VilTeX`Private`processedColor <> "] \\ellipse" <> 
               Part[VilTeX`Private`labels, 2] <> ";\n\n", 
               "% Borrar la intersecci\[OAcute]n A \:2229 B\n", 
               "\\begin{scope}\n", "    \\clip \\ellipse" <> 
               Part[VilTeX`Private`labels, 1] <> ";\n", 
               "    \\fill[white] \\ellipse" <> 
               Part[VilTeX`Private`labels, 2] <> ";\n", "\\end{scope}\n\n"}]; 
           Null, VilTeX`Private`symmetricCode = 
            StringJoin[{"% Sombrear todos los conjuntos\n", 
               StringJoin[
                Table[
                "\\fill[" <> VilTeX`Private`processedColor <> "] \\ellipse" <> 
                 Part[VilTeX`Private`labels, VilTeX`Private`i] <> ";\n", {
                 VilTeX`Private`i, VilTeX`Private`numSets}]], "\n", 
               "% Borrar intersecciones dobles y m\[UAcute]ltiples\n", 
               StringJoin[
                Table[
                "\\begin{scope}\n    \\clip \\ellipse" <> 
                 Part[VilTeX`Private`labels, VilTeX`Private`i] <> ";\n" <> 
                 StringJoin[
                   Table[
                   "    \\fill[white] \\ellipse" <> 
                    Part[VilTeX`Private`labels, VilTeX`Private`j] <> ";\n", {
                    VilTeX`Private`j, VilTeX`Private`i + 1, 
                    VilTeX`Private`numSets}]] <> "\\end{scope}\n", {
                 VilTeX`Private`i, 1, VilTeX`Private`numSets - 1}]], "\n"}]; 
           Null]; VilTeX`Private`labelsCode = StringJoin[
            Table[
            "\\node at (" <> 
             ToString[
              Part[VilTeX`Private`positions, VilTeX`Private`i, 1] + 
               If[Part[VilTeX`Private`positions, VilTeX`Private`i, 1] < 
                 0, (-VilTeX`Private`rx) 0.8, VilTeX`Private`rx 0.8]] <> "," <> 
             ToString[
               Part[VilTeX`Private`positions, VilTeX`Private`i, 2]] <> 
             ") {\\Large $" <> Part[VilTeX`Private`labels, VilTeX`Private`i] <> 
             "$};\n", {VilTeX`Private`i, VilTeX`Private`numSets}]]; 
         VilTeX`Private`symmetricLabelCode = 
          If[VilTeX`Private`showSymmetricLabel, 
            "% Etiqueta para la diferencia sim\[EAcute]trica\n\\node at (0," <> 
            ToString[VilTeX`Private`ry 1.8] <> ") {\\small $" <> 
            If[VilTeX`Private`numSets == 2, Part[VilTeX`Private`labels, 1] <> 
              " \\triangle " <> Part[VilTeX`Private`labels, 2], 
              StringRiffle[VilTeX`Private`labels, " \\triangle "]] <> 
            "$};\n\n", ""]; 
         VilTeX`Private`tikzCode = 
          StringJoin[{
            "\\begin{tikzpicture}[scale=" <> ToString[VilTeX`Private`scale] <> 
             "]\n\n", "% Definir las elipses\n", 
             VilTeX`Private`ellipseDefinitions, "\n", 
             VilTeX`Private`symmetricCode, 
             "% Dibujar los contornos de las elipses\n", 
             StringJoin[
              Table[
              "\\draw[black, thick] \\ellipse" <> 
               Part[VilTeX`Private`labels, VilTeX`Private`i] <> ";\n", {
               VilTeX`Private`i, VilTeX`Private`numSets}]], "\n", 
             "% Etiquetas\n", VilTeX`Private`labelsCode, "\n", 
             VilTeX`Private`symmetricLabelCode, "\\end{tikzpicture}"}]; 
         VilTeX`Private`fullDocument = 
          StringJoin[{
            "\\documentclass[border=5mm]{standalone}\n", 
             "\\usepackage{tikz}\n", "\\usepackage{amsmath}\n", 
             "\\usetikzlibrary{patterns}\n\n", "\\begin{document}\n", 
             VilTeX`Private`tikzCode, "\n\\end{document}"}]; 
         VilTeX`Private`folderPath = 
          FileNameJoin[{$HomeDirectory, "Downloads", "SymmetricDif"}]; Quiet[
           If[
            Not[
             DirectoryQ[VilTeX`Private`folderPath]], 
            CreateDirectory[VilTeX`Private`folderPath]]]; 
         VilTeX`Private`downloadPath = 
          FileNameJoin[{VilTeX`Private`folderPath, VilTeX`Private`filename}]; 
         Quiet[
           Export[
           VilTeX`Private`downloadPath, VilTeX`Private`fullDocument, "Text"]]; 
         VilTeX`Private`downloadPath]}], "SubValues" -> None, "DefaultValues" -> 
    None, "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {Protected}, "FullName" -> "VilTeX`SymmetricDif"|>, 
   False]]], "Output",
 CellChangeTimes->{3.967022511475194*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"9ba5966d-b03b-4685-bd70-9bcbd0d57df7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 1: diferencia sim\[EAcute]trica b\[AAcute]sica A \
\[EmptyUpTriangle] B", "Subsection",
 CellChangeTimes->{{3.9669722155811577`*^9, 3.966972227370956*^9}, {
  3.96697269501637*^9, 3.966972698074332*^9}, {3.967023482415901*^9, 
  3.967023484397766*^9}},ExpressionUUID->"338c22b7-93a4-4b50-a816-\
5e7195b50be0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SymmetricDif", "[", 
   RowBox[{"\"\<simetrica1.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}], ",", "\"\<blue\>\""}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967021500218103*^9, 3.967021539009901*^9}, 
   3.967021672805071*^9, {3.9670234973773317`*^9, 3.9670235006141148`*^9}},
 CellLabel->"In[87]:=",ExpressionUUID->"6a09682e-7399-4a8d-b8e2-bd47e7f71876"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670237164262657`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[87]:=",ExpressionUUID->"8ba1673b-8141-417d-910e-c85fed6945ee"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.9670237164274406`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[87]:=",ExpressionUUID->"48cd9546-7161-4329-b06b-2ba46e56c001"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023716428439*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[87]:=",ExpressionUUID->"11749f3b-1084-4709-83da-4f4e1ea5b44b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670237164290247`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[87]:=",ExpressionUUID->"63c1c9ea-501c-4415-9479-26def6aa6e26"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023716429604*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[87]:=",ExpressionUUID->"7b38bd86-930e-436c-afd3-d237cbcec9ec"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967023716508891*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[87]:=",ExpressionUUID->"2b6091e3-a8e8-4a26-ba43-0bed9305ce2f"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.9670237175147257`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[87]:=",ExpressionUUID->"d62dade0-f20a-4170-bb5d-454c4241f00b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/SymmetricDif/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/SymmetricDif/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670237175177526`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[87]:=",ExpressionUUID->"9fa04edf-a36f-42fd-80ac-719b79f8bbdc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"simetrica1\"\>"}],
  SequenceForm["Archivo: ", "simetrica1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670237175202723`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[87]:=",ExpressionUUID->"f3000415-9c08-422b-9eb6-f1c2eea4f402"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.9670237179641247`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[87]:=",ExpressionUUID->"d8b2481b-7b64-4258-a334-887c2a23a742"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/SymmetricDif/simetrica1.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/SymmetricDif/simetrica1.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023717964814*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[87]:=",ExpressionUUID->"5afe6906-ee2b-477b-a36c-ff7cbb767df7"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/SymmetricDif/\
simetrica1.pdf\"\>"], "Output",
 CellChangeTimes->{3.967023717978427*^9},
 CellLabel->"Out[88]=",ExpressionUUID->"816e435e-41b4-4c0a-bc43-5550ee01bf51"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 2: diferencia sim\[EAcute]trica de tres conjuntos", "Subsection",
 CellChangeTimes->{{3.9669722155811577`*^9, 3.966972227370956*^9}, {
  3.96697269501637*^9, 3.966972698074332*^9}, {3.967021692623477*^9, 
  3.967021693203027*^9}, {3.967021739781867*^9, 3.967021740308218*^9}, {
  3.967023575146927*^9, 
  3.967023577838215*^9}},ExpressionUUID->"620b9d8a-9f76-4e06-aed2-\
2869225d1b9e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SymmetricDif", "[", 
   RowBox[{"\"\<simetrica2.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\"", ",", "\"\<C\>\""}], "}"}], 
    ",", "\"\<red\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967021500218103*^9, 3.967021539009901*^9}, 
   3.967021672805071*^9, {3.967021723404994*^9, 3.9670217365279837`*^9}, 
   3.967023589528995*^9},
 CellLabel->"In[89]:=",ExpressionUUID->"9531f9a9-20d6-43a6-bd81-948ee2b1fd2e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023740308622*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[89]:=",ExpressionUUID->"75f0809a-0b51-4f9f-8e47-b322060afbb2"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.967023740309717*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[89]:=",ExpressionUUID->"91780348-00db-4dbd-b583-aa93fc47825e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670237403108053`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[89]:=",ExpressionUUID->"b001b725-81b3-47f7-a9d1-5e169a9ba859"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.96702374031141*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[89]:=",ExpressionUUID->"a420e369-4d4f-499c-931a-37e44e5eef15"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023740311997*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[89]:=",ExpressionUUID->"b0bbade3-f80d-40f9-9500-430d7eff85ad"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967023740385337*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[89]:=",ExpressionUUID->"fc80c348-fe46-4ad9-8b56-42e3844bdf74"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.967023741390608*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[89]:=",ExpressionUUID->"12517887-a64c-4769-89b3-ab774dc2956f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/SymmetricDif/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/SymmetricDif/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670237413936863`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[89]:=",ExpressionUUID->"01fc7a2e-6de7-4caf-a11e-657cc0cc0fae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"simetrica2\"\>"}],
  SequenceForm["Archivo: ", "simetrica2"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023741395694*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[89]:=",ExpressionUUID->"10127ad7-04b3-491a-a01d-f4bf6b7a0ac5"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.967023741842898*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[89]:=",ExpressionUUID->"57065d15-ad76-4cbc-8bdc-9076be65ece0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/SymmetricDif/simetrica2.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/SymmetricDif/simetrica2.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.96702374184378*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[89]:=",ExpressionUUID->"d41689e5-3ac6-4eca-8146-943ca53a1c7d"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/SymmetricDif/\
simetrica2.pdf\"\>"], "Output",
 CellChangeTimes->{3.967023741856135*^9},
 CellLabel->"Out[90]=",ExpressionUUID->"303de90a-7315-4f4c-a4a4-e89425441883"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 3: diferencia sim\[EAcute]trica de cuatro conjuntos", \
"Subsection",
 CellChangeTimes->{{3.9669722155811577`*^9, 3.966972227370956*^9}, {
  3.96697269501637*^9, 3.966972698074332*^9}, {3.967021692623477*^9, 
  3.967021693203027*^9}, {3.967021739781867*^9, 3.967021740308218*^9}, {
  3.9670220235241613`*^9, 3.967022026511013*^9}, {3.967023628665772*^9, 
  3.9670236298805723`*^9}},ExpressionUUID->"23b108ad-6076-46d5-b582-\
c70b5a102b56"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SymmetricDif", "[", 
   RowBox[{"\"\<simetrica3.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<P\>\"", ",", "\"\<Q\>\"", ",", "\"\<R\>\"", 
      ",", "\"\<S\>\""}], "}"}], ",", "\"\<purple\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967021500218103*^9, 3.967021539009901*^9}, 
   3.967021672805071*^9, {3.967021723404994*^9, 3.9670217365279837`*^9}, 
   3.967022030968194*^9, {3.967022064956696*^9, 3.967022065287479*^9}, {
   3.9670222461414547`*^9, 3.967022249781415*^9}, {3.967022290032826*^9, 
   3.967022291774508*^9}, 3.967023602402217*^9},
 CellLabel->"In[91]:=",ExpressionUUID->"f2c5dfab-2840-4048-a52b-b185ef831744"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023770194559*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"35068a3f-cb30-404b-9bd4-fd65edc53218"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.9670237701963654`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"64450868-e8a0-44ab-af18-f478d1d8b962"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023770197632*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"3da54f59-409f-4017-a790-636af31b05bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.96702377019833*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"724295df-d6d9-4a73-a755-0c00049305d1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.96702377019902*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"5bc37590-0151-4e0c-bbad-83057d418d46"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.9670237702807713`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"8904f237-ed49-44d0-aba4-81b7af737adb"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.967023771287409*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"b4b30b23-35ee-469b-8920-af68fac49952"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/SymmetricDif/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/SymmetricDif/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670237712922497`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"ba636d37-6219-47e8-a376-f49e5b31d309"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"simetrica3\"\>"}],
  SequenceForm["Archivo: ", "simetrica3"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023771294837*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"253bc2dc-3c70-44af-9a9c-d7d80f64983f"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.967023771755514*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"3802469d-9ff8-4797-89ac-7c61433f4432"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/SymmetricDif/simetrica3.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/SymmetricDif/simetrica3.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023771756405*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"5723548d-ab52-4cf6-88b8-c4c0cf9e766a"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/SymmetricDif/\
simetrica3.pdf\"\>"], "Output",
 CellChangeTimes->{3.967023771768898*^9},
 CellLabel->"Out[92]=",ExpressionUUID->"1fa57d75-e410-49a0-bc6b-baf472797f0c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 4: con etiqueta de diferencia sim\[EAcute]trica", "Subsection",
 CellChangeTimes->{{3.9669722155811577`*^9, 3.966972227370956*^9}, {
   3.96697269501637*^9, 3.966972698074332*^9}, {3.967021692623477*^9, 
   3.967021693203027*^9}, {3.967021739781867*^9, 3.967021754858276*^9}, {
   3.967021813019991*^9, 3.967021818163364*^9}, 3.967022105184704*^9, 
   3.967022214304068*^9, {3.967023651621192*^9, 
   3.967023653698826*^9}},ExpressionUUID->"281d9759-0f7e-4c6a-b573-\
5859e99d2178"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SymmetricDif", "[", 
   RowBox[{"\"\<simetrica4.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<X\>\"", ",", "\"\<Y\>\""}], "}"}], ",", "\"\<green\>\"", ",",
     "1.5", ",", "True"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967021500218103*^9, 3.967021539009901*^9}, 
   3.967021672805071*^9, {3.967021723404994*^9, 3.9670217365279837`*^9}, {
   3.967021772154702*^9, 3.9670217724637127`*^9}, {3.967021824945944*^9, 
   3.9670218349035807`*^9}, {3.967021871834454*^9, 3.967021905603507*^9}, 
   3.9670222209400387`*^9, 3.967023642918262*^9, 3.9670237838649063`*^9},
 CellLabel->"In[93]:=",ExpressionUUID->"182d76c6-1866-4139-948d-5ed0f5863400"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670237847026167`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[93]:=",ExpressionUUID->"8e1065fd-a71d-4661-bbbb-647483c8b7e5"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.967023784703896*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[93]:=",ExpressionUUID->"3906bd11-2f39-4b48-8405-442ec2886a8c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023784705024*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[93]:=",ExpressionUUID->"e19515b7-51b2-477d-b73e-73685f30b1b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023784705628*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[93]:=",ExpressionUUID->"ad06dc20-474b-4d0f-bace-79a899869ca1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023784706218*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[93]:=",ExpressionUUID->"76e64f6c-17de-40c5-961c-d717a83f631a"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967023784789936*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[93]:=",ExpressionUUID->"50636da8-9146-4447-8dad-f07e1e665c84"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.967023785797205*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[93]:=",ExpressionUUID->"b3127bd1-aff2-4556-8484-f9ed5ec74052"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/SymmetricDif/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/SymmetricDif/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023785802498*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[93]:=",ExpressionUUID->"50eeb443-cc6c-4923-b3cb-77868bb33148"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"simetrica4\"\>"}],
  SequenceForm["Archivo: ", "simetrica4"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023785805942*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[93]:=",ExpressionUUID->"f234de4f-fc34-4c5d-9762-30466cd0cbc3"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.967023786252887*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[93]:=",ExpressionUUID->"a6d08354-8525-42c3-8652-cf4de4555965"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/SymmetricDif/simetrica4.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/SymmetricDif/simetrica4.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670237862537947`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[93]:=",ExpressionUUID->"1022635b-702c-4793-bbca-2405c2bca31a"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/SymmetricDif/\
simetrica4.pdf\"\>"], "Output",
 CellChangeTimes->{3.96702378626616*^9},
 CellLabel->"Out[94]=",ExpressionUUID->"b9a37f26-f20e-41fa-994b-bf79f5e9967e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 5: elipses m\[AAcute]s peque\[NTilde]as", "Subsection",
 CellChangeTimes->{{3.9669722155811577`*^9, 3.966972227370956*^9}, {
   3.96697269501637*^9, 3.966972698074332*^9}, {3.967021692623477*^9, 
   3.967021693203027*^9}, {3.967021739781867*^9, 3.967021754858276*^9}, {
   3.967021813019991*^9, 3.967021818163364*^9}, {3.96702196939318*^9, 
   3.96702197150316*^9}, 3.967022108517112*^9, 3.9670221980273943`*^9, 
   3.967023681154154*^9},ExpressionUUID->"0873b26d-f320-4a47-8023-\
8d534fb5cc91"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SymmetricDif", "[", 
   RowBox[{"\"\<simetrica5.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}], ",", "\"\<orange\>\"", ",",
     "1.5", ",", "True", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0.8"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967021500218103*^9, 3.967021539009901*^9}, 
   3.967021672805071*^9, {3.967021723404994*^9, 3.9670217365279837`*^9}, {
   3.967021772154702*^9, 3.9670217724637127`*^9}, {3.967021824945944*^9, 
   3.9670218349035807`*^9}, {3.967021871834454*^9, 3.967021905603507*^9}, {
   3.967022045350721*^9, 3.967022045686844*^9}, {3.967022158668399*^9, 
   3.967022209067857*^9}, 3.9670223300486383`*^9, {3.967023664914345*^9, 
   3.967023687796958*^9}},
 CellLabel->"In[95]:=",ExpressionUUID->"dbddd0ca-465d-45b2-9d51-b5d176516969"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023796039547*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[95]:=",ExpressionUUID->"620b9f23-97a2-4df2-92db-6eab86737ed2"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.967023796041099*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[95]:=",ExpressionUUID->"6cad69c7-3fb8-4273-9148-e9cdea80330d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023796042466*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[95]:=",ExpressionUUID->"3c7615c8-07c8-4c64-92f7-cdda8f2398e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670237960432177`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[95]:=",ExpressionUUID->"ff62cb06-eef6-4488-a216-3269f7aa1950"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.967023796043898*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[95]:=",ExpressionUUID->"a3692272-1b85-4129-8f9d-d3983a6f83c7"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967023796110606*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[95]:=",ExpressionUUID->"f8e0bc70-7a66-48f8-97bc-4dafcbcff864"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.967023797117613*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[95]:=",ExpressionUUID->"b601d2ce-cfdc-455d-9762-8ecc5af484b6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/SymmetricDif/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/SymmetricDif/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670237971229057`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[95]:=",ExpressionUUID->"816d0a14-c8d9-4b51-80ad-ab3885bb1e2d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"simetrica5\"\>"}],
  SequenceForm["Archivo: ", "simetrica5"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670237971262913`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[95]:=",ExpressionUUID->"89fc61b9-677b-41e9-b26a-eaa842a1c160"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.967023797618291*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[95]:=",ExpressionUUID->"ea977d36-f1a7-4ec1-95e6-a757471009a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/SymmetricDif/simetrica5.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/SymmetricDif/simetrica5.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670237976192837`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[95]:=",ExpressionUUID->"a39bad4f-e25c-40ef-949c-0a8e3844145a"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/SymmetricDif/\
simetrica5.pdf\"\>"], "Output",
 CellChangeTimes->{3.9670237976319532`*^9},
 CellLabel->"Out[96]=",ExpressionUUID->"ca1640e0-f35b-4f93-a5ca-4603e9909090"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearPro", "Section",
 CellChangeTimes->{
  3.967023820096861*^9},ExpressionUUID->"ac6033dc-52a6-4f26-8443-\
8c43b717d237"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "LinearPro"}]], "Input",
 CellChangeTimes->{{3.967023823230525*^9, 3.9670238239932613`*^9}},
 CellLabel->"In[97]:=",ExpressionUUID->"d1ae11b0-7301-4642-bc03-0d0d9b323ddb"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"LinearPro[filename, constraints, objective, \
fillColor, scale, showOptimalPoint, showLabels, textSize, xRange, yRange] \
crea un diagrama de programaci\[OAcute]n lineal en formato TikZ/LaTeX que \
muestra la regi\[OAcute]n factible, el punto \[OAcute]ptimo y la soluci\
\[OAcute]n del problema de \
optimizaci\[OAcute]n.\\n\\nPAR\[CapitalAAcute]METROS:\\n- filename: String \
que especifica el nombre del archivo de salida (debe terminar en \
\\\".tex\\\")\\n- constraints: Lista de strings con las restricciones del \
problema (ej: {\\\"x + y <= 5\\\", \\\"x >= 0\\\", \\\"y >= 0\\\"})\\n- \
objective: Lista {\\\"tipo\\\", \\\"funci\[OAcute]n\\\"} donde tipo es \
\\\"max\\\" o \\\"min\\\" y funci\[OAcute]n es la expresi\[OAcute]n a \
optimizar (ej: {\\\"max\\\", \\\"3*x + 2*y\\\"})\\n- fillColor: String que \
especifica el color de relleno de la regi\[OAcute]n factible (opcional, por \
defecto \\\"green\\\")\\n- scale: Real que define la escala del diagrama \
completo (opcional, por defecto 1.2)\\n- showOptimalPoint: True/False para \
mostrar el punto \[OAcute]ptimo marcado en rojo (opcional, por defecto \
True)\\n- showLabels: True/False para mostrar etiquetas de ejes, coordenadas \
y valores (opcional, por defecto True)\\n- textSize: String que define el \
tama\[NTilde]o del texto (\\\"tiny\\\", \\\"small\\\", \\\"normal\\\", \
\\\"large\\\", \\\"huge\\\") (opcional, por defecto \\\"normal\\\")\\n- \
xRange: Lista {min, max} que define el rango del eje x (opcional, por defecto \
{0, 10})\\n- yRange: Lista {min, max} que define el rango del eje y \
(opcional, por defecto {0, 8})\\n\\nCOLORES PREDEFINIDOS:\\nLos siguientes \
colores se convierten autom\[AAcute]ticamente a tonos TikZ apropiados:\\n- \\\
\"blue\\\" -> \\\"blue!30\\\"     \[Bullet] \\\"red\\\" -> \\\"red!30\\\"     \
  \[Bullet] \\\"green\\\" -> \\\"green!30\\\"\\n- \\\"yellow\\\" -> \
\\\"yellow!40\\\" \[Bullet] \\\"orange\\\" -> \\\"orange!30\\\" \[Bullet] \
\\\"purple\\\" -> \\\"purple!30\\\"\\n- Cualquier otro string se convierte a \
\\\"color!30\\\"\\n\\nTIPOS DE RESTRICCIONES SOPORTADAS:\\n- Desigualdades \
lineales: \\\"x + y <= 5\\\", \\\"2*x - y >= 3\\\"\\n- Restricciones de no \
negatividad: \\\"x >= 0\\\", \\\"y >= 0\\\"\\n- Cualquier expresi\[OAcute]n \
linear v\[AAcute]lida en Mathematica\\n\\nFUNCIONALIDAD PRINCIPAL:\\n- \
Resuelve autom\[AAcute]ticamente el problema de optimizaci\[OAcute]n usando \
NMaximize/NMinimize\\n- Encuentra todos los v\[EAcute]rtices de la regi\
\[OAcute]n factible mediante tres m\[EAcute]todos:\\n  1. Intersecciones \
entre l\[IAcute]neas de restricciones\\n  2. Intersecciones con los bordes \
del rango de visualizaci\[OAcute]n\\n  3. Esquinas del \[AAcute]rea de \
visualizaci\[OAcute]n\\n- Genera la regi\[OAcute]n factible sombreada con el \
color especificado\\n- Marca el punto \[OAcute]ptimo en rojo con sus \
coordenadas y valor objetivo\\n- Dibuja ejes coordenados con marcas y \
etiquetas\\n- Incluye comentarios en el c\[OAcute]digo TikZ con las \
restricciones y objetivo\\n\\nVALIDACIONES:\\n- El filename debe terminar \
obligatoriamente en \\\".tex\\\"\\n- La lista objective debe contener \
exactamente 2 elementos: {\\\"tipo\\\", \\\"funci\[OAcute]n\\\"}\\n- El tipo \
debe ser \\\"max\\\" o \\\"min\\\" (case-insensitive)\\n- Las restricciones \
deben ser expresiones v\[AAcute]lidas de Mathematica\\n- Retorna $Failed si \
alguna validaci\[OAcute]n falla o hay error en la \
optimizaci\[OAcute]n\\n\\nVALOR DE RETORNO:\\nRetorna la ruta completa del \
archivo exportado, o $Failed en caso de error.\\nAdem\[AAcute]s imprime en \
consola el punto \[OAcute]ptimo y valor \[OAcute]ptimo \
encontrados.\\n\\nEJEMPLOS:\\n- LinearPro[\\\"ejemplo1.tex\\\", {\\\"x + y <= \
4\\\", \\\"x >= 0\\\", \\\"y >= 0\\\"}, {\\\"max\\\", \\\"3*x + 2*y\\\"}]\\n- \
LinearPro[\\\"prob2.tex\\\", {\\\"2*x + y <= 6\\\", \\\"x + 3*y <= 9\\\", \
\\\"x >= 0\\\", \\\"y >= 0\\\"}, {\\\"min\\\", \\\"x + y\\\"}, \\\"blue\\\", \
1.5, True, True, \\\"large\\\"]\\n- LinearPro[\\\"complejo.tex\\\", {\\\"x + \
2*y <= 8\\\", \\\"3*x + y <= 12\\\", \\\"x >= 1\\\", \\\"y >= 1\\\"}, \
{\\\"max\\\", \\\"5*x + 3*y\\\"}, \\\"red\\\", 1.0, True, False, \
\\\"small\\\", {0, 6}, {0, 6}]\\n\\nCASOS ESPECIALES:\\n- Problema no \
acotado: Detecta cuando el valor \[OAcute]ptimo es infinito\\n- Problema \
infactible: Detecta cuando no existe soluci\[OAcute]n\\n- Regi\[OAcute]n \
factible vac\[IAcute]a: Maneja casos sin v\[EAcute]rtices \
v\[AAcute]lidos\\n\\nARCHIVOS GENERADOS:\\n- Crea la carpeta \
Downloads/LinearPro si no existe\\n- Exporta archivo .tex completo con \
documento LaTeX standalone\\n- Incluye todos los paquetes necesarios (tikz, \
amsmath, patterns)\\n- Listo para compilar directamente con LaTeX/TikZ\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"LinearPro", "[", 
                    
                    RowBox[{
                    "VilTeX`Private`filename_String", ",", 
                    "VilTeX`Private`constraints_List", ",", 
                    "VilTeX`Private`objective_List", ",", 
                    
                    RowBox[{
                    "VilTeX`Private`fillColor_String", ":", "\"green\""}], 
                    ",", 
                    RowBox[{"VilTeX`Private`scale_Real", ":", "1.2`"}], ",", 
                    RowBox[{"VilTeX`Private`showOptimalPoint_", ":", "True"}],
                     ",", 
                    RowBox[{"VilTeX`Private`showLabels_", ":", "True"}], ",", 
                    
                    
                    RowBox[{
                    "VilTeX`Private`textSize_String", ":", "\"normal\""}], 
                    ",", 
                    RowBox[{"VilTeX`Private`xRange_List", ":", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "10"}], "}"}]}], ",", 
                    RowBox[{"VilTeX`Private`yRange_List", ":", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "8"}], "}"}]}]}], "]"}], ":=", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`x", ",", "VilTeX`Private`y", ",", 
                    "VilTeX`Private`processedColor", ",", 
                    "VilTeX`Private`objType", ",", 
                    "VilTeX`Private`objFunction", ",", 
                    "VilTeX`Private`optimalResult", ",", 
                    "VilTeX`Private`optimalPoint", ",", 
                    "VilTeX`Private`optimalValue", ",", 
                    "VilTeX`Private`vertices", ",", "VilTeX`Private`tikzCode",
                     ",", "VilTeX`Private`fullDocument", ",", 
                    "VilTeX`Private`folderPath", ",", 
                    "VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`formatNumber", ",", 
                    "VilTeX`Private`sizeCmd"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringEndsQ", "[", 
                    RowBox[{"VilTeX`Private`filename", ",", "\".tex\""}], 
                    "]"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: El archivo debe terminar en .tex\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`objective", "]"}], 
                    "\[NotEqual]", "2"}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: objetivo debe ser {\\\"max\\\"|\\\"min\\\", \
\\\"expresi\[OAcute]n\\\"}\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`num_", "]"}], ":=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"Round", "[", 
                    RowBox[{
                    RowBox[{"N", "[", "VilTeX`Private`num", "]"}], ",", 
                    "0.01`"}], "]"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`sizeCmd", "=", 
                    RowBox[{"Switch", "[", 
                    
                    RowBox[{"VilTeX`Private`textSize", ",", "\"huge\"", ",", 
                    "\"\\\\huge \"", ",", "\"large\"", ",", "\"\\\\large \"", 
                    ",", "\"small\"", ",", "\"\\\\small \"", ",", "\"tiny\"", 
                    ",", "\"\\\\tiny \"", ",", "_", ",", "\"\""}], "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`processedColor", "=", 
                    RowBox[{"Switch", "[", 
                    
                    RowBox[{"VilTeX`Private`fillColor", ",", "\"blue\"", ",", 
                    "\"blue!30\"", ",", "\"red\"", ",", "\"red!30\"", ",", 
                    "\"green\"", ",", "\"green!30\"", ",", "\"yellow\"", ",", 
                    "\"yellow!40\"", ",", "\"orange\"", ",", "\"orange!30\"", 
                    ",", "\"purple\"", ",", "\"purple!30\"", ",", "_", ",", 
                    RowBox[{"VilTeX`Private`fillColor", "<>", "\"!30\""}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`objType", "=", 
                    RowBox[{"ToLowerCase", "[", 
                    
                    RowBox[{"VilTeX`Private`objective", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`objFunction", "=", 
                    RowBox[{"ToExpression", "[", 
                    
                    RowBox[{"VilTeX`Private`objective", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`optimalResult", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`objType", "\[Equal]", "\"max\""}],
                     ",", 
                    RowBox[{"NMaximize", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`objFunction", ",", 
                    RowBox[{"And", "@@", 
                    
                    RowBox[{"ToExpression", "/@", 
                    "VilTeX`Private`constraints"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`x", ",", "VilTeX`Private`y"}], 
                    "}"}]}], "]"}], ",", 
                    RowBox[{"NMinimize", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`objFunction", ",", 
                    RowBox[{"And", "@@", 
                    
                    RowBox[{"ToExpression", "/@", 
                    "VilTeX`Private`constraints"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`x", ",", "VilTeX`Private`y"}], 
                    "}"}]}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Head", "[", "VilTeX`Private`optimalResult", 
                    "]"}], "===", "List"}], "&&", 
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`optimalResult", 
                    "]"}], "\[GreaterEqual]", "2"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`optimalValue", "=", 
                    RowBox[{"N", "[", 
                    
                    RowBox[{"VilTeX`Private`optimalResult", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`optimalPoint", "=", 
                    RowBox[{"N", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`x", ",", "VilTeX`Private`y"}], 
                    "}"}], "/.", "\[VeryThinSpace]", 
                    
                    RowBox[{"VilTeX`Private`optimalResult", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
                    "]"}]}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", "\"Error en optimizaci\[OAcute]n\"",
                     "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`vertices", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`constraintLines", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{"VilTeX`Private`constraints", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{"#1", ",", "\"<=\""}], "]"}], "||", 
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{"#1", ",", "\">=\""}], "]"}]}], "&"}]}], "]"}]}], 
                    "}"}], ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`eq1", "=", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`constraintLines", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"<=\"", "\[Rule]", "\"==\""}], ",", 
                    RowBox[{"\">=\"", "\[Rule]", "\"==\""}]}], "}"}]}], "]"}],
                     "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`eq2", "=", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`constraintLines", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`j", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"<=\"", "\[Rule]", "\"==\""}], ",", 
                    RowBox[{"\">=\"", "\[Rule]", "\"==\""}]}], "}"}]}], "]"}],
                     "]"}]}]}], "}"}], ",", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`sol", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"Solve", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`eq1", ",", "VilTeX`Private`eq2"}],
                     "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`x", ",", "VilTeX`Private`y"}], 
                    "}"}]}], "]"}], "]"}]}], "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`sol", "]"}], ">", 
                    "0"}], "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`x", ",", "VilTeX`Private`y"}], 
                    "}"}], "/.", "\[VeryThinSpace]", 
                    
                    RowBox[{"VilTeX`Private`sol", "\[LeftDoubleBracket]", "1",
                     "\[RightDoubleBracket]"}]}], ",", "NumericQ"}], "]"}]}], 
                    ",", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`point", "=", 
                    RowBox[{"N", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`x", ",", "VilTeX`Private`y"}], 
                    "}"}], "/.", "\[VeryThinSpace]", 
                    
                    RowBox[{"VilTeX`Private`sol", "\[LeftDoubleBracket]", "1",
                     "\[RightDoubleBracket]"}]}], "]"}]}], "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"And", "@@", 
                    RowBox[{"(", 
                    RowBox[{
                    
                    RowBox[{"ToExpression", "/@", 
                    "VilTeX`Private`constraints"}], "/.", "\[VeryThinSpace]", 
                    
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`x", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`point", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"VilTeX`Private`y", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`point", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}]}], "}"}]}], ")"}]}], ",", 
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`vertices", ",", 
                    "VilTeX`Private`point"}], "]"}]}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    RowBox[{"VilTeX`Private`i", "+", "1"}], ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`constraintLines", 
                    "]"}]}], "}"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", "1", ",", 
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`constraintLines", 
                    "]"}], "-", "1"}]}], "}"}]}], "]"}], ";"}]}], "]"}], ";", 
                    
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`boundaryConstraints", "=", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"x == \"", "<>", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"VilTeX`Private`xRange", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}]}], ",", 
                    RowBox[{"\"x == \"", "<>", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"VilTeX`Private`xRange", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "]"}]}], ",", 
                    RowBox[{"\"y == \"", "<>", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"VilTeX`Private`yRange", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}]}], ",", 
                    RowBox[{"\"y == \"", "<>", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"VilTeX`Private`yRange", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "]"}]}]}], "}"}]}], "}"}],
                     ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`eq1", "=", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`constraints", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"<=\"", "\[Rule]", "\"==\""}], ",", 
                    RowBox[{"\">=\"", "\[Rule]", "\"==\""}]}], "}"}]}], "]"}],
                     "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`eq2", "=", 
                    RowBox[{"ToExpression", "[", 
                    
                    RowBox[{"VilTeX`Private`boundaryConstraints", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`j", 
                    "\[RightDoubleBracket]"}], "]"}]}]}], "}"}], ",", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`sol", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"Solve", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`eq1", ",", "VilTeX`Private`eq2"}],
                     "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`x", ",", "VilTeX`Private`y"}], 
                    "}"}]}], "]"}], "]"}]}], "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`sol", "]"}], ">", 
                    "0"}], "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`x", ",", "VilTeX`Private`y"}], 
                    "}"}], "/.", "\[VeryThinSpace]", 
                    
                    RowBox[{"VilTeX`Private`sol", "\[LeftDoubleBracket]", "1",
                     "\[RightDoubleBracket]"}]}], ",", "NumericQ"}], "]"}]}], 
                    ",", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`point", "=", 
                    RowBox[{"N", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`x", ",", "VilTeX`Private`y"}], 
                    "}"}], "/.", "\[VeryThinSpace]", 
                    
                    RowBox[{"VilTeX`Private`sol", "\[LeftDoubleBracket]", "1",
                     "\[RightDoubleBracket]"}]}], "]"}]}], "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`xRange", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "\[LessEqual]", 
                    
                    RowBox[{"VilTeX`Private`point", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "\[LessEqual]", 
                    
                    RowBox[{"VilTeX`Private`xRange", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}], "&&", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`yRange", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "\[LessEqual]", 
                    
                    RowBox[{"VilTeX`Private`point", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "\[LessEqual]", 
                    
                    RowBox[{"VilTeX`Private`yRange", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}], "&&", 
                    RowBox[{"And", "@@", 
                    RowBox[{"(", 
                    RowBox[{
                    
                    RowBox[{"ToExpression", "/@", 
                    "VilTeX`Private`constraints"}], "/.", "\[VeryThinSpace]", 
                    
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`x", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`point", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"VilTeX`Private`y", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`point", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}]}], "}"}]}], ")"}]}]}], 
                    ",", 
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`vertices", ",", 
                    "VilTeX`Private`point"}], "]"}]}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", "1", ",", 
                    
                    RowBox[{"Length", "[", 
                    "VilTeX`Private`boundaryConstraints", "]"}]}], "}"}]}], 
                    "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", "1", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`constraints", 
                    "]"}]}], "}"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`corners", "=", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`xRange", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`yRange", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`xRange", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`yRange", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`xRange", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`yRange", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`xRange", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`yRange", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}], "}"}]}], "}"}]}], "}"}],
                     ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"And", "@@", 
                    RowBox[{"(", 
                    RowBox[{
                    
                    RowBox[{"ToExpression", "/@", 
                    "VilTeX`Private`constraints"}], "/.", "\[VeryThinSpace]", 
                    
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`x", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`corners", "\[LeftDoubleBracket]", 
                    
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"VilTeX`Private`y", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`corners", "\[LeftDoubleBracket]", 
                    
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}]}]}], "}"}]}], ")"}]}], ",", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"VilTeX`Private`vertices", ",", 
                    
                    RowBox[{"VilTeX`Private`corners", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}], "]"}]}], 
                    "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`corners", "]"}]}], 
                    "}"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`vertices", "=", 
                    RowBox[{"DeleteDuplicates", "[", 
                    RowBox[{"VilTeX`Private`vertices", ",", 
                    RowBox[{
                    RowBox[{
                    TemplateBox[{
                    RowBox[{"#1", "-", "#2"}]}, "Norm"], "<", "0.01`"}], 
                    "&"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`vertices", "]"}], 
                    ">", "0"}], ",", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`center", "=", 
                    RowBox[{"Mean", "[", "VilTeX`Private`vertices", "]"}]}], 
                    "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`vertices", "=", 
                    RowBox[{"SortBy", "[", 
                    RowBox[{"VilTeX`Private`vertices", ",", 
                    RowBox[{
                    RowBox[{"ArcTan", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", 
                    
                    RowBox[{"VilTeX`Private`center", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "-", 
                    
                    RowBox[{"VilTeX`Private`center", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}]}], "]"}], "&"}]}], 
                    "]"}]}], ";"}]}], "]"}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Advertencia: No se encontraron v\[EAcute]rtices v\
\[AAcute]lidos\"", "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\"\\\\begin{tikzpicture}[scale=\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`scale", "]"}], 
                    "<>", "\"]\\n\\n\""}], ")"}], "<>", 
                    "\"% Comentario: Problema de programaci\[OAcute]n \
lineal\\n\"", "<>", 
                    RowBox[{"(", 
                    RowBox[{"\"% Restricciones: \"", "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`constraints", 
                    "]"}], "<>", "\"\\n\""}], ")"}], "<>", 
                    RowBox[{"(", 
                    
                    RowBox[{"\"% Objetivo: \"", "<>", 
                    "VilTeX`Private`objType", "<>", "\"imizar \"", "<>", 
                    
                    RowBox[{"VilTeX`Private`objective", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "<>", "\"\\n\\n\""}], ")"}], "<>", 
                    "\"% Ejes coordenados\\n\"", "<>", 
                    RowBox[{"(", 
                    RowBox[{"\"\\\\draw[->] (-0.5,0) -- (\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`xRange", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "+", "1"}], "]"}], "<>", 
                    "\",0)\"", "<>", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`showLabels", ",", 
                    
                    RowBox[{"\" node[right] {\"", "<>", 
                    "VilTeX`Private`sizeCmd", "<>", "\"$x$}\""}], ",", 
                    "\"\""}], "]"}], "<>", "\";\\n\""}], ")"}], "<>", 
                    RowBox[{"(", 
                    RowBox[{"\"\\\\draw[->] (0,-0.5) -- (0,\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`yRange", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "+", "1"}], "]"}], "<>", 
                    "\")\"", "<>", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`showLabels", ",", 
                    
                    RowBox[{"\" node[above] {\"", "<>", 
                    "VilTeX`Private`sizeCmd", "<>", "\"$y$}\""}], ",", 
                    "\"\""}], "]"}], "<>", "\";\\n\\n\""}], ")"}], "<>", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`showLabels", ",", 
                    RowBox[{"\"% Marcas en ejes\\n\"", "<>", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"\\\\draw (\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`i", "]"}], "<>", 
                    "\",0) -- (\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`i", "]"}], "<>", 
                    "\",-0.1) node[below] {\"", "<>", 
                    "VilTeX`Private`sizeCmd", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`i", "]"}], "<>", 
                    "\"};\\n\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", "1", ",", 
                    
                    RowBox[{"VilTeX`Private`xRange", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"Max", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Round", "[", 
                    FractionBox[
                    
                    RowBox[{"VilTeX`Private`xRange", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "8"], "]"}]}], "]"}]}], 
                    "}"}]}], "]"}], "]"}], "<>", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"\\\\draw (0,\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`j", "]"}], "<>", 
                    "\") -- (-0.1,\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`j", "]"}], "<>", 
                    "\") node[left] {\"", "<>", "VilTeX`Private`sizeCmd", 
                    "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`j", "]"}], "<>", 
                    "\"};\\n\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", "1", ",", 
                    
                    RowBox[{"VilTeX`Private`yRange", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"Max", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Round", "[", 
                    FractionBox[
                    
                    RowBox[{"VilTeX`Private`yRange", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "6"], "]"}]}], "]"}]}], 
                    "}"}]}], "]"}], "]"}], "<>", "\"\\n\""}], ",", "\"\""}], 
                    "]"}], "<>", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`vertices", "]"}], 
                    "\[GreaterEqual]", "3"}], ",", 
                    
                    RowBox[{"\"% Regi\[OAcute]n factible\\n\\\\fill[\"", "<>",
                     "VilTeX`Private`processedColor", "<>", "\"] \"", "<>", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Riffle", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"\"(\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], "&"}], 
                    ")"}], "/@", "VilTeX`Private`vertices"}], ",", 
                    "\" -- \""}], "]"}], "]"}], "<>", 
                    "\" -- cycle;\\n\\n\""}], ",", "\"\""}], "]"}], "<>", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`vertices", "]"}], 
                    "\[GreaterEqual]", "3"}], ",", 
                    
                    RowBox[{
                    "\"% Contorno de la regi\[OAcute]n\\n\\\\draw[black, \
thick] \"", "<>", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Riffle", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"\"(\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], "&"}], 
                    ")"}], "/@", "VilTeX`Private`vertices"}], ",", 
                    "\" -- \""}], "]"}], "]"}], "<>", 
                    "\" -- cycle;\\n\\n\""}], ",", "\"\""}], "]"}], "<>", 
                    "\"% L\[IAcute]neas de restricciones\\n\"", "<>", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"% Restricci\[OAcute]n \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`i", "]"}], "<>", 
                    "\": \"", "<>", 
                    
                    RowBox[{"VilTeX`Private`constraints", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}], "<>", "\"\\n\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`constraints", 
                    "]"}]}], "}"}]}], "]"}], "]"}], "<>", "\"\\n\"", "<>", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`showOptimalPoint", ",", 
                    
                    RowBox[{"\"% Punto \[OAcute]ptimo\\n\\\\fill[red] (\"", 
                    "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`optimalPoint", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`optimalPoint", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\") circle (0.08);\\n\"", "<>", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`showLabels", ",", 
                    RowBox[{"\"\\\\node[red, above right] at (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`optimalPoint", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`optimalPoint", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\") {\"", "<>", "VilTeX`Private`sizeCmd", 
                    "<>", "\"(\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`optimalPoint", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\", \"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`optimalPoint", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\")};\\n\"", "<>", 
                    "\"\\\\node[red, below right] at (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`optimalPoint", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`optimalPoint", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\") {\"", "<>", "VilTeX`Private`sizeCmd", 
                    "<>", "\"$z = \"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`optimalValue", "]"}], "<>", 
                    "\"$};\\n\\n\""}], ",", "\"\\n\""}], "]"}]}], ",", 
                    "\"\""}], "]"}], "<>", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`showLabels", "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`vertices", "]"}], 
                    "\[GreaterEqual]", "3"}]}], ",", 
                    
                    RowBox[{"\"% Etiqueta de regi\[OAcute]n\\n\\\\node[\"", 
                    "<>", 
                    RowBox[{"StringTake", "[", 
                    RowBox[{"VilTeX`Private`fillColor", ",", 
                    RowBox[{"Min", "[", 
                    RowBox[{
                    
                    RowBox[{"StringLength", "[", "VilTeX`Private`fillColor", 
                    "]"}], ",", "6"}], "]"}]}], "]"}], "<>", 
                    "\"!80!black, font=\\\\bfseries] at (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    RowBox[{
                    RowBox[{"Mean", "[", "VilTeX`Private`vertices", "]"}], 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    RowBox[{
                    RowBox[{"Mean", "[", "VilTeX`Private`vertices", "]"}], 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\") {\"", "<>", "VilTeX`Private`sizeCmd", 
                    "<>", "\"Regi\[OAcute]n Factible};\\n\\n\""}], ",", 
                    "\"\""}], "]"}], "<>", "\"\\\\end{tikzpicture}\\n\""}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`fullDocument", "=", 
                    
                    RowBox[{
                    "\"\\\\documentclass[border=5mm]{standalone}\\n\"", "<>", 
                    "\"\\\\usepackage{tikz}\\n\"", "<>", 
                    "\"\\\\usepackage{amsmath}\\n\"", "<>", 
                    "\"\\\\usetikzlibrary{patterns}\\n\\n\"", "<>", 
                    "\"\\\\begin{document}\\n\"", "<>", 
                    "VilTeX`Private`tikzCode", "<>", 
                    "\"\\\\end{document}\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`folderPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"$HomeDirectory", ",", "\"Downloads\"", ",", 
                    "\"LinearPro\""}], "}"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"DirectoryQ", "[", "VilTeX`Private`folderPath", 
                    "]"}]}], ",", 
                    
                    RowBox[{"CreateDirectory", "[", 
                    "VilTeX`Private`folderPath", "]"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`downloadPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`folderPath", ",", 
                    "VilTeX`Private`filename"}], "}"}], "]"}]}], ";", 
                    RowBox[{"Export", "[", 
                    
                    RowBox[{"VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`fullDocument", ",", "\"Text\""}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`optimalValue", "===", 
                    "\[Infinity]"}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"\[Checkmark] Punto \[OAcute]ptimo: No acotado (\
\[Infinity])\"", "]"}], ";", 
                    
                    RowBox[{"Print", "[", 
                    "\"\[Checkmark] Valor \[OAcute]ptimo: \[Infinity]\"", 
                    "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`optimalValue", "===", 
                    "Undefined"}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"\[Checkmark] Punto \[OAcute]ptimo: No existe\"", "]"}],
                     ";", 
                    
                    RowBox[{"Print", "[", 
                    "\"\[Checkmark] Valor \[OAcute]ptimo: Indefinido\"", 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"\[Checkmark] Punto \[OAcute]ptimo: \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`optimalPoint", 
                    "]"}]}], "]"}], ";", 
                    RowBox[{"Print", "[", 
                    RowBox[{"\"\[Checkmark] Valor \[OAcute]ptimo: \"", "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`optimalValue", 
                    "]"}]}], "]"}], ";"}]}], "]"}]}], "]"}], ";", 
                    "VilTeX`Private`downloadPath"}]}], "]"}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilTeX`LinearPro\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"LinearPro[filename, constraints, objective, \
fillColor, scale, showOptimalPoint, showLabels, textSize, xRange, yRange] \
crea un diagrama de programaci\[OAcute]n lineal en formato TikZ/LaTeX que \
muestra la regi\[OAcute]n factible, el punto \[OAcute]ptimo y la soluci\
\[OAcute]n del problema de \
optimizaci\[OAcute]n.\\n\\nPAR\[CapitalAAcute]METROS:\\n- filename: String \
que especifica el nombre del archivo de salida (debe terminar en \
\\\".tex\\\")\\n- constraints: Lista de strings con las restricciones del \
problema (ej: {\\\"x + y <= 5\\\", \\\"x >= 0\\\", \\\"y >= 0\\\"})\\n- \
objective: Lista {\\\"tipo\\\", \\\"funci\[OAcute]n\\\"} donde tipo es \
\\\"max\\\" o \\\"min\\\" y funci\[OAcute]n es la expresi\[OAcute]n a \
optimizar (ej: {\\\"max\\\", \\\"3*x + 2*y\\\"})\\n- fillColor: String que \
especifica el color de relleno de la regi\[OAcute]n factible (opcional, por \
defecto \\\"green\\\")\\n- scale: Real que define la escala del diagrama \
completo (opcional, por defecto 1.2)\\n- showOptimalPoint: True/False para \
mostrar el punto \[OAcute]ptimo marcado en rojo (opcional, por defecto \
True)\\n- showLabels: True/False para mostrar etiquetas de ejes, coordenadas \
y valores (opcional, por defecto True)\\n- textSize: String que define el \
tama\[NTilde]o del texto (\\\"tiny\\\", \\\"small\\\", \\\"normal\\\", \
\\\"large\\\", \\\"huge\\\") (opcional, por defecto \\\"normal\\\")\\n- \
xRange: Lista {min, max} que define el rango del eje x (opcional, por defecto \
{0, 10})\\n- yRange: Lista {min, max} que define el rango del eje y \
(opcional, por defecto {0, 8})\\n\\nCOLORES PREDEFINIDOS:\\nLos siguientes \
colores se convierten autom\[AAcute]ticamente a tonos TikZ apropiados:\\n- \\\
\"blue\\\" -> \\\"blue!30\\\"     \[Bullet] \\\"red\\\" -> \\\"red!30\\\"     \
  \[Bullet] \\\"green\\\" -> \\\"green!30\\\"\\n- \\\"yellow\\\" -> \
\\\"yellow!40\\\" \[Bullet] \\\"orange\\\" -> \\\"orange!30\\\" \[Bullet] \
\\\"purple\\\" -> \\\"purple!30\\\"\\n- Cualquier otro string se convierte a \
\\\"color!30\\\"\\n\\nTIPOS DE RESTRICCIONES SOPORTADAS:\\n- Desigualdades \
lineales: \\\"x + y <= 5\\\", \\\"2*x - y >= 3\\\"\\n- Restricciones de no \
negatividad: \\\"x >= 0\\\", \\\"y >= 0\\\"\\n- Cualquier expresi\[OAcute]n \
linear v\[AAcute]lida en Mathematica\\n\\nFUNCIONALIDAD PRINCIPAL:\\n- \
Resuelve autom\[AAcute]ticamente el problema de optimizaci\[OAcute]n usando \
NMaximize/NMinimize\\n- Encuentra todos los v\[EAcute]rtices de la regi\
\[OAcute]n factible mediante tres m\[EAcute]todos:\\n  1. Intersecciones \
entre l\[IAcute]neas de restricciones\\n  2. Intersecciones con los bordes \
del rango de visualizaci\[OAcute]n\\n  3. Esquinas del \[AAcute]rea de \
visualizaci\[OAcute]n\\n- Genera la regi\[OAcute]n factible sombreada con el \
color especificado\\n- Marca el punto \[OAcute]ptimo en rojo con sus \
coordenadas y valor objetivo\\n- Dibuja ejes coordenados con marcas y \
etiquetas\\n- Incluye comentarios en el c\[OAcute]digo TikZ con las \
restricciones y objetivo\\n\\nVALIDACIONES:\\n- El filename debe terminar \
obligatoriamente en \\\".tex\\\"\\n- La lista objective debe contener \
exactamente 2 elementos: {\\\"tipo\\\", \\\"funci\[OAcute]n\\\"}\\n- El tipo \
debe ser \\\"max\\\" o \\\"min\\\" (case-insensitive)\\n- Las restricciones \
deben ser expresiones v\[AAcute]lidas de Mathematica\\n- Retorna $Failed si \
alguna validaci\[OAcute]n falla o hay error en la \
optimizaci\[OAcute]n\\n\\nVALOR DE RETORNO:\\nRetorna la ruta completa del \
archivo exportado, o $Failed en caso de error.\\nAdem\[AAcute]s imprime en \
consola el punto \[OAcute]ptimo y valor \[OAcute]ptimo \
encontrados.\\n\\nEJEMPLOS:\\n- LinearPro[\\\"ejemplo1.tex\\\", {\\\"x + y <= \
4\\\", \\\"x >= 0\\\", \\\"y >= 0\\\"}, {\\\"max\\\", \\\"3*x + 2*y\\\"}]\\n- \
LinearPro[\\\"prob2.tex\\\", {\\\"2*x + y <= 6\\\", \\\"x + 3*y <= 9\\\", \
\\\"x >= 0\\\", \\\"y >= 0\\\"}, {\\\"min\\\", \\\"x + y\\\"}, \\\"blue\\\", \
1.5, True, True, \\\"large\\\"]\\n- LinearPro[\\\"complejo.tex\\\", {\\\"x + \
2*y <= 8\\\", \\\"3*x + y <= 12\\\", \\\"x >= 1\\\", \\\"y >= 1\\\"}, \
{\\\"max\\\", \\\"5*x + 3*y\\\"}, \\\"red\\\", 1.0, True, False, \
\\\"small\\\", {0, 6}, {0, 6}]\\n\\nCASOS ESPECIALES:\\n- Problema no \
acotado: Detecta cuando el valor \[OAcute]ptimo es infinito\\n- Problema \
infactible: Detecta cuando no existe soluci\[OAcute]n\\n- Regi\[OAcute]n \
factible vac\[IAcute]a: Maneja casos sin v\[EAcute]rtices \
v\[AAcute]lidos\\n\\nARCHIVOS GENERADOS:\\n- Crea la carpeta \
Downloads/LinearPro si no existe\\n- Exporta archivo .tex completo con \
documento LaTeX standalone\\n- Incluye todos los paquetes necesarios (tikz, \
amsmath, patterns)\\n- Listo para compilar directamente con LaTeX/TikZ\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}},
            ScrollPosition->{0., 0.}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "LinearPro[filename, constraints, objective, fillColor, scale, \
showOptimalPoint, showLabels, textSize, xRange, yRange] crea un diagrama de \
programaci\[OAcute]n lineal en formato TikZ/LaTeX que muestra la \
regi\[OAcute]n factible, el punto \[OAcute]ptimo y la soluci\[OAcute]n del \
problema de optimizaci\[OAcute]n.\n\nPAR\[CapitalAAcute]METROS:\n- filename: \
String que especifica el nombre del archivo de salida (debe terminar en \
\".tex\")\n- constraints: Lista de strings con las restricciones del problema \
(ej: {\"x + y <= 5\", \"x >= 0\", \"y >= 0\"})\n- objective: Lista {\"tipo\", \
\"funci\[OAcute]n\"} donde tipo es \"max\" o \"min\" y funci\[OAcute]n es la \
expresi\[OAcute]n a optimizar (ej: {\"max\", \"3*x + 2*y\"})\n- fillColor: \
String que especifica el color de relleno de la regi\[OAcute]n factible \
(opcional, por defecto \"green\")\n- scale: Real que define la escala del \
diagrama completo (opcional, por defecto 1.2)\n- showOptimalPoint: True/False \
para mostrar el punto \[OAcute]ptimo marcado en rojo (opcional, por defecto \
True)\n- showLabels: True/False para mostrar etiquetas de ejes, coordenadas y \
valores (opcional, por defecto True)\n- textSize: String que define el tama\
\[NTilde]o del texto (\"tiny\", \"small\", \"normal\", \"large\", \"huge\") \
(opcional, por defecto \"normal\")\n- xRange: Lista {min, max} que define el \
rango del eje x (opcional, por defecto {0, 10})\n- yRange: Lista {min, max} \
que define el rango del eje y (opcional, por defecto {0, 8})\n\nCOLORES \
PREDEFINIDOS:\nLos siguientes colores se convierten autom\[AAcute]ticamente a \
tonos TikZ apropiados:\n- \"blue\" -> \"blue!30\"     \[Bullet] \"red\" -> \
\"red!30\"       \[Bullet] \"green\" -> \"green!30\"\n- \"yellow\" -> \
\"yellow!40\" \[Bullet] \"orange\" -> \"orange!30\" \[Bullet] \"purple\" -> \
\"purple!30\"\n- Cualquier otro string se convierte a \"color!30\"\n\nTIPOS \
DE RESTRICCIONES SOPORTADAS:\n- Desigualdades lineales: \"x + y <= 5\", \"2*x \
- y >= 3\"\n- Restricciones de no negatividad: \"x >= 0\", \"y >= 0\"\n- \
Cualquier expresi\[OAcute]n linear v\[AAcute]lida en Mathematica\n\n\
FUNCIONALIDAD PRINCIPAL:\n- Resuelve autom\[AAcute]ticamente el problema de \
optimizaci\[OAcute]n usando NMaximize/NMinimize\n- Encuentra todos los v\
\[EAcute]rtices de la regi\[OAcute]n factible mediante tres m\[EAcute]todos:\n\
  1. Intersecciones entre l\[IAcute]neas de restricciones\n  2. \
Intersecciones con los bordes del rango de visualizaci\[OAcute]n\n  3. \
Esquinas del \[AAcute]rea de visualizaci\[OAcute]n\n- Genera la \
regi\[OAcute]n factible sombreada con el color especificado\n- Marca el punto \
\[OAcute]ptimo en rojo con sus coordenadas y valor objetivo\n- Dibuja ejes \
coordenados con marcas y etiquetas\n- Incluye comentarios en el \
c\[OAcute]digo TikZ con las restricciones y objetivo\n\nVALIDACIONES:\n- El \
filename debe terminar obligatoriamente en \".tex\"\n- La lista objective \
debe contener exactamente 2 elementos: {\"tipo\", \"funci\[OAcute]n\"}\n- El \
tipo debe ser \"max\" o \"min\" (case-insensitive)\n- Las restricciones deben \
ser expresiones v\[AAcute]lidas de Mathematica\n- Retorna $Failed si alguna \
validaci\[OAcute]n falla o hay error en la optimizaci\[OAcute]n\n\nVALOR DE \
RETORNO:\nRetorna la ruta completa del archivo exportado, o $Failed en caso \
de error.\nAdem\[AAcute]s imprime en consola el punto \[OAcute]ptimo y valor \
\[OAcute]ptimo encontrados.\n\nEJEMPLOS:\n- LinearPro[\"ejemplo1.tex\", {\"x \
+ y <= 4\", \"x >= 0\", \"y >= 0\"}, {\"max\", \"3*x + 2*y\"}]\n- \
LinearPro[\"prob2.tex\", {\"2*x + y <= 6\", \"x + 3*y <= 9\", \"x >= 0\", \"y \
>= 0\"}, {\"min\", \"x + y\"}, \"blue\", 1.5, True, True, \"large\"]\n- \
LinearPro[\"complejo.tex\", {\"x + 2*y <= 8\", \"3*x + y <= 12\", \"x >= 1\", \
\"y >= 1\"}, {\"max\", \"5*x + 3*y\"}, \"red\", 1.0, True, False, \"small\", \
{0, 6}, {0, 6}]\n\nCASOS ESPECIALES:\n- Problema no acotado: Detecta cuando \
el valor \[OAcute]ptimo es infinito\n- Problema infactible: Detecta cuando no \
existe soluci\[OAcute]n\n- Regi\[OAcute]n factible vac\[IAcute]a: Maneja \
casos sin v\[EAcute]rtices v\[AAcute]lidos\n\nARCHIVOS GENERADOS:\n- Crea la \
carpeta Downloads/LinearPro si no existe\n- Exporta archivo .tex completo con \
documento LaTeX standalone\n- Incluye todos los paquetes necesarios (tikz, \
amsmath, patterns)\n- Listo para compilar directamente con LaTeX/TikZ", 
    "Documentation" -> None, "OwnValues" -> None, "UpValues" -> None, 
    "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilTeX`LinearPro, {VilTeX`LinearPro[
         Pattern[VilTeX`Private`filename, 
          Blank[String]], 
         Pattern[VilTeX`Private`constraints, 
          Blank[List]], 
         Pattern[VilTeX`Private`objective, 
          Blank[List]], 
         Optional[
          Pattern[VilTeX`Private`fillColor, 
           Blank[String]], "green"], 
         Optional[
          Pattern[VilTeX`Private`scale, 
           Blank[Real]], 1.2], 
         Optional[
          Pattern[VilTeX`Private`showOptimalPoint, 
           Blank[]], True], 
         Optional[
          Pattern[VilTeX`Private`showLabels, 
           Blank[]], True], 
         Optional[
          Pattern[VilTeX`Private`textSize, 
           Blank[String]], "normal"], 
         Optional[
          Pattern[VilTeX`Private`xRange, 
           Blank[List]], {0, 10}], 
         Optional[
          Pattern[VilTeX`Private`yRange, 
           Blank[List]], {0, 8}]] :> 
       Block[{VilTeX`Private`x, VilTeX`Private`y, 
          VilTeX`Private`processedColor, VilTeX`Private`objType, 
          VilTeX`Private`objFunction, VilTeX`Private`optimalResult, 
          VilTeX`Private`optimalPoint, VilTeX`Private`optimalValue, 
          VilTeX`Private`vertices, VilTeX`Private`tikzCode, 
          VilTeX`Private`fullDocument, VilTeX`Private`folderPath, 
          VilTeX`Private`downloadPath, VilTeX`Private`formatNumber, 
          VilTeX`Private`sizeCmd}, If[
           Not[
            StringEndsQ[VilTeX`Private`filename, ".tex"]], 
           Print["Error: El archivo debe terminar en .tex"]; Return[$Failed]]; 
         If[Length[VilTeX`Private`objective] != 2, 
           Print["Error: objetivo debe ser {\"max\"|\"min\", \"expresi\
\[OAcute]n\"}"]; Return[$Failed]]; VilTeX`Private`formatNumber[
            Pattern[VilTeX`Private`num, 
             Blank[]]] := ToString[
            Round[
             N[VilTeX`Private`num], 0.01]]; 
         VilTeX`Private`sizeCmd = 
          Switch[VilTeX`Private`textSize, "huge", "\\huge ", "large", 
            "\\large ", "small", "\\small ", "tiny", "\\tiny ", 
            Blank[], ""]; 
         VilTeX`Private`processedColor = 
          Switch[VilTeX`Private`fillColor, "blue", "blue!30", "red", "red!30",
             "green", "green!30", "yellow", "yellow!40", "orange", 
            "orange!30", "purple", "purple!30", 
            Blank[], VilTeX`Private`fillColor <> "!30"]; 
         VilTeX`Private`objType = ToLowerCase[
            Part[VilTeX`Private`objective, 1]]; 
         VilTeX`Private`objFunction = ToExpression[
            Part[VilTeX`Private`objective, 2]]; 
         VilTeX`Private`optimalResult = If[VilTeX`Private`objType == "max", 
            NMaximize[{VilTeX`Private`objFunction, 
              Apply[And, 
               Map[ToExpression, VilTeX`Private`constraints]]}, {
             VilTeX`Private`x, VilTeX`Private`y}], 
            NMinimize[{VilTeX`Private`objFunction, 
              Apply[And, 
               Map[ToExpression, VilTeX`Private`constraints]]}, {
             VilTeX`Private`x, VilTeX`Private`y}]]; If[
           And[
           Head[VilTeX`Private`optimalResult] === List, 
            Length[VilTeX`Private`optimalResult] >= 2], 
           VilTeX`Private`optimalValue = N[
              Part[VilTeX`Private`optimalResult, 1]]; 
           VilTeX`Private`optimalPoint = N[
              ReplaceAll[{VilTeX`Private`x, VilTeX`Private`y}, 
               Part[VilTeX`Private`optimalResult, 2]]], 
           Print["Error en optimizaci\[OAcute]n"]; Return[$Failed]]; 
         VilTeX`Private`vertices = {}; 
         With[{VilTeX`Private`constraintLines = 
            Select[VilTeX`Private`constraints, Or[
               StringContainsQ[#, "<="], 
               StringContainsQ[#, ">="]]& ]}, Do[
             Do[
              With[{VilTeX`Private`eq1 = ToExpression[
                  StringReplace[
                   Part[VilTeX`Private`constraintLines, VilTeX`Private`i], {
                   "<=" -> "==", ">=" -> "=="}]], VilTeX`Private`eq2 = 
                ToExpression[
                  StringReplace[
                   Part[VilTeX`Private`constraintLines, VilTeX`Private`j], {
                   "<=" -> "==", ">=" -> "=="}]]}, 
               With[{VilTeX`Private`sol = Quiet[
                   
                   Solve[{VilTeX`Private`eq1, VilTeX`Private`eq2}, {
                    VilTeX`Private`x, VilTeX`Private`y}]]}, 
                If[
                 And[Length[VilTeX`Private`sol] > 0, 
                  AllTrue[
                   ReplaceAll[{VilTeX`Private`x, VilTeX`Private`y}, 
                    Part[VilTeX`Private`sol, 1]], NumericQ]], 
                 With[{VilTeX`Private`point = N[
                    ReplaceAll[{VilTeX`Private`x, VilTeX`Private`y}, 
                    Part[VilTeX`Private`sol, 1]]]}, 
                  If[
                   Apply[And, 
                    ReplaceAll[
                    Map[ToExpression, VilTeX`Private`constraints], {
                    VilTeX`Private`x -> Part[VilTeX`Private`point, 1], 
                    VilTeX`Private`y -> Part[VilTeX`Private`point, 2]}]], 
                   AppendTo[
                   VilTeX`Private`vertices, VilTeX`Private`point]]]]]], {
              VilTeX`Private`j, VilTeX`Private`i + 1, 
               Length[VilTeX`Private`constraintLines]}], {
             VilTeX`Private`i, 1, Length[VilTeX`Private`constraintLines] - 
              1}]; Null]; 
         With[{VilTeX`Private`boundaryConstraints = {"x == " <> ToString[
                Part[VilTeX`Private`xRange, 1]], "x == " <> ToString[
                Part[VilTeX`Private`xRange, 2]], "y == " <> ToString[
                Part[VilTeX`Private`yRange, 1]], "y == " <> ToString[
                Part[VilTeX`Private`yRange, 2]]}}, Do[
             Do[
              With[{VilTeX`Private`eq1 = ToExpression[
                  StringReplace[
                   Part[VilTeX`Private`constraints, VilTeX`Private`i], {
                   "<=" -> "==", ">=" -> "=="}]], VilTeX`Private`eq2 = 
                ToExpression[
                  Part[
                  VilTeX`Private`boundaryConstraints, VilTeX`Private`j]]}, 
               With[{VilTeX`Private`sol = Quiet[
                   
                   Solve[{VilTeX`Private`eq1, VilTeX`Private`eq2}, {
                    VilTeX`Private`x, VilTeX`Private`y}]]}, 
                If[
                 And[Length[VilTeX`Private`sol] > 0, 
                  AllTrue[
                   ReplaceAll[{VilTeX`Private`x, VilTeX`Private`y}, 
                    Part[VilTeX`Private`sol, 1]], NumericQ]], 
                 With[{VilTeX`Private`point = N[
                    ReplaceAll[{VilTeX`Private`x, VilTeX`Private`y}, 
                    Part[VilTeX`Private`sol, 1]]]}, 
                  If[
                   And[
                   Part[VilTeX`Private`xRange, 1] <= 
                    Part[VilTeX`Private`point, 1] <= 
                    Part[VilTeX`Private`xRange, 2], 
                    Part[VilTeX`Private`yRange, 1] <= 
                    Part[VilTeX`Private`point, 2] <= 
                    Part[VilTeX`Private`yRange, 2], 
                    Apply[And, 
                    ReplaceAll[
                    Map[ToExpression, VilTeX`Private`constraints], {
                    VilTeX`Private`x -> Part[VilTeX`Private`point, 1], 
                    VilTeX`Private`y -> Part[VilTeX`Private`point, 2]}]]], 
                   AppendTo[
                   VilTeX`Private`vertices, VilTeX`Private`point]]]]]], {
              VilTeX`Private`j, 1, 
               Length[VilTeX`Private`boundaryConstraints]}], {
             VilTeX`Private`i, 1, 
              Length[VilTeX`Private`constraints]}]; Null]; 
         With[{VilTeX`Private`corners = {{
               Part[VilTeX`Private`xRange, 1], 
               Part[VilTeX`Private`yRange, 1]}, {
               Part[VilTeX`Private`xRange, 2], 
               Part[VilTeX`Private`yRange, 1]}, {
               Part[VilTeX`Private`xRange, 2], 
               Part[VilTeX`Private`yRange, 2]}, {
               Part[VilTeX`Private`xRange, 1], 
               Part[VilTeX`Private`yRange, 2]}}}, Do[
             If[
              Apply[And, 
               ReplaceAll[
                Map[ToExpression, VilTeX`Private`constraints], {
                VilTeX`Private`x -> 
                 Part[VilTeX`Private`corners, VilTeX`Private`i, 1], 
                 VilTeX`Private`y -> 
                 Part[VilTeX`Private`corners, VilTeX`Private`i, 2]}]], 
              AppendTo[VilTeX`Private`vertices, 
               Part[VilTeX`Private`corners, VilTeX`Private`i]]], {
             VilTeX`Private`i, 
              Length[VilTeX`Private`corners]}]; Null]; 
         VilTeX`Private`vertices = 
          DeleteDuplicates[VilTeX`Private`vertices, Norm[# - #2] < 0.01& ]; 
         If[Length[VilTeX`Private`vertices] > 0, 
           
           With[{VilTeX`Private`center = Mean[VilTeX`Private`vertices]}, 
            VilTeX`Private`vertices = 
             SortBy[VilTeX`Private`vertices, ArcTan[
               Part[#, 1] - Part[VilTeX`Private`center, 1], Part[#, 2] - Part[
                VilTeX`Private`center, 2]]& ]; Null], 
           Print["Advertencia: No se encontraron v\[EAcute]rtices \
v\[AAcute]lidos"]; Null]; 
         VilTeX`Private`tikzCode = ("\\begin{tikzpicture}[scale=" <> 
            ToString[VilTeX`Private`scale] <> "]\n\n") <> 
           "% Comentario: Problema de programaci\[OAcute]n lineal\n" <> (
            "% Restricciones: " <> ToString[VilTeX`Private`constraints] <> 
            "\n") <> ("% Objetivo: " <> VilTeX`Private`objType <> "imizar " <> 
            Part[VilTeX`Private`objective, 2] <> "\n\n") <> 
           "% Ejes coordenados\n" <> ("\\draw[->] (-0.5,0) -- (" <> 
            ToString[Part[VilTeX`Private`xRange, 2] + 1] <> ",0)" <> 
            If[VilTeX`Private`showLabels, " node[right] {" <> 
              VilTeX`Private`sizeCmd <> "$x$}", ""] <> ";\n") <> (
            "\\draw[->] (0,-0.5) -- (0," <> 
            ToString[Part[VilTeX`Private`yRange, 2] + 1] <> ")" <> 
            If[VilTeX`Private`showLabels, " node[above] {" <> 
              VilTeX`Private`sizeCmd <> "$y$}", ""] <> ";\n\n") <> 
           If[VilTeX`Private`showLabels, "% Marcas en ejes\n" <> StringJoin[
               Table[
               "\\draw (" <> ToString[VilTeX`Private`i] <> ",0) -- (" <> 
                ToString[VilTeX`Private`i] <> ",-0.1) node[below] {" <> 
                VilTeX`Private`sizeCmd <> ToString[VilTeX`Private`i] <> 
                "};\n", {VilTeX`Private`i, 1, 
                 Part[VilTeX`Private`xRange, 2], 
                 Max[1, 
                  Round[Part[VilTeX`Private`xRange, 2]/8]]}]] <> StringJoin[
               Table[
               "\\draw (0," <> ToString[VilTeX`Private`j] <> ") -- (-0.1," <> 
                ToString[VilTeX`Private`j] <> ") node[left] {" <> 
                VilTeX`Private`sizeCmd <> ToString[VilTeX`Private`j] <> 
                "};\n", {VilTeX`Private`j, 1, 
                 Part[VilTeX`Private`yRange, 2], 
                 Max[1, 
                  Round[Part[VilTeX`Private`yRange, 2]/6]]}]] <> "\n", ""] <> 
           If[Length[VilTeX`Private`vertices] >= 3, 
             "% Regi\[OAcute]n factible\n\\fill[" <> 
             VilTeX`Private`processedColor <> "] " <> StringJoin[
               Riffle[
                Map["(" <> VilTeX`Private`formatNumber[
                   Part[#, 1]] <> "," <> VilTeX`Private`formatNumber[
                   Part[#, 2]] <> ")"& , VilTeX`Private`vertices], " -- "]] <> 
             " -- cycle;\n\n", ""] <> 
           If[Length[VilTeX`Private`vertices] >= 3, 
             "% Contorno de la regi\[OAcute]n\n\\draw[black, thick] " <> 
             StringJoin[
               Riffle[
                Map["(" <> VilTeX`Private`formatNumber[
                   Part[#, 1]] <> "," <> VilTeX`Private`formatNumber[
                   Part[#, 2]] <> ")"& , VilTeX`Private`vertices], " -- "]] <> 
             " -- cycle;\n\n", ""] <> "% L\[IAcute]neas de restricciones\n" <> 
           StringJoin[
             Table[
             "% Restricci\[OAcute]n " <> ToString[VilTeX`Private`i] <> ": " <> 
              Part[VilTeX`Private`constraints, VilTeX`Private`i] <> "\n", {
              VilTeX`Private`i, 
               Length[VilTeX`Private`constraints]}]] <> "\n" <> 
           If[VilTeX`Private`showOptimalPoint, 
             "% Punto \[OAcute]ptimo\n\\fill[red] (" <> 
             VilTeX`Private`formatNumber[
               Part[VilTeX`Private`optimalPoint, 1]] <> "," <> 
             VilTeX`Private`formatNumber[
               Part[VilTeX`Private`optimalPoint, 2]] <> ") circle (0.08);\n" <> 
             If[VilTeX`Private`showLabels, "\\node[red, above right] at (" <> 
               VilTeX`Private`formatNumber[
                 Part[VilTeX`Private`optimalPoint, 1]] <> "," <> 
               VilTeX`Private`formatNumber[
                 Part[VilTeX`Private`optimalPoint, 2]] <> ") {" <> 
               VilTeX`Private`sizeCmd <> "(" <> VilTeX`Private`formatNumber[
                 Part[VilTeX`Private`optimalPoint, 1]] <> ", " <> 
               VilTeX`Private`formatNumber[
                 Part[VilTeX`Private`optimalPoint, 2]] <> ")};\n" <> 
               "\\node[red, below right] at (" <> 
               VilTeX`Private`formatNumber[
                 Part[VilTeX`Private`optimalPoint, 1]] <> "," <> 
               VilTeX`Private`formatNumber[
                 Part[VilTeX`Private`optimalPoint, 2]] <> ") {" <> 
               VilTeX`Private`sizeCmd <> "$z = " <> 
               VilTeX`Private`formatNumber[VilTeX`Private`optimalValue] <> 
               "$};\n\n", "\n"], ""] <> If[
             And[
             VilTeX`Private`showLabels, Length[VilTeX`Private`vertices] >= 3],
              "% Etiqueta de regi\[OAcute]n\n\\node[" <> 
             StringTake[VilTeX`Private`fillColor, 
               Min[
                StringLength[VilTeX`Private`fillColor], 6]] <> 
             "!80!black, font=\\bfseries] at (" <> VilTeX`Private`formatNumber[
               Part[
                Mean[VilTeX`Private`vertices], 1]] <> "," <> 
             VilTeX`Private`formatNumber[
               Part[
                Mean[VilTeX`Private`vertices], 2]] <> ") {" <> 
             VilTeX`Private`sizeCmd <> "Regi\[OAcute]n Factible};\n\n", ""] <> 
           "\\end{tikzpicture}\n"; 
         VilTeX`Private`fullDocument = 
          "\\documentclass[border=5mm]{standalone}\n" <> 
           "\\usepackage{tikz}\n" <> "\\usepackage{amsmath}\n" <> 
           "\\usetikzlibrary{patterns}\n\n" <> "\\begin{document}\n" <> 
           VilTeX`Private`tikzCode <> "\\end{document}\n"; 
         VilTeX`Private`folderPath = 
          FileNameJoin[{$HomeDirectory, "Downloads", "LinearPro"}]; If[
           Not[
            DirectoryQ[VilTeX`Private`folderPath]], 
           CreateDirectory[VilTeX`Private`folderPath]]; 
         VilTeX`Private`downloadPath = 
          FileNameJoin[{VilTeX`Private`folderPath, VilTeX`Private`filename}]; 
         Export[VilTeX`Private`downloadPath, VilTeX`Private`fullDocument, 
           "Text"]; If[
          VilTeX`Private`optimalValue === Infinity, 
           Print["\[Checkmark] Punto \[OAcute]ptimo: No acotado \
(\[Infinity])"]; Print["\[Checkmark] Valor \[OAcute]ptimo: \[Infinity]"], 
           If[
           VilTeX`Private`optimalValue === Undefined, 
            Print["\[Checkmark] Punto \[OAcute]ptimo: No existe"]; 
            Print["\[Checkmark] Valor \[OAcute]ptimo: Indefinido"], 
            Print["\[Checkmark] Punto \[OAcute]ptimo: " <> 
              ToString[VilTeX`Private`optimalPoint]]; 
            Print["\[Checkmark] Valor \[OAcute]ptimo: " <> 
              ToString[VilTeX`Private`optimalValue]]; Null]]; 
         VilTeX`Private`downloadPath]}], "SubValues" -> None, "DefaultValues" -> 
    None, "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {Protected}, "FullName" -> "VilTeX`LinearPro"|>, 
   False]]], "Output",
 CellChangeTimes->{3.9670238245580683`*^9},
 CellLabel->"Out[97]=",ExpressionUUID->"cb447b8b-fc25-4166-a1c8-930354749937"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 1: uso b\[AAcute]sico", "Subsection",
 CellChangeTimes->{{3.9670238979330597`*^9, 3.967023899794098*^9}, {
   3.967023974528059*^9, 3.9670239811099463`*^9}, 3.967024195089623*^9, 
   3.967027650564042*^9},ExpressionUUID->"27c30c42-b4be-4d3d-9e3b-\
025d86964e89"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], " ", "+", " ", 
      RowBox[{"3", "y"}]}], " ", "<=", " ", "12"}], "&&", 
    RowBox[{
     RowBox[{"x", " ", "+", " ", 
      RowBox[{"2", "y"}]}], " ", "<=", " ", "8"}], "&&", 
    RowBox[{"x", " ", ">=", " ", "0"}], "&&", 
    RowBox[{"y", " ", ">=", " ", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "0.5"}], ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "0.5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "False"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"NMaximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"3", "x"}], " ", "+", " ", 
      RowBox[{"2", "y"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"2", "x"}], " ", "+", " ", 
        RowBox[{"3", "y"}]}], " ", "<=", " ", "12"}], "&&", 
      RowBox[{
       RowBox[{"x", " ", "+", " ", 
        RowBox[{"2", "y"}]}], " ", "<=", " ", "8"}], "&&", 
      RowBox[{"x", " ", ">=", " ", "0"}], "&&", 
      RowBox[{"y", " ", ">=", " ", "0"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LinearPro", "[", 
   RowBox[{"\"\<linear1.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<2x + 3y <= 12\>\"", ",", "\"\<x + 2y <= 8\>\"", 
      ",", "\"\<x >= 0\>\"", ",", "\"\<y >= 0\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<max\>\"", ",", "\"\<3x + 2y\>\""}], "}"}], 
    ",", "\"\<blue\>\"", ",", "1.5", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{
      "la", " ", "escala", " ", "siempre", " ", "debe", " ", "tener", " ", 
       RowBox[{"el", " ", ".", " ", "y"}], " ", "entre", " ", "menor", " ", 
       "sea"}], ",", " ", 
      RowBox[{
      "mayor", " ", "tama\[NTilde]o", " ", "toma", " ", "la", " ", "figura", " ",
        "en", " ", "LaTeX"}]}], "*)"}], ",", "True", ",", "True", 
    ",", "\"\<normal\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967023990365939*^9, 3.967023992440062*^9}, {
   3.967024302734309*^9, 3.9670243030227127`*^9}, {3.967024395912404*^9, 
   3.967024397328577*^9}, 3.9670255991513157`*^9, 3.967026112208026*^9, 
   3.9670262725397263`*^9, {3.9670272088709383`*^9, 3.967027231732461*^9}, {
   3.967027724172607*^9, 3.96702793277242*^9}, {3.967027997574163*^9, 
   3.9670279980416822`*^9}, {3.9670281173855877`*^9, 
   3.9670281178779383`*^9}, {3.96702823078681*^9, 3.9670282331419477`*^9}, {
   3.967028832848137*^9, 3.9670289293859797`*^9}, {3.967029057778882*^9, 
   3.9670290743304653`*^9}, 3.967029163324667*^9, {3.967047480271467*^9, 
   3.967047522122568*^9}},ExpressionUUID->"8428d752-ca77-4881-aec6-\
efcf19d0d1c5"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxlmntczNn/x6d7Tc1U0yhNCbE291sjbJzDuPS1ypRLZI37Wjthl8Rg3U3l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    "], {{
      {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], Opacity[0.3], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHm812MWx5/z7abcFtWt7m255Va3fbm5t5R20iK3BU0qlBquSMWUJRKy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          "]], PolygonBox[CompressedData["
1:eJwtlXnQl1MYhs9zyr58luZDJmTftxbtKUtFtq/FIFuKlPoSSZTSZm3TSiRJ
Sik1odKYGGMMaROFNjvtpWWqmbju7vePe871nPP7ve95n7Vq2/KyLjmlNAxV
RFMjpTI2TmDtjb2PtQ3qXPzmfM5GYP8D/42Owu6O3Qt+FdWDm7F3BOv92IfD
XeGe8Fh0JfZY7H/hHagu3JS9Q/Ue7MvhMfB2eBsaBJ/K3nj4BbQIexmaBc9A
mbMHsR+DR6JDsDthPwGPRmvhK7Lf9RX6Efu87Lt/imZit8QuZe2H/RzrixL8
PmoIN+e8hLUD9nLWcWh28h2awFejxfBqVAavRl/AK9EC+JPCl8+gavB36AO4
BNWBm/D8CqytsS+FR8Nb4S365vA79Gzd6ULOR2JvhDegn+ALsnkhGqLYoKXw
OnQHvBu9DHdC9eEb+P3RrO2xX2L9Ay2B16Cf4Ys43wR/jo6Fe7LXB34NtYLX
oa/1bvSf4oy6wq+gp+Hjsn/7LJqs2KDp8BjUHo7s3ypmHbErZsdOMftQfsCu
zDoI+z7WA+Hc0zsacHY99mR4P1oq/7N3INmna7Avy86dL9GT2Mdk56a+4eNw
jBXbN3VHuJTz1+GBihH2idjj4P6oMjxQ/0mO8UnY/cK/fQNNh1uwV4m1L/bj
rEdm57pqYhJ2FzQNHoVaw+vRIvkatQjfWXddhVqGc/ZgrqLx8D1oCjwUlcOH
Zee2akq+7RHOLfn4G8UmnFvvotvDNaNamYkmwO3QVHg4qsSz+oS/VT6YDbdi
72TWAdjHw73CsZRPJsIPo/fgEeoByifUMTnH9sB3hnNtcHItXJKdy6qJs+Hh
yjn49+RvewB1S/7GwfBcNEG5mRzrBuFYKebqBQ2zY6+e0Bi+l/NyOBWxmFb0
EsXkUXQdeke5mVzrM4reVFrUQv8i11QTbVFjNDH5TqrNp4rYVih6Ve+iV6hn
1cNuxPoW9r7k3te38J164EPoGvQ2dnf0CHwtmqTcRHfBe8O+Uo+9G96PhiR/
k3y1ST0j2WdN4RVoTnLN1uF9ddFePRs15+wH+RBehm6CV6L58HJ0M7wKLUh+
pnKxBv/fnZyTNVW77O1J3lOtV2NvZ3LNV1ctsbcreU+5MqvoJcoZ9crnw726
pPB97XDtKwaaLVPCvU4z5tZwD1uI/T2qzXktVCX5m1TbS8Lfphq/GHsU9ubk
HnVwloR7kWaK7v5tONf1Daq9buHYqwZPy+6R6o1r9U74dPbWwx8lx7J6uNYU
0zM4G4r9S/JvVDsdwrFUDakWOodjqZqQr8/Kzm35XLGqkv0uxaxGOGeVq/rG
Zqx/hXNdNXSueqP24D+TY3VONitmN4bvrLuqx88L93D1btWMcrdmuLaVw8q9
q8K1qhxUblTleb8m54hm+Zaw7zXTNXu2h3uRZpB8vS08y+RzzeYd4d6kGa1Z
+Fm412gmajZtVQ4mzyj18jnh2amePgxtDOfib8m5Xj+7dpTz8vWGcO7K57eF
Z5JmkZ6p3NsZ7p3KwVvCM12zfEVybdUK91rVmHy5OXwmn56ZfQe9Wz4YAJ+S
3cvV4/8H4ntA3Q==
          "]]}]}, {}, {}, {}, {}}, 
     {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], LineBox[CompressedData["
1:eJwl1Hecz3UcwPHfyQhlREbKdkbLuM5dd5yzkqOQiNKwMkJIKXtvMrJVdlT2
qoyoUFb2XtmyQmVFz8/DH897vd+f3+N+97v7fB9XoHG7Om2jIpFItC+1U0Ui
w3QF3zGEU1RjF094PS/DzedIYTf5nOVnhPk8NdhDAWcF+dT8JzXZSyFnhRlp
vsBL7KOIs2hGmS/yMvsp6qwYo82XqMUBijsrwRjz5fD5OciTzp7iM/MV6nCI
p509w1jzX7zCYZ51VpJx5qvU5QilnJVmvPkar3KUMs5imGC+Tj2O8ZyzWCaa
t1CfzWxnB5NYy2usYxO/8VN4T3ayld+p4H226fc8b06gLPHE8XP4eVQ0v6V3
OE4jblPOeSLJ5hiSzZ/rmzQJd2FvHL6fWCrZv9SmtAh3Yn83nFOWyvZp2pI2
4W7s74Vz4qhin6HhYeoQ7sjePpwTT1X7LO3IR3zISn5gTrgjr3+lv4Tflxfs
n+gqvgl3Zf9a15MQnkl7N13N/HBn9nm6gURetPfUNSwKd2dfqBvD34bq9j76
I0vDHdqX6K8khWfYPlAf1z+0P3nMSZSnqr08KeblOoDBDAqfPdxfuH+vndQT
PGbup7m0r+bWZZpTe+uj2ktz6GLNrj30Ee2u2XSBZtWumlm7aBb9VjPpx/qQ
dtaHda5m1E6aXj/QDDpbH9T3Na2203Q6U9Noa31AW2lqna6ptLlGtJlG6VS9
xzv8x9vc5Qtu8QY3eJ2bTOFfGvI3DfiHyZwNd8LpcHecYWjU/f9J/wNiPo0k

       "]]}}], {}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None, "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{{-0.5, 7}, {-0.5, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.967024557463252*^9, 3.967025348939468*^9, 3.96702560211051*^9, 
   3.96702611260872*^9, 3.967026274827631*^9, {3.967027211290472*^9, 
   3.967027233608878*^9}, {3.967027707913957*^9, 3.9670277604818563`*^9}, {
   3.967027906973763*^9, 3.9670279332724743`*^9}, 3.967027999370604*^9, 
   3.967028672479898*^9, {3.967028835858079*^9, 3.96702893023003*^9}, {
   3.96702907656949*^9, 3.9670291052960873`*^9}, 3.9670291638890533`*^9, 
   3.967045668131708*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"efc36625-b988-4f7f-8e60-46b0959ef103"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"18.`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "6.`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.967024557463252*^9, 3.967025348939468*^9, 3.96702560211051*^9, 
   3.96702611260872*^9, 3.967026274827631*^9, {3.967027211290472*^9, 
   3.967027233608878*^9}, {3.967027707913957*^9, 3.9670277604818563`*^9}, {
   3.967027906973763*^9, 3.9670279332724743`*^9}, 3.967027999370604*^9, 
   3.967028672479898*^9, {3.967028835858079*^9, 3.96702893023003*^9}, {
   3.96702907656949*^9, 3.9670291052960873`*^9}, 3.9670291638890533`*^9, 
   3.96704566832101*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"75fc1da5-2efc-45e3-a391-a63dfbd0590a"],

Cell[CellGroupData[{

Cell[BoxData["\<\"\[Checkmark] Punto \[OAcute]ptimo: {6., 0.}\"\>"], "Print",
 CellChangeTimes->{
  3.967024557462452*^9, 3.967025348938613*^9, 3.967025600283389*^9, 
   3.967026112607918*^9, 3.96702627324192*^9, {3.967027209711692*^9, 
   3.9670272320586853`*^9}, {3.967027706162915*^9, 3.967027758890873*^9}, {
   3.9670279069780817`*^9, 3.96702793327875*^9}, 3.967027999376512*^9, 
   3.967028672485135*^9, {3.967028835863944*^9, 3.967028930235489*^9}, {
   3.967029076596957*^9, 3.967029105302425*^9}, 3.9670291638954144`*^9, 
   3.9670456683598833`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"c4c2b75c-c817-433f-9ea0-c59b93b2ea48"],

Cell[BoxData["\<\"\[Checkmark] Valor \[OAcute]ptimo: 18.\"\>"], "Print",
 CellChangeTimes->{
  3.967024557462452*^9, 3.967025348938613*^9, 3.967025600283389*^9, 
   3.967026112607918*^9, 3.96702627324192*^9, {3.967027209711692*^9, 
   3.9670272320586853`*^9}, {3.967027706162915*^9, 3.967027758890873*^9}, {
   3.9670279069780817`*^9, 3.96702793327875*^9}, 3.967027999376512*^9, 
   3.967028672485135*^9, {3.967028835863944*^9, 3.967028930235489*^9}, {
   3.967029076596957*^9, 3.967029105302425*^9}, 3.9670291638954144`*^9, 
   3.967045668360924*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"e1cc774d-83d5-41c0-8cf5-607de441359d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967024557462452*^9, 3.967025348938613*^9, 3.967025600283389*^9, 
   3.967026112607918*^9, 3.96702627324192*^9, {3.967027209711692*^9, 
   3.9670272320586853`*^9}, {3.967027706162915*^9, 3.967027758890873*^9}, {
   3.9670279069780817`*^9, 3.96702793327875*^9}, 3.967027999376512*^9, 
   3.967028672485135*^9, {3.967028835863944*^9, 3.967028930235489*^9}, {
   3.967029076596957*^9, 3.967029105302425*^9}, 3.9670291638954144`*^9, 
   3.967045668361906*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"b4ccf88c-b445-4458-bcd6-b85722a7c017"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967024557462452*^9, 3.967025348938613*^9, 3.967025600283389*^9, 
   3.967026112607918*^9, 3.96702627324192*^9, {3.967027209711692*^9, 
   3.9670272320586853`*^9}, {3.967027706162915*^9, 3.967027758890873*^9}, {
   3.9670279069780817`*^9, 3.96702793327875*^9}, 3.967027999376512*^9, 
   3.967028672485135*^9, {3.967028835863944*^9, 3.967028930235489*^9}, {
   3.967029076596957*^9, 3.967029105302425*^9}, 3.9670291638954144`*^9, 
   3.9670456683623943`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"f3de0324-3ac0-420f-9189-9eb3ec41804b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967024557462452*^9, 3.967025348938613*^9, 3.967025600283389*^9, 
   3.967026112607918*^9, 3.96702627324192*^9, {3.967027209711692*^9, 
   3.9670272320586853`*^9}, {3.967027706162915*^9, 3.967027758890873*^9}, {
   3.9670279069780817`*^9, 3.96702793327875*^9}, 3.967027999376512*^9, 
   3.967028672485135*^9, {3.967028835863944*^9, 3.967028930235489*^9}, {
   3.967029076596957*^9, 3.967029105302425*^9}, 3.9670291638954144`*^9, 
   3.967045668362872*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"21a6eee9-7a9b-4cae-9b5d-382a515e70a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967024557462452*^9, 3.967025348938613*^9, 3.967025600283389*^9, 
   3.967026112607918*^9, 3.96702627324192*^9, {3.967027209711692*^9, 
   3.9670272320586853`*^9}, {3.967027706162915*^9, 3.967027758890873*^9}, {
   3.9670279069780817`*^9, 3.96702793327875*^9}, 3.967027999376512*^9, 
   3.967028672485135*^9, {3.967028835863944*^9, 3.967028930235489*^9}, {
   3.967029076596957*^9, 3.967029105302425*^9}, 3.9670291638954144`*^9, 
   3.967045668363356*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"fb843a65-4d69-4e49-9e7a-e2f87f09438b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967024557462452*^9, 3.967025348938613*^9, 3.967025600283389*^9, 
   3.967026112607918*^9, 3.96702627324192*^9, {3.967027209711692*^9, 
   3.9670272320586853`*^9}, {3.967027706162915*^9, 3.967027758890873*^9}, {
   3.9670279069780817`*^9, 3.96702793327875*^9}, 3.967027999376512*^9, 
   3.967028672485135*^9, {3.967028835863944*^9, 3.967028930235489*^9}, {
   3.967029076596957*^9, 3.967029105302425*^9}, 3.9670291638954144`*^9, 
   3.967045668363842*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"40b7e4ea-dbdc-4937-9686-8a5ba59184db"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967024557462452*^9, 3.967025348938613*^9, 3.967025600283389*^9, 
   3.967026112607918*^9, 3.96702627324192*^9, {3.967027209711692*^9, 
   3.9670272320586853`*^9}, {3.967027706162915*^9, 3.967027758890873*^9}, {
   3.9670279069780817`*^9, 3.96702793327875*^9}, 3.967027999376512*^9, 
   3.967028672485135*^9, {3.967028835863944*^9, 3.967028930235489*^9}, {
   3.967029076596957*^9, 3.967029105302425*^9}, 3.9670291638954144`*^9, 
   3.967045668598744*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"1f8e454c-0fe4-4b5d-8f8e-9402f139197e"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967024557462452*^9, 3.967025348938613*^9, 3.967025600283389*^9, 
   3.967026112607918*^9, 3.96702627324192*^9, {3.967027209711692*^9, 
   3.9670272320586853`*^9}, {3.967027706162915*^9, 3.967027758890873*^9}, {
   3.9670279069780817`*^9, 3.96702793327875*^9}, 3.967027999376512*^9, 
   3.967028672485135*^9, {3.967028835863944*^9, 3.967028930235489*^9}, {
   3.967029076596957*^9, 3.967029105302425*^9}, 3.9670291638954144`*^9, 
   3.96704566960529*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"dff80b04-95e1-4e3d-a7e7-4acb791e92f1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/LinearPro/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967024557462452*^9, 3.967025348938613*^9, 3.967025600283389*^9, 
   3.967026112607918*^9, 3.96702627324192*^9, {3.967027209711692*^9, 
   3.9670272320586853`*^9}, {3.967027706162915*^9, 3.967027758890873*^9}, {
   3.9670279069780817`*^9, 3.96702793327875*^9}, 3.967027999376512*^9, 
   3.967028672485135*^9, {3.967028835863944*^9, 3.967028930235489*^9}, {
   3.967029076596957*^9, 3.967029105302425*^9}, 3.9670291638954144`*^9, 
   3.96704566960893*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"5c730682-8c43-45df-b951-bac9411e4d1b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"linear1\"\>"}],
  SequenceForm["Archivo: ", "linear1"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967024557462452*^9, 3.967025348938613*^9, 3.967025600283389*^9, 
   3.967026112607918*^9, 3.96702627324192*^9, {3.967027209711692*^9, 
   3.9670272320586853`*^9}, {3.967027706162915*^9, 3.967027758890873*^9}, {
   3.9670279069780817`*^9, 3.96702793327875*^9}, 3.967027999376512*^9, 
   3.967028672485135*^9, {3.967028835863944*^9, 3.967028930235489*^9}, {
   3.967029076596957*^9, 3.967029105302425*^9}, 3.9670291638954144`*^9, 
   3.9670456696107616`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"357e75b4-b567-473c-b6f1-90a67e3962d3"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967024557462452*^9, 3.967025348938613*^9, 3.967025600283389*^9, 
   3.967026112607918*^9, 3.96702627324192*^9, {3.967027209711692*^9, 
   3.9670272320586853`*^9}, {3.967027706162915*^9, 3.967027758890873*^9}, {
   3.9670279069780817`*^9, 3.96702793327875*^9}, 3.967027999376512*^9, 
   3.967028672485135*^9, {3.967028835863944*^9, 3.967028930235489*^9}, {
   3.967029076596957*^9, 3.967029105302425*^9}, 3.9670291638954144`*^9, 
   3.9670456705789757`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"7bb15e50-bb5c-41d2-b6c5-d89f476aa402"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/linear1.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/LinearPro/linear1.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967024557462452*^9, 3.967025348938613*^9, 3.967025600283389*^9, 
   3.967026112607918*^9, 3.96702627324192*^9, {3.967027209711692*^9, 
   3.9670272320586853`*^9}, {3.967027706162915*^9, 3.967027758890873*^9}, {
   3.9670279069780817`*^9, 3.96702793327875*^9}, 3.967027999376512*^9, 
   3.967028672485135*^9, {3.967028835863944*^9, 3.967028930235489*^9}, {
   3.967029076596957*^9, 3.967029105302425*^9}, 3.9670291638954144`*^9, 
   3.9670456705798607`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"89c26c90-453c-4fad-adb4-ec37d4fd929e"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/linear1.\
pdf\"\>"], "Output",
 CellChangeTimes->{
  3.967024557463252*^9, 3.967025348939468*^9, 3.96702560211051*^9, 
   3.96702611260872*^9, 3.967026274827631*^9, {3.967027211290472*^9, 
   3.967027233608878*^9}, {3.967027707913957*^9, 3.9670277604818563`*^9}, {
   3.967027906973763*^9, 3.9670279332724743`*^9}, 3.967027999370604*^9, 
   3.967028672479898*^9, {3.967028835858079*^9, 3.96702893023003*^9}, {
   3.96702907656949*^9, 3.9670291052960873`*^9}, 3.9670291638890533`*^9, 
   3.967045670591137*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"251a5595-9647-4fb7-8672-8c02da8f2eef"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 2: con decimales", "Subsection",
 CellChangeTimes->{{3.9670238979330597`*^9, 3.967023899794098*^9}, 
   3.967023936229601*^9, {3.967024000461131*^9, 3.9670240044072733`*^9}, 
   3.967024199349305*^9, 
   3.967027654117826*^9},ExpressionUUID->"bcb03d7f-b84d-4393-a075-\
d07c670d6320"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"3.7", "x"}], " ", "+", " ", 
      RowBox[{"2.1", "y"}]}], " ", "<=", " ", "15.6"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"1.2", "x"}], " ", "-", " ", 
      RowBox[{"0.8", "y"}]}], " ", ">=", " ", "2.4"}], "&&", 
    RowBox[{"x", " ", ">=", " ", "0"}], "&&", 
    RowBox[{"y", " ", ">=", " ", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "0.5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "0.5"}], ",", "2.5"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "False"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"NMaximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2.8", "x"}], " ", "+", " ", 
      RowBox[{"4.3", "y"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"3.7", "x"}], " ", "+", " ", 
        RowBox[{"2.1", "y"}]}], " ", "<=", " ", "15.6"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"1.2", "x"}], " ", "-", " ", 
        RowBox[{"0.8", "y"}]}], " ", ">=", " ", "2.4"}], "&&", 
      RowBox[{"x", " ", ">=", " ", "0"}], "&&", 
      RowBox[{"y", " ", ">=", " ", "0"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LinearPro", "[", 
   RowBox[{"\"\<linear2.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<3.7x + 2.1y <= 15.6\>\"", ",", "\"\<1.2x - 0.8y >= 2.4\>\"",
       ",", "\"\<x >= 0\>\"", ",", "\"\<y >= 0\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<max\>\"", ",", "\"\<2.8x + 4.3y\>\""}], "}"}], 
    ",", "\"\<green\>\"", ",", "2.0", ",", "True", ",", "True", 
    ",", "\"\<normal\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2.5"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967024306349987*^9, 3.967024309439598*^9}, {
   3.9670244015648727`*^9, 3.967024402896031*^9}, 3.967025662054639*^9, 
   3.967027241541016*^9, {3.9670280152758017`*^9, 3.967028124838666*^9}, {
   3.967028223960472*^9, 3.9670282263866577`*^9}, {3.967028762001361*^9, 
   3.967028822872664*^9}, {3.967028968108183*^9, 3.967029046335107*^9}, {
   3.967029089520442*^9, 3.967029090451342*^9}, 3.967029157803287*^9, {
   3.9670457643612423`*^9, 3.967045848135416*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"813633ce-1489-44bb-99e2-bb6d60087b6b"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxlmHtczOkex2ea6Trzq1kn65g2l5CRS8RINXqeTCtCZ0I2bcYttwaRxKDN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    "], {{
      {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], Opacity[0.3], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNV2lQlmUUvY+gLPoBgiCiIKDgCoSoKCqagAsioLlhCrIUZYKtZqml2Z5W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          "]], PolygonBox[CompressedData["
1:eJwtlfdvz1EUhu+1E8RqbKXUaFVrlBpFaYsaRXWgatSs0doxYm8SEYnEfyD2
JrFH7BlE7MRIzJAYsWI8b8794ek553Nv7zjnvecbVViSVVzKOTceykCKd647
1MGfB6fgKGRBHuyBDozPxvaG89CFOAPbFvrj38R2hsGwAxrzbSo2FcrjX8DO
hUKtSzwa1uFnw+2wp/ZKhuPwDnoA01wSf9pDa2dn2AtjiTdg+0A+/ivsQBgO
v+B3WCsaXujczFmMjYKO3tbQ/86BeOLd2F4wAz7BR6gQ5pyEw5AJuXAEKnvL
XyR8hS9QBfrBCTgAfSEHWjG3JcTjT4ddEOfNT4en0I14PjYCDqo2xBvDmm9h
EvFmzYMx+NtCftZDXeLt2J5QBC2Im0Er/GLYCc29+WkwAv9nyNVa1VC5hQT8
mfA37Km98p3lpo23MeVoKP437DBYAz/ge8iFahDj7Y66Wwk0IY6COGeaiPZ2
Jp1lGrTzpjFpaxY09KYhaWcKvJTl21bVDgbh38UWwArYr1p505Zqdi9oTNrq
rjp4u7PuuhTuwxlYCSk6M2PVoSv+cngM2cRDnWlcbyHT25jexDl4GLQhDdZh
rBbEqk5QAz8Chjhb8xGUleaxq+BOuIPOPhI+hzka055DGKvp7ew6Y1X8W9hl
MDFo44mzt7cxaOOYauxMI0XeNCUtbYEJxFexSbDJWe1y+bY61DAPP8ebdvWt
F/4N7BJYBA/gbNCaNCetJHqrlTRTEf8KdiGM052IC7y9Pa3R05tmpJUFUA5/
n7O3rZzobq+d9Q7dUWs9hwFhzTJMLA0xoeZvQg6VO+X4NFTzlhvlQNqP9aY9
vYFR+H+caXld0JJ6gnqBNJVGfBnbIewprTb1pk1ptj5+I29abOms1vW8vTXV
/FnIuXKd6OytJ3jrJXrz6l2dvPUa9bBK3nKmXKmH6C3X9qYd5Ve98r2z3qGe
mc7YNWfaVw/SW2/At8nO3nyktzPqbPp2PdRQtVPPy1BtvWlfPboHfqq3WujO
yfgXw9nVsy5Jt95+C9STDgUNSTv6jZCWPjjrhdLUP2fFTHFWo/+4eKoe
          "]]}]}, {}, {}, {}, {}}, 
     {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], LineBox[CompressedData["
1:eJwl0+dXznEcx+HfrczsHFvDzh5ZiYa9k5mVogiHPys7smUTkpmQsrN3MoqM
y+nBdV6f7/t+9jvnjs3elr41FATBRR5wgQTDeZ2oVbpYa/QLlTT1bsY+9we2
U8RbKjhLtt+zyHd31W50oQfd2WHvpVH0JIZodtp7ax9i6UdfdtkH6ED6M4g4
dtuH6FAGM5xh7LGP1FGMIJ7R7LWP1XGMYQLjKbCv0/Wcc9/nEx8J2T7rflq4
m1PsfscJCkkMNX7DltqKR+48faiT9ZJO0mSSyOC77SC57iv6npMcYpqtVNtq
O6rdm/WZztCrOl2v6Uxdw2p+ev/iFvO8b+opjjDfewEdiaQTx+wb9LWWkea+
rU00nDD+Bv8/QhDck7ucYZF3Z+64F2q5putaMvnt/Yc3bPQ+rg0c5TQdbO25
4X7FFvdLnavXdZbOYTarqLet1Oe6Ql9oHT84TBtbayIo8X7KJvcTnaqXNUWn
kMpyvtmW6jKW8Nj7K7UcICfU+J/4B1q4ZAY=
       "]], LineBox[{277, 367, 365, 366, 277}]}}], {}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None, "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{{-0.5, 5}, {-0.5, 2.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.967025658621542*^9, 3.967025664101593*^9}, 
   3.967026281763865*^9, 3.967027243964477*^9, 3.967028726205497*^9, {
   3.96702879610618*^9, 3.967028823342318*^9}, 3.967028947052877*^9, 
   3.967028984708139*^9, 3.967029034299213*^9, 3.967029111857806*^9, 
   3.967029158339117*^9, {3.9670457431144037`*^9, 3.967045848980332*^9}},
 CellLabel->"Out[26]=",ExpressionUUID->"c6e15086-e707-4668-9c2e-4593a7ca2b31"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"16.672992700729925`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "3.197080291970803`"}], ",", 
     RowBox[{"y", "\[Rule]", "1.7956204379562037`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.967025658621542*^9, 3.967025664101593*^9}, 
   3.967026281763865*^9, 3.967027243964477*^9, 3.967028726205497*^9, {
   3.96702879610618*^9, 3.967028823342318*^9}, 3.967028947052877*^9, 
   3.967028984708139*^9, 3.967029034299213*^9, 3.967029111857806*^9, 
   3.967029158339117*^9, {3.9670457431144037`*^9, 3.967045848983328*^9}},
 CellLabel->"Out[27]=",ExpressionUUID->"cf2c9aef-7d97-40eb-8cf6-ef5ec1afbb31"],

Cell[CellGroupData[{

Cell[BoxData["\<\"\[Checkmark] Punto \[OAcute]ptimo: {3.19708, \
1.79562}\"\>"], "Print",
 CellChangeTimes->{3.967045848986237*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[26]:=",ExpressionUUID->"c0e07160-8686-45db-ae58-e942fb012d14"],

Cell[BoxData["\<\"\[Checkmark] Valor \[OAcute]ptimo: 16.673\"\>"], "Print",
 CellChangeTimes->{3.9670458489870996`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[26]:=",ExpressionUUID->"250f5110-7ee7-4bad-8edb-2acd069c05e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967045848988118*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[26]:=",ExpressionUUID->"12aa0ea1-d833-4546-b2f9-b3de63017a13"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.967045848988639*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[26]:=",ExpressionUUID->"f07a4891-38a8-4dc2-b99e-21be3398c337"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967045848989133*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[26]:=",ExpressionUUID->"2c852586-ac72-4234-9547-2b3922a678ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967045848989699*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[26]:=",ExpressionUUID->"9dc64b1d-20ad-447b-aad2-fe288a7350f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.967045848990258*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[26]:=",ExpressionUUID->"26c84b4b-de3f-4c44-a7e8-c59d7997122b"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967045849075405*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[26]:=",ExpressionUUID->"f30e02ab-4699-4fec-b24b-1289d05235fa"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.967045850083188*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[26]:=",ExpressionUUID->"e5834956-4600-4882-b1c8-3aa223a114e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/LinearPro/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967045850088963*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[26]:=",ExpressionUUID->"b6f74bd1-4b1b-4990-a1ff-3027af7b6227"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"linear2\"\>"}],
  SequenceForm["Archivo: ", "linear2"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670458500919523`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[26]:=",ExpressionUUID->"496d14c4-4804-4642-9c15-6d5a6882008f"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.9670458505529757`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[26]:=",ExpressionUUID->"511cc1e5-fae7-48fb-a1cd-ed1193dd74fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/linear2.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/LinearPro/linear2.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967045850553915*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[26]:=",ExpressionUUID->"474b1e73-07ab-42b3-97ef-c7ef14f10efb"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/linear2.\
pdf\"\>"], "Output",
 CellChangeTimes->{{3.967025658621542*^9, 3.967025664101593*^9}, 
   3.967026281763865*^9, 3.967027243964477*^9, 3.967028726205497*^9, {
   3.96702879610618*^9, 3.967028823342318*^9}, 3.967028947052877*^9, 
   3.967028984708139*^9, 3.967029034299213*^9, 3.967029111857806*^9, 
   3.967029158339117*^9, {3.9670457431144037`*^9, 3.967045850565681*^9}},
 CellLabel->"Out[29]=",ExpressionUUID->"68711c08-4c34-4e59-aec9-38ce8482d869"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 3: m\[AAcute]s complejo", "Subsection",
 CellChangeTimes->{{3.9670238979330597`*^9, 3.967023899794098*^9}, 
   3.967023938103985*^9, {3.9670240199194*^9, 3.967024028529357*^9}, 
   3.967024203189686*^9, 
   3.967027657537855*^9},ExpressionUUID->"94a1459b-001b-42e5-8cd3-\
218aa8e2f704"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "+", "y"}], "\[LessEqual]", "10"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", "y"}], "\[LessEqual]", "15"}], "&&", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"3", " ", "y"}]}], "\[LessEqual]", "18"}], "&&", 
    RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"y", "\[GreaterEqual]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "0.5"}], ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "0.5"}], ",", "6"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "False"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"NMaximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", "x"}], " ", "+", " ", 
      RowBox[{"3", "y"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "+", "y"}], "\[LessEqual]", "10"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"2", " ", "x"}], "+", "y"}], "\[LessEqual]", "15"}], "&&", 
      RowBox[{
       RowBox[{"x", "+", 
        RowBox[{"3", " ", "y"}]}], "\[LessEqual]", "18"}], "&&", 
      RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"y", "\[GreaterEqual]", "0"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LinearPro", "[", 
   RowBox[{"\"\<linear3.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<x + y <= 10\>\"", ",", "\"\<2x + y <= 15\>\"", 
      ",", "\"\<x + 3y <= 18\>\"", ",", "\"\<x >= 0\>\"", 
      ",", "\"\<y >= 0\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<max\>\"", ",", "\"\<4x + 3y\>\""}], "}"}], ",", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<blue!30\>\"", ",", "\"\<red!30\>\"", 
       ",", "\"\<green!30\>\"", ",", "\"\<yellow!40\>\"", 
       ",", "\"\<orange!30\>\"", ",", "\"\<purple!30\>\""}], "}"}], "]"}], ",", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], "]"}], ",", "True", ",", "True", ",", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<tiny\>\"", ",", "\"\<small\>\"", ",", "\"\<normal\>\"", 
       ",", "\"\<large\>\"", ",", "\"\<huge\>\""}], "}"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "6"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9670243145258923`*^9, 3.967024315501979*^9}, {
   3.967024407039073*^9, 3.967024408479854*^9}, {3.967028128404664*^9, 
   3.967028128871913*^9}, {3.967028167871705*^9, 3.967028219352139*^9}, {
   3.967029117450428*^9, 3.9670291496432467`*^9}, {3.96704589400627*^9, 
   3.967045900547431*^9}, {3.967045946330194*^9, 3.967045962724916*^9}, {
   3.967046113256579*^9, 3.96704612796914*^9}, 3.967046170289857*^9},
 CellLabel->"In[46]:=",ExpressionUUID->"95ebd63a-7a8f-4da6-984d-47c82cabe1bd"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxl2ntcTOkfB/DprjQ1TdNMzRRSyxC5Druk86yRS9JOIUITu7lOrus2boU1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    "], {{
      {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], Opacity[0.3], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgccj1UXx++9UlKyomRHZCSRkVJGRiVlCyFSRGSkociKFjLKziyJhJaR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          "]], PolygonBox[CompressedData["
1:eJwtlnnUTlUYxd/zfAifYYWVolVJWpW5STRokpBIKUVESSWhREKRLCrzkJRS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          "]]}]}, {}, {}, {}, {}}, 
     {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], LineBox[CompressedData["
1:eJwl1He8zlUcwPHHvVbEtUcIFYVSiUhE0TQqSUTKSJERhcoeRQkVlQYyiqiM
sneFbNnZe2aF7PH+vvzxvp/zO+f3XPc557wUbtymVutUiUSiox8n6ZSUSNzA
MYpQlFPmP9D/dDHT6OO5L+V4gPJMN581OZHIYHzaeIB+wsD4LLczw3w275zR
mz3/pTP5xvh/fVArcCM3eS+jjuSstRE6mlHxLncwy3x2753Tgp4LMds4h7lM
xueNJ+gFnRiNOYpRnEvmZ+lFXcIcZnueQ0UeIoV8fl9mLcFl71wlr7krupS5
5PScxfpd3Mk8cys1FStIkI2sLLNWWHNwleyx7vMldb619bqBdSSRi5zcyi2k
8W7uWNPUJHO35z98dqfuYjvJ7OB387m9k9c4vVbSbWwlnefl1heQyziPuXu5
hz/N5TGXxvgQlUnNwTgfMlhb4Z3bjPOT0XO+OD8tpQutHYl/g8OkJbO1lDgf
CnguQ2nu4wD72M9u9rIn7qR3N+sWNvIPm+L3mV+ja1nF36yOPTe/TJfHHWMp
S7jCIhbHXsXfF98xzpQFsU/MjTOI84v7EXeWmUyNO860uC/8xhQm8SuTOcfP
/MI4fmJ83F/G8iPfM4YfOMNwvuNbhjGU03zF13zBEL7kFIP5nE8ZxGec5GP6
8yH9+IgT9OZ9etCLnhynG93pTFe6cJTq1OBJqvEU/1KVR3mElc714dhzrRLf
RR+PvdfH4hz0ifie+rSu0ZpxTvpM7IXW0nX6rK7X52J/9HndoLXjrLVO7KXW
jTPXF+L8tV7srdbXzfpi3A9tEPuuDXWrvqTb9OU4G22k2/UV3aGN47y0qe7U
JrpLX9UJ+pru1ma6R1/XidpC92pz3advxF3QVrpfW+oBbR13Q9/Ug9pGD2nb
uDf6lh7WdnpE3467pR1i37V9nIt2jPum7+oxfSfOUe/XsiwynkoWdz99nL3x
e0nX/1+/Br490Mc=
       "]]}}], {}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None, "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{{-0.5, 8}, {-0.5, 6}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.967027255843865*^9, {3.96702913904244*^9, 3.967029150491271*^9}, 
   3.967045921259409*^9, 3.9670459633008966`*^9, {3.9670461758375673`*^9, 
   3.967046194403542*^9}},
 CellLabel->"Out[46]=",ExpressionUUID->"36a5cdb6-916b-41b1-ad98-d38b5e0b7560"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"34.199999999999996`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "5.3999999999999995`"}], ",", 
     RowBox[{"y", "\[Rule]", "4.2`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.967027255843865*^9, {3.96702913904244*^9, 3.967029150491271*^9}, 
   3.967045921259409*^9, 3.9670459633008966`*^9, {3.9670461758375673`*^9, 
   3.967046194406025*^9}},
 CellLabel->"Out[47]=",ExpressionUUID->"7419a434-1b6e-4454-8838-246b023c1a84"],

Cell[CellGroupData[{

Cell[BoxData["\<\"\[Checkmark] Punto \[OAcute]ptimo: {5.4, 4.2}\"\>"], "Print",
 CellChangeTimes->{
  3.967027254249352*^9, {3.9670291390491247`*^9, 3.967029150519305*^9}, 
   3.9670459212837067`*^9, 3.967045963326489*^9, {3.9670461758644867`*^9, 
   3.967046194429925*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"3075da8a-0597-4ff3-91d1-991b668adf7e"],

Cell[BoxData["\<\"\[Checkmark] Valor \[OAcute]ptimo: 34.2\"\>"], "Print",
 CellChangeTimes->{
  3.967027254249352*^9, {3.9670291390491247`*^9, 3.967029150519305*^9}, 
   3.9670459212837067`*^9, 3.967045963326489*^9, {3.9670461758644867`*^9, 
   3.967046194430867*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"0defcc15-9332-40cb-a0ca-b1713ce2697f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967027254249352*^9, {3.9670291390491247`*^9, 3.967029150519305*^9}, 
   3.9670459212837067`*^9, 3.967045963326489*^9, {3.9670461758644867`*^9, 
   3.967046194431787*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"9ef59a9d-934d-4382-82e1-d5643b8130af"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967027254249352*^9, {3.9670291390491247`*^9, 3.967029150519305*^9}, 
   3.9670459212837067`*^9, 3.967045963326489*^9, {3.9670461758644867`*^9, 
   3.967046194432263*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"7e83f9e9-89ba-44dc-8a08-ba1df0e006ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967027254249352*^9, {3.9670291390491247`*^9, 3.967029150519305*^9}, 
   3.9670459212837067`*^9, 3.967045963326489*^9, {3.9670461758644867`*^9, 
   3.967046194432715*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"e820b156-7445-4d15-9e5d-249e27c229a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967027254249352*^9, {3.9670291390491247`*^9, 3.967029150519305*^9}, 
   3.9670459212837067`*^9, 3.967045963326489*^9, {3.9670461758644867`*^9, 
   3.967046194433201*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"5b0bb8d6-1c7e-474a-8e47-8e4125d6ef29"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967027254249352*^9, {3.9670291390491247`*^9, 3.967029150519305*^9}, 
   3.9670459212837067`*^9, 3.967045963326489*^9, {3.9670461758644867`*^9, 
   3.967046194433688*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"166fd890-2afc-44c4-b6d4-44eadc018191"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967027254249352*^9, {3.9670291390491247`*^9, 3.967029150519305*^9}, 
   3.9670459212837067`*^9, 3.967045963326489*^9, {3.9670461758644867`*^9, 
   3.96704619447364*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"bf33b6ee-bbcf-4900-bf9b-4a8a454e7fa7"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967027254249352*^9, {3.9670291390491247`*^9, 3.967029150519305*^9}, 
   3.9670459212837067`*^9, 3.967045963326489*^9, {3.9670461758644867`*^9, 
   3.967046195480291*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"48cda130-8ce5-4ece-b32f-459a50b1b6fe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/LinearPro/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967027254249352*^9, {3.9670291390491247`*^9, 3.967029150519305*^9}, 
   3.9670459212837067`*^9, 3.967045963326489*^9, {3.9670461758644867`*^9, 
   3.9670461954855423`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"c8c82304-174b-4f0a-9442-54b942a8f11b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"linear3\"\>"}],
  SequenceForm["Archivo: ", "linear3"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967027254249352*^9, {3.9670291390491247`*^9, 3.967029150519305*^9}, 
   3.9670459212837067`*^9, 3.967045963326489*^9, {3.9670461758644867`*^9, 
   3.967046195488082*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"b0dfc022-474c-4d09-8659-f8637a580ace"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Error en compilaci\[OAcute]n (Exit Code: \"\>", "\[InvisibleSpace]",
    "1", "\[InvisibleSpace]", "\<\")\"\>"}],
  SequenceForm["Error en compilaci\[OAcute]n (Exit Code: ", 1, ")"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967027254249352*^9, {3.9670291390491247`*^9, 3.967029150519305*^9}, 
   3.9670459212837067`*^9, 3.967045963326489*^9, {3.9670461758644867`*^9, 
   3.967046195958413*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"4efecbe6-1b3b-4ea9-9e97-2539e22f1588"],

Cell[BoxData["\<\"Detalles del error:\"\>"], "Print",
 CellChangeTimes->{
  3.967027254249352*^9, {3.9670291390491247`*^9, 3.967029150519305*^9}, 
   3.9670459212837067`*^9, 3.967045963326489*^9, {3.9670461758644867`*^9, 
   3.967046195959326*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"1e4a2ce6-0ed8-4f2b-81fc-feae7f5fd023"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Output: \"\>", 
   "\[InvisibleSpace]", "\<\"This is pdfTeX, Version 3.141592653-2.6-1.40.26 \
(TeX Live 2024) (preloaded format=pdflatex)\\n restricted \\\\write18 \
enabled.\\nentering extended \
mode\\n(/Users/enriquevilchezquesada/Downloads/LinearPro/linear3.tex\\\
nLaTeX2e <2023-11-01> patch level 1\\nL3 programming layer \
<2024-02-20>\\n(/usr/local/texlive/2024/texmf-dist/tex/latex/standalone/\
standalone.cls\\nDocument Class: standalone 2022/10/10 v1.3b Class to compile \
TeX sub-files \
stan\\ndalone\\n(/usr/local/texlive/2024/texmf-dist/tex/latex/tools/shellesc.\
sty)\\n(/usr/local/texlive/2024/texmf-dist/tex/generic/iftex/ifluatex.sty\\n(/\
usr/local/texlive/2024/texmf-dist/tex/generic/iftex/iftex.sty))\\n(/usr/local/\
texlive/2024/texmf-dist/tex/latex/xkeyval/xkeyval.sty\\n(/usr/local/texlive/\
2024/texmf-dist/tex/generic/xkeyval/xkeyval.tex\\n(/usr/local/texlive/2024/\
texmf-dist/tex/generic/xkeyval/xkvutils.tex\\n(/usr/local/texlive/2024/texmf-\
dist/tex/generic/xkeyval/keyval.tex))))\\n(/usr/local/texlive/2024/texmf-dist/\
tex/latex/standalone/standalone.cfg)\\n(/usr/local/texlive\"\>"}],
  SequenceForm[
  "Output: ", 
   "This is pdfTeX, Version 3.141592653-2.6-1.40.26 (TeX Live 2024) \
(preloaded format=pdflatex)\n restricted \\write18 enabled.\nentering \
extended mode\n(/Users/enriquevilchezquesada/Downloads/LinearPro/linear3.tex\n\
LaTeX2e <2023-11-01> patch level 1\nL3 programming layer <2024-02-20>\n\
(/usr/local/texlive/2024/texmf-dist/tex/latex/standalone/standalone.cls\n\
Document Class: standalone 2022/10/10 v1.3b Class to compile TeX sub-files \
stan\ndalone\n\
(/usr/local/texlive/2024/texmf-dist/tex/latex/tools/shellesc.sty)\n\
(/usr/local/texlive/2024/texmf-dist/tex/generic/iftex/ifluatex.sty\n\
(/usr/local/texlive/2024/texmf-dist/tex/generic/iftex/iftex.sty))\n\
(/usr/local/texlive/2024/texmf-dist/tex/latex/xkeyval/xkeyval.sty\n\
(/usr/local/texlive/2024/texmf-dist/tex/generic/xkeyval/xkeyval.tex\n\
(/usr/local/texlive/2024/texmf-dist/tex/generic/xkeyval/xkvutils.tex\n\
(/usr/local/texlive/2024/texmf-dist/tex/generic/xkeyval/keyval.tex))))\n\
(/usr/local/texlive/2024/texmf-dist/tex/latex/standalone/standalone.cfg)\n\
(/usr/local/texlive"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967027254249352*^9, {3.9670291390491247`*^9, 3.967029150519305*^9}, 
   3.9670459212837067`*^9, 3.967045963326489*^9, {3.9670461758644867`*^9, 
   3.9670461959598417`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"620a0c2c-69e6-4586-8095-d370b331670d"],

Cell[BoxData["\<\"Revisa el archivo LaTeX en el editor para corregir \
errores\"\>"], "Print",
 CellChangeTimes->{
  3.967027254249352*^9, {3.9670291390491247`*^9, 3.967029150519305*^9}, 
   3.9670459212837067`*^9, 3.967045963326489*^9, {3.9670461758644867`*^9, 
   3.9670461959605618`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"c61ac111-f903-4b4b-9fd6-e480d6d7618a"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/linear3.\
tex\"\>"], "Output",
 CellChangeTimes->{
  3.967027255843865*^9, {3.96702913904244*^9, 3.967029150491271*^9}, 
   3.967045921259409*^9, 3.9670459633008966`*^9, {3.9670461758375673`*^9, 
   3.967046195961021*^9}},
 CellLabel->"Out[49]=",ExpressionUUID->"32cd154a-760c-4d84-a130-24abfe246da2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 4: m\[IAcute]nimo", "Subsection",
 CellChangeTimes->{{3.9670238979330597`*^9, 3.967023899794098*^9}, 
   3.967023940174996*^9, {3.9670240400058517`*^9, 3.967024043317231*^9}, 
   3.96702420937061*^9, 
   3.967027660267405*^9},ExpressionUUID->"2698a05b-8a6c-4b5b-a432-\
bc315b3b22cc"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "+", "y"}], "\[GreaterEqual]", "4"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", "y"}], "\[GreaterEqual]", "6"}], "&&", 
    RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"y", "\[GreaterEqual]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "0.5"}], ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "0.5"}], ",", "8"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "False"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", " ", "+", " ", 
      RowBox[{"2", "y"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "+", "y"}], "\[GreaterEqual]", "4"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"2", " ", "x"}], "+", "y"}], "\[GreaterEqual]", "6"}], "&&", 
      RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"y", "\[GreaterEqual]", "0"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LinearPro", "[", 
   RowBox[{"\"\<linear4.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<x + y >= 4\>\"", ",", "\"\<2x + y >= 6\>\"", 
      ",", "\"\<x >= 0\>\"", ",", "\"\<y >= 0\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<min\>\"", ",", "\"\<x + 2y\>\""}], "}"}], 
    ",", "\"\<orange\>\"", ",", "2.0", ",", "True", ",", "True", 
    ",", "\"\<huge\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967024323406068*^9, 3.967024324174759*^9}, {
   3.9670244126672564`*^9, 3.967024414134192*^9}, 3.967028132428028*^9, {
   3.967028254272485*^9, 3.9670282842494307`*^9}, {3.967028332835958*^9, 
   3.967028354028483*^9}, {3.967029176660658*^9, 3.967029196566144*^9}, {
   3.9670462559693727`*^9, 3.9670462981208267`*^9}, {3.96704637235572*^9, 
   3.967046404771791*^9}},
 CellLabel->"In[70]:=",ExpressionUUID->"d1021df5-7723-4860-8c98-d6b92abb1153"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdmXt8TNfehyd3uUzuF5lEIiGRSku1jaoT9mJcKlQnqITK9MrbdhxUUaNI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    "], {{
      {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], Opacity[0.3], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgn8llMWx9/72FJCCIlWJaVJkaVIWUurLCUlpY1SYWbs0TSMyVaUNVti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          "]], PolygonBox[CompressedData["
1:eJwtlOdvjmEUxt/7KLVqExGxR62iRktLbapDVVG7ao8OVNUeESNWIpE06Rfx
0X9hb0kJn20NMRKaWMHvyrk//HKu87zv/dzPfZ1zn/7lVcWVlkgkNkASNIZE
ojMPVhOXkLfVj1BMvhT6o/vCKHQFjETfJM6DnTCf/D6xEA7BUPIbxLlQDRPI
x0E6ejcMQF8nzoFKeAY9eLaeeJWtW6F/omfDYrgF483X5sJtmES+R3vDZHSm
9gj+bDb6HrEADkAJ+UOtgWOwgPyBIhyB7uTdYF3wbxiCHgSj0VXwSb6QHyem
8n3fievIzxDrya8R+5l7MwuaoZ25d2fhC6wgP6EzJ9yb4eQ7oked0B1hVfAa
dECnwHKtg67oLlCGXgt/5CP5JWIW/INa8nriFPgNNeQX5Q2MQafBWPSu4LUb
ba5Vwxz0FBiP3hu8NoPNz64ajTWvgbyvgfewj2eXiSmcp4mYbF6rNPgA+8mv
EHvx+x3iVPN358FC/de8FpnQAv0jelcCRl4HDejpMA19l5ivfYP3WgHPDsee
m2jeE+qF2uBrn8VeaojefyWeDF6DUtXG3DvV9Ff8hpLYc/KyMd6F+niWj9FL
namNagfn9Z/g3qabeyOPN6M3mn/7Od0R9CZzfSF61xS9kocryT8Ts+M3tjdf
o/+WBt+rDE4F31O9W0x+NPaweuMb8XTwHikkz4eM4B6Vo5/qXAn/j+7GPJ4d
jHckFz0XJgZ/Ngs9Aybo7Oo59Brz3tI36C5nmHudHnvxcaz1pXg3mmPvn4m9
+Cj2inoyy7wn1At1we9utrnWHdbdSzWfHbqDr6Al+UziY96xyLyH1Dvy4AUk
kefEMz6JNVJt9Ey9Pd28d9Tj8ro1eVH0/B30Id+uMwT3rsh8NshDeZNnPtvk
kbyZYz5b5FG17gokB3/H81hD1U7f/Df4ndZd1p5vtA/5ZuJ3vjeY33Hdbc1c
9fpMc+/V85q9A81npWbwBs1K89mjmbUcvcx8NmlmrNYsMZ81milb0VvMvdtI
ruFfYb73VvJh6FHms3wMvIXe5r/pTK+hp/nal6zZjt5mrnWGEebv0FrNtP9f
CqdD
          "]]}]}, {}, {}, {}, {}}, 
     {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], LineBox[CompressedData["
1:eJwt09VWVWEYhtEFtqJgu+lNhx0otoSdKHai2IKFiR56C16D1+CRioqB3YmK
3WInc4/hwRzP97+cMdYOV1SXVUUFQdBEiBgKDeeZFx0E5cxhLmWcs8/S2Uxn
JjM4a5+q05jEFCZzxl6qEymihGLq7eN1AmMYx1hO20fpaEYwkkJO2Qt0OEMY
xlBO2gfpYPozkAHU2ftqP3LJJ48T9mzNIYMsMjluT9N0UgiTyjH7Dv2urfSn
1uoPbavteOHep8/1Hg3s9P6lL3nNfu9Xep8L1Hj/1jcscC9kPm+9H3CRRd6L
6UwX/toO6B9tr+90qX7QJfpeH3KJZd7LiSWOrly279J/+pEV7lWsZBsduGLf
rZ+0tTbqVSrczdpNuxPFQQI60okv/r5aP+sjrrHGu5Ie9KQX1+17NJqv7rW6
nnVsJ4Yb9r36TdvoY73JBvdGetOHJ7ZbbHJvJkQ8TbbbbHFXkUAiT213qHZv
JYlkntnuEk8CiSSRTAqphCPfCOlkkElW5Hsih1zyyI98e4Qi3wjN/k2NNHCU
IxzmEDVUUk4pBWT//y22AOCjZG0=
       "]]}}], {}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None, "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{{-0.5, 10}, {-0.5, 8}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.967027266366153*^9, 3.967029197928383*^9, {3.96704622999737*^9, 
   3.967046299018489*^9}, 3.967046373827528*^9, 3.967046414762409*^9},
 CellLabel->"Out[70]=",ExpressionUUID->"b5fd292a-6b1b-4a60-abb0-0cdc1bc664e2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "4.`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.967027266366153*^9, 3.967029197928383*^9, {3.96704622999737*^9, 
   3.967046299018489*^9}, 3.967046373827528*^9, 3.967046414764942*^9},
 CellLabel->"Out[71]=",ExpressionUUID->"42fd5884-6a52-4bed-8007-5e12ed5e369a"],

Cell[CellGroupData[{

Cell[BoxData["\<\"\[Checkmark] Punto \[OAcute]ptimo: {4., 0.}\"\>"], "Print",
 CellChangeTimes->{
  3.9670272647716208`*^9, 3.967029197953785*^9, {3.967046230026186*^9, 
   3.967046299033867*^9}, 3.967046373851905*^9, 3.9670464147897663`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[70]:=",ExpressionUUID->"089fef0e-80fe-4775-84b0-275607d44f16"],

Cell[BoxData["\<\"\[Checkmark] Valor \[OAcute]ptimo: 4.\"\>"], "Print",
 CellChangeTimes->{
  3.9670272647716208`*^9, 3.967029197953785*^9, {3.967046230026186*^9, 
   3.967046299033867*^9}, 3.967046373851905*^9, 3.967046414790847*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[70]:=",ExpressionUUID->"7c2100f8-3f9a-4d03-90bb-360c0560d207"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9670272647716208`*^9, 3.967029197953785*^9, {3.967046230026186*^9, 
   3.967046299033867*^9}, 3.967046373851905*^9, 3.967046414791828*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[70]:=",ExpressionUUID->"058195d6-0931-4c23-902c-611844588472"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.9670272647716208`*^9, 3.967029197953785*^9, {3.967046230026186*^9, 
   3.967046299033867*^9}, 3.967046373851905*^9, 3.967046414792316*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[70]:=",ExpressionUUID->"d76d0595-3333-4a42-8da1-1dd575cf2e7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9670272647716208`*^9, 3.967029197953785*^9, {3.967046230026186*^9, 
   3.967046299033867*^9}, 3.967046373851905*^9, 3.967046414792777*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[70]:=",ExpressionUUID->"722436c7-12ac-4fbf-9e20-c85724ed996a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9670272647716208`*^9, 3.967029197953785*^9, {3.967046230026186*^9, 
   3.967046299033867*^9}, 3.967046373851905*^9, 3.9670464147932587`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[70]:=",ExpressionUUID->"626057e7-4f3d-4878-8b54-b510e8c68cc0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9670272647716208`*^9, 3.967029197953785*^9, {3.967046230026186*^9, 
   3.967046299033867*^9}, 3.967046373851905*^9, 3.967046414793736*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[70]:=",ExpressionUUID->"0afb91a8-d0df-41f7-a599-9eba320ec9f2"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.9670272647716208`*^9, 3.967029197953785*^9, {3.967046230026186*^9, 
   3.967046299033867*^9}, 3.967046373851905*^9, 3.9670464148469143`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[70]:=",ExpressionUUID->"ca23ffeb-877a-4f0c-a2ce-7145a57e94f0"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.9670272647716208`*^9, 3.967029197953785*^9, {3.967046230026186*^9, 
   3.967046299033867*^9}, 3.967046373851905*^9, 3.967046415853939*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[70]:=",ExpressionUUID->"2684bf7f-fbc3-43f5-9ad0-116e62faf970"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/LinearPro/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9670272647716208`*^9, 3.967029197953785*^9, {3.967046230026186*^9, 
   3.967046299033867*^9}, 3.967046373851905*^9, 3.967046415860427*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[70]:=",ExpressionUUID->"efc69bc9-5c41-451d-8ca4-2f3139477de8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"linear4\"\>"}],
  SequenceForm["Archivo: ", "linear4"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9670272647716208`*^9, 3.967029197953785*^9, {3.967046230026186*^9, 
   3.967046299033867*^9}, 3.967046373851905*^9, 3.9670464158652678`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[70]:=",ExpressionUUID->"8f954272-de54-46c0-8ac7-345d3d82b4fa"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.9670272647716208`*^9, 3.967029197953785*^9, {3.967046230026186*^9, 
   3.967046299033867*^9}, 3.967046373851905*^9, 3.967046416329338*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[70]:=",ExpressionUUID->"dc80d514-3158-46fd-a80e-e77687c317f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/linear4.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/LinearPro/linear4.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9670272647716208`*^9, 3.967029197953785*^9, {3.967046230026186*^9, 
   3.967046299033867*^9}, 3.967046373851905*^9, 3.967046416330275*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[70]:=",ExpressionUUID->"5c8a7409-6829-4f7d-952e-b73b0f15bb68"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/linear4.\
pdf\"\>"], "Output",
 CellChangeTimes->{
  3.967027266366153*^9, 3.967029197928383*^9, {3.96704622999737*^9, 
   3.967046299018489*^9}, 3.967046373827528*^9, 3.967046416341587*^9},
 CellLabel->"Out[73]=",ExpressionUUID->"84f71c4e-00d8-4837-afee-9a1062acc719"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 5: usando varias opciones", "Subsection",
 CellChangeTimes->{{3.9670238979330597`*^9, 3.967023899794098*^9}, 
   3.967023942350395*^9, {3.9670240546621933`*^9, 3.967024063064405*^9}, 
   3.967024213000141*^9, 
   3.967027663613946*^9},ExpressionUUID->"a651f180-b245-4ae3-b5cc-\
77034c3ee085"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"2", " ", "y"}]}], "\[LessEqual]", "20"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"3", " ", "x"}], "+", "y"}], "\[LessEqual]", "25"}], "&&", 
    RowBox[{"x", "\[GreaterEqual]", "2"}], "&&", 
    RowBox[{"y", "\[GreaterEqual]", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "0.5"}], ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "0.5"}], ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "False"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"NMaximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"5", "x"}], " ", "+", " ", 
      RowBox[{"3", "y"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "+", 
        RowBox[{"2", " ", "y"}]}], "\[LessEqual]", "20"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"3", " ", "x"}], "+", "y"}], "\[LessEqual]", "25"}], "&&", 
      RowBox[{"x", "\[GreaterEqual]", "2"}], "&&", 
      RowBox[{"y", "\[GreaterEqual]", "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LinearPro", "[", 
   RowBox[{"\"\<linear5.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<x + 2y <= 20\>\"", ",", "\"\<3x + y <= 25\>\"", 
      ",", "\"\<x >= 2\>\"", ",", "\"\<y >= 1\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<max\>\"", ",", "\"\<5x + 3y\>\""}], "}"}], 
    ",", "\"\<orange\>\"", ",", "0.6", ",", "True", ",", "True", 
    ",", "\"\<normal\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "12"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "10"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9670243275464897`*^9, 3.9670243281187277`*^9}, {
   3.967024419355645*^9, 3.967024420610036*^9}, 3.967028136431642*^9, {
   3.9670282882203608`*^9, 3.9670282888062487`*^9}, {3.96702836979605*^9, 
   3.967028406884698*^9}, {3.967029212193166*^9, 3.967029234413941*^9}, {
   3.9670464606073637`*^9, 3.9670464645357933`*^9}, {3.967046505506606*^9, 
   3.9670465287681417`*^9}},
 CellLabel->"In[94]:=",ExpressionUUID->"28682c21-e511-471c-a915-ae33dbd50432"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxlmXtczPn+x6fbVGOm60yXuY9o25NLv46wNuZ9jJWNJdesGDab0ym/IkqR
W5hcEzt7KNdySw51WiVMxLok98tKuRUiyzKiiNRvzv56fb4Pjj94PL36ft/v
7/vz/rzf788nTWT8qChrHo/nbfnrP/9+mzI/KUVkRXMVPe3LDI3ainWOx6rC
+IxD8n+2623sxHhqXaZvZawL49w/xoWmiNwZ17XI4/wKJIzV/IfrqsK8GE92
21tsaJQy3qqMrw4yKhjDn3O5Sd1H6j8wf8DwBwx/wPAHDH/A8AcMf8DwBwx/
hOL7exul1gR/wPAHDH/A8AcMf8DwBwx/wPAHDH8O3rQuMxn4zB8w/AHDHzD8
AcMfMPwBwx8w/AHDn4lZvlcMjQLmDxj+gOEPGP6A4Q8Y/oDhDxj2bSeGPgzT
OzP7YNgHwz4Y9sGwD4Z9MOyDYX+cc595onpXZh8M+2DYB8M+GPbBsA+GfTDs
55srljZKxcw+GPbBsA+GfTDsg2EfDHttVydkVIV5MHtg2APDHhj2wLAHhj0w
7I365fkGk8GL2QPDHhj2wLAHhj0w7IFhb7dxQU6OScrsgWEPDHtg2APDHhj2
wLD3PtFln6FRzuyBYQ8Me2DYA8MeGO8fHp57MNZPxd4PxvvBeD8Yz4+USyf7
FajZ82DoH4QPH0orNXSsy6hYUb2SOteOkqY3NmsXeK0O0evk5FBqPJNjciBw
4dzS6lg/EZHwjE9Bjjfx/vzjzvIbDH1M3TrH+iBJx/97UtiyEF9jlYzSnswq
zTG50s5p1T1TREpy2Hq5ztDoQK07iuUFGjUZSiK+rA9yYrx8mS7br8Dm/+Mf
zPmL/gNG/Ye/qDfwB/sB/Hl+wx/EF/bhH+KXsWm+S+UzORXlTRpqrHKksLWH
nktDpTQ2+ceBKWvcaX1M1GJRlBu13Ouf0JitJL+dRbP0OgH51j4pi41W04Gc
Kbk5wUryDd7ysSrMrG3Y8HxEQY49pY4fxqtvUn+az5bvjV44xWGk3pquXCkc
qF+iYfH4nLF+YMQH/kMHQ0e8oYOhY72gg6GffP3VnTC9mOlg6Fh/6GDoWA/o
YOhYz8/z8/P54/PvnxGVTbLKdqaDoU9pmvFLVZgtizcYOvIfOhg69gN0MPR/
KeOapZUuTAdDx36BDoaO/QMdDD3vpI97Zawn08HQ/8xfSxyhg6FjP0IHQ8d+
gA7+5P0a9afvtzDy9fP8Bk8rTN4gqhcyTvgx7WWQ2JVx0Ywh7vXF7ozNqU59
jOEejANW3Jiga/FiHPdz9oLGbBnjS3t0vVLWqOhSW7lLrukNyxesP+YhMPaj
fKlDn97Gj4wjfTy68nhWrP4hP/A8GPmK9UU9BMO/8N2OB3OCXVi9aI/ufjY2
T8zqI9YP/QaM7x0devxK2D0Pxh/7LR+ra/Fkz2N98TwYP7/Hf2RNkNibsD+x
3mD0H8R/xIvZf7QvVLD1RXzzVvl24/HsGKO/gFm962DUU/Bu04CjJoMzY/Qv
MOonGPUZfC3Jf5eJL2GM/gl2WfKqIjbPkzHiAUb8wVgvMOo7GOsNRn5gvkd8
P59XEF/k766P+6JFUXK2XmAWn47+gPyFPeQf5nf4pz97/m//2Vd4H+YTfP+f
/T1Uxvop9i8Y8wLWY8dl/ttHxSq2v9HvsN7oT8h31DvED4x8nxC7WK/XObH5
BPax39EfkT+o37CH/Yv4QEd+Qcf7oeN7oCN/oCO/oGO9oCO/oCN/oCO+0PH9
0JFf0JE/0LF+0BFvzC+on6hH0JFv0Ets83rUB9mw9UJ+QEd+QMc8BJ2/8uWY
FJGQ6TgfQUe9go7zC/R96ZvKDAluTMd8BR31DTrmLeioZ9Cxf6CjXn0y/1ny
GzryGzrqF3TUL+jId+jI9+jM4AMiKx6bJxoS5prbz6kYQ8f6JB2POWAQqrj1
6tDZ+nQwW48ORvyRD2aHnSk26XwqmOhnE1XFzav4ebYeHczi38GI9yOPMYsa
t0u5+HfoiHfC1EEDUh5y8y50Fu8OZvHtYMQT+T+4LuJcmEjGdMQT+2d9et8t
Gj8F01E/JnwIyPBbJmCM/brWPNG28hwXf5xHUA/cPO62P+qlYf2ny5Sa/YPv
aah+66yBUTyLf2LBuoKTZq0hPcj3VJ2KhJPtta7TX2mhh2aPPKTLbmF8Ye2F
F8/6WrHnZ48yW5XstGMsl4gli1wEpP5dvOE5T0GPJ4e8l3xwZPqpqj5+oalO
jHtf3K8QzHZlvPKA9ouXe90pZtvZ8Fm/SMk7s9PR5np3pt9bezXgxn0J48CZ
U/sdlngxNoxq0m0dKmVc89f075YsljPuIfEOjz6kpBMBPovXrHSjU/35CQlH
lEyneWMLdyepKWZB53Bjd8v55WJrfXaWmum/xyqDstZp6Oyk/afCM6zJ8PL4
b348S39O+kpYctWe8emM06PFEhHj3Ot5333VzZXxg/txMxsuujNWP+/184Z4
D8ZT3r0vHezqzXir7Yk7TUUyxvdc0nm7xigZ/+VBhsH+qJLGq6qONAS3a6ds
vBkrsvSFR/vjtommWvKybGjcxSAFm7/H/zLgdvEaOSVWyC4a9gnp1KC4tz1r
ZMTf7nmnfCY3f4XtfvFTuJ87bTZHaAraufOp03t1aclqb+q+qD2r2wRPyhij
LTXM86Zny3qsrlrlSVP2fBc93tLPeyenrAix1J+oGsdeYpEX6+fPn4ZM1QWI
qeyPf9tXPlbQonkFo40aEY2rNt8qjlCTWFi93u+BpS83+8ribTRUe9dHJHvB
nWePrG4ubPTgs/Md8jupdFCFzoqbp8Dof2DsHzD6Gxj7EYz9C0Z8wKhHYJyn
P+f8O5v79KaPWlthxHTRCG7+Kc+u62aUylm9wrwSuL97il+sE5sXPPefeNfu
bZlXC3u1tnf1ZvUH80sCv7yuZiF3P3JjxZfigmQlpW3IO5jzgDufD/Dtmeh3
wJXVH5xHj9ziuReoVey8vi1uJq++lrs/sLnetN11pYZaG8bVNLkoyDjC+bQm
y5EGa33a21M9aZtHRlcjyekH33On+VddydRto12op4qKrseqZEZbWnnYqap4
uoYWBPYbtLULl7+Xghseh1ridy1+tKzWUu89GrP3XB0sI+eN687f9ncjyeGf
s+V2Mir9x3T9VLMbFY2Z6/U+you0M14nR16SkszQJg+tktDuaQ/WBosVlGmc
ftbw0IVqTv32tH21igat0b+OzeWTOGZ240J/Dc15ok5uUfEo+t3Kh+8/aGji
D50jCoZYUUZdX+HKm5pP63kwVy9LgnRhPokcR5bdE+U/4erDP18fblTZakgg
dNkremlN+dPejPg1R0O98m0CeQe4+yL0z2Gvr4/wOaghnrnqYMKj/76PQP5g
PcCYP8FYPzDOI2DkBxj5BEa+gfH9mLfwfbkNczKNJe+0PbISRuhiVUy/1Svy
ZtRwFQVqX7amjnmn1Y0VBLXIVfQu8FvN9Nz37H04L+J970omR4jP8li8cR6E
vj1lSdy9QDumo35BHxK8Z3HeVkemY36Gbm6rNCYInKg5TR2Zl8zdvyVs+FtI
xv/K6d2Ir6uHxovY8zhvsn435e1o5dfcvID6B109cMUkm5nuTMf9AuuPPrK/
N+yWULf+w+4HDZQy3TTsjb1ELSWf5cvyXbdLqNE6+A9puzdpPdOH6q25+QLn
V7yvwnb/jIt3PJmO8ynrv48HzC1y4+YP1FvoM85eWbJhiJzpqAesP+dFrkld
oPz0/Rouv4XfzD0fMIG7Xzyiyraq76smxxz3YaE9uH7I5ouuY+ZXhr7h8qeq
+86UHk3aFYe3/ZQ3k+uX9tf8b/OLhYwHNkWsC2x1YZxm1bm4bgvXL8tFDbcy
tVy/5EkPtGrrvBgP8J2tfpnG9ctlwwO8nberqHBXwsqeC95oA+4NbRNvVJF6
xAdFSC3n35B9m3boO39kbJ6YWCnit2lN9ZGiyv1Klr83+u7Sj5+ppJL0+mFr
x3Pz0LCNr35sabXm8mOm/t2VOBsKDRx9PszM3Xekrj3ae+8XSipfODk4382G
Wp9W907xUFLwqjI1L8mGUA//2b9In2Wph76Przq9v6ugijnV/qcvcPvjzQRJ
8q/R9lx+/DWt06Yajjcrvlq15kYnbv2bdymjBgupkvzj+x+Skzn8xNOAYk7v
PKPHZX81l/+r7zza6Pm9CzmcqF5VdVTG9kdSs8CtUiCnu3fqI/RlzuQ2xOlu
ULqMZJOy4/yiXSlu09LLizJl1GnzjdGXhnPzXdLI8lsu49wY15Yl5bZmcFwZ
OOpB0yox417bHP5Vd0pM5UP+vbDzRymJjcN1Tx3c6bfj8SX8NCkJRJ2XJqSI
Sdx8t+epf0hJuboi0PZX7nml+NGzmhMejJcvyi4+896DjqwI3mJa6s32V2lY
n0x7nTf9T6rJtV8fbp5MaEpsOv6W4zs/dDu+L8Cbim8N7Opcyd0PYd7xuu/n
38Uy72SMNkXYJFk4OlwfvcXiZ9tU2lvgRV/P7m019hW3X8/ctG/f2Z3bnwG6
YxWZ0ziWlmY5rJyqYLy0S9i1xM0cx2X5u8VnqRjfsntwe8I1FbuPMvcbJSm4
oqCBHjf9X7pIiF/9UhI/R0HNlxbZBNhK6GPeT4duz1fQto8xDc9+E1KCMn/Q
gCg1VZasrcyZ50QzBJK/jAlQs3qA+5Rv91fHt1y25fZvzKwGfoAd43Onow6F
uwsYp6e194yaxXHIvVdtxeOcGdttWjXn1xKOIz8M8BF858b4ZPWq+y7zOc61
tws5/ELM2PrxSJtypYRxrfv5mOhMT8bU6PlFfDnHavW6DM9AKeNFbXdDlZEc
67uFF525Lmd8TLAz7qKNgjHur4zVD1vC1luz/Yrz6vAnV3+XTpKx8+bEr7tv
S43lfv+VENGkS8n3oPszvvcsyJfTlUvf7DB5e7DzIu671LUXtmhuyCk5xigN
Dfrv+65uZ+2s6lerKS/wUqrOJGT3X1v7Km4mJqqYv20eMetTd3Gctir5QImt
igb3fHi7qOKDNvmntmObQhV05+8XBR/IgabtENRG3fSmL5YO7Kya70ET92Wa
Q+Ve9M30QnP8PhmdLDlTa1juSPJ5D/R5l9RkKhwg5Lm6kFSVc1v6VkVPRx0s
TAjmk7XAFPR9Xw3JX4Sr7vvIyXpIccW0L53p/AZl4vJDrpR/4f4Qny4q+j8G
WOLT
    "], {{
      {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], Opacity[0.3], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHm8z2UWx5/zu7Z7ubaLCSWSXbJEQqLGOpVKliEztqm0SIsWJS2WG2oI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          "]], PolygonBox[CompressedData["
1:eJwtlXmwj2UYhp/nwx+hzKhJjTKT0Ux/ZJqyhGhVpIVOoyxFJCQcIpQUIxXS
YtCmmISSShup5IiIpOyS7aSkrBmlonTdbjPnOnN93+/73u9dnvd+z+taWtK3
iIihUBHOzYjq3CjH68DNXC+Bj/C50AZ/AB7Ee0Bf/BSe34JvhRu5Hg/P4e/D
JXgN6I9vh174evgMrw9d5fAu/h10wT+Fd/BVcBf+CbyNr4QL8DP43k68HVzK
dS0YEO5TJ3wuvIV/BW3xcliIl0FnfD7MxlfA7fjPsBhfAhepv7S/G+8Gdbk+
k+td6ivczfUCmIOvgfZ4PxiEL4PumhsYhm+C6/CnYFT4my3xp2F0eIz34WfR
/h68J9yguYNn8PegFf4sjAt/83r9BmPDc1aCr9Ochef0fvxs2tuH99EYuP48
3dY6uEdzkV6bDdBCbcMT4TkeKIfh+AhYjd+S7pvm+Ca8x8n11Bi/xzdBA/xV
uAyvDQPxh8Jj05prrTXGevgE1QheGa7GP4RZmlv4GJ8H/J14Zj+yDzqHn9mL
74H2+BvwG/4rlOAz4EqNLf2b3rkYP5yuBbV5Df8uhCH4w3Brus/qay8Ygo9J
j70fnFr4HT27TXOK70rXymY4hJ9W+LfBIr0GfU7uqStUK+m+qc+D8KqF90pv
KOX6qvSzqqHLVfvwenhM2jtl8EF4zhfhE6F7+F4jfAq8pFqFtfiatE+GNzW3
2rOqNWiKz4SpeHP4Ad8MzcL3mmlvwGuqRWiMT0u3pTVugk9Pr7XeaY4/Bo+q
tmAx/kV6bSdoT+PfwvnhPv6E70y3rTHuwLen+6JvNsRfgRfC76zCv4Fzwvca
4C/DpPC9SfjzmvPwnNTHX0x/+3TtSXxp2vXOaPzJdF9V449rb6ZrT2MYqrVO
10JT+DG95lrrReHar1Y4y7Qeyoo707WizFBW3MF1aTgzlFXt0mutzKrCdWXo
FM7MSvhyfq+pvRTOXmWssrUcvsTvTf82Dw7iv2tM4TY24hvSfVUG9E5nXll4
zZV9t6X7rgzcpr2RroUF4b26Ne3as7vxX9LZeiIT8dbpb+sMWIl/nT4b5of7
viLtGsO1+FgYGc7gioUzUVm4MZyFR9RGOBOVbcdhbTjjlI1HVTPhjFTW/Qur
w5n3XzqDlb261zN9RulsUg1E4cxT1qnNAXhHeCS854enM17Zrnt/pc8YnS3q
k7I3aWN9OIN1llUo3HedaX+mzxCdHcvDY/0j7RqzsvRv1Ww4UzukM0LZoJo4
kD4zdFZoDYvCmaws1jePpc9EnYWag3/SZ6LOQrWpbO+fPouU8f8D9ZYM9A==

          "]]}]}, {}, {}, {}, {}}, 
     {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], LineBox[CompressedData["
1:eJwl1HWUFmUUB+BvgQWlkVpAYmlJaZUUBAHJRelcOldEukNCSlBCuluku0O6
u0FQQulunu/wxzO/+973zjlz5p0z4ZFREe1CAoFAqEtphvKYJzRgLWUYxlOe
0ZB1fM1wnvOCRqynLCN4ySsi2UA5RvKaNzRmI+X5hbfBB4kWCDSRm/iGUYTo
RaOpejMVGE10vRg0U3elIs1JoJeQvOrkbGErYxjLOFKQyEwLWYkdVGYnLQm1
t0fuZTf72UdM/W4yNR+pq8iOFCINR6jKNKbTmjBzreQJIjjOKU4Sy1532YNv
OU81CpOeC1xkHvNZQEYSu6+N/I4rVOdv2vIvNfiHG1znA/M9ZVaSqGvKTsRV
Bz+AD2UcYtPLOhv3uM9davE9UXxJZ34Ivkfz7WVvcpLMuq58yEpq84D4+vEo
pc5BUnUHWYc+5A6elV492YWf+ZFBDGEw/fiUvuTiKwbQn4H8RHZKsoLl3OE2
n1CCZSzlf/4jC8VZwp/c4iaZKcZi/uAaV8lEURaxkMtcIgNFmMscznGWcL5g
NrM4w2nS8TkzmcExjpKWz5jKFA5ziI8pyGQmcZADpKIAE5nALv4iJfn5nfFs
Zxth5OM3fmUNq4PnRh4eUZ9VIe//B+8A+deC/A==
       "]]}}], {}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None, "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{{-0.5, 12}, {-0.5, 10}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.967027279291103*^9, 3.967029235965569*^9, {3.967046441898477*^9, 
   3.967046466112818*^9}, {3.96704650649899*^9, 3.9670465293175287`*^9}},
 CellLabel->"Out[94]=",ExpressionUUID->"e28dcebd-5638-4415-9f5e-fb4f8a9469b4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"51.`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "5.999999999999999`"}], ",", 
     RowBox[{"y", "\[Rule]", "7.`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.967027279291103*^9, 3.967029235965569*^9, {3.967046441898477*^9, 
   3.967046466112818*^9}, {3.96704650649899*^9, 3.967046529320232*^9}},
 CellLabel->"Out[95]=",ExpressionUUID->"f1399c20-fc65-4c6d-8411-e1b4d44ddd82"],

Cell[CellGroupData[{

Cell[BoxData["\<\"\[Checkmark] Punto \[OAcute]ptimo: {6., 7.}\"\>"], "Print",
 CellChangeTimes->{
  3.967027277707548*^9, 3.967029235972492*^9, {3.967046441904892*^9, 
   3.967046466118485*^9}, {3.96704650650499*^9, 3.967046529344491*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[94]:=",ExpressionUUID->"a82106ed-7548-49ab-a28c-3398a48e37b1"],

Cell[BoxData["\<\"\[Checkmark] Valor \[OAcute]ptimo: 51.\"\>"], "Print",
 CellChangeTimes->{
  3.967027277707548*^9, 3.967029235972492*^9, {3.967046441904892*^9, 
   3.967046466118485*^9}, {3.96704650650499*^9, 3.967046529345564*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[94]:=",ExpressionUUID->"21513565-086e-48b7-a8d6-6f21d0606426"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967027277707548*^9, 3.967029235972492*^9, {3.967046441904892*^9, 
   3.967046466118485*^9}, {3.96704650650499*^9, 3.967046529346509*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[94]:=",ExpressionUUID->"199dca8f-2864-4601-9a4a-d09cb0c77552"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967027277707548*^9, 3.967029235972492*^9, {3.967046441904892*^9, 
   3.967046466118485*^9}, {3.96704650650499*^9, 3.967046529346993*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[94]:=",ExpressionUUID->"dbb414ad-998e-4b03-9207-50dc6611b0ec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967027277707548*^9, 3.967029235972492*^9, {3.967046441904892*^9, 
   3.967046466118485*^9}, {3.96704650650499*^9, 3.967046529347492*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[94]:=",ExpressionUUID->"95c18b2e-5f7e-4048-9dff-63f34a19129b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967027277707548*^9, 3.967029235972492*^9, {3.967046441904892*^9, 
   3.967046466118485*^9}, {3.96704650650499*^9, 3.967046529347991*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[94]:=",ExpressionUUID->"0f7d5842-942c-4b21-a9eb-ff837752a07b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967027277707548*^9, 3.967029235972492*^9, {3.967046441904892*^9, 
   3.967046466118485*^9}, {3.96704650650499*^9, 3.967046529348514*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[94]:=",ExpressionUUID->"1a076f50-82f3-44e9-8514-d6ccb95aec4b"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967027277707548*^9, 3.967029235972492*^9, {3.967046441904892*^9, 
   3.967046466118485*^9}, {3.96704650650499*^9, 3.967046529400955*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[94]:=",ExpressionUUID->"dce7cf7a-f5c2-4eed-99fe-1a75c914a63f"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967027277707548*^9, 3.967029235972492*^9, {3.967046441904892*^9, 
   3.967046466118485*^9}, {3.96704650650499*^9, 3.9670465304070377`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[94]:=",ExpressionUUID->"e92b80f3-2f8b-4472-8884-0d347dbe6832"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/LinearPro/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967027277707548*^9, 3.967029235972492*^9, {3.967046441904892*^9, 
   3.967046466118485*^9}, {3.96704650650499*^9, 3.967046530412071*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[94]:=",ExpressionUUID->"90f844de-417d-48b6-b65c-92b3461940ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"linear5\"\>"}],
  SequenceForm["Archivo: ", "linear5"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967027277707548*^9, 3.967029235972492*^9, {3.967046441904892*^9, 
   3.967046466118485*^9}, {3.96704650650499*^9, 3.967046530415142*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[94]:=",ExpressionUUID->"dd4eb4c3-c37c-4265-a3b2-272ba6bb2bec"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967027277707548*^9, 3.967029235972492*^9, {3.967046441904892*^9, 
   3.967046466118485*^9}, {3.96704650650499*^9, 3.96704653089554*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[94]:=",ExpressionUUID->"1bc5dfe8-2ddc-428c-8935-112fe55d7cad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/linear5.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/LinearPro/linear5.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967027277707548*^9, 3.967029235972492*^9, {3.967046441904892*^9, 
   3.967046466118485*^9}, {3.96704650650499*^9, 3.967046530896496*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[94]:=",ExpressionUUID->"01fbfd35-0fb3-4a4b-bd4e-e6fb4d12d315"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/linear5.\
pdf\"\>"], "Output",
 CellChangeTimes->{
  3.967027279291103*^9, 3.967029235965569*^9, {3.967046441898477*^9, 
   3.967046466112818*^9}, {3.96704650649899*^9, 3.967046530908463*^9}},
 CellLabel->"Out[97]=",ExpressionUUID->"1518fdfb-2631-4b9d-b8a9-824edd0e7d09"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Ejemplo 6: soluci\[OAcute]n \[UAcute]nica con un \[UAcute]nico punto en la \
regi\[OAcute]n factible\
\>", "Subsection",
 CellChangeTimes->{{3.9670238979330597`*^9, 3.967023899794098*^9}, {
   3.967023974528059*^9, 3.9670239811099463`*^9}, {3.967027588506658*^9, 
   3.9670276150574636`*^9}, 
   3.967027667243868*^9},ExpressionUUID->"1cac52b7-aff6-4571-8f4a-\
7fc1c8355ddb"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "+", "y"}], "\[LessEqual]", "5"}], "&&", 
    RowBox[{
     RowBox[{"x", "+", "y"}], "\[GreaterEqual]", "5"}], "&&", 
    RowBox[{"x", "\[LessEqual]", "3"}], "&&", 
    RowBox[{"x", "\[GreaterEqual]", "3"}], "&&", 
    RowBox[{"y", "\[GreaterEqual]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "0.5"}], ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "0.5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "False"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"NMaximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", " ", "+", " ", "y"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "+", "y"}], "\[LessEqual]", "5"}], "&&", 
      RowBox[{
       RowBox[{"x", "+", "y"}], "\[GreaterEqual]", "5"}], "&&", 
      RowBox[{"x", "\[LessEqual]", "3"}], "&&", 
      RowBox[{"x", "\[GreaterEqual]", "3"}], "&&", 
      RowBox[{"y", "\[GreaterEqual]", "0"}]}]}], "}"}], 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"o", " ", "se", " ", "pone", " ", "x"}], "==", "3"}], "*)"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LinearPro", "[", 
   RowBox[{"\"\<linear6.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<x + y <= 5\>\"", ",", "\"\<x + y >= 5\>\"", 
      ",", "\"\<x <= 3\>\"", ",", "\"\<x >= 3\>\"", ",", "\"\<y >= 0\>\""}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<max\>\"", ",", "\"\<x + y\>\""}], "}"}], ",", "\"\<cyan\>\"",
     ",", "1.2", ",", "True", ",", "True", ",", "\"\<small\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967024295279932*^9, 3.967024298375147*^9}, {
   3.967024379063809*^9, 3.967024389216703*^9}, 3.967025165643898*^9, 
   3.9670256454525537`*^9, 3.96702585672293*^9, 3.96702626145315*^9, 
   3.96702646743841*^9, 3.9670271151158*^9, 3.967027187840479*^9, 
   3.96702731602456*^9, 3.9670281422377367`*^9, {3.967028292733903*^9, 
   3.9670282932623863`*^9}, {3.967028435122631*^9, 3.9670284469664927`*^9}, {
   3.967029245196211*^9, 3.967029273247703*^9}, {3.967046596738411*^9, 
   3.9670466530622263`*^9}, 3.967046720655662*^9},
 CellLabel->
  "In[168]:=",ExpressionUUID->"5637cc4d-fd23-4163-bb6d-f5a652735921"],

Cell[BoxData[
 GraphicsBox[{{}, {}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None, "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{{-0.5, 7}, {-0.5, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.967029277809935*^9, 3.967046662410351*^9, {3.967046709851935*^9, 
   3.967046721919655*^9}, 3.9670480503537407`*^9},
 CellLabel->
  "Out[168]=",ExpressionUUID->"1159aad1-8676-47d6-9997-786ba636ce29"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "3.`"}], ",", 
     RowBox[{"y", "\[Rule]", "2.`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.967029277809935*^9, 3.967046662410351*^9, {3.967046709851935*^9, 
   3.967046721919655*^9}, 3.9670480503566427`*^9},
 CellLabel->
  "Out[169]=",ExpressionUUID->"64358e34-49d8-4191-b999-1f5d25244139"],

Cell[CellGroupData[{

Cell[BoxData["\<\"\[Checkmark] Punto \[OAcute]ptimo: {3., 2.}\"\>"], "Print",
 CellChangeTimes->{
  3.967029277820571*^9, 3.967046662419039*^9, {3.967046709862265*^9, 
   3.9670467219350157`*^9}, 3.9670480503629093`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[168]:=",ExpressionUUID->"0d8635d3-3bb4-478d-892b-767cb2da4b67"],

Cell[BoxData["\<\"\[Checkmark] Valor \[OAcute]ptimo: 5.\"\>"], "Print",
 CellChangeTimes->{
  3.967029277820571*^9, 3.967046662419039*^9, {3.967046709862265*^9, 
   3.9670467219350157`*^9}, 3.967048050363858*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[168]:=",ExpressionUUID->"1b28b1dd-d03a-4b38-a519-aebff123cfc4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967029277820571*^9, 3.967046662419039*^9, {3.967046709862265*^9, 
   3.9670467219350157`*^9}, 3.967048050365015*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[168]:=",ExpressionUUID->"ed9afd2f-e827-48df-ab02-37c4aa4f0dd9"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967029277820571*^9, 3.967046662419039*^9, {3.967046709862265*^9, 
   3.9670467219350157`*^9}, 3.967048050365675*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[168]:=",ExpressionUUID->"362ad7e8-b410-4be4-9c58-1634266ed25b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967029277820571*^9, 3.967046662419039*^9, {3.967046709862265*^9, 
   3.9670467219350157`*^9}, 3.967048050366314*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[168]:=",ExpressionUUID->"228c7ab4-5289-4af6-9ed1-5e15b627903b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967029277820571*^9, 3.967046662419039*^9, {3.967046709862265*^9, 
   3.9670467219350157`*^9}, 3.967048050366963*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[168]:=",ExpressionUUID->"d3647d75-6910-4f86-bd85-4e6e06f15b2d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967029277820571*^9, 3.967046662419039*^9, {3.967046709862265*^9, 
   3.9670467219350157`*^9}, 3.967048050367659*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[168]:=",ExpressionUUID->"9c487f47-c719-4068-b184-9a42c7011b1e"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967029277820571*^9, 3.967046662419039*^9, {3.967046709862265*^9, 
   3.9670467219350157`*^9}, 3.967048050457965*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[168]:=",ExpressionUUID->"b5f458d6-9b11-4484-b729-be1d194760b0"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967029277820571*^9, 3.967046662419039*^9, {3.967046709862265*^9, 
   3.9670467219350157`*^9}, 3.967048051465653*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[168]:=",ExpressionUUID->"fcd37851-dd16-466c-b3d8-9a444ddf3384"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/LinearPro/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967029277820571*^9, 3.967046662419039*^9, {3.967046709862265*^9, 
   3.9670467219350157`*^9}, 3.967048051471323*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[168]:=",ExpressionUUID->"da077052-d358-4ad0-9009-085879219f61"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"linear6\"\>"}],
  SequenceForm["Archivo: ", "linear6"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967029277820571*^9, 3.967046662419039*^9, {3.967046709862265*^9, 
   3.9670467219350157`*^9}, 3.967048051475211*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[168]:=",ExpressionUUID->"b751968e-7242-4c9e-9a01-4feffcd27e06"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967029277820571*^9, 3.967046662419039*^9, {3.967046709862265*^9, 
   3.9670467219350157`*^9}, 3.967048051931925*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[168]:=",ExpressionUUID->"06040aae-7f41-490c-9b97-30650f023ca7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/linear6.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/LinearPro/linear6.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967029277820571*^9, 3.967046662419039*^9, {3.967046709862265*^9, 
   3.9670467219350157`*^9}, 3.967048051932963*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[168]:=",ExpressionUUID->"577926c8-dbfe-485e-99ae-1c483d39d287"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/linear6.\
pdf\"\>"], "Output",
 CellChangeTimes->{
  3.967029277809935*^9, 3.967046662410351*^9, {3.967046709851935*^9, 
   3.967046721919655*^9}, 3.967048051948884*^9},
 CellLabel->
  "Out[171]=",ExpressionUUID->"40ff029e-2be0-4615-9197-26682d63aaf7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 7: no acotado (no compila el .tex)", "Subsection",
 CellChangeTimes->{{3.9670238979330597`*^9, 3.967023899794098*^9}, {
   3.967023944285866*^9, 3.967023945606237*^9}, {3.967024075783321*^9, 
   3.967024078550578*^9}, 3.9670242163780203`*^9, 3.96702761873475*^9, 
   3.9670276716243343`*^9, {3.967046797125938*^9, 3.967046804672493*^9}, {
   3.9670468647042313`*^9, 3.9670468737041607`*^9}, {3.967047082697801*^9, 
   3.967047083177636*^9}},ExpressionUUID->"5e3cdf43-35ee-4fd6-82fc-\
6b225074d2e5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "-", "y"}], "\[GreaterEqual]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"y", "\[GreaterEqual]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "0.5"}], ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "0.5"}], ",", "15"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "False"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"NMaximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", " ", "+", " ", 
      RowBox[{"2", "y"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "-", "y"}], "\[GreaterEqual]", 
       RowBox[{"-", "1"}]}], "&&", 
      RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"y", "\[GreaterEqual]", "0"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LinearPro", "[", 
   RowBox[{"\"\<linear7.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<x - y >= -1\>\"", ",", "\"\<x >= 0\>\"", 
      ",", "\"\<y >= 0\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<max\>\"", ",", "\"\<x + 2y\>\""}], "}"}], ",", "\"\<red\>\"",
     ",", "1.0", ",", "True", ",", "True", ",", "\"\<normal\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "15"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "15"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967024331524342*^9, 3.967024332068255*^9}, {
  3.967024426241149*^9, 3.967024427620998*^9}, {3.967028296350068*^9, 
  3.967028296936488*^9}, {3.9670284583556423`*^9, 3.967028479504229*^9}, {
  3.967029292881415*^9, 3.967029305906616*^9}, {3.9670467714810257`*^9, 
  3.967046774089099*^9}},
 CellLabel->
  "In[120]:=",ExpressionUUID->"0c1f35ad-e892-4520-b5e8-13b957ff0daf"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx1mntYVNUWwAdU4KogIC8HREDAQUCpHDXTZhemhqaDmVnqYCpq4VtS0DQ1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    "], {{
      {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], Opacity[0.3], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgn411P2x7/32hpjX8Y6lDW7KEt2igxZkp1EEhXZ1yxZk+3PSFIke1nL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          "]], PolygonBox[CompressedData["
1:eJwllnmwlnMcxZ/nuCpJ0r3t623fVfZ9zBAVSYlcEleWS8pajcaMMYwZEy12
2ckue9Zs2UUqbdrt+5IkJvE5zh+fec9533uf9/f8nvM737e6duKICSqKYhZU
wF+Y9rAQPbMsig7ov+EG9CLeuwtdDQ3x9eFf+Ax/GK/d+fwfXu/BN+C1Ct8V
PRN+RDfmvc7o6fAtvhG+E/o6+Bq/M75Er4HB6P14ryP6WvgSvRPvnYB+Ftqg
D4FR6KehFfoAOA79FLT0/8NI9JPQAr0PjEA/Ac3Re8Gx6LnQDL0HDEc/DlXo
AXA8+hlojT4IjkE/BpXo3aELegZ8z/p28R6gr4df8U3w/dG3g8qscSD6TqhX
5h4GoO+AijLfUYn+GSah53KNZr4WTMXPw9+tPAPvvfe4G3qW/4fPdvWa0LP9
QMvsQV/0rbCtyD33Qd/iZ1rknnujb4atRe65F/om2FLkHnuib4TN+Kb4Hs4C
bMLvhu+Hvg22F9ljf9ci2LvMd+6AXgfD8EO8Ru8VjMfPxg9BP6hkoysMRj+g
7GVnOBI9R8lKNRyBvl/JSgcYj/4JLkKv5npD0Q8pe9EdzkH/ABOcUz7fxutU
/OfZomKKknlnfSN+EvpPmIbfgL8Y/QdcjV+PvxD9O1yBX4c/H/0bXIZfi/dh
+gWm4NfgB6HvVbLbDnZEb4CR6Bo+Pxv9HdThV+FHo1fBofjFzryzD2Pwk/H1
vXYYja/zmfHZgVr8lc6gzxachZ/hZ+SzBxfg5+CHoR9VnmVfOBP9DYxDr+Tz
o9GPKM+2N5yCXg/D0Z/yeQ16NQzCL8HXor+AGvxy/Dj0VzAWvwJ/KnojjMIv
w5+MXgtD8UvxR6EfVs5KzzLZ/Aj2LJPRhcoZ9dkcWCarHyramXX3nKjslTvo
/3tX7sV74LVXKNnzPTiLY5Tvdia9Fild4zX5WTRW9s7PxF10knKv7iRnqYmS
XWdqs7OnZOEq/CbvtZKFy8tkpSXML5IZZ6stvFckY1vRk5WsTcdvQV+iZO2a
MtlrDQuKZNBZa650gTPnZ1Eo3etn4r2up2TLe95Guaav5e9spazZa/U1Wyhr
9lq9xnbKmrwWz4B53nuoRLct013PKdod5iyPVbLhTF+qZN5Z9xlzdk9XsuEM
O7unKVlwhp3dM5SsOMPOYiMly86ks9RQyb4z5aw1ULLvzHk2PA/ty8wIZ/1c
5aw78+6Gpkr23RHu1vOUrnDHLlFmhmfFvt4jpePd7f3KdN+7inYHvqOcIZ+d
PmW68G1FuxPdvUth/zIF84rSae6yTj5DyszyrPLfLFdmjGfLgfCBMoM8e/qX
6eL3Fe1O/liZYZ5dPiOfKDPOs82d6y5erNyLO9mzZ5lybc8gz96XlbV4Br+k
dKy7tWOZWfyioj2TVyoz17P24DLdtL3MbHdHucvrlO5yp3tWTVS6zzPLXVil
zDJ3omfdCuVannmeXW9AjzIz7HWlw93d3eBNpSPcDf6bF5QZ4O73M/fsnQ9d
yszg+5SO9/b7N8qryozxbPHfeDYvgF5lZvRbSue56/yef6u8pny3f7P4t8/h
ymzwb6D/AFxRHqM=
          "]]}]}, {}, {}, {}, {}}, 
     {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], LineBox[CompressedData["
1:eJwl1GV0F2QUwOE/KY2Ao2tIKUhJjG5wSKOkEqPDDQVG52jQ0Uh3qXTjaHR0
SIM0Ckp3HOo5hw/P+7vnfr3nvMFhEfXD4wQCgSDPXtKYP48bCGxgPbMpwjoa
cYbTzKIwa2nIKU4yk0Ks4WtOcJwZFGQ1X/EXx5hOAVbRgKMcYRqfsZL6HOYQ
P5OfFdTjIAeYSj6WU5f97GMKn/IbddhLLJP5hF+pzZ/8wSTy8gu12MNuJpKH
ZdRkFzuZQG6W8iU72M54crGEGmxjK+PIyWJCieF3ovmYRXzBFjbzEzlYSHU2
sZEfyc58qtGH3vTllTsu0GDmMJd5vLbvp2/0rDamKE04x1v7/hrgPE0pRjP+
Jg4DiMsFvqE433KReAwkPpdoTglacJkEDCIhV2hJCK24ygcMJhHXCKMkrblO
YoaQhH9oQyna8i9JiSIZN2hHadpzk+QMJQX/0YEydOR/UjKMD7lFJ8rSmduk
YjipuUMXyvEdd0nDCD7iHuGUJ4L7BDGStDygKxX4noekYxTpecQPVKQbj8nA
aDLyhO5UogdPycQYMvOMSCrTk+dkYSxZeUEvqlCVl2TjiPMf5TAHiGUXMaxn
OQuZTjRRRNKBJoQSQu7A+//kHWx9jvs=
       "]]}}], {}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None, "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{{-0.5, 15}, {-0.5, 15}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.9670293069301033`*^9, {3.967046762136526*^9, 3.967046774972885*^9}},
 CellLabel->
  "Out[120]=",ExpressionUUID->"76c56cf2-3e5f-4d59-a191-0f88945dbd74"],

Cell[BoxData[
 TemplateBox[{
  "NMaximize", "dinfeas", 
   "\"The dual appears to be infeasible, which implies that the primal \
optimization is either unbounded or infeasible. Reducing the tolerance may \
help resolve the dual infeasibility.\"", 2, 121, 13, 34481913892064439222, 
   "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.967029306958397*^9, {3.967046762160904*^9, 3.967046774975683*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[120]:=",ExpressionUUID->"a6d42684-d93f-4d7e-8070-3d115f18f012"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Infinity]", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "Indeterminate"}], ",", 
     RowBox[{"y", "\[Rule]", "Indeterminate"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9670293069301033`*^9, {3.967046762136526*^9, 3.967046774978242*^9}},
 CellLabel->
  "Out[121]=",ExpressionUUID->"e5ea55de-1543-4b2d-9456-62dc6dca4174"],

Cell[BoxData[
 TemplateBox[{
  "NMaximize", "dinfeas", 
   "\"The dual appears to be infeasible, which implies that the primal \
optimization is either unbounded or infeasible. Reducing the tolerance may \
help resolve the dual infeasibility.\"", 2, 122, 14, 34481913892064439222, 
   "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.967029306958397*^9, {3.967046762160904*^9, 3.967046774978943*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[120]:=",ExpressionUUID->"399a2884-0b66-485a-b23a-4abf1cabc157"],

Cell[CellGroupData[{

Cell[BoxData["\<\"\[Checkmark] Punto \[OAcute]ptimo: No acotado (\[Infinity])\
\"\>"], "Print",
 CellChangeTimes->{
  3.967029306969182*^9, {3.967046762165806*^9, 3.96704677498094*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[120]:=",ExpressionUUID->"1967c5e1-b8f2-4f7b-a2db-1bed0a8418b3"],

Cell[BoxData["\<\"\[Checkmark] Valor \[OAcute]ptimo: \[Infinity]\"\>"], \
"Print",
 CellChangeTimes->{
  3.967029306969182*^9, {3.967046762165806*^9, 3.9670467749814997`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[120]:=",ExpressionUUID->"60594d2a-207f-44a0-971b-1ab42f820d25"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967029306969182*^9, {3.967046762165806*^9, 3.967046774982484*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[120]:=",ExpressionUUID->"0f1027d0-7af4-4a3e-9747-e1abab91a607"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967029306969182*^9, {3.967046762165806*^9, 3.967046774983019*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[120]:=",ExpressionUUID->"ec5f25cd-8e69-41df-91d3-1ee892ebd348"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967029306969182*^9, {3.967046762165806*^9, 3.967046774983533*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[120]:=",ExpressionUUID->"82591257-b082-47c5-9d3b-96160889e4ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967029306969182*^9, {3.967046762165806*^9, 3.9670467749840717`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[120]:=",ExpressionUUID->"c9329dc9-8d61-4a10-a9bd-45163f91be03"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967029306969182*^9, {3.967046762165806*^9, 3.9670467749846077`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[120]:=",ExpressionUUID->"cc38f5b1-3501-48c2-ba87-c4b394d6d804"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967029306969182*^9, {3.967046762165806*^9, 3.9670467750605793`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[120]:=",ExpressionUUID->"2b21ac7e-2b3d-447a-95b2-c2997697eb74"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967029306969182*^9, {3.967046762165806*^9, 3.967046776067734*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[120]:=",ExpressionUUID->"e7334e1d-7061-497f-a901-75afd630b438"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/LinearPro/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967029306969182*^9, {3.967046762165806*^9, 3.9670467760739098`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[120]:=",ExpressionUUID->"df89e7da-c635-4703-b07e-b9d1c7290c95"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"linear7\"\>"}],
  SequenceForm["Archivo: ", "linear7"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967029306969182*^9, {3.967046762165806*^9, 3.967046776078373*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[120]:=",ExpressionUUID->"b5daf009-ec47-4ec4-8299-3bfa729886a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Error en compilaci\[OAcute]n (Exit Code: \"\>", "\[InvisibleSpace]",
    "1", "\[InvisibleSpace]", "\<\")\"\>"}],
  SequenceForm["Error en compilaci\[OAcute]n (Exit Code: ", 1, ")"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967029306969182*^9, {3.967046762165806*^9, 3.967046776551423*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[120]:=",ExpressionUUID->"97d84619-c9da-439c-81ff-130f998bd244"],

Cell[BoxData["\<\"Detalles del error:\"\>"], "Print",
 CellChangeTimes->{
  3.967029306969182*^9, {3.967046762165806*^9, 3.967046776552375*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[120]:=",ExpressionUUID->"549e6e0e-c558-4b54-85e4-9aefa08e070c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Output: \"\>", 
   "\[InvisibleSpace]", "\<\"This is pdfTeX, Version 3.141592653-2.6-1.40.26 \
(TeX Live 2024) (preloaded format=pdflatex)\\n restricted \\\\write18 \
enabled.\\nentering extended \
mode\\n(/Users/enriquevilchezquesada/Downloads/LinearPro/linear7.tex\\\
nLaTeX2e <2023-11-01> patch level 1\\nL3 programming layer \
<2024-02-20>\\n(/usr/local/texlive/2024/texmf-dist/tex/latex/standalone/\
standalone.cls\\nDocument Class: standalone 2022/10/10 v1.3b Class to compile \
TeX sub-files \
stan\\ndalone\\n(/usr/local/texlive/2024/texmf-dist/tex/latex/tools/shellesc.\
sty)\\n(/usr/local/texlive/2024/texmf-dist/tex/generic/iftex/ifluatex.sty\\n(/\
usr/local/texlive/2024/texmf-dist/tex/generic/iftex/iftex.sty))\\n(/usr/local/\
texlive/2024/texmf-dist/tex/latex/xkeyval/xkeyval.sty\\n(/usr/local/texlive/\
2024/texmf-dist/tex/generic/xkeyval/xkeyval.tex\\n(/usr/local/texlive/2024/\
texmf-dist/tex/generic/xkeyval/xkvutils.tex\\n(/usr/local/texlive/2024/texmf-\
dist/tex/generic/xkeyval/keyval.tex))))\\n(/usr/local/texlive/2024/texmf-dist/\
tex/latex/standalone/standalone.cfg)\\n(/usr/local/texlive\"\>"}],
  SequenceForm[
  "Output: ", 
   "This is pdfTeX, Version 3.141592653-2.6-1.40.26 (TeX Live 2024) \
(preloaded format=pdflatex)\n restricted \\write18 enabled.\nentering \
extended mode\n(/Users/enriquevilchezquesada/Downloads/LinearPro/linear7.tex\n\
LaTeX2e <2023-11-01> patch level 1\nL3 programming layer <2024-02-20>\n\
(/usr/local/texlive/2024/texmf-dist/tex/latex/standalone/standalone.cls\n\
Document Class: standalone 2022/10/10 v1.3b Class to compile TeX sub-files \
stan\ndalone\n\
(/usr/local/texlive/2024/texmf-dist/tex/latex/tools/shellesc.sty)\n\
(/usr/local/texlive/2024/texmf-dist/tex/generic/iftex/ifluatex.sty\n\
(/usr/local/texlive/2024/texmf-dist/tex/generic/iftex/iftex.sty))\n\
(/usr/local/texlive/2024/texmf-dist/tex/latex/xkeyval/xkeyval.sty\n\
(/usr/local/texlive/2024/texmf-dist/tex/generic/xkeyval/xkeyval.tex\n\
(/usr/local/texlive/2024/texmf-dist/tex/generic/xkeyval/xkvutils.tex\n\
(/usr/local/texlive/2024/texmf-dist/tex/generic/xkeyval/keyval.tex))))\n\
(/usr/local/texlive/2024/texmf-dist/tex/latex/standalone/standalone.cfg)\n\
(/usr/local/texlive"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967029306969182*^9, {3.967046762165806*^9, 3.967046776552841*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[120]:=",ExpressionUUID->"b0ed0335-c0b5-44c2-b5d3-ab2cc3e7a447"],

Cell[BoxData["\<\"Revisa el archivo LaTeX en el editor para corregir \
errores\"\>"], "Print",
 CellChangeTimes->{
  3.967029306969182*^9, {3.967046762165806*^9, 3.967046776553578*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[120]:=",ExpressionUUID->"07f27a3d-91be-4651-ab7a-a94c5f552445"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/linear7.\
tex\"\>"], "Output",
 CellChangeTimes->{
  3.9670293069301033`*^9, {3.967046762136526*^9, 3.967046776554041*^9}},
 CellLabel->
  "Out[123]=",ExpressionUUID->"34fdacab-7c58-4a46-98ad-e229a2618344"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 8: no acotado (no compila el .tex)", "Subsection",
 CellChangeTimes->{{3.9670238979330597`*^9, 3.967023899794098*^9}, 
   3.9670239469581223`*^9, {3.967024086768228*^9, 3.9670240913024054`*^9}, 
   3.967024218820931*^9, 3.9670276213882647`*^9, 3.9670276742191563`*^9, {
   3.96704710188556*^9, 
   3.96704710281915*^9}},ExpressionUUID->"1a63ceed-7225-400c-a5f2-\
6ac13652a023"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "+", "y"}], "\[GreaterEqual]", "2"}], "&&", 
    RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"y", "\[GreaterEqual]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "0.5"}], ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "0.5"}], ",", "20"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "False"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"NMaximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], " ", "+", " ", 
      RowBox[{"3", "y"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "+", "y"}], "\[GreaterEqual]", "2"}], "&&", 
      RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"y", "\[GreaterEqual]", "0"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LinearPro", "[", 
   RowBox[{"\"\<linear8.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<x + y >= 2\>\"", ",", "\"\<x >= 0\>\"", 
      ",", "\"\<y >= 0\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<max\>\"", ",", "\"\<2x + 3y\>\""}], "}"}], 
    ",", "\"\<green\>\"", ",", "1.0", ",", "True", ",", "True", 
    ",", "\"\<normal\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "20"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9670243353557453`*^9, 3.967024336701056*^9}, {
  3.967024432525772*^9, 3.967024433858655*^9}, {3.967028299513351*^9, 
  3.967028300041319*^9}, {3.9670284913991213`*^9, 3.9670285142144337`*^9}, {
  3.9670293261706047`*^9, 3.967029339433207*^9}, {3.9670471094325027`*^9, 
  3.967047111980946*^9}},
 CellLabel->
  "In[124]:=",ExpressionUUID->"4e6101df-2f5b-488a-9874-9807a404cb9c"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJztmf1zlNUVxwNEgZRFKNBACDELJLyTF8jagGapC5QGrBCZRKBEEGIzBIaX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    "], {{
      {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], Opacity[0.3], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmnncV1PXxvfeIco8pUhSUVIKlUhKGZJCk1I0iEiEDCHzFEVEKQ0aRIWk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          "]], PolygonBox[CompressedData["
1:eJwllMdSlkEQRT+6XMmCMoMZs4ixzDkHBBW0DFt3gCRFEARRFEVREEERJJkj
BszhXVSexHO9VZyq8wMz/0zf7sk8WVZQGkmS5MAomMmHy3AvJUlOw3H8N7zH
iyAbvwu9+DlYjv+Fz/g41i/A26CHz1WQhd+BB3g1zMKvQhd+BubhN6EbPwtP
8d3QhD+H13gBtOBD8ALPhWb8FTzGt+vMWgtz8OtwH6+ER/hWaMSfwCC+ES7q
b/AQ3wyXtJf+B98JV/BnAt+rM+u7YZnuAufxWniJH9B36qw6E34IbuBvYInO
An14jX6HH9Gd8Vu6I54D17QXnMD/wEe8Dgbw9dCgs8IGZRF23eEoPgJfcX7+
r00NZ6E9dimb8F1U0z34l3Btdad9Whu+m86grEeH91LmY3E1SBteDOPxCriN
n4KJeCW04yWQhhdDK14Ik/Fa6MDLYD/+LXxXZbgD/xTOTjVfg7+FAfwCrMPf
wWCKa5CP/wzXVj2Rh38P94IyWIUPQT9eD9tUy3D26pFN+Idw9sr8MP4r3FvK
5CD+I5ylMpyuXlHP4xWQjlerp/FSmIrXQyderp7GJ4RroRqVK4twrVTDBnxa
eC+tacIzw7OgmavCJ4X3Vk3r8CnhvVXDGjwjXEudoQQfE85GNW/EZ4RnV2fe
gg+He1sz0IMvDfeuerILXxzuTc10H746XDtloNleEZ59zXgvvjLcm6pxMz47
PGua6X58bTg7ZdaKzw+/BZrxFnxueNY1o534ovBbojeiHV8Yfiv0hqi3j4V7
ST3+D1MlkDs=
          "]]}]}, {}, {}, {}, {}}, 
     {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], LineBox[CompressedData["
1:eJwl01V7DwAYxuH/nGmmmRimO6eZNjnGsLCyadNMmzbNdOd0d3d3N9/Bsfu6
HNzv+3yBX2jSuKixQYFAIMgJ84PJtJ/lCQS20oDN1GcLT9lEPTZSlxyesIE6
rKM263nMWmqxmpqs4RGrqEE21VnJQ1ZQjWWEsZwHLKUqi6nCEu6ziMpkEcpC
7rGASsyjIvO5y1wqMJvyzOEOswghk3LM5DYzKMs0yjCdW0ylNJMpxRRuMomS
TKAEE7lBBsUZRzHGc52xBDOaoozhGqMozEgKMYjfDKQA+fhBDEVoxC8aUpD8
/GQwjXlOE7YxhGM05QXN2M5QjtOcl4Szg1hO0IJXtGQncZykFa9pzS7iOUUb
3tCW3SRwmna8pT17GMYZOvCOCPaSyFk68p5O7COJc3TmA13YTzLn6cpHunGA
FC7QnU/04CCpXCSSz/TkEMO5RC++0JvDpHGZPnylL7mkc4V+fCOKI4zgKv35
zgCOEk22zgYyiBgGM4ShxBJHPAkMI5EkkkkhleGkkU40EdQnhLz81fMfXnKN
XHLIIoN4IgkP/O//H0YNd2E=
       "]]}}], {}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None, "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{{-0.5, 20}, {-0.5, 20}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.967029340791676*^9, 3.967047116721532*^9},
 CellLabel->
  "Out[124]=",ExpressionUUID->"28a26600-64aa-425e-8115-839a4a179cd0"],

Cell[BoxData[
 TemplateBox[{
  "NMaximize", "dinfeas", 
   "\"The dual appears to be infeasible, which implies that the primal \
optimization is either unbounded or infeasible. Reducing the tolerance may \
help resolve the dual infeasibility.\"", 2, 125, 15, 34481913892064439222, 
   "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{3.967029340795401*^9, 3.967047116724471*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"6967174c-491a-4142-afb7-cc28a4321f36"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Infinity]", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "Indeterminate"}], ",", 
     RowBox[{"y", "\[Rule]", "Indeterminate"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.967029340791676*^9, 3.9670471167272043`*^9},
 CellLabel->
  "Out[125]=",ExpressionUUID->"088750ca-823c-4e58-b634-0be2e95054cc"],

Cell[BoxData[
 TemplateBox[{
  "NMaximize", "dinfeas", 
   "\"The dual appears to be infeasible, which implies that the primal \
optimization is either unbounded or infeasible. Reducing the tolerance may \
help resolve the dual infeasibility.\"", 2, 126, 16, 34481913892064439222, 
   "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{3.967029340795401*^9, 3.967047116727912*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"76f0209d-ac6f-4460-8a79-387edf02cad3"],

Cell[CellGroupData[{

Cell[BoxData["\<\"\[Checkmark] Punto \[OAcute]ptimo: No acotado (\[Infinity])\
\"\>"], "Print",
 CellChangeTimes->{3.967029340806429*^9, 3.967047116729907*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"f6cc0ba4-ce93-4341-8625-81c46ffc4e6f"],

Cell[BoxData["\<\"\[Checkmark] Valor \[OAcute]ptimo: \[Infinity]\"\>"], \
"Print",
 CellChangeTimes->{3.967029340806429*^9, 3.9670471167304897`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"66b0c196-df9c-494a-b47b-18b7e4b29ed2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967029340806429*^9, 3.967047116731496*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"85615426-70ee-4fb6-a839-6f47d4db5363"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.967029340806429*^9, 3.967047116732041*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"0463bb80-a391-4523-b640-467f74cca5c4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967029340806429*^9, 3.967047116732564*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"cc063f3f-83b3-4f96-94b7-56f60c3bf018"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967029340806429*^9, 3.967047116733119*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"00ff28ac-899d-49ac-b2bd-6d86a5ff3746"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.967029340806429*^9, 3.967047116733679*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"aeb8aa48-1a3d-43de-b70f-e0c230a0c719"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967029340806429*^9, 3.967047116796608*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"ce07be01-8940-46fb-8a7a-a8eaa4d34487"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.967029340806429*^9, 3.967047117803953*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"c1bb5ca9-bc65-48bc-902a-5182a6482f8d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/LinearPro/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967029340806429*^9, 3.967047117809964*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"b6872821-3df9-49c9-86a4-c2320b0d235c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"linear8\"\>"}],
  SequenceForm["Archivo: ", "linear8"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967029340806429*^9, 3.967047117815322*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"50727bb4-f7ea-4044-9830-a91d967d78ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Error en compilaci\[OAcute]n (Exit Code: \"\>", "\[InvisibleSpace]",
    "1", "\[InvisibleSpace]", "\<\")\"\>"}],
  SequenceForm["Error en compilaci\[OAcute]n (Exit Code: ", 1, ")"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967029340806429*^9, 3.9670471182772827`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"24fc7832-cb48-4f30-9f62-0dd5f01ef4ad"],

Cell[BoxData["\<\"Detalles del error:\"\>"], "Print",
 CellChangeTimes->{3.967029340806429*^9, 3.967047118278206*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"54e3faa2-d7c6-46b7-9f0d-e533c9189772"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Output: \"\>", 
   "\[InvisibleSpace]", "\<\"This is pdfTeX, Version 3.141592653-2.6-1.40.26 \
(TeX Live 2024) (preloaded format=pdflatex)\\n restricted \\\\write18 \
enabled.\\nentering extended \
mode\\n(/Users/enriquevilchezquesada/Downloads/LinearPro/linear8.tex\\\
nLaTeX2e <2023-11-01> patch level 1\\nL3 programming layer \
<2024-02-20>\\n(/usr/local/texlive/2024/texmf-dist/tex/latex/standalone/\
standalone.cls\\nDocument Class: standalone 2022/10/10 v1.3b Class to compile \
TeX sub-files \
stan\\ndalone\\n(/usr/local/texlive/2024/texmf-dist/tex/latex/tools/shellesc.\
sty)\\n(/usr/local/texlive/2024/texmf-dist/tex/generic/iftex/ifluatex.sty\\n(/\
usr/local/texlive/2024/texmf-dist/tex/generic/iftex/iftex.sty))\\n(/usr/local/\
texlive/2024/texmf-dist/tex/latex/xkeyval/xkeyval.sty\\n(/usr/local/texlive/\
2024/texmf-dist/tex/generic/xkeyval/xkeyval.tex\\n(/usr/local/texlive/2024/\
texmf-dist/tex/generic/xkeyval/xkvutils.tex\\n(/usr/local/texlive/2024/texmf-\
dist/tex/generic/xkeyval/keyval.tex))))\\n(/usr/local/texlive/2024/texmf-dist/\
tex/latex/standalone/standalone.cfg)\\n(/usr/local/texlive\"\>"}],
  SequenceForm[
  "Output: ", 
   "This is pdfTeX, Version 3.141592653-2.6-1.40.26 (TeX Live 2024) \
(preloaded format=pdflatex)\n restricted \\write18 enabled.\nentering \
extended mode\n(/Users/enriquevilchezquesada/Downloads/LinearPro/linear8.tex\n\
LaTeX2e <2023-11-01> patch level 1\nL3 programming layer <2024-02-20>\n\
(/usr/local/texlive/2024/texmf-dist/tex/latex/standalone/standalone.cls\n\
Document Class: standalone 2022/10/10 v1.3b Class to compile TeX sub-files \
stan\ndalone\n\
(/usr/local/texlive/2024/texmf-dist/tex/latex/tools/shellesc.sty)\n\
(/usr/local/texlive/2024/texmf-dist/tex/generic/iftex/ifluatex.sty\n\
(/usr/local/texlive/2024/texmf-dist/tex/generic/iftex/iftex.sty))\n\
(/usr/local/texlive/2024/texmf-dist/tex/latex/xkeyval/xkeyval.sty\n\
(/usr/local/texlive/2024/texmf-dist/tex/generic/xkeyval/xkeyval.tex\n\
(/usr/local/texlive/2024/texmf-dist/tex/generic/xkeyval/xkvutils.tex\n\
(/usr/local/texlive/2024/texmf-dist/tex/generic/xkeyval/keyval.tex))))\n\
(/usr/local/texlive/2024/texmf-dist/tex/latex/standalone/standalone.cfg)\n\
(/usr/local/texlive"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967029340806429*^9, 3.967047118278679*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"53673755-1734-4e7c-b225-d3cd179df370"],

Cell[BoxData["\<\"Revisa el archivo LaTeX en el editor para corregir \
errores\"\>"], "Print",
 CellChangeTimes->{3.967029340806429*^9, 3.967047118279428*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"b5208ac0-14fd-4d3b-ab03-1c6d0263d5dd"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/linear8.\
tex\"\>"], "Output",
 CellChangeTimes->{3.967029340791676*^9, 3.9670471182798862`*^9},
 CellLabel->
  "Out[127]=",ExpressionUUID->"7e8dd8f5-64da-4825-96a1-fa37ecb8b092"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Ejemplo 9: regi\[OAcute]n factible vac\[IAcute]a (no compila el .tex, soluci\
\[OAcute]n vac\[IAcute]a)\
\>", "Subsection",
 CellChangeTimes->{{3.9670238979330597`*^9, 3.967023899794098*^9}, 
   3.967023949353593*^9, {3.967024108414625*^9, 3.9670241134413033`*^9}, 
   3.9670242384422083`*^9, {3.967047183889182*^9, 3.967047222021937*^9}, 
   3.967047350789898*^9},ExpressionUUID->"aadeb044-de12-44bc-b1b5-\
1530e3efdf0d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "+", "y"}], "\[LessEqual]", "2"}], "&&", 
    RowBox[{
     RowBox[{"x", "+", "y"}], "\[GreaterEqual]", "8"}], "&&", 
    RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"y", "\[GreaterEqual]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "0.5"}], ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "0.5"}], ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "False"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"NMaximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", " ", "+", " ", "y"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "+", "y"}], "\[LessEqual]", "2"}], "&&", 
      RowBox[{
       RowBox[{"x", "+", "y"}], "\[GreaterEqual]", "8"}], "&&", 
      RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"y", "\[GreaterEqual]", "0"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LinearPro", "[", 
   RowBox[{"\"\<linear9.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<x + y <= 2\>\"", ",", "\"\<x + y >= 8\>\"", 
      ",", "\"\<x >= 0\>\"", ",", "\"\<y >= 0\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<max\>\"", ",", "\"\<x + y\>\""}], "}"}], 
    ",", "\"\<purple\>\"", ",", "1.0", ",", "True", ",", "True", 
    ",", "\"\<normal\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "10"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967024340597849*^9, 3.967024341065988*^9}, {
  3.967024438134035*^9, 3.967024439846547*^9}, {3.96702830360975*^9, 
  3.967028304107411*^9}, {3.967028546876664*^9, 3.967028554880177*^9}, {
  3.96702937454489*^9, 3.967029389261629*^9}, {3.9670471390560493`*^9, 
  3.9670471428978453`*^9}},
 CellLabel->
  "In[128]:=",ExpressionUUID->"731f3bd1-7434-4014-8fd1-2c57575ca64b"],

Cell[BoxData[
 GraphicsBox[{{}, {}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None, "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{{-0.5, 10}, {-0.5, 10}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.967029390308922*^9, 3.96704714365279*^9},
 CellLabel->
  "Out[128]=",ExpressionUUID->"754aa68e-3dba-4396-acd2-5a25b0226ef2"],

Cell[BoxData[
 TemplateBox[{
  "NMaximize", "nsol", 
   "\"There are no points that satisfy the constraints \\!\\(\\*RowBox[{\\\"{\
\\\", RowBox[{RowBox[{RowBox[{\\\"x\\\", \\\"+\\\", \\\"y\\\"}], \\\"\
\[LessEqual]\\\", \\\"2\\\"}], \\\",\\\", RowBox[{RowBox[{\\\"x\\\", \
\\\"+\\\", \\\"y\\\"}], \\\"\[GreaterEqual]\\\", \\\"8\\\"}], \\\",\\\", \
RowBox[{\\\"x\\\", \\\"\[GreaterEqual]\\\", \\\"0\\\"}], \\\",\\\", \
RowBox[{\\\"y\\\", \\\"\[GreaterEqual]\\\", \\\"0\\\"}]}], \\\"}\\\"}]\\).\"",
    2, 129, 17, 34481913892064439222, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{3.967029390332477*^9, 3.967047143677093*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[128]:=",ExpressionUUID->"f8ba5d0f-6786-4c87-a121-e2e02884967c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "\[Infinity]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "Indeterminate"}], ",", 
     RowBox[{"y", "\[Rule]", "Indeterminate"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.967029390308922*^9, 3.967047143682973*^9},
 CellLabel->
  "Out[129]=",ExpressionUUID->"f0db83f6-0ca7-40d9-80e7-80231f9f856b"],

Cell[BoxData[
 TemplateBox[{
  "NMaximize", "nsol", 
   "\"There are no points that satisfy the constraints \\!\\(\\*RowBox[{\\\"{\
\\\", RowBox[{RowBox[{RowBox[{\\\"x\\\", \\\"+\\\", \\\"y\\\"}], \\\"\
\[LessEqual]\\\", \\\"2\\\"}], \\\",\\\", RowBox[{RowBox[{\\\"x\\\", \
\\\"+\\\", \\\"y\\\"}], \\\"\[GreaterEqual]\\\", \\\"8\\\"}], \\\",\\\", \
RowBox[{\\\"x\\\", \\\"\[GreaterEqual]\\\", \\\"0\\\"}], \\\",\\\", \
RowBox[{\\\"y\\\", \\\"\[GreaterEqual]\\\", \\\"0\\\"}]}], \\\"}\\\"}]\\).\"",
    2, 130, 18, 34481913892064439222, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{3.967029390332477*^9, 3.967047143683683*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[128]:=",ExpressionUUID->"13068467-af82-4cac-b903-4a705c92b0e0"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Advertencia: No se encontraron v\[EAcute]rtices \
v\[AAcute]lidos\"\>"], "Print",
 CellChangeTimes->{3.967029390338146*^9, 3.967047143690099*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[128]:=",ExpressionUUID->"348f8769-286b-4ba9-8322-e9914f3ca9ba"],

Cell[BoxData["\<\"\[Checkmark] Punto \[OAcute]ptimo: {Indeterminate, \
Indeterminate}\"\>"], "Print",
 CellChangeTimes->{3.967029390338146*^9, 3.967047143690621*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[128]:=",ExpressionUUID->"cf34858b-78ae-4604-8790-84d22321a471"],

Cell[BoxData["\<\"\[Checkmark] Valor \[OAcute]ptimo: -Infinity\"\>"], "Print",
 CellChangeTimes->{3.967029390338146*^9, 3.967047143691594*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[128]:=",ExpressionUUID->"cfe496dc-b26a-461c-97c8-66141b728f47"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967029390338146*^9, 3.967047143692133*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[128]:=",ExpressionUUID->"acecccaa-7d9b-4179-88c6-d0db7ffb355a"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.967029390338146*^9, 3.967047143692596*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[128]:=",ExpressionUUID->"ef8ef046-be22-4e01-87e0-91ec795dca26"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967029390338146*^9, 3.96704714369306*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[128]:=",ExpressionUUID->"d1803c68-d4dd-4d2f-8f19-a382d8c1cea4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967029390338146*^9, 3.9670471436935253`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[128]:=",ExpressionUUID->"01d41803-e384-42ad-8fe9-38dec1967d53"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.967029390338146*^9, 3.967047143693993*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[128]:=",ExpressionUUID->"b3186657-3338-4154-af88-2227c7320bdd"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967029390338146*^9, 3.967047143756528*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[128]:=",ExpressionUUID->"d8995acd-3aba-42e9-903f-b6b030eec694"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.967029390338146*^9, 3.9670471447518053`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[128]:=",ExpressionUUID->"2cce3a49-d93c-4ec6-9599-df16ffbccd31"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/LinearPro/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967029390338146*^9, 3.967047144757078*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[128]:=",ExpressionUUID->"1a0e6da5-d080-41f2-8512-3314effdffcb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"linear9\"\>"}],
  SequenceForm["Archivo: ", "linear9"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967029390338146*^9, 3.967047144760455*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[128]:=",ExpressionUUID->"442ced28-53a9-4748-8e20-6c6a95189e66"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Error en compilaci\[OAcute]n (Exit Code: \"\>", "\[InvisibleSpace]",
    "1", "\[InvisibleSpace]", "\<\")\"\>"}],
  SequenceForm["Error en compilaci\[OAcute]n (Exit Code: ", 1, ")"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967029390338146*^9, 3.96704714521872*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[128]:=",ExpressionUUID->"02f031b0-3048-4a65-8453-48d4294bce39"],

Cell[BoxData["\<\"Detalles del error:\"\>"], "Print",
 CellChangeTimes->{3.967029390338146*^9, 3.967047145219655*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[128]:=",ExpressionUUID->"f99babd6-fa19-4bfa-9fdb-d1a218bdcdc7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Output: \"\>", 
   "\[InvisibleSpace]", "\<\"This is pdfTeX, Version 3.141592653-2.6-1.40.26 \
(TeX Live 2024) (preloaded format=pdflatex)\\n restricted \\\\write18 \
enabled.\\nentering extended \
mode\\n(/Users/enriquevilchezquesada/Downloads/LinearPro/linear9.tex\\\
nLaTeX2e <2023-11-01> patch level 1\\nL3 programming layer \
<2024-02-20>\\n(/usr/local/texlive/2024/texmf-dist/tex/latex/standalone/\
standalone.cls\\nDocument Class: standalone 2022/10/10 v1.3b Class to compile \
TeX sub-files \
stan\\ndalone\\n(/usr/local/texlive/2024/texmf-dist/tex/latex/tools/shellesc.\
sty)\\n(/usr/local/texlive/2024/texmf-dist/tex/generic/iftex/ifluatex.sty\\n(/\
usr/local/texlive/2024/texmf-dist/tex/generic/iftex/iftex.sty))\\n(/usr/local/\
texlive/2024/texmf-dist/tex/latex/xkeyval/xkeyval.sty\\n(/usr/local/texlive/\
2024/texmf-dist/tex/generic/xkeyval/xkeyval.tex\\n(/usr/local/texlive/2024/\
texmf-dist/tex/generic/xkeyval/xkvutils.tex\\n(/usr/local/texlive/2024/texmf-\
dist/tex/generic/xkeyval/keyval.tex))))\\n(/usr/local/texlive/2024/texmf-dist/\
tex/latex/standalone/standalone.cfg)\\n(/usr/local/texlive\"\>"}],
  SequenceForm[
  "Output: ", 
   "This is pdfTeX, Version 3.141592653-2.6-1.40.26 (TeX Live 2024) \
(preloaded format=pdflatex)\n restricted \\write18 enabled.\nentering \
extended mode\n(/Users/enriquevilchezquesada/Downloads/LinearPro/linear9.tex\n\
LaTeX2e <2023-11-01> patch level 1\nL3 programming layer <2024-02-20>\n\
(/usr/local/texlive/2024/texmf-dist/tex/latex/standalone/standalone.cls\n\
Document Class: standalone 2022/10/10 v1.3b Class to compile TeX sub-files \
stan\ndalone\n\
(/usr/local/texlive/2024/texmf-dist/tex/latex/tools/shellesc.sty)\n\
(/usr/local/texlive/2024/texmf-dist/tex/generic/iftex/ifluatex.sty\n\
(/usr/local/texlive/2024/texmf-dist/tex/generic/iftex/iftex.sty))\n\
(/usr/local/texlive/2024/texmf-dist/tex/latex/xkeyval/xkeyval.sty\n\
(/usr/local/texlive/2024/texmf-dist/tex/generic/xkeyval/xkeyval.tex\n\
(/usr/local/texlive/2024/texmf-dist/tex/generic/xkeyval/xkvutils.tex\n\
(/usr/local/texlive/2024/texmf-dist/tex/generic/xkeyval/keyval.tex))))\n\
(/usr/local/texlive/2024/texmf-dist/tex/latex/standalone/standalone.cfg)\n\
(/usr/local/texlive"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967029390338146*^9, 3.967047145220138*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[128]:=",ExpressionUUID->"b815912d-3531-47c1-951c-e10ba1cfad28"],

Cell[BoxData["\<\"Revisa el archivo LaTeX en el editor para corregir \
errores\"\>"], "Print",
 CellChangeTimes->{3.967029390338146*^9, 3.967047145220875*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[128]:=",ExpressionUUID->"325dcaa2-7220-4dfc-9cce-6dd475829363"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/linear9.\
tex\"\>"], "Output",
 CellChangeTimes->{3.967029390308922*^9, 3.967047145221324*^9},
 CellLabel->
  "Out[131]=",ExpressionUUID->"2394bf4e-3b64-4c46-8f1c-39af76603f40"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Ejemplo 10: regi\[OAcute]n factible vac\[IAcute]a (no compila el .tex, soluci\
\[OAcute]n vac\[IAcute]a)\
\>", "Subsection",
 CellChangeTimes->{{3.9670238979330597`*^9, 3.967023899794098*^9}, {
  3.967023951756078*^9, 3.967023953061056*^9}, {3.967024122948389*^9, 
  3.967024130465397*^9}, {3.9670242421188307`*^9, 3.967024242295952*^9}, {
  3.967047276102126*^9, 3.967047295326928*^9}, {3.967047326842702*^9, 
  3.967047334898869*^9}},ExpressionUUID->"428a3a6a-7f1d-4ce1-8008-\
1e47756be506"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", "y"}], "\[LessEqual]", "4"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", "y"}], "\[GreaterEqual]", "10"}], "&&", 
    RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"y", "\[GreaterEqual]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "0.5"}], ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "0.5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "False"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", " ", "+", " ", "y"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"2", " ", "x"}], "+", "y"}], "\[LessEqual]", "4"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"2", " ", "x"}], "+", "y"}], "\[GreaterEqual]", "10"}], "&&", 
      
      RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"y", "\[GreaterEqual]", "0"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LinearPro", "[", 
   RowBox[{"\"\<linear10.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<2x + y <= 4\>\"", ",", "\"\<2x + y >= 10\>\"", 
      ",", "\"\<x >= 0\>\"", ",", "\"\<y >= 0\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<min\>\"", ",", "\"\<x + y\>\""}], "}"}], 
    ",", "\"\<orange\>\"", ",", "1.0", ",", "True", ",", "True", 
    ",", "\"\<normal\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "12"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967024344575061*^9, 3.9670243451005497`*^9}, {
  3.967024445277281*^9, 3.967024446429215*^9}, {3.9670283068795023`*^9, 
  3.967028307377705*^9}, {3.967028564632742*^9, 3.967028601546652*^9}, {
  3.96702940511722*^9, 3.9670294266719427`*^9}},
 CellLabel->
  "In[132]:=",ExpressionUUID->"d15cad3c-258b-4b7b-bc03-bdaf678ec5ec"],

Cell[BoxData[
 GraphicsBox[{{}, {}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None, "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{{-0.5, 7}, {-0.5, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.967029427499242*^9, 3.967047245154307*^9},
 CellLabel->
  "Out[132]=",ExpressionUUID->"cd9ceb8d-c1c4-415d-b8da-6a95b6c71669"],

Cell[BoxData[
 TemplateBox[{
  "NMinimize", "nsol", 
   "\"There are no points that satisfy the constraints \\!\\(\\*RowBox[{\\\"{\
\\\", RowBox[{RowBox[{RowBox[{RowBox[{\\\"2\\\", \\\" \\\", \\\"x\\\"}], \
\\\"+\\\", \\\"y\\\"}], \\\"\[LessEqual]\\\", \\\"4\\\"}], \\\",\\\", \
RowBox[{RowBox[{RowBox[{\\\"2\\\", \\\" \\\", \\\"x\\\"}], \\\"+\\\", \\\"y\\\
\"}], \\\"\[GreaterEqual]\\\", \\\"10\\\"}], \\\",\\\", RowBox[{\\\"x\\\", \\\
\"\[GreaterEqual]\\\", \\\"0\\\"}], \\\",\\\", RowBox[{\\\"y\\\", \\\"\
\[GreaterEqual]\\\", \\\"0\\\"}]}], \\\"}\\\"}]\\).\"", 2, 133, 19, 
   34481913892064439222, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{3.967029427503213*^9, 3.967047245157192*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[132]:=",ExpressionUUID->"f053c407-1603-431d-bb59-d438358bdfd4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Infinity]", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "Indeterminate"}], ",", 
     RowBox[{"y", "\[Rule]", "Indeterminate"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.967029427499242*^9, 3.9670472451598988`*^9},
 CellLabel->
  "Out[133]=",ExpressionUUID->"9e8a2f12-6c05-4f1e-a490-fc2419717a4c"],

Cell[BoxData[
 TemplateBox[{
  "NMinimize", "nsol", 
   "\"There are no points that satisfy the constraints \\!\\(\\*RowBox[{\\\"{\
\\\", RowBox[{RowBox[{RowBox[{RowBox[{\\\"2\\\", \\\" \\\", \\\"x\\\"}], \
\\\"+\\\", \\\"y\\\"}], \\\"\[LessEqual]\\\", \\\"4\\\"}], \\\",\\\", \
RowBox[{RowBox[{RowBox[{\\\"2\\\", \\\" \\\", \\\"x\\\"}], \\\"+\\\", \\\"y\\\
\"}], \\\"\[GreaterEqual]\\\", \\\"10\\\"}], \\\",\\\", RowBox[{\\\"x\\\", \\\
\"\[GreaterEqual]\\\", \\\"0\\\"}], \\\",\\\", RowBox[{\\\"y\\\", \\\"\
\[GreaterEqual]\\\", \\\"0\\\"}]}], \\\"}\\\"}]\\).\"", 2, 134, 20, 
   34481913892064439222, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{3.967029427503213*^9, 3.967047245160591*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[132]:=",ExpressionUUID->"7b2dc010-d38e-4cc9-a605-9e0d44b13432"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Advertencia: No se encontraron v\[EAcute]rtices \
v\[AAcute]lidos\"\>"], "Print",
 CellChangeTimes->{3.9670294275158873`*^9, 3.967047245162899*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[132]:=",ExpressionUUID->"30374e00-5589-4b15-a6b5-48bbe6c129cc"],

Cell[BoxData["\<\"\[Checkmark] Punto \[OAcute]ptimo: No acotado (\[Infinity])\
\"\>"], "Print",
 CellChangeTimes->{3.9670294275158873`*^9, 3.967047245163493*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[132]:=",ExpressionUUID->"21e8da7d-f5f8-4961-a102-9ea15867a5c2"],

Cell[BoxData["\<\"\[Checkmark] Valor \[OAcute]ptimo: \[Infinity]\"\>"], \
"Print",
 CellChangeTimes->{3.9670294275158873`*^9, 3.967047245164459*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[132]:=",ExpressionUUID->"295aa3ca-6d01-4326-adc2-c6c1e028e663"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670294275158873`*^9, 3.9670472451649723`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[132]:=",ExpressionUUID->"bdeef3ca-85c6-431a-8baa-dc2f0cde4be2"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.9670294275158873`*^9, 3.967047245165482*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[132]:=",ExpressionUUID->"52ccd7ef-b3cf-429f-ad36-e896464794aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670294275158873`*^9, 3.967047245166024*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[132]:=",ExpressionUUID->"e100f35d-4474-485d-9e4c-95cb450b01d1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670294275158873`*^9, 3.967047245166573*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[132]:=",ExpressionUUID->"65ce0e53-7ef9-4c4b-b1fd-3e62adb168e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670294275158873`*^9, 3.967047245167145*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[132]:=",ExpressionUUID->"6be56125-5499-4689-9e48-0f484b87df9b"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.9670294275158873`*^9, 3.967047245221786*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[132]:=",ExpressionUUID->"cef712a2-e670-44f6-a614-568c5dc3cc72"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.9670294275158873`*^9, 3.9670472462267942`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[132]:=",ExpressionUUID->"8b56d1a2-f25d-4e12-95c5-58375bf332cf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/LinearPro/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670294275158873`*^9, 3.967047246232233*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[132]:=",ExpressionUUID->"2de54359-1cda-47d4-9536-0162516bac61"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"linear10\"\>"}],
  SequenceForm["Archivo: ", "linear10"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670294275158873`*^9, 3.967047246235902*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[132]:=",ExpressionUUID->"eeeceb9d-01a6-4659-b0db-bd615b192dfe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Error en compilaci\[OAcute]n (Exit Code: \"\>", "\[InvisibleSpace]",
    "1", "\[InvisibleSpace]", "\<\")\"\>"}],
  SequenceForm["Error en compilaci\[OAcute]n (Exit Code: ", 1, ")"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670294275158873`*^9, 3.967047246677437*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[132]:=",ExpressionUUID->"c49ceeeb-e03a-4f89-9ac1-dcbb70915651"],

Cell[BoxData["\<\"Detalles del error:\"\>"], "Print",
 CellChangeTimes->{3.9670294275158873`*^9, 3.967047246678396*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[132]:=",ExpressionUUID->"0d11939f-8739-43df-b604-1411f1e9884d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Output: \"\>", 
   "\[InvisibleSpace]", "\<\"This is pdfTeX, Version 3.141592653-2.6-1.40.26 \
(TeX Live 2024) (preloaded format=pdflatex)\\n restricted \\\\write18 \
enabled.\\nentering extended \
mode\\n(/Users/enriquevilchezquesada/Downloads/LinearPro/linear10.tex\\\
nLaTeX2e <2023-11-01> patch level 1\\nL3 programming layer \
<2024-02-20>\\n(/usr/local/texlive/2024/texmf-dist/tex/latex/standalone/\
standalone.cls\\nDocument Class: standalone 2022/10/10 v1.3b Class to compile \
TeX sub-files \
stan\\ndalone\\n(/usr/local/texlive/2024/texmf-dist/tex/latex/tools/shellesc.\
sty)\\n(/usr/local/texlive/2024/texmf-dist/tex/generic/iftex/ifluatex.sty\\n(/\
usr/local/texlive/2024/texmf-dist/tex/generic/iftex/iftex.sty))\\n(/usr/local/\
texlive/2024/texmf-dist/tex/latex/xkeyval/xkeyval.sty\\n(/usr/local/texlive/\
2024/texmf-dist/tex/generic/xkeyval/xkeyval.tex\\n(/usr/local/texlive/2024/\
texmf-dist/tex/generic/xkeyval/xkvutils.tex\\n(/usr/local/texlive/2024/texmf-\
dist/tex/generic/xkeyval/keyval.tex))))\\n(/usr/local/texlive/2024/texmf-dist/\
tex/latex/standalone/standalone.cfg)\\n(/usr/local/texliv\"\>"}],
  SequenceForm[
  "Output: ", 
   "This is pdfTeX, Version 3.141592653-2.6-1.40.26 (TeX Live 2024) \
(preloaded format=pdflatex)\n restricted \\write18 enabled.\nentering \
extended mode\n(/Users/enriquevilchezquesada/Downloads/LinearPro/linear10.tex\
\nLaTeX2e <2023-11-01> patch level 1\nL3 programming layer <2024-02-20>\n\
(/usr/local/texlive/2024/texmf-dist/tex/latex/standalone/standalone.cls\n\
Document Class: standalone 2022/10/10 v1.3b Class to compile TeX sub-files \
stan\ndalone\n\
(/usr/local/texlive/2024/texmf-dist/tex/latex/tools/shellesc.sty)\n\
(/usr/local/texlive/2024/texmf-dist/tex/generic/iftex/ifluatex.sty\n\
(/usr/local/texlive/2024/texmf-dist/tex/generic/iftex/iftex.sty))\n\
(/usr/local/texlive/2024/texmf-dist/tex/latex/xkeyval/xkeyval.sty\n\
(/usr/local/texlive/2024/texmf-dist/tex/generic/xkeyval/xkeyval.tex\n\
(/usr/local/texlive/2024/texmf-dist/tex/generic/xkeyval/xkvutils.tex\n\
(/usr/local/texlive/2024/texmf-dist/tex/generic/xkeyval/keyval.tex))))\n\
(/usr/local/texlive/2024/texmf-dist/tex/latex/standalone/standalone.cfg)\n\
(/usr/local/texliv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9670294275158873`*^9, 3.967047246678873*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[132]:=",ExpressionUUID->"df50c5fe-3728-49b9-ab6e-2ae886ada341"],

Cell[BoxData["\<\"Revisa el archivo LaTeX en el editor para corregir \
errores\"\>"], "Print",
 CellChangeTimes->{3.9670294275158873`*^9, 3.967047246679587*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[132]:=",ExpressionUUID->"4cc3e2a4-1662-4144-809f-09e46e076dd7"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/linear10.\
tex\"\>"], "Output",
 CellChangeTimes->{3.967029427499242*^9, 3.967047246680031*^9},
 CellLabel->
  "Out[135]=",ExpressionUUID->"7aadab09-e0f8-48dc-b89a-e8a4ac353c68"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 11", "Subsection",
 CellChangeTimes->{{3.9670238979330597`*^9, 3.967023899794098*^9}, 
   3.9670239554762163`*^9, 
   3.967024245792472*^9},ExpressionUUID->"d47fe75f-8203-4032-b1f0-\
329e2822eedc"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "+", "y"}], "\[LessEqual]", "10"}], "&&", 
    RowBox[{
     RowBox[{"x", "+", "y"}], "\[LessEqual]", "15"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", "y"}], "\[LessEqual]", "12"}], "&&", 
    RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"y", "\[GreaterEqual]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "0.5"}], ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "0.5"}], ",", "11"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "False"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"NMaximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"3", "x"}], " ", "+", " ", 
      RowBox[{"2", "y"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "+", "y"}], "\[LessEqual]", "10"}], "&&", 
      RowBox[{
       RowBox[{"x", "+", "y"}], "\[LessEqual]", "15"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"2", " ", "x"}], "+", "y"}], "\[LessEqual]", "12"}], "&&", 
      RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"y", "\[GreaterEqual]", "0"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LinearPro", "[", 
   RowBox[{"\"\<linear11.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<x + y <= 10\>\"", ",", "\"\<x + y <= 15\>\"", 
      ",", "\"\<2x + y <= 12\>\"", ",", "\"\<x >= 0\>\"", 
      ",", "\"\<y >= 0\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<max\>\"", ",", "\"\<3x + 2y\>\""}], "}"}], 
    ",", "\"\<brown\>\"", ",", "0.7", ",", "True", ",", "True", 
    ",", "\"\<huge\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "11"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9670243519382668`*^9, 3.967024353699242*^9}, {
  3.967024450783359*^9, 3.967024451876989*^9}, {3.9670283100303917`*^9, 
  3.967028312388865*^9}, {3.967028614582136*^9, 3.967028651195464*^9}, {
  3.967029440022389*^9, 3.967029462449801*^9}, {3.967047368186013*^9, 
  3.967047418874152*^9}},
 CellLabel->
  "In[140]:=",ExpressionUUID->"7d660972-b342-4de0-a987-7dd7a511f8da"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxlmnlUU9cWxsMsQxhCCBDmIDROiGhAkXpPjaWUqo04oFRTqmCVoG2V+sRZ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    "], {{
      {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], Opacity[0.3], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXW81lUSxs/8AAnp7rxwAem4dKekgHRjICIiiiKggogiKgb22t2KsYqN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          "]], PolygonBox[CompressedData["
1:eJwtlXmwl2McxZ/v061u0s3lmotoioZh7MMwjDVLK7okSVJJEqUoSyp0W8So
pE2irI3IUkpESUoZZSlLIhpjjDEmRg2h+pw5zx/nfs95n/f3u+/vec45b+s+
g+sG5ZRSPagApyPGRUrPwFeDi9GPo1+GrwdL4WO51pL5HPpM+AT4s/APwU54
Z641YL6O7gifBX8VvgG8Cx/HtVbMBeh28OnwV+Afg3PRk9Hz4ev0nfAJXGvD
XIReyRyPPpK5EH02/GH48/C1YDh6BPoJeFPmzeAK8B+6IbM3aAveQn8KHoWf
z2cycwv6Qebx6PfhT4GR8Nnlt9QwL0CfB15K/swOcANojv4XTIVflP3s2rM+
0uBt+GfgNtZ6oavgu8FAeC3XlsKngE7w20FFeA9r4Adn39sMHAg/CPwN3x8s
5p56dAvmPPT/zFvA5OTvPIS1W8PfvQz8CP9egP8A9mO9KdgBrwQHwKvBLu0f
qII3B3/pXjCIzw4F0+BfgfHwM7K9Ig9UwpuA3+GNwYXwx8pZf6Q9kzfAL8Vv
CR7gZ2gD7Q/3rg2fzTawB74X/ORbUwV/GoJfdZ7aA3gz8Ce8Cbgk7AGdfVv0
fcz7wRz41/IzfBjrlXpu9AnwMeGz/gC0Qd+FniGv6gzhY7h2KHMmujV8GHw6
fDk4GX0imKvfwvXj4KOYs5M91ELniZ4Kfwccg74XPQu+AvRHXxfea+3xAHkV
LEk+wzvgh3PPHvhe8A96N9juf5cGsnZ92BvyxAB0z7A3dIZd0HPQbyRnoB+8
I1gD3wROZf2P4p1g3gQ6hc9qMxgS9rC8qzNX9pfIA8kdMAo9j/kmupY5JDtz
yloj8ELYM/KKMlfH+tDstY3JXbBcnZLcCU8qr9ldoWdeh14P3kvO9ET4Wdld
o8yrG1ZzbVJyR6gbVjAnJndEf3AZ+AT9JejF+jVhb/4G6uE3gi+Sz3Ar/Dsh
OaP3cP9DpeuqmJvAZvBi8h5skVdL/reCVeoe8G3y/1wW7hh1i/b8NfgD4Bv4
SrAw7FF5U79xW+kUdYmeQVlVJpQFZbYrz3NlOAvyQDfIVeHsKCM90d2098kZ
6YG+OpwVZa47ums4e8rcCPSM0qXVpUsWqUOSO2WjnjX82/Qb9Vu3h7tDuiX3
H5GdJXl0EmvnZHexOnww+rDs7lEGOoT3tKr8j/lhj8vb6sg18Lqwt5WBvpB2
4b36XOcBPzo7m8rQWPRp2dnVO6s9+pRsL69KzvrdJbuV5azblzWd+Uj4sdlZ
VGaHo4/KzrY6YBr60ux3n95Rd6JbZWdZHdClZKC2eLBzeE+ri6dnMjtkv9v0
DpwbzoC8r8yo6+VRebOidM2C0l3qnEfCmVVW5Tl556Ts8MtDU0pmlVW9ky4P
v7NqSgb6wXuEu1sd2Rd9bbgr1fm90d3D3a/O3qCshN+1i8Ho8Blo79Wh8vbT
4TV5vBGfb5ydJXluH4v5CuU=
          "]]}]}, {}, {}, {}, {}}, 
     {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], LineBox[CompressedData["
1:eJwl1Hl813MAx/HfJqXQoQORWoUo5SoRUokkydp9ZqmdbczutZa22oakkKOE
nKUU0YGiXDlKuelw5z5D5Or5eeyP156f93ftt+37/a2YrKLYwqhIJDLKhxnR
kcj9fFmxirP/4n59rnh7PBP4H//XF0q045jEiKL0pZ3MeKYwWgdpj53KBKax
hQ7WV3Y6E5nBlmqlr+1MJnECD1FrfWNfyWRmsY0O1bf2RKbwKh6mw/WdPYmp
nMy2aqfv7WymMYft1UE/2LlMZx6PUEf9aOczgwXspM76yZ7CTBZyJ3dphz7W
z+Hn1yd6Ux/qAX2kbfpMn2p3eB29En4/jdC1Xu+h8LoqVq19Tfi9daFK7EfC
v9Oxzsepm4q03bWRKnWu4GYtU539KN/SRSqzq/mqXtPFKnftMU7V9JBdG+5v
VPP7pcJeyes0wPlU9Vd9uPe6RKfZp+sX51/1pOrtVXxbo1VpN/F1rdFMezXf
0buaHb6HazeGZ6hLVWWv4026wHmYhmpueL4ao+H2PO7Vb1qvWa49y/d0mart
2/mGnleD/Rzf1+WqsRdwLH8PX8MxulrZ4Xq4P86beJfu0SJt1Ra9pEaff5Ef
6ApNs+/jeP7JexXrXByeq3LscWpy3sc/wtc53x1+Ji4Mn+cL4V7wznCveUe4
n9wYng/nh2fL28Lz5IbwXuCt4X3FW8L7h8/wfN7MczmH5/FpDuENPJvX8xyu
5WA2chAbeBaf4kDO4hmcyTP5BE9hHftyBvvxcZ7MaezDGp7EFTyRVTyelTyB
y9mb5ezJMvbiUsawlN1Zwh5cwmPCs+LR4e+BXfkwj2IBuzCfR/JB/qs8/a1c
/aPFUc3/Nx4AEHigHA==
       "]]}}], {}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None, "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{{-0.5, 7}, {-0.5, 11}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.967029463969569*^9, 3.9670473728499126`*^9, 
  3.9670474198617077`*^9},
 CellLabel->
  "Out[140]=",ExpressionUUID->"640cb717-7081-4273-a779-3dd9e1d9d7db"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"22.`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2.`"}], ",", 
     RowBox[{"y", "\[Rule]", "8.`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.967029463969569*^9, 3.9670473728499126`*^9, 
  3.967047419864922*^9},
 CellLabel->
  "Out[141]=",ExpressionUUID->"b5dc2860-725d-413a-8491-402bfaec6163"],

Cell[CellGroupData[{

Cell[BoxData["\<\"\[Checkmark] Punto \[OAcute]ptimo: {2., 8.}\"\>"], "Print",
 CellChangeTimes->{3.967029463977893*^9, 3.967047372878703*^9, 
  3.967047419868701*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[140]:=",ExpressionUUID->"8015b4b8-094f-492d-9750-c45c8055abb8"],

Cell[BoxData["\<\"\[Checkmark] Valor \[OAcute]ptimo: 22.\"\>"], "Print",
 CellChangeTimes->{3.967029463977893*^9, 3.967047372878703*^9, 
  3.967047419869892*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[140]:=",ExpressionUUID->"eab4ac70-13da-41ec-9f32-06fe1b31db94"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967029463977893*^9, 3.967047372878703*^9, 
  3.967047419870932*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[140]:=",ExpressionUUID->"06252abe-ffd2-4252-a336-f5f6141b14fd"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.967029463977893*^9, 3.967047372878703*^9, 
  3.967047419871491*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[140]:=",ExpressionUUID->"564bfd93-4c39-4688-a6a8-ee2397002299"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967029463977893*^9, 3.967047372878703*^9, 
  3.9670474198720427`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[140]:=",ExpressionUUID->"195cad5e-03a4-4c4d-8ce9-34d53e959942"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967029463977893*^9, 3.967047372878703*^9, 
  3.967047419872611*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[140]:=",ExpressionUUID->"8c857db6-7374-40ff-8b2d-16388f6f3b39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.967029463977893*^9, 3.967047372878703*^9, 
  3.967047419873178*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[140]:=",ExpressionUUID->"66f19cc2-ee8e-43dd-83b8-1e5aeff30fac"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967029463977893*^9, 3.967047372878703*^9, 
  3.9670474199501677`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[140]:=",ExpressionUUID->"e5a488f1-057e-4c1a-887f-0199e09c3b55"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.967029463977893*^9, 3.967047372878703*^9, 
  3.9670474209565563`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[140]:=",ExpressionUUID->"a2b1c36a-702f-4375-ac6a-2614f63beada"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/LinearPro/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967029463977893*^9, 3.967047372878703*^9, 
  3.967047420963707*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[140]:=",ExpressionUUID->"7b4a822f-df77-4913-96b1-7a4e5b68110f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"linear11\"\>"}],
  SequenceForm["Archivo: ", "linear11"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967029463977893*^9, 3.967047372878703*^9, 
  3.9670474209663687`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[140]:=",ExpressionUUID->"4b17b9ad-8630-4694-afa9-e3a2d067ec0c"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.967029463977893*^9, 3.967047372878703*^9, 
  3.9670474214227343`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[140]:=",ExpressionUUID->"a7f29037-dca6-4d1d-b9d6-cd428d71e411"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/linear11.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/LinearPro/linear11.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967029463977893*^9, 3.967047372878703*^9, 
  3.9670474214239273`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[140]:=",ExpressionUUID->"5898b83e-f60e-492c-842a-96461dc0977c"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/linear11.\
pdf\"\>"], "Output",
 CellChangeTimes->{3.967029463969569*^9, 3.9670473728499126`*^9, 
  3.96704742143565*^9},
 CellLabel->
  "Out[143]=",ExpressionUUID->"9ea549d2-05e3-46df-a717-031f75a4b0ed"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Ejemplo 12: soluci\[OAcute]n (4-t, 2+t), 0 \[LessEqual] t \[LessEqual] 1 \
(solo muestra un punto)\
\>", "Subsection",
 CellChangeTimes->{{3.9670238979330597`*^9, 3.967023899794098*^9}, 
   3.9670239554762163`*^9, 3.967024245792472*^9, {3.967047587254078*^9, 
   3.9670475994448442`*^9}, {3.967047686660701*^9, 3.9670476943416862`*^9}, {
   3.967047847138782*^9, 3.967047849686988*^9}, {3.967047888675148*^9, 
   3.967047895482746*^9}},ExpressionUUID->"9598b3e5-f3ed-4304-a94a-\
903eacd6717c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "+", "y"}], "\[LessEqual]", "6"}], "&&", 
    RowBox[{"x", "\[LessEqual]", "4"}], "&&", 
    RowBox[{"y", "\[LessEqual]", "3"}], "&&", 
    RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"y", "\[GreaterEqual]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "0.5"}], ",", "4.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "0.5"}], ",", "3.5"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "False"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"NMaximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", " ", "+", " ", "y"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "+", "y"}], "\[LessEqual]", "6"}], "&&", 
      RowBox[{"x", "\[LessEqual]", "4"}], "&&", 
      RowBox[{"y", "\[LessEqual]", "3"}], "&&", 
      RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"y", "\[GreaterEqual]", "0"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LinearPro", "[", 
   RowBox[{"\"\<linear12.tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<x + y <= 6\>\"", ",", "\"\<x <= 4\>\"", 
      ",", "\"\<y <= 3\>\"", ",", "\"\<x >= 0\>\"", ",", "\"\<y >= 0\>\""}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<max\>\"", ",", "\"\<x + y\>\""}], "}"}], 
    ",", "\"\<green\>\"", ",", "1.0", ",", "True", ",", "True", 
    ",", "\"\<normal\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4.5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3.5"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9670243519382668`*^9, 3.967024353699242*^9}, {
   3.967024450783359*^9, 3.967024451876989*^9}, {3.9670283100303917`*^9, 
   3.967028312388865*^9}, {3.967028614582136*^9, 3.967028651195464*^9}, {
   3.967029440022389*^9, 3.967029462449801*^9}, {3.967047368186013*^9, 
   3.967047418874152*^9}, {3.967047617227983*^9, 3.9670476685731916`*^9}, {
   3.967047713561034*^9, 3.967047791230554*^9}, 3.9670478271451597`*^9},
 CellLabel->
  "In[164]:=",ExpressionUUID->"cc91ba40-5148-4252-90bc-e456cad90dab"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxl2HlY1NUex/FhX2RQ0ccFlysqNqZI1wKT8PLTMS2XKypqSk2pueBUcEnN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    "], {{
      {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], Opacity[0.3], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmQn411MWxr/nWkvInqX+LaRNRbYWFWmjkJQWLULJvu9kS/Zky1YpW5J1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          "]], PolygonBox[CompressedData["
1:eJwtlHmwz2UUxr/vyVKo6CJh5BotozKXDDKWi2iuysgyUk25mkKTZJKaElmy
Zi1E4ZItZI2iSfvGNNM6aKMFo1RSIfvnmef7x/N7nue83+/7Pb/znvcU9hvc
/aHIsmwoKAdKMF1A85Rl9fHN0evRP6PPg1vjN8G/4svDi8HlxE7hvwX3oe8H
bYn3xd+A3oj+RfvDd+PvAa3R3Yh9AW/B3wzvx6+Dm4W/9RN+A9wi/K5y+Are
iu8KH8isv0S/lTlWiu8b/ra+sQY0wQe8l9hrcKtw7sppMFoFeBpdTOxB9KCw
fpjYLcoNFGWuyadgKv4S+F9is+HAN4bX4RuhX0H/iD4L7sX3A7ehGxK/Dr0K
3oPP4Kvwy+EfsGdAEf7VPNcEP4MfC7bhm+LLQF38SfxuMADdP5yrav4SqI7/
H78TzMVXCL+7Az8M/SiYju5AbAG4DH8Cvws8gh4aXlNNGqKXor9HnwaF+Jfx
32U+83r4Rclnr5wK8C8mf/s4eBz/GBil2hB/HpxJ1jOIjWRtRFhfS2wWyMJ6
EXIMenS4tkXEHkAPBKX4K/GjdHbhZ3UGy5QvOIy/GD8TnEh+dgixIapVWF9N
7DlwKlkrxzqsLUyurWpSCz8/uTaq6fX4tXlvqqfmgHLh3HRGK3Se4G90VWKd
0DeG71Iz/BLVD/yFvwj/tXoXXArOBwfBb+LMPT1ZfZ9cS5VmKj9HQD31Nb4X
e/UM6/rEpqkvk3V73QnWbgWFmd95Av2kckruAd29z9FrM9/BZ8GfoDaoRmwK
fFg9l7zHTTzfObym2JvgBVAjz3kbPA/UBL/rvvHs1vyulsAfgInELkyuwXbl
jC+A/8O/D0/AV1Ee+Pfg8fjK8B/4d+Fx+ErwIXxNdI1wbZTzh2BSuLbqgY/1
n8JncQS/GW6Dr5A8wz6Bp+j/wP/gN6K3JM+izvBHYHK4l3SmO1Q3fHX4KP4b
+B1QC1yg98A+UJW1ivDY5D21Vxmxmer18LvHNO/UT+H/rj2XgAbhu6Y79ga+
OLzXPvwy+IrwrNCdXKHeDc8azZA1mh/h2VSQ5/ZZ8reU42rNn/B/1QwrU7+H
a6uaL9ZdCtdeZ7QaNA7PIs2sBboP4drrTFZq3oVrWy3v5bfzs1dPd2CtY7j3
VZM70H3Cs78Vsd7o28O6mFg3zUrQMnnmjkvuoZK8R+9C3xnu7Qb6PrgmfDk0
cw/p28mzrlLei5Pys1FPztBdSp7FpTzTjndfz2urnpiuc03eWzO7B+vdw7m1
zHt9Qn5X1fNPsTY8fLa6U+cAIbXoHw==
          "]]}]}, {}, {}, {}, {}}, 
     {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], LineBox[CompressedData["
1:eJwl1Hl813McwPHfSoTkVugwue/K1UVRUY405T6nVEMzinUZuohi2lVYkzWp
pNa2dii3FNGJDrlvofs+nu+HP557fT+fPbb9fp/357fk1PSU/kmJRKKHL0up
qpVILNHfGUWZdbX+zHKqrZfpH/zJO8y1V6MFPEO59Qqdx7tUWs/XiYyhwnql
vsdiPucle9kcyWfWL+oPOkvf5ggWWb+g3+tMfYvDWWg9Tr/TGTqd+nxqPVbX
6TR9k8NYYP28fqtT9Q3q8Yn1c7pWS3QKh/JxvG5do8X6OofwkfWzulon62sc
zIdxDrpKi3QSdfnAerR+o4X6Kgfxfpy1fqU1+rX+zV/x+5nAgfbrMJIRjLaX
zwGeazOcp+P79vKo5TmJp3gyvm8vNwbteZ9m6RPxM55z2MseMu09Hj/neTy7
2UWGvYfjd8Ws2MkO0uz1I8tzNtvZxn32UuNvxCzZyhbusHc7w2KWbGYTPe31
YGjMko1s4Hp71zEkZsl//MtV9jozOGbJP6znOHvHkhaz5Ee+YHa8Tj1aX9aj
9BU9Rh/QhjEPbaCFerw+qCfG/PQELdJG+pA2iXlrY52sTTU+SMlxP/QkLdaT
NV1PifukzbRET43z1NPj/ulpOlXP0Aw9K+6rnqnT9Gx9RM+N+63n6Aw9Tx/V
C+LzoOfrTG2uA7RlfH60hc7SC3WgXqyz9SIt1Uv0MW2lc/RSLdPWcR+0rZZr
G63Qdpqpl+tcvUwrtb0O0lL9Un/ll7hL1ldwJR3oREdy6EJXruZariGXG+hO
N24khTxu5hZu4jZuJZ+7uJs7uZd7KKA399OLvvRhQsw3ZhnzjxnF/JgY5xln
F+cdZxLnFXcm7lrcw3h/cX/jrsYd4jfvbwRzPFfpT0n//y/dD8nzs8A=
       "]]}}], {}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None, "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{{-0.5, 4.5}, {-0.5, 3.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.967047726757605*^9, 3.967047792101325*^9}, {
  3.967047828789736*^9, 3.967047856016226*^9}},
 CellLabel->
  "Out[164]=",ExpressionUUID->"a1205f4b-60bd-4352-a842-65d682cf8d89"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6.`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "4.`"}], ",", 
     RowBox[{"y", "\[Rule]", "2.`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.967047726757605*^9, 3.967047792101325*^9}, {
  3.967047828789736*^9, 3.967047856019137*^9}},
 CellLabel->
  "Out[165]=",ExpressionUUID->"2fcabdae-e1b2-404f-947e-1b859893a0fe"],

Cell[CellGroupData[{

Cell[BoxData["\<\"\[Checkmark] Punto \[OAcute]ptimo: {4., 2.}\"\>"], "Print",
 CellChangeTimes->{{3.967047726764971*^9, 3.9670477921303177`*^9}, {
  3.967047828795843*^9, 3.9670478560231647`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[164]:=",ExpressionUUID->"e8a4e3fa-d98e-4a85-991d-6b1baa12ee63"],

Cell[BoxData["\<\"\[Checkmark] Valor \[OAcute]ptimo: 6.\"\>"], "Print",
 CellChangeTimes->{{3.967047726764971*^9, 3.9670477921303177`*^9}, {
  3.967047828795843*^9, 3.96704785602423*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[164]:=",ExpressionUUID->"0c140d92-799a-4faa-8396-f7f83594d490"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967047726764971*^9, 3.9670477921303177`*^9}, {
  3.967047828795843*^9, 3.967047856025276*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[164]:=",ExpressionUUID->"8e10ab53-7af0-4bdf-90ca-a280f7c6ce67"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.967047726764971*^9, 3.9670477921303177`*^9}, {
  3.967047828795843*^9, 3.967047856025857*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[164]:=",ExpressionUUID->"0163476f-43ee-4ae7-8927-e86c0cbb6340"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967047726764971*^9, 3.9670477921303177`*^9}, {
  3.967047828795843*^9, 3.967047856026408*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[164]:=",ExpressionUUID->"2aff194a-1c8b-4ac1-a8dd-ec1f5a82b33c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967047726764971*^9, 3.9670477921303177`*^9}, {
  3.967047828795843*^9, 3.967047856026957*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[164]:=",ExpressionUUID->"90c9c36b-ecfa-48e4-9d0f-3d3af7ca9e56"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967047726764971*^9, 3.9670477921303177`*^9}, {
  3.967047828795843*^9, 3.9670478560275297`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[164]:=",ExpressionUUID->"d9a8fae8-78d2-44d7-b9ed-4670b0e5175d"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.967047726764971*^9, 3.9670477921303177`*^9}, {
  3.967047828795843*^9, 3.967047856104972*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[164]:=",ExpressionUUID->"c52f5580-81a7-421e-b559-4ae482a6aaf5"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.967047726764971*^9, 3.9670477921303177`*^9}, {
  3.967047828795843*^9, 3.967047857111692*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[164]:=",ExpressionUUID->"e1981fff-7005-4c44-84cd-677ee67b6a82"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/LinearPro/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967047726764971*^9, 3.9670477921303177`*^9}, {
  3.967047828795843*^9, 3.9670478571188803`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[164]:=",ExpressionUUID->"75fedced-7f77-4f6d-9970-1ebbfc700e87"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"linear12\"\>"}],
  SequenceForm["Archivo: ", "linear12"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967047726764971*^9, 3.9670477921303177`*^9}, {
  3.967047828795843*^9, 3.967047857121768*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[164]:=",ExpressionUUID->"244ede7c-4cd2-4a3b-afb0-f5f074c12146"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.967047726764971*^9, 3.9670477921303177`*^9}, {
  3.967047828795843*^9, 3.9670478575740128`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[164]:=",ExpressionUUID->"d5f4b5d2-2ada-4d90-8803-49811503d187"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/linear12.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/LinearPro/linear12.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967047726764971*^9, 3.9670477921303177`*^9}, {
  3.967047828795843*^9, 3.967047857575221*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[164]:=",ExpressionUUID->"30925e7e-efe3-4d17-97f5-1ceef42a74b7"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/LinearPro/linear12.\
pdf\"\>"], "Output",
 CellChangeTimes->{{3.967047726757605*^9, 3.967047792101325*^9}, {
  3.967047828789736*^9, 3.967047857586461*^9}},
 CellLabel->
  "Out[167]=",ExpressionUUID->"e29162cc-bff7-4502-853e-04ea00ccf374"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CrearTablaSignosTeX", "Section",
 CellChangeTimes->{
  3.966968435050807*^9, {3.971378196394128*^9, 
   3.971378201939004*^9}},ExpressionUUID->"b31a0318-fc4d-40c3-85b6-\
6d691a13863c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "CrearTablaSignosTeX"}]], "Input",
 CellChangeTimes->{{3.966968437294499*^9, 3.966968438599978*^9}, 
   3.971378183645586*^9},
 CellLabel->"In[2]:=",ExpressionUUID->"19637cc5-27f2-4e87-b4f3-3cfcead964e9"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"CrearTablaSignosTeX[desigualdad, variable, \
nombreArchivo] crea una tabla de signos profesional en formato LaTeX para \
resolver desigualdades algebraicas racionales. Genera un archivo .tex \
completo con la tabla, an\[AAcute]lisis de signos y soluci\[OAcute]n \
final.\\n\\nPAR\[CapitalAAcute]METROS:\\n- desigualdad: Expresi\[OAcute]n de \
desigualdad con operadores <, <=, >, >= (ej: x^2 - 1 > 0, (x+1)/(x-2) <= \
0)\\n- variable: S\[IAcute]mbolo de la variable independiente (opcional, por \
defecto x)\\n- nombreArchivo: String que especifica el nombre del archivo de \
salida (opcional, por defecto \\\"tabla_signos.tex\\\", debe terminar en \
\\\".tex\\\")\\n\\nTIPOS DE DESIGUALDADES SOPORTADAS:\\n- Polinomiales: x^2 - \
4 > 0, x^3 + 2*x^2 - x - 2 <= 0\\n- Racionales: (x+1)/(x-2) >= 0, \
(x^2-1)/((x+3)*(x-4)) < 0\\n- Factorizadas: (x-1)*(x+2)*(x-3) <= 0, \
(x+1)^2*(x-2) >= 0\\n- Productos complejos: (2*x+1)*(x-3)^2/((x+4)*(x-1)) >= \
0\\n\\nMULTIPLICIDADES MANEJADAS:\\n- Multiplicidad par: (x-3)^2 >= 0 \
\[RightArrow] incluye x=3 como soluci\[OAcute]n aislada\\n- Multiplicidad \
impar: (x-1)^3 <= 0 \[RightArrow] maneja cambios de signo correctamente\\n- \
Mixtas: (x-1)^2*(x+2)^3 >= 0 \[RightArrow] combina ambos tipos \
adecuadamente\\n\\nCARACTER\[CapitalIAcute]STICAS PRINCIPALES:\\n- \
Factorizaci\[OAcute]n autom\[AAcute]tica de numeradores y denominadores\\n- \
Detecci\[OAcute]n inteligente de puntos cr\[IAcute]ticos (ceros e \
indefiniciones)\\n- Manejo correcto de multiplicidades pares e impares\\n- \
Resoluci\[OAcute]n precisa considerando inclusi\[OAcute]n/exclusi\[OAcute]n \
de puntos\\n- Formato LaTeX profesional con comando \\\\cerodivisorio para \
cambios de signo\\n- Notaci\[OAcute]n europea de intervalos: ]-\[Infinity], \
a[, [b, c], \\\\{d\\\\} \:222a ]e, +\[Infinity][\\n\\nVALIDACIONES AUTOM\
\[CapitalAAcute]TICAS:\\n- Rechaza funciones transcendentes (sin, cos, exp, \
log, etc.)\\n- Rechaza ra\[IAcute]ces con variable dentro: Sqrt[x+1], \
(x-2)^(1/3)\\n- Acepta solo expresiones algebraicas racionales\\n- Valida \
formato del nombre de archivo (.tex obligatorio)\\n\\nFUNCIONALIDAD DEL \
ARCHIVO GENERADO:\\n- Documento LaTeX standalone completo y compilable\\n- \
Tabla de signos con separadores visuales apropiados:\\n  \[Bullet] Barras \
simples | para ceros del numerador\\n  \[Bullet] Barras dobles || para puntos \
de indefinici\[OAcute]n (ceros del denominador)\\n- Comando \
\\\\cerodivisorio{\[PlusMinus]} para cambios de signo en factores\\n- Fila \
final \\\"Signo\\\" con notaci\[OAcute]n tradicional (+, -, 0)\\n- Informaci\
\[OAcute]n completa: desigualdad original, soluci\[OAcute]n final, puntos de \
indefinici\[OAcute]n\\n\\nESTRUCTURA DE ARCHIVOS:\\n- Carpeta: \
Downloads/[nombreArchivo sin extensi\[OAcute]n]\\n- Archivo: \
[nombreArchivo].tex\\n- Crea directorios autom\[AAcute]ticamente si no \
existen\\n\\nEJEMPLOS DE USO:\\n- CrearTablaSignosTeX[x^2 - 4 > 0]\\n  % \
Genera tabla para desigualdad cuadr\[AAcute]tica b\[AAcute]sica\\n- \
CrearTablaSignosTeX[(x+1)/(x-2) <= 0, x, \\\"racional.tex\\\"]\\n  % Funci\
\[OAcute]n racional con punto de indefinici\[OAcute]n\\n- \
CrearTablaSignosTeX[(x-1)^2*(x+3) >= 0, y, \\\"multiplicidad.tex\\\"]\\n  % \
Maneja multiplicidad par correctamente\\n- \
CrearTablaSignosTeX[-((2*x+1)*(x-3)^2)/((x+4)*(x-1)) >= 0]\\n  % Caso \
complejo con m\[UAcute]ltiples factores y multiplicidades\\n\\nCASOS \
ESPECIALES MANEJADOS:\\n- Puntos de multiplicidad par que satisfacen \
desigualdades inclusivas\\n- Factores con coeficientes principales \
negativos\\n- Expresiones con m\[UAcute]ltiples niveles de factorizaci\
\[OAcute]n\\n- Denominadores con varios factores independientes\\n- \
Soluciones que incluyen puntos aislados y intervalos\\n\\nVALIDACIONES Y \
ERRORES:\\nRetorna $Failed si:\\n- La desigualdad no contiene la variable \
especificada\\n- Contiene funciones transcendentes o ra\[IAcute]ces con \
variable\\n- El nombre de archivo no termina en \\\".tex\\\"\\n- No se pueden \
encontrar puntos cr\[IAcute]ticos\\n- Ocurre error en la exportaci\[OAcute]n \
del archivo\\n\\nVALOR DE RETORNO:\\n- \[CapitalEAcute]xito: Ruta completa \
del archivo .tex generado\\n- Fallo: $Failed con mensaje de error \
apropiado\\n\\nALGORITMO DE RESOLUCI\[CapitalOAcute]N:\\n1. Factorizaci\
\[OAcute]n completa de numerador y denominador\\n2. Identificaci\[OAcute]n de \
todos los puntos cr\[IAcute]ticos\\n3. Creaci\[OAcute]n de intervalos de \
prueba\\n4. Evaluaci\[OAcute]n de signos en cada intervalo\\n5. Determinaci\
\[OAcute]n de inclusi\[OAcute]n/exclusi\[OAcute]n de puntos \
cr\[IAcute]ticos\\n6. Construcci\[OAcute]n de la soluci\[OAcute]n en notaci\
\[OAcute]n de intervalos\\n7. Generaci\[OAcute]n del c\[OAcute]digo LaTeX con \
tabla profesional\\n\\nFORMATO DE SALIDA:\\n- Soluci\[OAcute]n \
matem\[AAcute]ticamente correcta en notaci\[OAcute]n europea\\n- Puntos \
aislados: \\\\{valor\\\\}\\n- Intervalos: ]a, b[, [c, d], ]-\[Infinity], e[, \
]f, +\[Infinity][\\n- Uniones: A \:222a B \:222a C\\n- Conjunto \
vac\[IAcute]o: \[EmptySet]\\n\\nCOMPATIBILIDAD:\\n- Funciona con cualquier \
versi\[OAcute]n de Mathematica que soporte FactorList, Solve y Together\\n- \
Genera c\[OAcute]digo LaTeX compatible con distribuciones \
est\[AAcute]ndar\\n- Los archivos .tex son compilables directamente sin \
dependencias adicionales\\n\\nNOTA PEDAG\[CapitalOAcute]GICA:\\nEsta funci\
\[OAcute]n es ideal para ense\[NTilde]anza de \[AAcute]lgebra avanzada, prec\
\[AAcute]lculo y c\[AAcute]lculo inicial, proporcionando visualizaciones \
claras del m\[EAcute]todo de tabla de signos y facilitando la comprensi\
\[OAcute]n de las relaciones entre factorizaci\[OAcute]n, signos y soluciones \
de desigualdades.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"CrearTablaSignosTeX", "[", 
                    RowBox[{"VilTeX`Private`desigualdad_", ",", 
                    
                    RowBox[{
                    "VilTeX`Private`variable_", ":", "VilTeX`Private`x"}], 
                    ",", 
                    
                    RowBox[{
                    "VilTeX`Private`nombreArchivo_", ":", 
                    "\"tabla_signos.tex\""}]}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`expr", ",", 
                    "VilTeX`Private`puntosOrdenados", ",", 
                    "VilTeX`Private`intervalos", ",", "VilTeX`Private`signos",
                     ",", "VilTeX`Private`texCode", ",", 
                    "VilTeX`Private`factores", ",", "VilTeX`Private`operador",
                     ",", "VilTeX`Private`ladoIzq", ",", 
                    "VilTeX`Private`ladoDer", ",", 
                    "VilTeX`Private`factoresList", ",", 
                    "VilTeX`Private`signosPorFactor", ",", 
                    "VilTeX`Private`esAlgebraica", ",", 
                    "VilTeX`Private`rutaCompleta", ",", 
                    "VilTeX`Private`carpetaDescargas", ",", 
                    "VilTeX`Private`folderName", ",", 
                    "VilTeX`Private`folderPath", ",", 
                    "VilTeX`Private`numFactores", ",", 
                    "VilTeX`Private`formatExactNumber", ",", 
                    "VilTeX`Private`numPuntos", ",", 
                    "VilTeX`Private`numIntervalos", ",", 
                    "VilTeX`Private`numeradorFactores", ",", 
                    "VilTeX`Private`denominadorFactores", ",", 
                    "VilTeX`Private`todosPuntosCriticos", ",", 
                    "VilTeX`Private`puntosIndefinidos", ",", 
                    "VilTeX`Private`solucionTexto"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"Less", ",", "LessEqual", ",", "Greater", ",", 
                    "GreaterEqual"}], "}"}], ",", 
                    
                    RowBox[{"VilTeX`Private`desigualdad", 
                    "\[LeftDoubleBracket]", "0", "\[RightDoubleBracket]"}]}], 
                    "]"}]}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"StringQ", "[", "VilTeX`Private`nombreArchivo", 
                    "]"}]}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringEndsQ", "[", 
                    RowBox[{"VilTeX`Private`nombreArchivo", ",", "\".tex\""}],
                     "]"}]}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"VilTeX`Private`SymbolQ", "[", 
                    "VilTeX`Private`variable", "]"}]}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`ladoIzq", ",", 
                    "VilTeX`Private`operador", ",", 
                    "VilTeX`Private`ladoDer"}], "}"}], "=", 
                    RowBox[{"Switch", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`desigualdad", 
                    "\[LeftDoubleBracket]", "0", "\[RightDoubleBracket]"}], 
                    ",", "Less", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`desigualdad", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    ",", "\"<\"", ",", 
                    
                    RowBox[{"VilTeX`Private`desigualdad", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
                    "}"}], ",", "LessEqual", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`desigualdad", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    ",", "\"\\\\leq\"", ",", 
                    
                    RowBox[{"VilTeX`Private`desigualdad", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
                    "}"}], ",", "Greater", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`desigualdad", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    ",", "\">\"", ",", 
                    
                    RowBox[{"VilTeX`Private`desigualdad", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
                    "}"}], ",", "GreaterEqual", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`desigualdad", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    ",", "\"\\\\geq\"", ",", 
                    
                    RowBox[{"VilTeX`Private`desigualdad", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
                    "}"}], ",", "_", ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "None", ",", "None"}], "}"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`expr", "=", 
                    RowBox[{"Simplify", "[", 
                    
                    RowBox[{"VilTeX`Private`ladoIzq", "-", 
                    "VilTeX`Private`ladoDer"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"FreeQ", "[", 
                    
                    RowBox[{"VilTeX`Private`expr", ",", 
                    "VilTeX`Private`variable"}], "]"}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`esAlgebraica", "=", 
                    RowBox[{"FreeQ", "[", 
                    RowBox[{"VilTeX`Private`expr", ",", 
                    
                    RowBox[{"Sin", "|", "Cos", "|", "Tan", "|", "Cot", "|", 
                    "Sec", "|", "Csc", "|", "ArcSin", "|", "ArcCos", "|", 
                    "ArcTan", "|", "Exp", "|", "Log", "|", "Log10", "|", 
                    "VilTeX`Private`Ln"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", "VilTeX`Private`esAlgebraica"}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`tieneRaizConVariable", "[", 
                    
                    RowBox[{"VilTeX`Private`expr_", ",", 
                    "VilTeX`Private`var_"}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"FreeQ", "[", 
                    RowBox[{"VilTeX`Private`expr", ",", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`x_", "?", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"FreeQ", "[", 
                    RowBox[{"#1", ",", "VilTeX`Private`var"}], "]"}]}], "&"}],
                     ")"}]}], ")"}], 
                    RowBox[{"VilTeX`Private`n_", "?", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"IntegerQ", "[", "#1", "]"}]}], "&"}], ")"}]}]]}],
                     "]"}]}], "||", 
                    RowBox[{"!", 
                    RowBox[{"FreeQ", "[", 
                    RowBox[{"VilTeX`Private`expr", ",", 
                    SqrtBox[
                    RowBox[{"VilTeX`Private`x_", "?", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"FreeQ", "[", 
                    RowBox[{"#1", ",", "VilTeX`Private`var"}], "]"}]}], "&"}],
                     ")"}]}]]}], "]"}]}], "||", 
                    RowBox[{"!", 
                    RowBox[{"FreeQ", "[", 
                    RowBox[{"VilTeX`Private`expr", ",", 
                    RadicalBox[
                    RowBox[{"VilTeX`Private`x_", "?", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"FreeQ", "[", 
                    RowBox[{"#1", ",", "VilTeX`Private`var"}], "]"}]}], "&"}],
                     ")"}]}], "_", SurdForm -> True, MultilineFunction -> 
                    None]}], "]"}]}]}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`tieneRaizConVariable", "[", 
                    
                    RowBox[{"VilTeX`Private`expr", ",", 
                    "VilTeX`Private`variable"}], "]"}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`carpetaDescargas", "=", 
                    RowBox[{"Switch", "[", 
                    RowBox[{"$OperatingSystem", ",", "\"Windows\"", ",", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    RowBox[{"$HomeDirectory", ",", "\"Downloads\""}], "}"}], 
                    "]"}], ",", "\"MacOSX\"", ",", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    RowBox[{"$HomeDirectory", ",", "\"Downloads\""}], "}"}], 
                    "]"}], ",", "\"Unix\"", ",", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    RowBox[{"$HomeDirectory", ",", "\"Downloads\""}], "}"}], 
                    "]"}], ",", "_", ",", "$HomeDirectory"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"DirectoryQ", "[", 
                    "VilTeX`Private`carpetaDescargas", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Quiet", "[", 
                    
                    RowBox[{"CreateDirectory", "[", 
                    "VilTeX`Private`carpetaDescargas", "]"}], "]"}], ";"}]}], 
                    "]"}], ";", 
                    RowBox[{"VilTeX`Private`folderName", "=", 
                    
                    RowBox[{"FileBaseName", "[", 
                    "VilTeX`Private`nombreArchivo", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`folderPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`carpetaDescargas", ",", 
                    "VilTeX`Private`folderName"}], "}"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"DirectoryQ", "[", "VilTeX`Private`folderPath", 
                    "]"}]}], ",", 
                    
                    RowBox[{"CreateDirectory", "[", 
                    "VilTeX`Private`folderPath", "]"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`rutaCompleta", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`folderPath", ",", 
                    "VilTeX`Private`nombreArchivo"}], "}"}], "]"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`limpiarFactorParaLaTeX", "[", 
                    "VilTeX`Private`factor_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`resultado", "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"PolynomialQ", "[", 
                    
                    RowBox[{"VilTeX`Private`factor", ",", 
                    "VilTeX`Private`variable"}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    
                    RowBox[{"VilTeX`Private`RationalQ", "[", 
                    "VilTeX`Private`factor", "]"}]}], "&&", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`factor", "]"}], 
                    "=!=", "Times"}]}], ",", 
                    RowBox[{"VilTeX`Private`resultado", "=", 
                    RowBox[{"\"\\\\text{Factor}_{\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"Hash", "[", 
                    RowBox[{"VilTeX`Private`factor", ",", "\"MD5\""}], "]"}], 
                    "]"}], "<>", "\"}\""}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`resultado", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"Check", "[", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"TeXForm", "[", "VilTeX`Private`factor", "]"}], 
                    "]"}], ",", "$Failed"}], "]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`resultado", "===", "$Failed"}], 
                    "||", 
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{"VilTeX`Private`resultado", ",", "\"#\""}], 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`resultado", "=", 
                    RowBox[{"\"\\\\text{Factor}_{\"", "<>", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`factoresList", 
                    "]"}], "]"}], "<>", "\"}\""}]}], ";"}]}], "]"}], ";"}]}], 
                    "]"}], ";", 
                    RowBox[{"VilTeX`Private`resultado", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"VilTeX`Private`resultado", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"\"#\"", "~~", "___"}], "\[Rule]", "\"\""}], ",", 
                    
                    RowBox[{
                    RowBox[{"\"*#\"", "~~", "___"}], "\[Rule]", "\"\""}], ",", 
                    RowBox[{
                    RowBox[{"\"DynamicModule\"", "~~", "___"}], "\[Rule]", 
                    "\"\\\\text{Factor}\""}], ",", 
                    RowBox[{"\"&\"", "\[Rule]", "\"\\\\&\""}]}], "}"}]}], 
                    "]"}]}], ";", "VilTeX`Private`resultado"}]}], "]"}]}], 
                    ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`formatExactNumber", "[", 
                    "VilTeX`Private`x_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`result", "}"}], ",", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{"IntegerQ", "[", "VilTeX`Private`x", "]"}], ",", 
                    RowBox[{"ToString", "[", "VilTeX`Private`x", "]"}], ",", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`x", "]"}], "===", 
                    "Rational"}], ",", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"Check", "[", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"TeXForm", "[", "VilTeX`Private`x", "]"}], "]"}], 
                    ",", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilTeX`Private`x", ",", "InputForm"}], "]"}]}], 
                    "]"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`x", "]"}], "===", 
                    "Root"}], ",", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"NumberForm", "[", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"VilTeX`Private`x", ",", "4"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"4", ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
                    RowBox[{"!", 
                    RowBox[{"FreeQ", "[", 
                    RowBox[{"VilTeX`Private`x", ",", "Root"}], "]"}]}], ",", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"NumberForm", "[", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"VilTeX`Private`x", ",", "4"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"4", ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`x", "]"}], "===", 
                    "Power"}], "||", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`x", "]"}], "===", 
                    "Sqrt"}]}], ",", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"Check", "[", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"TeXForm", "[", "VilTeX`Private`x", "]"}], "]"}], 
                    ",", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"NumberForm", "[", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"VilTeX`Private`x", ",", "4"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"4", ",", "1"}], "}"}]}], "]"}], "]"}]}], "]"}], 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilTeX`Private`x", "]"}], "&&", 
                    
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"VilTeX`Private`x", "-", 
                    RowBox[{"Round", "[", "VilTeX`Private`x", "]"}]}], "]"}], 
                    "<", 
                    FractionBox["1", 
                    SuperscriptBox["10", "10"]]}]}], ",", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"Round", "[", "VilTeX`Private`x", "]"}], "]"}], 
                    ",", "True", ",", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"Check", "[", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"TeXForm", "[", 
                    RowBox[{"Rationalize", "[", 
                    RowBox[{"VilTeX`Private`x", ",", "0"}], "]"}], "]"}], 
                    "]"}], ",", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"NumberForm", "[", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"VilTeX`Private`x", ",", "4"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"4", ",", "1"}], "}"}]}], "]"}], "]"}]}], "]"}], 
                    "]"}]}], "]"}]}], "]"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`manejarFactorizacion", "[", 
                    "VilTeX`Private`polinomio_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`factorList", ",", 
                    "VilTeX`Private`factoresLimpios", ",", 
                    "VilTeX`Private`signoGlobal"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`factorList", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"Check", "[", 
                    RowBox[{
                    
                    RowBox[{"FactorList", "[", "VilTeX`Private`polinomio", 
                    "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`polinomio", ",", "1"}], "}"}], 
                    "}"}]}], "]"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`factoresLimpios", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`signoGlobal", "=", "1"}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`factor", "=", 
                    
                    RowBox[{"VilTeX`Private`factorList", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"VilTeX`Private`multiplicidad", "=", 
                    
                    RowBox[{"VilTeX`Private`factorList", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}]}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilTeX`Private`factor", "]"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`signoGlobal", "*=", 
                    RowBox[{"Sign", "[", "VilTeX`Private`factor", "]"}]}], 
                    ";"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"VilTeX`Private`factor", "===", "1"}]}], ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`factorProcesado", "}"}], ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`factorProcesado", "=", 
                    "VilTeX`Private`factor"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`factor", "]"}], 
                    "===", "Plus"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`factor", "]"}], 
                    "\[GreaterEqual]", "2"}]}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`coefPrincipal", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`coefPrincipal", "=", 
                    RowBox[{"Coefficient", "[", 
                    
                    RowBox[{"VilTeX`Private`factor", ",", 
                    "VilTeX`Private`variable", ",", 
                    RowBox[{"Exponent", "[", 
                    
                    RowBox[{"VilTeX`Private`factor", ",", 
                    "VilTeX`Private`variable"}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`coefPrincipal", "<", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`factorProcesado", "=", 
                    RowBox[{"-", "VilTeX`Private`factor"}]}], ";", 
                    RowBox[{"VilTeX`Private`signoGlobal", "*=", 
                    RowBox[{"-", "1"}]}], ";"}]}], "]"}], ";"}]}], "]"}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`factoresLimpios", ",", 
                    "VilTeX`Private`factorProcesado"}], "]"}], ";"}]}], "]"}],
                     ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`j", ",", "1", ",", 
                    "VilTeX`Private`multiplicidad"}], "}"}]}], "]"}], ";"}]}],
                     "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", "1", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`factorList", 
                    "]"}]}], "}"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`signoGlobal", "<", "0"}], "&&", 
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`factoresLimpios", 
                    "]"}], ">", "0"}]}], ",", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`factoresLimpios", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "=", 
                    RowBox[{"-", 
                    
                    RowBox[{"VilTeX`Private`factoresLimpios", 
                    "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}]}], ";"}]}], "]"}], ";", 
                    "VilTeX`Private`factoresLimpios"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`expr", "=", 
                    RowBox[{"Together", "[", "VilTeX`Private`expr", "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`numeradorFactores", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`denominadorFactores", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`puntosIndefinidos", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`expr", "=", 
                    RowBox[{"Together", "[", "VilTeX`Private`expr", "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`numeradorFactores", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`denominadorFactores", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`puntosIndefinidos", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`numeradorFactores", "=", 
                    RowBox[{"VilTeX`Private`manejarFactorizacion", "[", 
                    RowBox[{"Numerator", "[", "VilTeX`Private`expr", "]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`denominadorFactores", "=", 
                    RowBox[{"VilTeX`Private`manejarFactorizacion", "[", 
                    RowBox[{"Denominator", "[", "VilTeX`Private`expr", "]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`factoresList", "=", 
                    RowBox[{"Join", "[", 
                    
                    RowBox[{"VilTeX`Private`numeradorFactores", ",", 
                    "VilTeX`Private`denominadorFactores"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`factoresList", 
                    "]"}], "\[Equal]", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`factoresList", "=", 
                    RowBox[{"{", "VilTeX`Private`expr", "}"}]}], ";"}]}], 
                    "]"}], ";", 
                    RowBox[{"VilTeX`Private`numFactores", "=", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`factoresList", 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`todosPuntosCriticos", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`sols", ",", 
                    "VilTeX`Private`soluciones"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`soluciones", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"Check", "[", 
                    RowBox[{
                    RowBox[{"Solve", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`numeradorFactores", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}], "\[Equal]", "0"}], ",", 
                    "VilTeX`Private`variable", ",", 
                    TemplateBox[{}, "Reals"]}], "]"}], ",", 
                    RowBox[{"{", "}"}]}], "]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`soluciones", "]"}],
                     ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`sols", "=", 
                    
                    RowBox[{"VilTeX`Private`variable", "/.", 
                    "\[VeryThinSpace]", "VilTeX`Private`soluciones"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`sols", "=", 
                    RowBox[{"Flatten", "[", 
                    RowBox[{"{", "VilTeX`Private`sols", "}"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`sols", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{"VilTeX`Private`sols", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"NumericQ", "[", 
                    RowBox[{"N", "[", "#1", "]"}], "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Im", "[", 
                    RowBox[{"N", "[", "#1", "]"}], "]"}], "\[Equal]", "0"}]}],
                     ")"}], "||", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"NumericQ", "[", "#1", "]"}]}], "&&", 
                    RowBox[{"FreeQ", "[", 
                    RowBox[{"#1", ",", "Complex"}], "]"}]}], ")"}]}], "&"}]}],
                     "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`sols", "]"}], ">", 
                    "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`todosPuntosCriticos", "=", 
                    RowBox[{"Join", "[", 
                    
                    RowBox[{"VilTeX`Private`todosPuntosCriticos", ",", 
                    "VilTeX`Private`sols"}], "]"}]}], ";"}]}], "]"}], ";"}]}],
                     "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", "1", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`numeradorFactores",
                     "]"}]}], "}"}]}], "]"}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`sols", ",", 
                    "VilTeX`Private`soluciones"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`soluciones", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"Check", "[", 
                    RowBox[{
                    RowBox[{"Solve", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`denominadorFactores", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}], "\[Equal]", "0"}], ",", 
                    "VilTeX`Private`variable", ",", 
                    TemplateBox[{}, "Reals"]}], "]"}], ",", 
                    RowBox[{"{", "}"}]}], "]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`soluciones", "]"}],
                     ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`sols", "=", 
                    
                    RowBox[{"VilTeX`Private`variable", "/.", 
                    "\[VeryThinSpace]", "VilTeX`Private`soluciones"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`sols", "=", 
                    RowBox[{"Flatten", "[", 
                    RowBox[{"{", "VilTeX`Private`sols", "}"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`sols", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{"VilTeX`Private`sols", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"NumericQ", "[", 
                    RowBox[{"N", "[", "#1", "]"}], "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Im", "[", 
                    RowBox[{"N", "[", "#1", "]"}], "]"}], "\[Equal]", "0"}]}],
                     ")"}], "||", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"NumericQ", "[", "#1", "]"}]}], "&&", 
                    RowBox[{"FreeQ", "[", 
                    RowBox[{"#1", ",", "Complex"}], "]"}]}], ")"}]}], "&"}]}],
                     "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`sols", "]"}], ">", 
                    "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`puntosIndefinidos", "=", 
                    RowBox[{"Join", "[", 
                    
                    RowBox[{"VilTeX`Private`puntosIndefinidos", ",", 
                    "VilTeX`Private`sols"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`todosPuntosCriticos", "=", 
                    RowBox[{"Join", "[", 
                    
                    RowBox[{"VilTeX`Private`todosPuntosCriticos", ",", 
                    "VilTeX`Private`sols"}], "]"}]}], ";"}]}], "]"}], ";"}]}],
                     "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", "1", ",", 
                    
                    RowBox[{"Length", "[", 
                    "VilTeX`Private`denominadorFactores", "]"}]}], "}"}]}], 
                    "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", 
                    "VilTeX`Private`todosPuntosCriticos", "]"}], "\[Equal]", 
                    "0"}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`puntosOrdenados", "=", 
                    RowBox[{"Sort", "[", 
                    RowBox[{
                    RowBox[{"DeleteDuplicates", "[", 
                    RowBox[{"VilTeX`Private`todosPuntosCriticos", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"N", "[", "#1", "]"}], "-", 
                    RowBox[{"N", "[", "#2", "]"}]}], "]"}], "<", 
                    FractionBox["1", 
                    SuperscriptBox["10", "10"]]}], "&"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", "#1", "]"}], "<", 
                    RowBox[{"N", "[", "#2", "]"}]}], "&"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`numPuntos", "=", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`puntosOrdenados", 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`intervalos", "=", 
                    RowBox[{"Join", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "\[Infinity]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`puntosOrdenados", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    "}"}], "}"}], ",", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`puntosOrdenados", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`puntosOrdenados", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", "+", "1"}], 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", "1", ",", 
                    RowBox[{"VilTeX`Private`numPuntos", "-", "1"}]}], "}"}]}],
                     "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"Last", "[", "VilTeX`Private`puntosOrdenados", 
                    "]"}], ",", "\[Infinity]"}], "}"}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`numIntervalos", "=", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`intervalos", 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`signosPorFactor", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`puntoTest", ",", 
                    "VilTeX`Private`valorTest"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`intervalos", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`j", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "\[Equal]", 
                    RowBox[{"-", "\[Infinity]"}]}], ",", 
                    RowBox[{"VilTeX`Private`puntoTest", "=", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    
                    RowBox[{"VilTeX`Private`intervalos", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`j", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "-", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"N", "[", 
                    
                    RowBox[{"VilTeX`Private`intervalos", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`j", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "]"}], "-", "10"}]}], 
                    ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`intervalos", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`j", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "\[Equal]", "\[Infinity]"}], 
                    ",", 
                    RowBox[{"VilTeX`Private`puntoTest", "=", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    
                    RowBox[{"VilTeX`Private`intervalos", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`j", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "+", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"N", "[", 
                    
                    RowBox[{"VilTeX`Private`intervalos", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`j", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "]"}], "+", "10"}]}], 
                    ",", 
                    RowBox[{"VilTeX`Private`puntoTest", "=", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    
                    RowBox[{"VilTeX`Private`intervalos", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`j", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "+", 
                    RowBox[{"N", "[", 
                    
                    RowBox[{"VilTeX`Private`intervalos", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`j", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}]}], ")"}]}]}]}], "]"}]}], 
                    "]"}], ";", 
                    RowBox[{"VilTeX`Private`valorTest", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"Check", "[", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`factoresList", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}], "/.", "\[VeryThinSpace]", 
                    
                    RowBox[{"VilTeX`Private`variable", "\[Rule]", 
                    "VilTeX`Private`puntoTest"}]}], "]"}], ",", "0"}], "]"}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"NumericQ", "[", "VilTeX`Private`valorTest", 
                    "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`valorTest", "]"}], 
                    ">", 
                    FractionBox["1", 
                    SuperscriptBox["10", "8"]]}]}], ",", 
                    RowBox[{"Sign", "[", "VilTeX`Private`valorTest", "]"}], 
                    ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`puntoTest2", ",", 
                    "VilTeX`Private`valorTest2"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`puntoTest2", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`intervalos", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`j", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "\[Equal]", 
                    RowBox[{"-", "\[Infinity]"}]}], ",", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    
                    RowBox[{"VilTeX`Private`intervalos", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`j", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "-", "100"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`intervalos", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`j", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "\[Equal]", "\[Infinity]"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    
                    RowBox[{"VilTeX`Private`intervalos", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`j", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "+", "100"}], ",", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    
                    RowBox[{"VilTeX`Private`intervalos", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`j", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    
                    RowBox[{"VilTeX`Private`intervalos", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`j", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "-", 
                    RowBox[{"N", "[", 
                    
                    RowBox[{"VilTeX`Private`intervalos", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`j", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}]}], ")"}]}]}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`valorTest2", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"Check", "[", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`factoresList", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}], "/.", "\[VeryThinSpace]", 
                    
                    RowBox[{"VilTeX`Private`variable", "\[Rule]", 
                    "VilTeX`Private`puntoTest2"}]}], "]"}], ",", "0"}], "]"}],
                     "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"NumericQ", "[", "VilTeX`Private`valorTest2", 
                    "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`valorTest2", "]"}], 
                    ">", 
                    FractionBox["1", 
                    SuperscriptBox["10", "8"]]}]}], ",", 
                    RowBox[{"Sign", "[", "VilTeX`Private`valorTest2", "]"}], 
                    ",", "0"}], "]"}]}]}], "]"}]}], "]"}]}]}], "]"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`j", ",", "1", ",", 
                    "VilTeX`Private`numIntervalos"}], "}"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", "1", ",", 
                    "VilTeX`Private`numFactores"}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`signos", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Times", "@@", 
                    
                    RowBox[{"VilTeX`Private`signosPorFactor", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "VilTeX`Private`i"}], 
                    "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", "1", ",", 
                    "VilTeX`Private`numIntervalos"}], "}"}]}], "]"}]}], ";", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`debeIncluirPunto", "[", 
                    
                    RowBox[{"VilTeX`Private`punto_", ",", 
                    "VilTeX`Private`esInclusiva_", ",", 
                    "VilTeX`Private`puntosIndef_"}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`valorEnPunto", "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"VilTeX`Private`puntosIndef", ",", "10"}], "]"}], 
                    ",", 
                    RowBox[{"N", "[", 
                    RowBox[{"VilTeX`Private`punto", ",", "10"}], "]"}]}], 
                    "]"}], ",", 
                    RowBox[{"Return", "[", "False", "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", "VilTeX`Private`esInclusiva"}], ",", 
                    RowBox[{"Return", "[", "False", "]"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`valorEnPunto", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"Check", "[", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"VilTeX`Private`expr", "/.", "\[VeryThinSpace]", 
                    
                    RowBox[{"VilTeX`Private`variable", "\[Rule]", 
                    "VilTeX`Private`punto"}]}], "]"}], ",", "Undefined"}], 
                    "]"}], "]"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"NumericQ", "[", "VilTeX`Private`valorEnPunto", 
                    "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`valorEnPunto", "]"}], 
                    "<", 
                    FractionBox["1", 
                    SuperscriptBox["10", "10"]]}]}]}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`solucionTexto", "=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`intervalosResultado", ",", 
                    "VilTeX`Private`esInclusiva", ",", 
                    "VilTeX`Private`puntosAislados"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`intervalosResultado", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`puntosAislados", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`esInclusiva", "=", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"LessEqual", ",", "GreaterEqual"}], "}"}], ",", 
                    
                    RowBox[{"VilTeX`Private`desigualdad", 
                    "\[LeftDoubleBracket]", "0", "\[RightDoubleBracket]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`puntosQueIncluir", "=", 
                    RowBox[{"{", "}"}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`debeIncluirPunto", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`puntosOrdenados", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}], ",", 
                    "VilTeX`Private`esInclusiva", ",", 
                    "VilTeX`Private`puntosIndefinidos"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"VilTeX`Private`puntosQueIncluir", ",", 
                    
                    RowBox[{"VilTeX`Private`puntosOrdenados", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}]}], "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", "1", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`puntosOrdenados", 
                    "]"}]}], "}"}]}], "]"}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", "=", "1"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"While", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`i", "\[LessEqual]", 
                    "VilTeX`Private`numIntervalos"}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`satisfaceIntervalo", ",", 
                    "VilTeX`Private`inicioGrupo", ",", 
                    "VilTeX`Private`finGrupo"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`satisfaceIntervalo", "=", 
                    RowBox[{"Switch", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`desigualdad", 
                    "\[LeftDoubleBracket]", "0", "\[RightDoubleBracket]"}], 
                    ",", "Less", ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`signos", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "<", "0"}],
                     ",", "LessEqual", ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`signos", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "<", "0"}],
                     ",", "Greater", ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`signos", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], ">", "0"}],
                     ",", "GreaterEqual", ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`signos", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], ">", 
                    "0"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`satisfaceIntervalo", ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`inicioGrupo", "=", 
                    "VilTeX`Private`i"}], ";", 
                    
                    RowBox[{"VilTeX`Private`finGrupo", "=", 
                    "VilTeX`Private`i"}], ";", 
                    RowBox[{"While", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`finGrupo", "<", 
                    "VilTeX`Private`numIntervalos"}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`satisfaceSiguiente", "}"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`satisfaceSiguiente", "=", 
                    RowBox[{"Switch", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`desigualdad", 
                    "\[LeftDoubleBracket]", "0", "\[RightDoubleBracket]"}], 
                    ",", "Less", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`signos", "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`finGrupo", "+", "1"}], 
                    "\[RightDoubleBracket]"}], "<", "0"}], ",", "LessEqual", 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`signos", "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`finGrupo", "+", "1"}], 
                    "\[RightDoubleBracket]"}], "<", "0"}], ",", "Greater", 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`signos", "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`finGrupo", "+", "1"}], 
                    "\[RightDoubleBracket]"}], ">", "0"}], ",", 
                    "GreaterEqual", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`signos", "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`finGrupo", "+", "1"}], 
                    "\[RightDoubleBracket]"}], ">", "0"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`satisfaceSiguiente", ",", 
                    RowBox[{"VilTeX`Private`finGrupo", "++"}], ",", 
                    RowBox[{"Break", "[", "]"}]}], "]"}], ";"}]}], "]"}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`puntoIzq", ",", 
                    "VilTeX`Private`puntoDer", ",", 
                    "VilTeX`Private`incluyeIzq", ",", 
                    "VilTeX`Private`incluyeDer", ",", 
                    "VilTeX`Private`intervaloTexto"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`puntoIzq", "=", 
                    
                    RowBox[{"VilTeX`Private`intervalos", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`inicioGrupo", ",", "1"}], 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`puntoDer", "=", 
                    
                    RowBox[{"VilTeX`Private`intervalos", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`finGrupo", ",", "2"}], 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`incluyeIzq", "=", 
                    RowBox[{"If", "